/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.order.controller;

import com.qianjiang.customer.bean.DepositInfo;
import com.qianjiang.customer.bean.TradeInfo;
import com.qianjiang.customer.service.DepositInfoService;
import com.qianjiang.customer.service.TradeInfoService;
import com.qianjiang.order.bean.BackOrder;
import com.qianjiang.order.bean.BackOrderLog;
import com.qianjiang.order.bean.Order;
import com.qianjiang.order.service.BackOrderLogService;
import com.qianjiang.order.service.BackOrderService;
import com.qianjiang.order.service.OrderCouponService;
import com.qianjiang.order.service.OrderLogService;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.util.MyLogger;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Random;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AjaxBackOrderController {
    private static final MyLogger LOGGER = new MyLogger(AjaxBackOrderController.class);
    private BackOrderService backOrderService;
    private OrderService orderService;
    private BackOrderLogService backOrderLogService;
    private OrderLogService orderLogService;
    @Resource(name="OrderCouponService")
    private OrderCouponService orderCouponService;
    @Autowired
    private DepositInfoService depositInfoService;
    @Autowired
    private TradeInfoService tradeInfoService;

    @RequestMapping(value={"/backorderdetailajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BackOrder backOrderDetailajax(Long backOrderId) {
        return this.backOrderService.detail(backOrderId);
    }

    @RequestMapping(value={"/backorderlog"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<BackOrderLog> backorderlog(Long backOrderId) {
        return this.backOrderLogService.queryByBackId(backOrderId);
    }

    @RequestMapping(value={"/ispointenough"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int isPointEnough(String orderId) {
        try {
            return this.backOrderService.isPointEnough(orderId);
        }
        catch (Exception e) {
            LOGGER.error("ispointenough error", (Throwable)e);
            return 0;
        }
    }

    public String createBackOrderNo() {
        String d = new SimpleDateFormat("yyyyMMdd").format(Calendar.getInstance().getTime());
        Random r = new Random();
        Double d1 = r.nextDouble();
        String s = d1 + "";
        s = d + s.substring(3, 9);
        return s;
    }

    public BackOrderLogService getBackOrderLogService() {
        return this.backOrderLogService;
    }

    @Resource(name="BackOrderLogService")
    public void setBackOrderLogService(BackOrderLogService backOrderLogService) {
        this.backOrderLogService = backOrderLogService;
    }

    public OrderService getOrderService() {
        return this.orderService;
    }

    @Resource(name="OrderService")
    public void setOrderService(OrderService orderService) {
        this.orderService = orderService;
    }

    public BackOrderService getBackOrderService() {
        return this.backOrderService;
    }

    @Resource(name="BackOrderService")
    public void setBackOrderService(BackOrderService backOrderService) {
        this.backOrderService = backOrderService;
    }

    public OrderLogService getOrderLogService() {
        return this.orderLogService;
    }

    @Resource(name="OrderLogService")
    public void setOrderLogService(OrderLogService orderLogService) {
        this.orderLogService = orderLogService;
    }

    @RequestMapping(value={"/checkbackprice"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Object checkBackPrice(Long backOrderId) {
        return this.backOrderService.selectBackOrderByBackOrderId(backOrderId);
    }

    public void updateDepositInfo(Order order, BigDecimal backPrice, BackOrder backOrder, HttpServletRequest request) {
        if (order.getPayId().intValue() == 5) {
            Long customerId = order.getCustomerId();
            DepositInfo depositInfo = this.depositInfoService.selectDepositByCustId(customerId);
            BigDecimal preDepositPrice = depositInfo.getPreDeposit();
            preDepositPrice = backPrice == null || backPrice.intValue() == 0 ? (preDepositPrice == null || preDepositPrice.intValue() == 0 ? order.getOrderPrice() : preDepositPrice.add(order.getOrderPrice())) : (preDepositPrice == null || preDepositPrice.intValue() == 0 ? backPrice : preDepositPrice.add(backPrice));
            depositInfo.setPreDeposit(preDepositPrice);
            if (depositInfo.getFreezePreDeposit() != null && depositInfo.getFreezePreDeposit().intValue() != 0) {
                preDepositPrice = preDepositPrice.add(depositInfo.getFreezePreDeposit());
            }
            TradeInfo tradeInfo = this.getTradeInfo(customerId, backOrder, preDepositPrice, backPrice, order);
            this.tradeInfoService.insertTradeInfo(tradeInfo);
            this.depositInfoService.updateDeposit(depositInfo);
        }
    }

    public TradeInfo getTradeInfo(Long customerId, BackOrder backOrder, BigDecimal currentPrice, BigDecimal backPrice, Order order) {
        TradeInfo tradeInfo = new TradeInfo();
        tradeInfo.setCustomerId(customerId);
        tradeInfo.setOrderCode(backOrder.getOrderCode());
        tradeInfo.setOrderType("1");
        tradeInfo.setOrderStatus("4");
        tradeInfo.setCurrentPrice(currentPrice);
        BigDecimal orderPrice = backPrice == null || backPrice.intValue() == 0 ? backOrder.getBackPrice() : backPrice;
        tradeInfo.setOrderPrice(orderPrice);
        tradeInfo.setCreateTime(new Date());
        tradeInfo.setUpdateTime(new Date());
        tradeInfo.setDelFlag("0");
        tradeInfo.setTradeRemark("\u9000\u6b3e\u8ba2\u5355:" + order.getOrderCode() + ",\u9000\u6b3e\u5355\u53f7:" + backOrder.getBackOrderCode());
        return tradeInfo;
    }
}

