/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.order.controller;

import com.alibaba.fastjson.JSON;
import com.qianjiang.alipay.AlipayUtils;
import com.qianjiang.alipay.RequestDatas;
import com.qianjiang.common.service.SeoService;
import com.qianjiang.customer.bean.CustomerAddress;
import com.qianjiang.customer.bean.DepositInfo;
import com.qianjiang.customer.bean.TradeInfo;
import com.qianjiang.customer.service.CustomerAddressService1;
import com.qianjiang.customer.service.DepositInfoService;
import com.qianjiang.customer.service.OrderNoticeService;
import com.qianjiang.customer.service.TradeInfoService;
import com.qianjiang.goods.bean.GoodsProduct;
import com.qianjiang.goods.bean.PageBean;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.order.bean.BackOrder;
import com.qianjiang.order.bean.BackOrderGeneral;
import com.qianjiang.order.bean.BackOrderLog;
import com.qianjiang.order.bean.Order;
import com.qianjiang.order.bean.OrderAddress;
import com.qianjiang.order.bean.OrderGoods;
import com.qianjiang.order.bean.OrderLogger;
import com.qianjiang.order.service.BackOrderLogService;
import com.qianjiang.order.service.BackOrderService;
import com.qianjiang.order.service.OrderCouponService;
import com.qianjiang.order.service.OrderGoodsService;
import com.qianjiang.order.service.OrderLogService;
import com.qianjiang.order.service.OrderLoggerService;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.order.service.ReturnGoodsService;
import com.qianjiang.orderbartergoods.domain.OrderBarterGoodsDomain;
import com.qianjiang.orderbartergoods.model.OrderBarterGoods;
import com.qianjiang.orderbartergoods.service.OrderBarterGoodsService;
import com.qianjiang.orderrepaircost.domain.RepairCostDomain;
import com.qianjiang.orderrepaircost.model.RepairCost;
import com.qianjiang.orderrepaircost.service.RepairCostService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.OrderConstants;
import com.qianjiang.util.UploadUtil;
import com.qianjiang.wxpay.WXPayUtil;
import com.qianjiang.wxpay.WxPayExecutingRequest;
import com.qianjiang.wxpay.dto.RefundRequestParameter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class BackOrderController {
    private static final MyLogger LOGGER = new MyLogger(BackOrderController.class);
    private static final String BACKORDERLIST_HTM = "backorderlist.htm";
    private static final String BACKORDER = "backorder";
    private static final String ORDERLOGS = "orderLogs";
    private static final String ORDERID = "orderId";
    private static final String BACKORDERLOGS = "backOrderLogs";
    private static final String BACKORDERGENERAL = "backOrderGeneral";
    private static final String ADMIN = "admin";
    private static final String ISO_8859_1 = "ISO-8859-1";
    private BackOrderService backOrderService;
    private OrderService orderService;
    private BackOrderLogService backOrderLogService;
    private OrderLogService orderLogService;
    @Resource(name="OrderCouponService")
    private OrderCouponService orderCouponService;
    @Autowired
    private DepositInfoService depositInfoService;
    @Autowired
    private TradeInfoService tradeInfoService;
    @Resource(name="orderLoggerService")
    private OrderLoggerService orderLoggerService;
    @Autowired
    private RepairCostService repairCostService;
    @Autowired
    private ReturnGoodsService returngoods;
    @Autowired
    private SeoService seoService;
    @Autowired
    private OrderBarterGoodsService orderBarterGoodsService;
    @Autowired
    private CustomerAddressService1 customerAddressServiceMix;
    @Autowired
    private OrderGoodsService OrderGoodsService;
    @Autowired
    private GoodsProductService GoodsProductService;
    @Autowired
    private OrderNoticeService OrderNoticeService;
    @Autowired
    private RepairCostService RepairCostService;

    @RequestMapping(value={"/backorderlist"})
    public ModelAndView backOrderList(HttpServletRequest request, BackOrder bkorder, com.qianjiang.util.PageBean pageBean, String startTime, String endTime) {
        bkorder.setBusinessId(0L);
        bkorder.setIsBack("1");
        pageBean.setUrl(BACKORDERLIST_HTM);
        pageBean = this.backOrderService.backOrderList(pageBean, bkorder, startTime, endTime);
        return new ModelAndView("jsp/order/backorderlist", "pageBean", (Object)pageBean).addObject("businessId", (Object)0);
    }

    @RequestMapping(value={"/exportBackOrderList"})
    public void exportBackOrderList(HttpServletRequest request, HttpServletResponse response, String type) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet("\u9000\u5355\u5217\u8868");
        HSSFRow row = sheet.createRow(0);
        HSSFCellStyle style = wb.createCellStyle();
        style.setAlignment((short)2);
        sheet.setColumnWidth(0, 6000);
        sheet.setColumnWidth(1, 6000);
        sheet.setColumnWidth(2, 6000);
        sheet.setColumnWidth(3, 6000);
        sheet.setColumnWidth(4, 6000);
        sheet.setColumnWidth(5, 6000);
        sheet.setColumnWidth(6, 6000);
        sheet.setColumnWidth(7, 6000);
        HSSFCell cell = row.createCell(0);
        cell.setCellValue("\u9000\u5355\u53f7");
        cell.setCellStyle(style);
        cell = row.createCell(1);
        cell.setCellValue("\u5546\u54c1\u540d\u79f0");
        cell.setCellStyle(style);
        cell = row.createCell(2);
        cell.setCellValue("\u5546\u54c1\u91d1\u989d");
        cell.setCellStyle(style);
        cell = row.createCell(3);
        cell.setCellValue("\u6570\u91cf");
        cell.setCellStyle(style);
        cell = row.createCell(4);
        cell.setCellValue("\u6536\u8d27\u4eba");
        cell.setCellStyle(style);
        cell = row.createCell(5);
        cell.setCellValue("\u9000\u8d27\u72b6\u6001");
        cell.setCellStyle(style);
        cell = row.createCell(6);
        cell.setCellValue("\u9000\u8d27\u91d1\u989d");
        cell.setCellStyle(style);
        cell = row.createCell(7);
        cell.setCellValue("\u9000\u8d27\u65f6\u95f4");
        cell.setCellStyle(style);
        BackOrder order = new BackOrder();
        List list = this.backOrderService.exportBackOrderListMix(order);
        int q = 0;
        if (null != list) {
            for (int i = 0; i < list.size(); ++i) {
                row = sheet.createRow(i + 1 + q);
                BackOrder backOrder = (BackOrder)list.get(i);
                row.createCell(0).setCellValue(backOrder.getBackOrderCode());
                row.createCell(1).setCellValue(backOrder.getGoodsProductVo().getGoodsInfoName());
                row.createCell(2).setCellValue(backOrder.getBackPrice() + "");
                row.createCell(3).setCellValue((double)backOrder.getOrderGoodslistVo().size());
                row.createCell(4).setCellValue(backOrder.getOrder().getShippingPerson());
                String backCheck = backOrder.getBackCheck();
                if (backCheck.equals("0")) {
                    row.createCell(5).setCellValue("\u9000\u8d27\u7533\u8bf7");
                } else if (backCheck.equals("1")) {
                    row.createCell(5).setCellValue("\u5f85\u5546\u5bb6\u6536\u8d27");
                } else if (backCheck.equals("2")) {
                    row.createCell(5).setCellValue("\u62d2\u7edd\u9000\u8d27");
                } else if (backCheck.equals("15")) {
                    row.createCell(5).setCellValue("\u5f85\u9000\u6b3e");
                } else if (backCheck.equals("4")) {
                    row.createCell(5).setCellValue("\u9000\u8d27\u7ed3\u675f");
                } else if (backCheck.equals("6")) {
                    row.createCell(5).setCellValue("\u5ba1\u6838\u9000\u6b3e");
                } else if (backCheck.equals("7")) {
                    row.createCell(5).setCellValue("\u62d2\u7edd\u9000\u6b3e");
                } else if (backCheck.equals("8")) {
                    row.createCell(5).setCellValue("\u62d2\u7edd\u6536\u8d27");
                } else if (backCheck.equals("10")) {
                    row.createCell(5).setCellValue("\u5df2\u9000\u6b3e");
                } else if (backCheck.equals("9")) {
                    row.createCell(5).setCellValue("\u5f85\u5ba2\u6237\u586b\u5199\u7269\u6d41\u5730\u5740");
                } else if (backCheck.equals("11")) {
                    row.createCell(5).setCellValue("\u5b9a\u635f\u4e2d");
                } else if (backCheck.equals("12")) {
                    row.createCell(5).setCellValue("\u5f85\u5ba2\u6237\u786e\u8ba4\u8bc4\u4f30\u8d39\u7528\u4e2d");
                } else if (backCheck.equals("13")) {
                    row.createCell(5).setCellValue("\u5f85\u5ba2\u6237\u786e\u8ba4\u5b9e\u9645\u5b9a\u635f\u8d39\u7528\u4e2d");
                } else if (backCheck.equals("14")) {
                    row.createCell(5).setCellValue("\u7ef4\u4fee\u8d39\u7528\u8bc4\u4f30\u4e2d");
                } else if (backCheck.equals("16")) {
                    row.createCell(5).setCellValue("\u7528\u6237\u5df2\u53d6\u6d88");
                }
                row.createCell(6).setCellValue(backOrder.getBackPrice() + "");
                row.createCell(7).setCellValue(backOrder.getBackTime());
                q += list.size();
            }
        }
        String filename = String.valueOf(System.currentTimeMillis()).concat(".xls");
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment;filename=" + filename);
        try {
            ServletOutputStream ouputStream = response.getOutputStream();
            wb.write((OutputStream)ouputStream);
            ouputStream.flush();
            ouputStream.close();
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    @RequestMapping(value={"/repaircostlist"})
    public ModelAndView barterOrderList(HttpServletRequest request, PageBean pageBean, String startTime, String endTime, RepairCost repairCost) {
        ModelAndView mav = new ModelAndView("jsp/order/repaircostlist");
        Map result = null;
        pageBean.setUrl("repaircostlist.htm");
        result = this.RepairCostService.searchRepairCostListMix(repairCost, pageBean);
        pageBean = (PageBean)JSON.parseObject((String)JSON.toJSONString(result.get("pageBean")), PageBean.class);
        mav.addObject("map", (Object)result);
        mav.addObject("pageBean", (Object)pageBean);
        mav.addObject("repairCost", (Object)repairCost);
        return mav;
    }

    @RequestMapping(value={"/barterorderlist"})
    public ModelAndView barterOrderList(HttpServletRequest request, BackOrder bkorder, com.qianjiang.util.PageBean pageBean, String startTime, String endTime) {
        bkorder.setBusinessId(0L);
        bkorder.setIsBack("3");
        pageBean.setUrl(BACKORDERLIST_HTM);
        return new ModelAndView(OrderConstants.BARTERORDERLIST, "pageBean", (Object)this.backOrderService.backOrderList(pageBean, bkorder, startTime, endTime)).addObject("businessId", (Object)0);
    }

    @RequestMapping(value={"/backorderlististhird"})
    public ModelAndView backOrderLististhird(HttpServletRequest request, String status, BackOrder bkorder, com.qianjiang.util.PageBean pageBean, String startTime, String endTime) {
        String statusNew = status;
        if (StringUtils.isEmpty((String)statusNew)) {
            statusNew = "1";
        }
        pageBean.setUrl("backorderlististhird.htm");
        return new ModelAndView("jsp/order/backorderlist", "pageBean", (Object)this.backOrderService.backOrderList(pageBean, bkorder, startTime, endTime)).addObject("businessId", (Object)1);
    }

    @RequestMapping(value={"modifyBackOrder"})
    public ModelAndView modifyBackOrderByCheck(BackOrder backOrder, HttpServletRequest request) {
        this.orderLogService.insertSelective(null, backOrder.getOrderId(), request.getSession().getAttribute("name").toString(), "5");
        int count = this.backOrderService.modifyBackBeanCheck(backOrder);
        if (count > 0) {
            return new ModelAndView((View)new RedirectView(BACKORDERLIST_HTM));
        }
        return null;
    }

    @RequestMapping(value={"modifyBackOrderisthird"})
    public ModelAndView modifyBackOrderByCheckisthird(BackOrder backOrder, HttpServletRequest request) {
        this.orderLogService.insertSelective(null, backOrder.getOrderId(), request.getSession().getAttribute("name").toString(), "5");
        int count = this.backOrderService.modifyBackBeanCheck(backOrder);
        if (count > 0) {
            return new ModelAndView((View)new RedirectView("backorderlististhird.htm"));
        }
        return null;
    }

    @RequestMapping(value={"/newbackdetail"})
    public ModelAndView newBackDetail(String backId, String orderId, String businessId) {
        List backOrderLogs = this.backOrderLogService.queryByBackId(Long.valueOf(backId));
        BackOrder backorder = this.backOrderService.backdetail(Long.valueOf(backId), Long.valueOf(orderId));
        List repairCostList = null;
        BigDecimal repairCostPriceSum = null;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("orderBarterId", backId);
        List orderBarterGoodsList = this.orderBarterGoodsService.selectByOrderBarterIdAll(map);
        List goodsProductAll = null;
        if (orderBarterGoodsList.size() > 0) {
            Long[] productGoodsIds = new Long[orderBarterGoodsList.size()];
            int index = 0;
            for (OrderBarterGoods orderBarterGoods : orderBarterGoodsList) {
                productGoodsIds[index] = orderBarterGoods.getGoodsInfoId();
                ++index;
            }
            List<Long> list = Arrays.asList(productGoodsIds);
            goodsProductAll = this.GoodsProductService.selectProductByGoodsInFoId(list);
        }
        BackOrderGeneral backOrderGeneral = this.backOrderService.queryBackOrderGeneral(Long.valueOf(backId));
        String orderCode = backorder.getOrderCode();
        repairCostList = this.repairCostService.selectAllByOrderCode(orderCode);
        if (repairCostList != null && repairCostList.size() != 0) {
            for (RepairCost repairCost : repairCostList) {
                if (repairCost.getIsAssessment() != "1" && !"1".equals(repairCost.getIsAssessment()) || repairCost.getOrderType() != "1" && !"1".equals(repairCost.getOrderType())) continue;
                repairCostPriceSum = repairCost.getRepairPrice();
                BigDecimal sumPrice = backorder.getBackOrderGoodsList().get(0).getGoodsBackPrice();
                for (GoodsProduct goodsProduct : goodsProductAll) {
                    repairCostPriceSum = repairCostPriceSum.add(goodsProduct.getGoodsInfoPreferPrice());
                }
                repairCostPriceSum = sumPrice.subtract(repairCostPriceSum);
            }
        }
        return new ModelAndView("jsp/order/backorderdetail").addObject(BACKORDER, (Object)this.backOrderService.backdetail(Long.valueOf(backId), Long.valueOf(orderId))).addObject(ORDERLOGS, (Object)this.orderLogService.selectOrderLogByOrderId(Long.valueOf(orderId))).addObject(ORDERID, (Object)orderId).addObject(BACKORDERLOGS, (Object)backOrderLogs).addObject(BACKORDERGENERAL, (Object)backOrderGeneral).addObject("businessId", (Object)businessId).addObject("goodsProductAll", (Object)goodsProductAll).addObject("repairCostList", (Object)repairCostList).addObject("repairCostPriceSum", (Object)repairCostPriceSum);
    }

    @RequestMapping(value={"/newbackprice"})
    public ModelAndView newbackprice(String backId, String orderId, String businessId) {
        List backOrderLogs = this.backOrderLogService.queryByBackId(Long.valueOf(backId));
        BackOrderGeneral backOrderGeneral = this.backOrderService.queryBackOrderGeneral(Long.valueOf(backId));
        return new ModelAndView("jsp/order/backorderprice").addObject(BACKORDER, (Object)this.backOrderService.backdetail(Long.valueOf(backId), Long.valueOf(orderId))).addObject(ORDERLOGS, (Object)this.orderLogService.selectOrderLogByOrderId(Long.valueOf(orderId))).addObject(ORDERID, (Object)orderId).addObject(BACKORDERLOGS, (Object)backOrderLogs).addObject(BACKORDERGENERAL, (Object)backOrderGeneral).addObject("businessId", (Object)businessId);
    }

    @RequestMapping(value={"/backorderdetail"})
    public ModelAndView backOrderDetail(Long backOrderId, Long orderId) {
        List backOrderLogs = this.backOrderLogService.queryByBackId(backOrderId);
        Order order = this.orderService.getPayOrder(orderId);
        BackOrderGeneral backOrderGeneral = this.backOrderService.queryBackOrderGeneral(backOrderId);
        return new ModelAndView("jsp/order/newbackorderdetail").addObject(BACKORDER, (Object)this.backOrderService.backdetail(backOrderId, orderId)).addObject(ORDERLOGS, (Object)this.orderLogService.selectOrderLogByOrderId(orderId)).addObject(ORDERID, (Object)orderId).addObject(BACKORDERLOGS, (Object)backOrderLogs).addObject("backPrice", (Object)order.getBackPrice()).addObject(BACKORDERGENERAL, (Object)backOrderGeneral);
    }

    @RequestMapping(value={"back/upload"})
    public void uploadBackImg(MultipartHttpServletRequest request, HttpServletResponse resp, Long orderId) throws IOException {
        PrintWriter out = resp.getWriter();
        String msg = null;
        MultipartFile file = request.getFile("uploadDocument");
        file.getOriginalFilename();
        msg = file.getSize() > 0x400000L ? "101" : (!this.checkExtendsName(file.getOriginalFilename()) ? "102" : (String)UploadUtil.uploadFileByWidth((MultipartFile)request.getFile("uploadDocument")).get("oldimg") + "," + orderId);
        out.append("<script>parent.callback('" + msg + "');</script>");
    }

    @RequestMapping(value={"back/keepBackOrderInfoprice"})
    public ModelAndView keepBackOrderInfoprice(HttpServletRequest request, BackOrder backOrder) {
        if (this.backOrderService.isBackOrderRecordExist(backOrder.getOrderCode())) {
            LOGGER.error("orderCode :" + backOrder.getOrderCode() + "alerdy exist BackOrderRecord");
            return new ModelAndView((View)new RedirectView("../customer/myorder.html"));
        }
        backOrder.setBusinessId(this.orderService.getPayOrder(backOrder.getOrderId()).getBusinessId());
        backOrder.setBackOrderCode(this.createBackOrderNo());
        backOrder.setBackCheck("6");
        backOrder.setBackTime(new Date());
        int count = this.backOrderService.insertBackOrderInfo(backOrder);
        this.orderService.updateStatusBackById(backOrder.getOrderId(), "15", null);
        if (count > 0) {
            BackOrderLog backOrderLog = new BackOrderLog();
            backOrderLog.setBackLogPerson("customer");
            backOrderLog.setBackLogTime(new Date());
            backOrderLog.setBackLogStatus("1");
            backOrderLog.setBackOrderId(backOrder.getBackOrderId());
            this.backOrderLogService.insert(backOrderLog);
        }
        return new ModelAndView((View)new RedirectView("../customer/myorder.html"));
    }

    @RequestMapping(value={"/checkIsBackGoods"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> checkIsBackGoods(HttpServletRequest req, String orderCode) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("result", false);
        try {
            BackOrder backOrder = new BackOrder();
            backOrder.setOrderCode(orderCode);
            BackOrder isBackOrder = this.backOrderService.isBackOrder(backOrder.getOrderCode());
            if (isBackOrder != null) {
                resultMap.put("result", true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5728\u786e\u8ba4\u7533\u8bf7\u9000\u8d27\u5148\u5224\u65ad\u662f\u5426\u5df2\u7ecf\u9000\u8d27\u8fc7\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return resultMap;
    }

    @RequestMapping(value={"back/keepBarterOrderInfo"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ModelAndView keepBarterOrderInfo(HttpServletRequest request, BackOrder backOrder, String orderCode) {
        int i;
        String[] goods = request.getParameterValues("goods");
        String[] goodsId = request.getParameterValues("goodsId");
        String[] goodsInfoId = request.getParameterValues("goodsInfoId");
        BackOrder isBackOrder = this.backOrderService.isBackOrder(backOrder.getOrderCode());
        backOrder.setBusinessId(this.orderService.getPayOrder(backOrder.getOrderId()).getBusinessId());
        backOrder.setBackCheck("0");
        backOrder.setBackTime(new Date());
        Order order = this.orderService.getPayOrder(backOrder.getOrderId());
        if ("".equals(backOrder.getBackGoodsIdAndSum())) {
            order.setBackPrice(order.getOrderPrice().subtract(order.getExpressPrice()));
            List og = this.orderService.queryOrderGoods(order.getOrderId());
            StringBuilder goodsInfo = new StringBuilder();
            for (i = 0; i < og.size(); ++i) {
                if (i > 0) {
                    goodsInfo.append("-");
                }
                goodsInfo.append(((OrderGoods)og.get(i)).getGoodsInfoId() + "," + ((OrderGoods)og.get(i)).getGoodsInfoNum() + "," + ((OrderGoods)og.get(i)).getOrderGoodsId());
            }
            backOrder.setBackGoodsIdAndSum(goodsInfo.toString());
        }
        int count = 0;
        if (null == isBackOrder) {
            backOrder.setBackOrderCode(this.createBackOrderNo());
            count = this.backOrderService.insertBackOrderInfo(backOrder);
        }
        Long barterId = this.backOrderService.selectLastId();
        for (i = 0; i < goods.length; ++i) {
            JSONObject object = JSONObject.fromObject((Object)goods[i]);
            OrderBarterGoodsDomain orderBarterGoodsDomain = new OrderBarterGoodsDomain();
            orderBarterGoodsDomain.setOrderBarterId(barterId);
            orderBarterGoodsDomain.setGoodsId(Long.valueOf(Long.parseLong(object.getString("goodsId"))));
            orderBarterGoodsDomain.setGoodsInfoId(Long.valueOf(Long.parseLong(object.getString("goodsInfoId"))));
            orderBarterGoodsDomain.setGoodsIdCover(Long.valueOf(Long.parseLong(goodsId[0])));
            orderBarterGoodsDomain.setGoodsInfoIdCover(Long.valueOf(Long.parseLong(goodsInfoId[0])));
            orderBarterGoodsDomain.setGoodsInfoOldPrice(new BigDecimal(object.getString("goodsPrice")));
            orderBarterGoodsDomain.setCreateTiem(new Date());
            orderBarterGoodsDomain.setBarterTime(new Date());
            this.orderBarterGoodsService.saveOrderBarterGoods(orderBarterGoodsDomain);
            request.getSession().setAttribute("orderBarterGoodsDomain", (Object)orderBarterGoodsDomain);
        }
        this.orderService.updateStatusBackById(backOrder.getOrderId(), "14", null);
        if (count > 0) {
            BackOrderLog backOrderLog = new BackOrderLog();
            backOrderLog.setBackLogPerson("customer");
            backOrderLog.setBackLogTime(new Date());
            backOrderLog.setBackLogStatus("1");
            backOrderLog.setBackOrderId(backOrder.getBackOrderId());
            this.backOrderLogService.insert(backOrderLog);
        }
        return new ModelAndView((View)new RedirectView("../customer/myorder.html"));
    }

    @RequestMapping(value={"back/keepBackOrderInfo"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ModelAndView keepBackOrderInfo(HttpServletRequest request, BackOrder backOrder, String orderCode) {
        BackOrder isBackOrder = this.backOrderService.isBackOrder(backOrder.getOrderCode());
        backOrder.setBusinessId(this.orderService.getPayOrder(backOrder.getOrderId()).getBusinessId());
        backOrder.setBackCheck("0");
        backOrder.setBackTime(new Date());
        Order order = this.orderService.getPayOrder(backOrder.getOrderId());
        if ("".equals(backOrder.getBackGoodsIdAndSum())) {
            order.setBackPrice(order.getOrderPrice().subtract(order.getExpressPrice()));
            List og = this.orderService.queryOrderGoods(order.getOrderId());
            StringBuilder goodsInfo = new StringBuilder();
            for (int i = 0; i < og.size(); ++i) {
                if (i > 0) {
                    goodsInfo.append("-");
                }
                goodsInfo.append(((OrderGoods)og.get(i)).getGoodsInfoId() + "," + ((OrderGoods)og.get(i)).getGoodsInfoNum() + "," + ((OrderGoods)og.get(i)).getOrderGoodsId());
            }
            backOrder.setBackGoodsIdAndSum(goodsInfo.toString());
        }
        int count = 0;
        if (null == isBackOrder) {
            backOrder.setBackOrderCode(this.createBackOrderNo());
            count = this.backOrderService.insertBackOrderInfo(backOrder);
        }
        this.orderService.updateStatusBackById(backOrder.getOrderId(), "14", null);
        if (count > 0) {
            BackOrderLog backOrderLog = new BackOrderLog();
            backOrderLog.setBackLogPerson("customer");
            backOrderLog.setBackLogTime(new Date());
            backOrderLog.setBackLogStatus("1");
            backOrderLog.setBackOrderId(backOrder.getBackOrderId());
            this.backOrderLogService.insert(backOrderLog);
        }
        return new ModelAndView((View)new RedirectView("../customer/myorder.html"));
    }

    @RequestMapping(value={"savebackorderdetail"})
    public ModelAndView saveBackOrderDetail(HttpServletRequest request, HttpServletResponse response, BackOrderLog backOrderLog, Long orderId, BigDecimal backPrice) {
        backOrderLog.setBackLogPerson(ADMIN);
        backOrderLog.setBackLogTime(new Date());
        this.backOrderLogService.insert(backOrderLog);
        Order order = this.orderService.getPayOrder(orderId);
        BackOrder backOrder = this.backOrderService.queryBackOrderByOrderCode(order.getOrderCode());
        if (Long.valueOf(backOrderLog.getBackLogStatus()) == 2L) {
            if (Long.valueOf(backOrder.getIsBack()) == 1L) {
                this.orderService.updateStatusBackById(orderId, "8", backPrice);
                this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "9");
            }
            if (Long.valueOf(backOrder.getIsBack()) == 2L) {
                this.orderService.updateStatusBackById(orderId, "12", backPrice);
                this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "3");
            }
        } else if (Long.valueOf(backOrderLog.getBackLogStatus()) == 3L) {
            this.orderService.updateStatusBackById(orderId, "9", backPrice);
            this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "2");
        } else if (Long.valueOf(backOrderLog.getBackLogStatus()) == 5L) {
            this.orderService.updateStatusBackById(orderId, "10", backPrice);
            this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "3");
        } else if (Long.valueOf(backOrderLog.getBackLogStatus()) == 6L) {
            this.orderService.updateStatusBackById(orderId, "16", backPrice);
            this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "8");
        } else if (Long.valueOf(backOrderLog.getBackLogStatus()) == 7L) {
            this.orderService.updateStatusBackById(orderId, "17", backPrice);
            int cont = this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "4");
            if (cont == 1) {
                this.backOrderService.reducePointOrderBack(orderId);
                this.backOrderService.addStockOrderBack(orderId, backOrderLog.getBackOrderId());
            }
        }
        PrintWriter out = null;
        try {
            out = response.getWriter();
            out.append("<script>parent.call_back();</script>");
        }
        catch (IOException e) {
            LOGGER.error("\u65b0\u589e\u4e00\u6761\u9000\u8d27\u64cd\u4f5c\u65e5\u5fd7", (Throwable)e);
        }
        return null;
    }

    @RequestMapping(value={"/newsavebackorderprice"})
    public ModelAndView newsaveBackOrderprice(HttpServletRequest request, HttpServletResponse response, BackOrderLog backOrderLog, Long orderId, BigDecimal backPrice) {
        backOrderLog.setBackLogPerson(ADMIN);
        backOrderLog.setBackLogTime(new Date());
        this.backOrderLogService.insert(backOrderLog);
        Order order = this.orderService.getPayOrder(orderId);
        BackOrder backOrder = this.backOrderService.queryBackOrderByOrderCode(order.getOrderCode());
        if (Long.valueOf(backOrderLog.getBackLogStatus()) == 2L) {
            if (Long.valueOf(backOrder.getIsBack()) == 1L) {
                this.orderService.updateStatusBackById(orderId, "8", backPrice);
                this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "9");
            }
            if (Long.valueOf(backOrder.getIsBack()) == 2L) {
                this.orderService.updateStatusBackById(orderId, "12", backPrice);
                this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "3");
            }
        } else if (Long.valueOf(backOrderLog.getBackLogStatus()) == 3L) {
            this.orderService.updateStatusBackById(orderId, "9", backPrice);
            this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "2");
        } else if (Long.valueOf(backOrderLog.getBackLogStatus()) == 5L) {
            this.orderService.updateStatusBackById(orderId, "10", backPrice);
            this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "3");
        } else if (Long.valueOf(backOrderLog.getBackLogStatus()) == 6L) {
            this.orderService.updateStatusBackById(orderId, "16", backPrice);
            this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "8");
        } else if (Long.valueOf(backOrderLog.getBackLogStatus()) == 7L || Long.valueOf(backOrderLog.getBackLogStatus()) == 8L) {
            this.orderService.updateStatusBackById(orderId, "17", backPrice);
            int cont = this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "4");
            if (cont == 1) {
                this.backOrderService.reducePointOrderBack(orderId);
            }
        } else if (Long.valueOf(backOrderLog.getBackLogStatus()) == 9L) {
            this.orderService.updateStatusBackById(orderId, "13", backPrice);
            int cont = this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "7");
            if (cont == 1) {
                this.backOrderService.reducePointOrderBack(orderId);
            }
        }
        return new ModelAndView((View)new RedirectView(BACKORDERLIST_HTM));
    }

    @RequestMapping(value={"/canelBackOrder"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int canelBackOrder(HttpServletRequest request, HttpServletResponse response, String orderCode, String backOrderId, String orderType) {
        if ("0".equals(orderType) || "1".equals(orderType)) {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            BackOrder backOrder = new BackOrder();
            backOrder.setCustomerId(customerId);
            backOrder.setOrderCode(orderCode);
            backOrder.setBackCheck("16");
            int result = this.backOrderService.updateBackOrderByOrderCodesMix(backOrder);
            if (result > 0) {
                Order order = new Order();
                order.setOrderCode(orderCode);
                order.setOrderCargoStatus("0");
                order.setOrderStatus("3");
                this.orderService.updateOrderCodes(order);
                return 1;
            }
        }
        return 0;
    }

    @RequestMapping(value={"/deliverBarterOrder"}, produces={"application/json;charset=UTF-8"})
    public ModelAndView deliverBarterOrder(HttpServletRequest request, HttpServletResponse response) {
        return null;
    }

    @RequestMapping(value={"/barterCostBuy"})
    public ModelAndView barterCostBuy(HttpServletRequest request, HttpServletResponse response, Long orderId, String orderNo, BackOrderLog backOrderLog, BigDecimal backPrice, String repairCostStatus, String goodsPrice, String backOrderId) throws IOException {
        Object out = null;
        HashMap<String, String> map = new HashMap<String, String>();
        if (backOrderId == null || backOrderId == "") {
            backOrderId = (String)request.getSession().getAttribute("backOrderId");
            orderNo = (String)request.getSession().getAttribute("orderNo");
            backPrice = (BigDecimal)request.getSession().getAttribute("backPrice");
        }
        map.put("orderBarterId", backOrderId);
        request.getSession().setAttribute("backOrderId", (Object)backOrderId);
        List orderBarterGodos = this.orderBarterGoodsService.selectByOrderBarterIdAll(map);
        BigDecimal orderBarterPriceSum = new BigDecimal(0);
        Long[] orderBarterGood = new Long[orderBarterGodos.size()];
        int index = 0;
        int index2 = 0;
        for (OrderBarterGoods orderBarterGoods : orderBarterGodos) {
            ++index2;
        }
        Long[] l = new Long[index2];
        for (OrderBarterGoods orderBarterGoods : orderBarterGodos) {
            l[index] = 1L;
            orderBarterGood[index] = orderBarterGoods.getGoodsInfoId();
            orderBarterPriceSum = orderBarterGoods.getGoodsInfoOldPrice().add(orderBarterPriceSum);
            ++index;
        }
        HashMap<String, String> repairMap = new HashMap<String, String>();
        repairMap.put("orderType", "1");
        repairMap.put("isAssessment", "1");
        repairMap.put("orderCode", orderNo);
        request.getSession().setAttribute("orderNo", (Object)orderNo);
        request.getSession().setAttribute("backPrice", (Object)backPrice);
        RepairCost repairCost = (RepairCost)JSON.parseObject((String)JSON.toJSONString((Object)this.repairCostService.selectRepairCostByCode(repairMap)), RepairCost.class);
        double subtractPrice = backPrice.subtract(orderBarterPriceSum.add(repairCost.getRepairPrice())).doubleValue();
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        OrderAddress orderAddressNew = new OrderAddress();
        CustomerAddress customerAddress = this.customerAddressServiceMix.queryDefaultAddr(customerId);
        if (null == customerAddress) {
            customerAddress = this.customerAddressServiceMix.selectByCIdFirst(customerId);
        } else if (orderAddressNew.getAddressName() == null || orderAddressNew.getAddressPhone() == null || orderAddressNew.getAddressDetail() == null || orderAddressNew.getAddressDetailInfo() == null) {
            orderAddressNew = new OrderAddress();
            orderAddressNew.setAddressId(customerAddress.getAddressId());
            orderAddressNew.setAddressDetailInfo(customerAddress.getAddressDetail());
            orderAddressNew.setAddressName(customerAddress.getAddressName());
            orderAddressNew.setAddressPhone(customerAddress.getAddressMoblie());
            orderAddressNew.setAddressDetail(customerAddress.getProvince().getProvinceName() + customerAddress.getCity().getCityName() + customerAddress.getDistrict().getDistrictName());
        } else {
            orderAddressNew.setAddressCitySecondStageName(new String(orderAddressNew.getAddressCitySecondStageName().getBytes(ISO_8859_1), "utf-8"));
            orderAddressNew.setAddressCountiesThirdStageName(new String(orderAddressNew.getAddressCountiesThirdStageName().getBytes(ISO_8859_1), "utf-8"));
            orderAddressNew.setAddressDetail(new String(orderAddressNew.getAddressDetail().getBytes(ISO_8859_1), "utf-8"));
            orderAddressNew.setAddressDetailInfo(new String(orderAddressNew.getAddressDetailInfo().getBytes(ISO_8859_1), "utf-8"));
            orderAddressNew.setAddressName(new String(orderAddressNew.getAddressName().getBytes(ISO_8859_1), "utf-8"));
            orderAddressNew.setAddressPhone(new String(orderAddressNew.getAddressPhone().getBytes(ISO_8859_1), "utf-8"));
            orderAddressNew.setProviceFirstStageName(new String(orderAddressNew.getProviceFirstStageName().getBytes(ISO_8859_1), "utf-8"));
        }
        if (subtractPrice <= 0.0) {
            request.getSession().setAttribute("orderAddress", (Object)orderAddressNew);
            request.getSession().setAttribute("subtractPrice", (Object)String.valueOf(subtractPrice).substring(1, String.valueOf(subtractPrice).length()));
            request.getSession().setAttribute("orderBarterPriceSum", (Object)orderBarterPriceSum);
            request.getSession().setAttribute("repairCost", (Object)repairCost);
            request.getSession().setAttribute("orderBarterGoodIndex", (Object)orderBarterGood);
            return new ModelAndView("order/bartersuborder");
        }
        OrderLogger orderLogger = new OrderLogger();
        orderLogger.setName((String)request.getSession().getAttribute("name"));
        orderLogger.setOrderId(orderId.toString());
        orderLogger.setDetail("Customer\u5b9a\u635f\u786e\u8ba4\u5b8c\u6210");
        orderLogger.setType("\u5b9a\u635f\u786e\u8ba4\u7ef4\u4fee");
        orderLogger.setStatus("0");
        this.orderLoggerService.saveLogger(orderLogger);
        List orders = this.returngoods.selectBackOrderId(orderNo);
        BigDecimal backPriceNew = backPrice;
        if (backPriceNew == null) {
            backPriceNew = ((BackOrder)orders.get(0)).getOrderPrice();
        }
        backOrderLog.setBackLogStatus("14");
        backOrderLog.setBackOrderId(((BackOrder)orders.get(0)).getBackOrderId());
        backOrderLog.setBackLogPerson("customer");
        backOrderLog.setBackLogTime(new Date());
        backOrderLog.setBackRemark("\u786e\u8ba4\u5b9a\u635f\u4fe1\u606f");
        backOrderLog.setCustomerRemark("\u786e\u8ba4\u5b9a\u635f\u4fe1\u606f");
        int result = this.backOrderLogService.insert(backOrderLog);
        this.orderService.updateStatusBackById(orderId, "28", backPriceNew);
        this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "15");
        if (customerAddress == null) {
            customerAddress = this.customerAddressServiceMix.selectByCIdFirst(customerId);
        }
        this.orderService.saveAddOrderInterface(orderBarterPriceSum, new BigDecimal("10"), "25_EMS", "", orderBarterGood, l, Long.valueOf(1690L), Long.valueOf(1L), "", "2", "\u660e\u7ec6", customerAddress, backOrderId, "");
        if (1 == result) {
            ModelAndView mav = new ModelAndView("customer/back_order_list");
            return this.seoService.getCurrSeo(mav);
        }
        return new ModelAndView("order/myorder");
    }

    @RequestMapping(value={"/findRepairByOrderCode"})
    public ModelAndView findRepairByOrderCode(HttpServletRequest request, HttpServletResponse response, String orderCode, String isAssessment) {
        HashMap<String, String> repairMap = new HashMap<String, String>();
        isAssessment = "0".equals(isAssessment) ? "0" : "1";
        repairMap.put("isAssessment", isAssessment);
        repairMap.put("orderCode", orderCode);
        RepairCost repairCost = (RepairCost)JSON.parseObject((String)JSON.toJSONString((Object)this.repairCostService.selectRepairCostByCode(repairMap)), RepairCost.class);
        request.getSession().setAttribute("repairCost", (Object)"");
        return new ModelAndView("/customer/repair_cost_list").addObject("repairCosts", (Object)repairCost);
    }

    @RequestMapping(value={"/confirmPairCost"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int confirmPairCost(HttpServletRequest request, HttpServletResponse response, Long orderId, String orderNo, BackOrderLog backOrderLog, BigDecimal backPrice, String repairCostStatus) {
        if ("0".equals(repairCostStatus)) {
            if ("1".equals("1")) {
                OrderLogger orderLogger = new OrderLogger();
                orderLogger.setName((String)request.getSession().getAttribute("name"));
                orderLogger.setOrderId(orderId.toString());
                orderLogger.setDetail("Customer\u786e\u8ba4\u5b8c\u6210");
                orderLogger.setType("\u786e\u8ba4\u8bc4\u4f30\u7ef4\u4fee");
                orderLogger.setStatus("0");
                this.orderLoggerService.saveLogger(orderLogger);
            }
            List orders = this.returngoods.selectBackOrderId(orderNo);
            BigDecimal backPriceNew = backPrice;
            if (backPriceNew == null) {
                backPriceNew = ((BackOrder)orders.get(0)).getOrderPrice();
            }
            backOrderLog.setBackLogStatus("13");
            backOrderLog.setBackOrderId(((BackOrder)orders.get(0)).getBackOrderId());
            backOrderLog.setBackLogPerson("customer");
            backOrderLog.setBackLogTime(new Date());
            backOrderLog.setBackRemark("\u786e\u8ba4\u8bc4\u4f30\u4fe1\u606f");
            backOrderLog.setCustomerRemark("\u786e\u8ba4\u8bc4\u4f30\u4fe1\u606f");
            int result = this.backOrderLogService.insert(backOrderLog);
            this.orderService.updateStatusBackById(orderId, "8", backPriceNew);
            this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "9");
            if (1 == result) {
                return 1;
            }
        } else if ("1".equals(repairCostStatus)) {
            if ("1".equals("1")) {
                OrderLogger orderLogger = new OrderLogger();
                orderLogger.setName((String)request.getSession().getAttribute("name"));
                orderLogger.setOrderId(orderId.toString());
                orderLogger.setDetail("Customer\u5b9a\u635f\u786e\u8ba4\u5b8c\u6210");
                orderLogger.setType("\u5b9a\u635f\u786e\u8ba4\u7ef4\u4fee");
                orderLogger.setStatus("0");
                this.orderLoggerService.saveLogger(orderLogger);
            }
            List orders = this.returngoods.selectBackOrderId(orderNo);
            BigDecimal backPriceNew = backPrice;
            if (backPriceNew == null) {
                backPriceNew = ((BackOrder)orders.get(0)).getOrderPrice();
            }
            backOrderLog.setBackLogStatus("14");
            backOrderLog.setBackOrderId(((BackOrder)orders.get(0)).getBackOrderId());
            backOrderLog.setBackLogPerson("customer");
            backOrderLog.setBackLogTime(new Date());
            backOrderLog.setBackRemark("\u786e\u8ba4\u5b9a\u635f\u4fe1\u606f");
            backOrderLog.setCustomerRemark("\u786e\u8ba4\u5b9a\u635f\u4fe1\u606f");
            int result = this.backOrderLogService.insert(backOrderLog);
            this.orderService.updateStatusBackById(orderId, "28", backPriceNew);
            this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "15");
            if (1 == result) {
                return 1;
            }
        }
        return 0;
    }

    @RequestMapping(value={"/saveOneRepairCost"})
    public ModelAndView saveOneRepairCost(HttpServletRequest request, HttpServletResponse response, BackOrderLog backOrderLog, Long orderId, BigDecimal backPrice, String orderCode, String goodsBackPrice, String repairPrice, String backOrderId, String isAssessment, String backRemark, String orderType, String barterCycle) throws IOException {
        RepairCostDomain repairCostDomain = new RepairCostDomain();
        String[] goodsInfoItemNo = request.getParameterValues("goodsInfoItemNo");
        barterCycle = barterCycle == null ? "0" : barterCycle;
        PrintWriter out = null;
        BigDecimal backPriceNew = new BigDecimal(goodsBackPrice);
        backOrderLog.setBackOrderId(Long.parseLong(backOrderId));
        backOrderLog.setBackLogPerson(ADMIN);
        backOrderLog.setBackLogTime(new Date());
        Order order = this.orderService.getPayOrder(orderId);
        if (backPriceNew == null) {
            backPriceNew = order.getOrderPrice();
        }
        if (Long.valueOf(backOrderLog.getBackLogStatus()) == 11L) {
            String result = null;
            for (int i = 0; i < goodsInfoItemNo.length; ++i) {
                repairCostDomain.setCreateTime(new Date());
                repairCostDomain.setGoodsInfoId(Long.valueOf(Long.parseLong(goodsInfoItemNo[i])));
                repairCostDomain.setOrderCode(orderCode);
                repairCostDomain.setRepairPrice(new BigDecimal(Integer.parseInt(repairPrice)));
                repairCostDomain.setOrderType(orderType.equals("0") ? "0" : "1");
                repairCostDomain.setIsAssessment(isAssessment);
                repairCostDomain.setBarterCycle(Long.valueOf(Long.parseLong(barterCycle)));
                repairCostDomain.setRepairRemark(backRemark);
                result = this.repairCostService.saveRepairCost(repairCostDomain);
            }
            if (result != "" && result != null) {
                this.orderService.updateStatusBackById(orderId, "26", backPriceNew);
                this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "12");
                if ("1".equals("1")) {
                    OrderLogger orderLogger = new OrderLogger();
                    orderLogger.setName((String)request.getSession().getAttribute("name"));
                    orderLogger.setOrderId(orderId.toString());
                    orderLogger.setDetail("\u7ef4\u4fee\u8d39\u7528\u8bc4\u4f30\u5b8c\u6210");
                    orderLogger.setType("\u8bc4\u4f30\u5b8c\u6210");
                    orderLogger.setStatus("0");
                    this.orderLoggerService.saveLogger(orderLogger);
                }
                backOrderLog.setBackRemark("\u586b\u5199\u8bc4\u4f30\u5355");
                this.backOrderLogService.insert(backOrderLog);
            }
        } else if (Long.valueOf(backOrderLog.getBackLogStatus()) == 12L) {
            String result = null;
            for (int i = 0; i < goodsInfoItemNo.length; ++i) {
                repairCostDomain.setCreateTime(new Date());
                repairCostDomain.setGoodsInfoId(Long.valueOf(Long.parseLong(goodsInfoItemNo[i])));
                repairCostDomain.setOrderCode(orderCode);
                repairCostDomain.setRepairPrice(new BigDecimal(Integer.parseInt(repairPrice)));
                repairCostDomain.setOrderType("0");
                repairCostDomain.setIsAssessment(isAssessment);
                repairCostDomain.setGoodsInfoPrice(backPrice);
                repairCostDomain.setRepairRemark(backRemark);
                repairCostDomain.setOrderType(orderType.equals("0") ? "0" : "1");
                repairCostDomain.setBarterCycle(Long.valueOf(Long.parseLong(barterCycle)));
                result = this.repairCostService.saveRepairCost(repairCostDomain);
            }
            if (result != "" && result != null) {
                this.orderService.updateStatusBackById(orderId, "27", backPriceNew);
                this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "13");
                if ("1".equals("1")) {
                    OrderLogger orderLogger = new OrderLogger();
                    orderLogger.setName((String)request.getSession().getAttribute("name"));
                    orderLogger.setOrderId(orderId.toString());
                    orderLogger.setDetail("\u5b9e\u9645\u5b9a\u635f\u7ef4\u4fee\u8d39\u7528\u8bc4\u4f30\u5b8c\u6210");
                    orderLogger.setType("\u5b9e\u9645\u8bc4\u4f30\u5b8c\u6210");
                    orderLogger.setStatus("0");
                    this.orderLoggerService.saveLogger(orderLogger);
                }
                this.orderService.updateStatusBackById(orderId, "27", backPriceNew);
                this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "13");
            }
            backOrderLog.setBackRemark("\u586b\u5199\u5b9a\u635f\u5355");
            this.backOrderLogService.insert(backOrderLog);
        }
        out = response.getWriter();
        out.append("<script>parent.location.reload();</script>");
        out.flush();
        out.close();
        return null;
    }

    @RequestMapping(value={"/newsavebackorderdetail"})
    public ModelAndView newsaveBackOrderDetail(HttpServletRequest request, HttpServletResponse response, BackOrderLog backOrderLog, Long orderId, BigDecimal backPrice) throws IOException {
        PrintWriter out = null;
        BigDecimal backPriceNew = backPrice;
        backOrderLog.setBackLogPerson(ADMIN);
        backOrderLog.setBackLogTime(new Date());
        this.backOrderLogService.insert(backOrderLog);
        Order order = this.orderService.getPayOrder(orderId);
        if (backPriceNew == null) {
            backPriceNew = order.getOrderPrice();
        }
        BackOrder backOrder = this.backOrderService.queryBackOrderByOrderCode(order.getOrderCode());
        if (Long.valueOf(backOrderLog.getBackLogStatus()) == 15L) {
            if (order.getPayId() == 1L) {
                try {
                    AlipayUtils alipay = new AlipayUtils();
                    String out_trade_no = order.getOrderCode();
                    BigDecimal refund_amount = backPrice;
                    if (refund_amount == null) {
                        refund_amount = backPriceNew;
                    }
                    String refund_reason = backOrder.getBackRemark();
                    String out_request_no = backOrder.getBackOrderCode();
                    RequestDatas requestData = new RequestDatas(out_trade_no, refund_amount, refund_reason, out_request_no);
                    AlipayUtils.AlipayExecute(requestData);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOGGER.error("\u652f\u4ed8\u5b9d\u9000\u6b3e\u5f02\u5e38", (Throwable)e);
                }
            } else if (order.getPayId() == 3L) {
                try {
                    WxPayExecutingRequest wxpay = new WxPayExecutingRequest();
                    String out_trade_no = order.getOrderCode();
                    String out_refund_no = backOrder.getBackOrderCode();
                    BigDecimal total_fee = order.getOrderPrice();
                    BigDecimal refund_fee = backPrice;
                    if (refund_fee == null) {
                        refund_fee = backPriceNew;
                    }
                    WXPayUtil wxPayUtil = new WXPayUtil();
                    int total_fees = WXPayUtil.changeYtoF(total_fee);
                    int refund_fees = WXPayUtil.changeYtoF(refund_fee);
                    RefundRequestParameter refundRequestParameter = new RefundRequestParameter();
                    refundRequestParameter.setOut_trade_no(out_trade_no);
                    refundRequestParameter.setOut_refund_no(out_refund_no);
                    refundRequestParameter.setTotal_fee(total_fees);
                    refundRequestParameter.setRefund_fee(refund_fees);
                    WxPayExecutingRequest.wxRefundExecuting(refundRequestParameter);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOGGER.error("\u5fae\u4fe1\u9000\u6b3e\u5f02\u5e38", (Throwable)e);
                }
            }
            this.orderService.updateStatusBackById(orderId, "17", backPriceNew);
            this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "4");
        } else if (Long.valueOf(backOrderLog.getBackLogStatus()) == 14L) {
            this.orderService.updateStatusBackById(orderId, "27", backPriceNew);
            this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "13");
            if ("1".equals("1")) {
                OrderLogger orderLogger = new OrderLogger();
                orderLogger.setName((String)request.getSession().getAttribute("name"));
                orderLogger.setOrderId(orderId.toString());
                orderLogger.setDetail("\u5b9a\u635f\u5b9e\u9645\u8bc4\u4f30\u7528\u5b8c\u6210");
                orderLogger.setType("\u5b9a\u635f\u5b9e\u9645\u8bc4\u4f30\u5b8c\u6210");
                orderLogger.setStatus("0");
                this.orderLoggerService.saveLogger(orderLogger);
            }
        } else if (Long.valueOf(backOrderLog.getBackLogStatus()) == 2L) {
            if (Long.valueOf(backOrder.getIsBack()) == 1L || Long.valueOf(backOrder.getIsBack()) == 3L) {
                this.orderService.updateStatusBackById(orderId, "24", backPriceNew);
                this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "14");
                if ("1".equals("1")) {
                    OrderLogger orderLogger = new OrderLogger();
                    orderLogger.setName((String)request.getSession().getAttribute("name"));
                    orderLogger.setOrderId(orderId.toString());
                    orderLogger.setDetail("\u901a\u8fc7");
                    orderLogger.setType("\u5ba1\u6838\u9000\u8d27");
                    orderLogger.setStatus("0");
                    this.orderLoggerService.saveLogger(orderLogger);
                }
            }
            if (Long.valueOf(backOrder.getIsBack()) == 2L) {
                this.orderService.updateStatusBackById(orderId, "12", backPriceNew);
                this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "3");
            }
        } else if (Long.valueOf(backOrderLog.getBackLogStatus()) == 3L) {
            this.orderService.updateStatusBackById(orderId, "9", backPriceNew);
            if ("1".equals("1")) {
                OrderLogger orderLogger = new OrderLogger();
                orderLogger.setName((String)request.getSession().getAttribute("name"));
                orderLogger.setOrderId(orderId.toString());
                orderLogger.setDetail("\u9a73\u56de");
                orderLogger.setType("\u5ba1\u6838\u9000\u8d27");
                orderLogger.setStatus("0");
                this.orderLoggerService.saveLogger(orderLogger);
            }
            this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "2");
        } else if (Long.valueOf(backOrderLog.getBackLogStatus()) == 5L) {
            this.orderService.updateStatusBackById(orderId, "25", backPriceNew);
            this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "11");
        } else if (Long.valueOf(backOrderLog.getBackLogStatus()) == 6L) {
            this.orderService.updateStatusBackById(orderId, "16", backPriceNew);
            this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "8");
        } else if (Long.valueOf(backOrderLog.getBackLogStatus()) == 7L) {
            this.orderService.updateStatusBackById(orderId, "17", backPriceNew);
            BackOrder bo = new BackOrder();
            bo.setBackOrderId(backOrder.getBackOrderId());
            bo.setBackPrice(backPriceNew);
            this.backOrderService.updateBackOrderReducePrice(bo);
            int cont = this.backOrderService.modifyBackOrderByCheckNew(backOrderLog.getBackOrderId(), "4");
            if (cont == 1) {
                this.backOrderService.reducePointOrderBack(orderId);
                this.orderCouponService.modifyCouponStatus(orderId);
            }
            this.updateDepositInfo(order, backPrice, backOrder, request);
        } else if (Long.valueOf(backOrderLog.getBackLogStatus()) == 8L) {
            if ("1".equals("1")) {
                OrderLogger orderLogger = new OrderLogger();
                orderLogger.setName((String)request.getSession().getAttribute("name"));
                orderLogger.setOrderId(orderId.toString());
                orderLogger.setDetail("\u901a\u8fc7");
                orderLogger.setType("\u5ba1\u6838\u9000\u6b3e");
                orderLogger.setStatus("0");
                this.orderLoggerService.saveLogger(orderLogger);
            }
            if (order.getPayId() == 1L) {
                try {
                    AlipayUtils alipay = new AlipayUtils();
                    String out_trade_no = order.getOrderCode();
                    BigDecimal refund_amount = backPriceNew;
                    String refund_reason = backOrder.getBackRemark();
                    String out_request_no = backOrder.getBackOrderCode();
                    RequestDatas requestData = new RequestDatas(out_trade_no, refund_amount, refund_reason, out_request_no);
                    AlipayUtils.AlipayExecute(requestData);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOGGER.error("\u652f\u4ed8\u5b9d\u9000\u6b3e\u5f02\u5e38", (Throwable)e);
                }
            } else if (order.getPayId() == 3L) {
                try {
                    WxPayExecutingRequest wxpay = new WxPayExecutingRequest();
                    String out_trade_no = order.getOrderCode();
                    String out_refund_no = backOrder.getBackOrderCode();
                    BigDecimal total_fee = order.getOrderPrice();
                    BigDecimal refund_fee = backPriceNew;
                    WXPayUtil wxPayUtil = new WXPayUtil();
                    int total_fees = WXPayUtil.changeYtoF(total_fee);
                    int refund_fees = WXPayUtil.changeYtoF(refund_fee);
                    RefundRequestParameter refundRequestParameter = new RefundRequestParameter();
                    refundRequestParameter.setOut_trade_no(out_trade_no);
                    refundRequestParameter.setOut_refund_no(out_refund_no);
                    refundRequestParameter.setTotal_fee(total_fees);
                    refundRequestParameter.setRefund_fee(refund_fees);
                    WxPayExecutingRequest.wxRefundExecuting(refundRequestParameter);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOGGER.error("\u5fae\u4fe1\u9000\u6b3e\u5f02\u5e38", (Throwable)e);
                }
            }
            this.orderService.updateStatusBackById(orderId, "18", backPriceNew);
            int cont = this.backOrderService.modifyBackOrderByCheckNew(backOrderLog.getBackOrderId(), "10");
            if (cont == 1) {
                this.backOrderService.reducePointOrderBackNew(orderId);
                this.orderCouponService.modifyCouponStatus(orderId);
            }
            this.updateDepositInfo(order, backPrice, backOrder, request);
        } else if (Long.valueOf(backOrderLog.getBackLogStatus()) == 9L) {
            this.orderService.updateStatusBackById(orderId, "13", backPriceNew);
            int cont = this.backOrderService.modifyBackOrderByCheckNew(backOrderLog.getBackOrderId(), "7");
            if (cont == 1 && "1".equals("1")) {
                OrderLogger orderLogger = new OrderLogger();
                orderLogger.setName((String)request.getSession().getAttribute("name"));
                orderLogger.setOrderId(orderId.toString());
                orderLogger.setDetail("\u9a73\u56de");
                orderLogger.setType("\u5ba1\u6838\u9000\u6b3e");
                orderLogger.setStatus("0");
                this.orderLoggerService.saveLogger(orderLogger);
            }
        }
        out = response.getWriter();
        out.append("<script>parent.location.reload();</script>");
        out.flush();
        out.close();
        return null;
    }

    private boolean checkExtendsName(String fileName) {
        String[] extendNames;
        if (fileName.indexOf(".") < 0) {
            return false;
        }
        String extend = fileName.substring(fileName.lastIndexOf(".") + 1);
        for (String extendName : extendNames = new String[]{"jpg", "jpeg", "bmp", "png", "gif"}) {
            if (!extend.equals(extendName)) continue;
            return true;
        }
        return false;
    }

    public String createBackOrderNo() {
        String d = new SimpleDateFormat("yyyyMMdd").format(Calendar.getInstance().getTime());
        Random r = new Random();
        Double d1 = r.nextDouble();
        String s = d1 + "";
        s = d + s.substring(3, 9);
        return s;
    }

    public BackOrderLogService getBackOrderLogService() {
        return this.backOrderLogService;
    }

    @Resource(name="BackOrderLogService")
    public void setBackOrderLogService(BackOrderLogService backOrderLogService) {
        this.backOrderLogService = backOrderLogService;
    }

    public OrderService getOrderService() {
        return this.orderService;
    }

    @Resource(name="OrderService")
    public void setOrderService(OrderService orderService) {
        this.orderService = orderService;
    }

    public BackOrderService getBackOrderService() {
        return this.backOrderService;
    }

    @Resource(name="BackOrderService")
    public void setBackOrderService(BackOrderService backOrderService) {
        this.backOrderService = backOrderService;
    }

    public OrderLogService getOrderLogService() {
        return this.orderLogService;
    }

    @Resource(name="OrderLogService")
    public void setOrderLogService(OrderLogService orderLogService) {
        this.orderLogService = orderLogService;
    }

    public void updateDepositInfo(Order order, BigDecimal backPrice, BackOrder backOrder, HttpServletRequest request) {
        if (order.getPayId().intValue() == 5) {
            Long customerId = order.getCustomerId();
            DepositInfo depositInfo = this.depositInfoService.selectDepositByCustId(customerId);
            BigDecimal preDepositPrice = depositInfo.getPreDeposit();
            preDepositPrice = backPrice == null || backPrice.intValue() == 0 ? (preDepositPrice == null || preDepositPrice.intValue() == 0 ? order.getOrderPrice() : preDepositPrice.add(order.getOrderPrice())) : (preDepositPrice == null || preDepositPrice.intValue() == 0 ? backPrice : preDepositPrice.add(backPrice));
            depositInfo.setPreDeposit(preDepositPrice);
            if (depositInfo.getFreezePreDeposit() != null && depositInfo.getFreezePreDeposit().intValue() != 0) {
                preDepositPrice = preDepositPrice.add(depositInfo.getFreezePreDeposit());
            }
            TradeInfo tradeInfo = this.getTradeInfo(customerId, backOrder, preDepositPrice, backPrice, order);
            this.tradeInfoService.insertTradeInfo(tradeInfo);
            this.depositInfoService.updateDeposit(depositInfo);
        }
    }

    public TradeInfo getTradeInfo(Long customerId, BackOrder backOrder, BigDecimal currentPrice, BigDecimal backPrice, Order order) {
        TradeInfo tradeInfo = new TradeInfo();
        tradeInfo.setCustomerId(customerId);
        tradeInfo.setOrderCode(backOrder.getOrderCode());
        tradeInfo.setOrderType("1");
        tradeInfo.setOrderStatus("4");
        tradeInfo.setCurrentPrice(currentPrice);
        BigDecimal orderPrice = backPrice == null || backPrice.intValue() == 0 ? backOrder.getBackPrice() : backPrice;
        tradeInfo.setOrderPrice(orderPrice);
        tradeInfo.setCreateTime(new Date());
        tradeInfo.setUpdateTime(new Date());
        tradeInfo.setDelFlag("0");
        tradeInfo.setTradeRemark("\u9000\u6b3e\u8ba2\u5355:" + order.getOrderCode() + ",\u9000\u6b3e\u5355\u53f7:" + backOrder.getBackOrderCode());
        return tradeInfo;
    }
}

