/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.order.controller;

import com.qianjiang.goods.service.WareHouseService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.order.bean.Order;
import com.qianjiang.order.bean.OrderContainer;
import com.qianjiang.order.bean.OrderExpress;
import com.qianjiang.order.service.OrderCouponService;
import com.qianjiang.order.service.OrderLogService;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.system.bean.LogisticsSingle;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.system.service.ILogisticsCompanyBiz;
import com.qianjiang.system.service.LogisticsSingleService;
import com.qianjiang.util.MyLogger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AjaxOrderCargoController {
    public static final MyLogger LOGGER = new MyLogger(AjaxOrderCargoController.class);
    private static final String ORDER = "order";
    private static final String YSTATUS = "yStatus";
    private static final String RELATIONS = "relations";
    private OrderService orderService;
    private OrderCouponService orderCouponService;
    private OrderLogService orderLogService;
    @Resource(name="logisticsCompanyBizImpl")
    private ILogisticsCompanyBiz iLogisticsCompanyBiz;
    @Resource(name="LogisticsSingleService")
    private LogisticsSingleService logisticsSingleService;
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;
    @Resource(name="WareHouseService")
    private WareHouseService wareHouseService;

    @RequestMapping(value={"/orderpickingajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> orderPickingajax(Long[] orderId, HttpServletRequest request, String status, String yStatus) {
        String pickingName = request.getSession().getAttribute("name").toString();
        return this.orderService.queryByPincking(orderId, Long.valueOf(0L), pickingName, status);
    }

    @RequestMapping(value={"changeorderbyfif"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int changeOrderByFif(Long[] orderIds, String status, HttpServletRequest request, String token) {
        int i;
        if (token == null || !"L".equals(token)) {
            return 0;
        }
        for (i = 0; i < orderIds.length; ++i) {
            if (this.orderService.judgeStatus("0", orderIds[i]) != 0) continue;
            return 0;
        }
        for (i = 0; i < orderIds.length; ++i) {
            this.orderLogService.insertSelective(null, orderIds[i], request.getSession().getAttribute("name").toString(), "2");
        }
        return this.orderService.updateOrderCargoStatusByOrderIds(orderIds, status);
    }

    @RequestMapping(value={"/ordercontainerajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> orderContainerajax(Long orderId, HttpServletRequest request, String yStatus) {
        this.orderService.initContainerRelation(orderId);
        List relations = this.orderService.queryContainerRalation(orderId);
        Order order = this.orderService.getPayOrder(orderId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(ORDER, order);
        map.put(RELATIONS, relations);
        map.put(YSTATUS, yStatus);
        return map;
    }

    @RequestMapping(value={"modifyorderbyparam"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int modifyOrderByParam(Long orderId, String orderStatus, HttpServletRequest request, String token) {
        if (token == null || !"L".equals(token)) {
            return 0;
        }
        if (this.orderService.judgeStatus("1", orderId) == 0) {
            return 0;
        }
        this.orderLogService.insertSelective(null, orderId, request.getSession().getAttribute("name").toString(), "3");
        return this.orderService.updateSetCargoStatusByOrderId(orderId, orderStatus);
    }

    @RequestMapping(value={"/addcontainerajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int addContainerajax(Long orderId, HttpServletRequest request) {
        this.orderService.addContainerRalation(orderId);
        return 1;
    }

    @RequestMapping(value={"/updatecontainer"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean updateContainer(OrderContainer container, Long orderId, HttpServletRequest request) {
        OrderContainer orderContainer = this.orderService.queryOrderContainerById(container.getContainerId());
        OrderContainer newCon = this.orderService.queryOrderContainerByGoodInfoId(container.getRelationId(), orderContainer.getGoodsInfoId());
        if (orderContainer.getGoodsNum() > container.getGoodsNum()) {
            orderContainer.setGoodsNum(orderContainer.getGoodsNum() - container.getGoodsNum());
            this.orderService.updateRelation(orderContainer);
            if (newCon != null) {
                newCon.setGoodsNum(newCon.getGoodsNum() + container.getGoodsNum());
                this.orderService.updateRelation(newCon);
            } else {
                newCon = container;
                newCon.setContainerId(null);
                newCon.setGoodsInfoId(orderContainer.getGoodsInfoId());
                newCon.setContainerStatus("0");
                if (StringUtils.isNotEmpty((String)orderContainer.getContainerStatus()) && orderContainer.getContainerStatus().equals("1")) {
                    newCon.setContainerStatus("1");
                }
                this.orderService.addRelation(newCon);
            }
        } else if (orderContainer.getGoodsNum().equals(container.getGoodsNum())) {
            if (newCon != null) {
                newCon.setGoodsNum(newCon.getGoodsNum() + container.getGoodsNum());
                this.orderService.updateRelation(newCon);
                this.orderService.delContainerByCId(container.getContainerId());
            } else {
                this.orderService.updateRelation(container);
            }
        }
        return true;
    }

    @RequestMapping(value={"/updatecontainerajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int updateContainerajax(OrderContainer container, Long orderId, HttpServletRequest request) {
        this.orderService.updateRelation(container);
        return 1;
    }

    @RequestMapping(value={"/delrelationbyidajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int delRelationByIdajax(Long relationId, Long orderId, HttpServletRequest request) {
        this.orderService.delRelationById(relationId);
        return 1;
    }

    @RequestMapping(value={"/verifycount"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Long verifyCount(Long relationId) {
        return this.orderService.verifyCount(relationId);
    }

    @RequestMapping(value={"/sendgoodsorder"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> sendGoodsOrder(Long expressId, Long orderId, HttpServletRequest request, String status, String yStatus) {
        List relations = this.orderService.queryContainerRalation(orderId);
        Order order = this.orderService.getPayOrder(orderId);
        OrderExpress express = null;
        if (expressId != null) {
            express = new OrderExpress();
            express.setExpressId(expressId);
        } else {
            express = this.orderService.expressDetail(orderId);
        }
        order.setOrderExpress(express);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(ORDER, order);
        map.put(RELATIONS, relations);
        map.put("status", status);
        map.put(YSTATUS, yStatus);
        map.put("expressList", this.iLogisticsCompanyBiz.queryAllLogisticsCompany());
        map.put("basicSet", this.basicSetService.findBasicSet());
        List wareHouses = this.wareHouseService.queryAllWareHouse();
        if (wareHouses != null) {
            map.put("ware", wareHouses.get(0));
        }
        LogisticsSingle logisticsSingle = this.logisticsSingleService.selectLogisticsSingle(Long.valueOf(0L), express.getExpressId());
        map.put("logisticsSingle", logisticsSingle);
        return map;
    }

    @RequestMapping(value={"/subsendgoodsorder"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int subSendGoodsorder(String token, Long orderId, Long[] relationIds, String[] expressNo, HttpServletRequest request, int[] expressId) {
        if (token == null || !"L".equals(token)) {
            return 0;
        }
        if (this.orderService.judgeStatus("2", orderId) == 0) {
            return 0;
        }
        this.orderService.updateSendOrderGoods(relationIds, expressNo, expressId);
        String pickingName = request.getSession().getAttribute("name").toString();
        this.orderLogService.insertSelective(null, orderId, request.getSession().getAttribute("name").toString(), "4");
        this.orderService.sendOrderByP(orderId, "2", pickingName, "2", Long.valueOf(0L));
        this.orderService.updateSetCargoStatusByOrderId(orderId, "3");
        return 0;
    }

    @RequestMapping(value={"onekeydelivery"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean isOneKeyDeliveryFinished(HttpServletRequest request, Long orderId, String expressNo, Long thirdId, Long logComId) {
        if (orderId == null || StringUtils.isEmpty((String)expressNo) || thirdId == null) {
            return false;
        }
        long loginUserId = (Long)request.getSession().getAttribute("loginUserId");
        String name = (String)request.getSession().getAttribute("name");
        String ip = IPAddress.getIpAddr((HttpServletRequest)request);
        return this.orderService.isOneKeyDeliveryFinished(orderId, expressNo, name, loginUserId, ip, thirdId, logComId);
    }

    public OrderService getOrderService() {
        return this.orderService;
    }

    @Resource(name="OrderService")
    public void setOrderService(OrderService orderService) {
        this.orderService = orderService;
    }

    public OrderCouponService getOrderCouponService() {
        return this.orderCouponService;
    }

    @Resource(name="OrderCouponService")
    public void setOrderCouponService(OrderCouponService orderCouponService) {
        this.orderCouponService = orderCouponService;
    }

    public OrderLogService getOrderLogService() {
        return this.orderLogService;
    }

    @Resource(name="OrderLogService")
    public void setOrderLogService(OrderLogService orderLogService) {
        this.orderLogService = orderLogService;
    }
}

