/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.order.controller;

import com.qianjiang.customer.bean.CustomerAddress;
import com.qianjiang.goods.service.WareHouseService;
import com.qianjiang.order.bean.Order;
import com.qianjiang.order.bean.OrderExpress;
import com.qianjiang.order.service.OrderCouponService;
import com.qianjiang.order.service.OrderLogService;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.system.service.ILogisticsCompanyBiz;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AjaxOrderController {
    public static final MyLogger LOGGER = new MyLogger(AjaxOrderController.class);
    private static final String ORDER = "order";
    private static final String DATE = "yyyy-MM-dd";
    private OrderService orderService;
    private OrderCouponService orderCouponService;
    private OrderLogService orderLogService;
    @Resource(name="WareHouseService")
    private WareHouseService wareHouseService;
    @Resource(name="logisticsCompanyBizImpl")
    private ILogisticsCompanyBiz logisticsCompanyBiz;
    @Resource(name="logisticsCompanyBizImpl")
    private ILogisticsCompanyBiz logisticsCompanyBizImpl;

    @ResponseBody
    @RequestMapping(value={"/newajaxgetpagefoot"}, produces={"application/json;charset=UTF-8"})
    public PageBean newajaxgetpagefoot(Order order, String status, PageBean pageBean, HttpServletRequest request) {
        String statusNew = status;
        order.setBusinessId(0L);
        if (StringUtils.isEmpty((String)statusNew)) {
            statusNew = "1";
        }
        return this.orderService.newajaxgetpagefoot(statusNew, order, pageBean);
    }

    @RequestMapping(value={"/checkDeleteByGoodsIds"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String checkDeleteByGoodsIds(HttpServletRequest request, HttpServletResponse resp, String goodsIds) {
        String result = "";
        if (null != goodsIds && !"".equals(goodsIds)) {
            String[] goodsIds1 = goodsIds.split(",");
            Long[] goodsIds2 = new Long[goodsIds1.length];
            for (int i = 0; i < goodsIds1.length; ++i) {
                goodsIds2[i] = Long.parseLong(goodsIds1[i]);
            }
            if (goodsIds2 != null && goodsIds1.length > 0) {
                int count = this.orderService.queryOrderCountBygoodsIds(goodsIds2);
                result = count > 0 ? "0" : "1";
            }
        }
        return result;
    }

    @RequestMapping(value={"/checkDeleteByGoodsInfoIds"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String checkDeleteByGoodsInfoIds(HttpServletRequest request) {
        String[] tags = request.getParameterValues("goodsInfoIds[]");
        Long[] goodsInfoIds = null;
        if (tags.length > 0 && tags != null) {
            goodsInfoIds = new Long[tags.length];
            for (int i = 0; i < tags.length; ++i) {
                goodsInfoIds[i] = Long.valueOf(tags[i]);
            }
        }
        if (this.orderService.queryOrderCountBygoodsInfoIds(goodsInfoIds) > 0) {
            return "0";
        }
        return "1";
    }

    @ResponseBody
    @RequestMapping(value={"/ajaxGetorderDetail"}, produces={"application/json;charset=UTF-8"})
    public Map<String, Object> ajaxGetorderDetail(HttpServletRequest request, Long[] goodsIdP, String customerName) {
        return this.orderService.ajaxGetorderDetail(null, null, customerName);
    }

    @ResponseBody
    @RequestMapping(value={"/ajaxsaveOrder"}, produces={"application/json;charset=UTF-8"})
    public int ajaxsaveOrder(BigDecimal goodsAllPrice, BigDecimal freightPrice, String companyInfo, String customerRemark, Long[] goodsIdP, Long[] goodsNum, Long distinctId, Long payType, String invoiceTitle, String invoiceType, String invoiceContent, CustomerAddress customerAddress, String customerName, HttpServletRequest request) {
        String username = (String)request.getSession().getAttribute("name");
        return this.orderService.saveAddOrder(goodsAllPrice, freightPrice, companyInfo, customerRemark, goodsIdP, goodsNum, distinctId, payType, invoiceTitle, invoiceType, invoiceContent, customerAddress, username, customerName);
    }

    @RequestMapping(value={"/orderdetailajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> orderDetailAjax(Long orderId, HttpServletRequest request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put(ORDER, this.orderService.orderDetail(orderId));
            map.put("relations", this.orderService.queryContainerRalation(orderId));
            map.put("orderLogs", this.orderLogService.selectOrderLogByOrderId(orderId));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    @RequestMapping(value={"/expressdetail"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> expressDetail(Long orderId, Map<String, Object> map, String type, HttpServletRequest request) {
        try {
            List logisticsCompanyList = this.logisticsCompanyBizImpl.queryLogisticsCompanys();
            OrderExpress orderExpress = this.orderService.expressDetail(orderId);
            map.put("orderExpress", orderExpress);
            map.put("logisticsCompanyList", logisticsCompanyList);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u67e5\u8be2\u5feb\u9012\u516c\u53f8\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return map;
    }

    @RequestMapping(value={"/querystatistics"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> queryStatistics() {
        Map result = null;
        try {
            result = this.orderService.queryStatistics();
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u67e5\u8be2\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public OrderService getOrderService() {
        return this.orderService;
    }

    @Resource(name="OrderService")
    public void setOrderService(OrderService orderService) {
        this.orderService = orderService;
    }

    public OrderCouponService getOrderCouponService() {
        return this.orderCouponService;
    }

    @Resource(name="OrderCouponService")
    public void setOrderCouponService(OrderCouponService orderCouponService) {
        this.orderCouponService = orderCouponService;
    }

    public OrderLogService getOrderLogService() {
        return this.orderLogService;
    }

    @Resource(name="OrderLogService")
    public void setOrderLogService(OrderLogService orderLogService) {
        this.orderLogService = orderLogService;
    }
}

