/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.order.controller;

import com.alibaba.fastjson.JSON;
import com.qianjiang.alipay.AlipayUtils;
import com.qianjiang.alipay.RequestDatas;
import com.qianjiang.common.service.SeoService;
import com.qianjiang.customer.bean.CustomerAddress;
import com.qianjiang.customer.bean.DepositInfo;
import com.qianjiang.customer.bean.TradeInfo;
import com.qianjiang.customer.service.CustomerAddressService1;
import com.qianjiang.customer.service.CustomerPointServiceMapper;
import com.qianjiang.customer.service.CustomerService;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.customer.service.DepositInfoService;
import com.qianjiang.customer.service.OrderNoticeService;
import com.qianjiang.customer.service.TradeInfoService;
import com.qianjiang.goods.bean.GoodsProduct;
import com.qianjiang.goods.bean.GoodsProductSon;
import com.qianjiang.goods.bean.PageBean;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.goods.service.GoodsProductSonService;
import com.qianjiang.goods.service.ProductWareService;
import com.qianjiang.goods.vo.GoodsProductVo;
import com.qianjiang.index.service.TopAndBottomService;
import com.qianjiang.order.bean.BackOrder;
import com.qianjiang.order.bean.BackOrderGeneral;
import com.qianjiang.order.bean.BackOrderLog;
import com.qianjiang.order.bean.Order;
import com.qianjiang.order.bean.OrderAddress;
import com.qianjiang.order.bean.OrderGoods;
import com.qianjiang.order.bean.OrderLogger;
import com.qianjiang.order.service.BackOrderLogService;
import com.qianjiang.order.service.BackOrderService;
import com.qianjiang.order.service.OrderCouponService;
import com.qianjiang.order.service.OrderGoodsService;
import com.qianjiang.order.service.OrderLogService;
import com.qianjiang.order.service.OrderLoggerService;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.order.service.ReturnGoodsService;
import com.qianjiang.orderbackgoods.domain.OrderBackGoodsDomain;
import com.qianjiang.orderbackgoods.model.OrderBackGoods;
import com.qianjiang.orderbackgoods.service.OrderBackGoodsService;
import com.qianjiang.orderbartergoods.domain.OrderBarterGoodsDomain;
import com.qianjiang.orderbartergoods.model.OrderBarterGoods;
import com.qianjiang.orderbartergoods.service.OrderBarterGoodsService;
import com.qianjiang.orderrepaircost.domain.RepairCostDomain;
import com.qianjiang.orderrepaircost.model.RepairCost;
import com.qianjiang.orderrepaircost.service.RepairCostService;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.promotion.bean.FullbuyDiscountPromotion;
import com.qianjiang.promotion.bean.FullbuyNoCountPromotion;
import com.qianjiang.promotion.bean.FullbuyNoDiscountPromotion;
import com.qianjiang.promotion.bean.FullbuyReducePromotion;
import com.qianjiang.promotion.bean.Promotion;
import com.qianjiang.promotion.bean.PromotionRush;
import com.qianjiang.promotion.service.PromotionService;
import com.qianjiang.util.CollectionUtil;
import com.qianjiang.util.HttpRequestUtils;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.OrderConstants;
import com.qianjiang.util.UploadUtil;
import com.qianjiang.wxpay.WXPayUtil;
import com.qianjiang.wxpay.WxPayExecutingRequest;
import com.qianjiang.wxpay.dto.RefundRequestParameter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class BackOrderController {
    private static final MyLogger LOGGER = new MyLogger(BackOrderController.class);
    private static final String BACKORDERLIST_HTM = "backorderlist.htm";
    private static final String BACKORDER = "backorder";
    private static final String ORDERLOGS = "orderLogs";
    private static final String ORDERID = "orderId";
    private static final String BACKORDERLOGS = "backOrderLogs";
    private static final String BACKORDERGENERAL = "backOrderGeneral";
    private static final String ADMIN = "admin";
    private static final String ISO_8859_1 = "ISO-8859-1";
    private BackOrderService backOrderService;
    private OrderService orderService;
    private BackOrderLogService backOrderLogService;
    private OrderLogService orderLogService;
    @Resource(name="OrderCouponService")
    private OrderCouponService orderCouponService;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceMapper;
    @Resource(name="TopAndBottomService")
    private TopAndBottomService topAndBottomService;
    @Autowired
    private DepositInfoService depositInfoService;
    @Autowired
    private TradeInfoService tradeInfoService;
    @Resource(name="orderLoggerService")
    private OrderLoggerService orderLoggerService;
    @Autowired
    private ProductWareService productWareService;
    @Autowired
    private RepairCostService repairCostService;
    @Autowired
    private ReturnGoodsService returngoods;
    @Autowired
    private SeoService seoService;
    @Autowired
    private OrderBarterGoodsService orderBarterGoodsService;
    @Autowired
    private CustomerAddressService1 customerAddressServiceMix;
    @Autowired
    private OrderGoodsService OrderGoodsService;
    @Autowired
    private ReturnGoodsService returnGoodsService;
    @Resource(name="MarketingService")
    private PromotionService marketService;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceInterface;
    @Resource(name="customerPointServiceMapper")
    private CustomerPointServiceMapper customerPointServiceMapper;
    @Autowired
    private GoodsProductService GoodsProductService;
    @Autowired
    private OrderNoticeService OrderNoticeService;
    @Autowired
    private RepairCostService RepairCostService;
    @Autowired
    private GoodsProductService goodsProductService;
    @Autowired
    private CustomerService customerService;
    @Autowired
    private OrderGoodsService orderGoodsService;
    @Autowired
    private GoodsProductSonService goodsProductSonService;
    @Autowired
    private OrderBackGoodsService orderBackGoodsService;

    public TopAndBottomService getTopAndBottomService() {
        return this.topAndBottomService;
    }

    public void setTopAndBottomService(TopAndBottomService topAndBottomService) {
        this.topAndBottomService = topAndBottomService;
    }

    @RequestMapping(value={"/backorderlist"})
    public ModelAndView backOrderList(HttpServletRequest request, BackOrder bkorder, com.qianjiang.util.PageBean pageBean, String startTime, String endTime) {
        bkorder.setBusinessId(0L);
        bkorder.setIsBack("1");
        pageBean.setUrl(BACKORDERLIST_HTM);
        pageBean = this.backOrderService.backOrderList(pageBean, bkorder, startTime, endTime);
        return new ModelAndView("jsp/order/backorderlist", "pageBean", (Object)pageBean).addObject("businessId", (Object)0);
    }

    @RequestMapping(value={"/exportBackOrderList"})
    public void exportBackOrderList(HttpServletRequest request, HttpServletResponse response, String type) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet("\u9000\u5355\u5217\u8868");
        HSSFRow row = sheet.createRow(0);
        HSSFCellStyle style = wb.createCellStyle();
        style.setAlignment((short)2);
        sheet.setColumnWidth(0, 6000);
        sheet.setColumnWidth(1, 6000);
        sheet.setColumnWidth(2, 6000);
        sheet.setColumnWidth(3, 6000);
        sheet.setColumnWidth(4, 6000);
        sheet.setColumnWidth(5, 6000);
        sheet.setColumnWidth(6, 6000);
        sheet.setColumnWidth(7, 6000);
        HSSFCell cell = row.createCell(0);
        cell.setCellValue("\u9000\u5355\u53f7");
        cell.setCellStyle(style);
        cell = row.createCell(1);
        cell.setCellValue("\u5546\u54c1\u540d\u79f0");
        cell.setCellStyle(style);
        cell = row.createCell(2);
        cell.setCellValue("\u5546\u54c1\u91d1\u989d");
        cell.setCellStyle(style);
        cell = row.createCell(3);
        cell.setCellValue("\u6570\u91cf");
        cell.setCellStyle(style);
        cell = row.createCell(4);
        cell.setCellValue("\u6536\u8d27\u4eba");
        cell.setCellStyle(style);
        cell = row.createCell(5);
        cell.setCellValue("\u9000\u8d27\u72b6\u6001");
        cell.setCellStyle(style);
        cell = row.createCell(6);
        cell.setCellValue("\u9000\u8d27\u91d1\u989d");
        cell.setCellStyle(style);
        cell = row.createCell(7);
        cell.setCellValue("\u9000\u8d27\u65f6\u95f4");
        cell.setCellStyle(style);
        BackOrder order = new BackOrder();
        List list = this.backOrderService.exportBackOrderListMix(order);
        int q = 0;
        if (null != list) {
            for (int i = 0; i < list.size(); ++i) {
                row = sheet.createRow(i + 1 + q);
                BackOrder backOrder = (BackOrder)list.get(i);
                row.createCell(0).setCellValue(backOrder.getBackOrderCode());
                row.createCell(1).setCellValue(backOrder.getGoodsProductVo().getGoodsInfoName());
                row.createCell(2).setCellValue(backOrder.getBackPrice() + "");
                row.createCell(3).setCellValue((double)backOrder.getOrderGoodslistVo().size());
                row.createCell(4).setCellValue(backOrder.getOrder().getShippingPerson());
                String backCheck = backOrder.getBackCheck();
                if (backCheck.equals("0")) {
                    row.createCell(5).setCellValue("\u9000\u8d27\u7533\u8bf7");
                } else if (backCheck.equals("1")) {
                    row.createCell(5).setCellValue("\u5f85\u5546\u5bb6\u6536\u8d27");
                } else if (backCheck.equals("2")) {
                    row.createCell(5).setCellValue("\u62d2\u7edd\u9000\u8d27");
                } else if (backCheck.equals("15")) {
                    row.createCell(5).setCellValue("\u5f85\u9000\u6b3e");
                } else if (backCheck.equals("4")) {
                    row.createCell(5).setCellValue("\u9000\u8d27\u7ed3\u675f");
                } else if (backCheck.equals("6")) {
                    row.createCell(5).setCellValue("\u5ba1\u6838\u9000\u6b3e");
                } else if (backCheck.equals("7")) {
                    row.createCell(5).setCellValue("\u62d2\u7edd\u9000\u6b3e");
                } else if (backCheck.equals("8")) {
                    row.createCell(5).setCellValue("\u62d2\u7edd\u6536\u8d27");
                } else if (backCheck.equals("10")) {
                    row.createCell(5).setCellValue("\u5df2\u9000\u6b3e");
                } else if (backCheck.equals("9")) {
                    row.createCell(5).setCellValue("\u5f85\u5ba2\u6237\u586b\u5199\u7269\u6d41\u5730\u5740");
                } else if (backCheck.equals("11")) {
                    row.createCell(5).setCellValue("\u5b9a\u635f\u4e2d");
                } else if (backCheck.equals("12")) {
                    row.createCell(5).setCellValue("\u5f85\u5ba2\u6237\u786e\u8ba4\u8bc4\u4f30\u8d39\u7528\u4e2d");
                } else if (backCheck.equals("13")) {
                    row.createCell(5).setCellValue("\u5f85\u5ba2\u6237\u786e\u8ba4\u5b9e\u9645\u5b9a\u635f\u8d39\u7528\u4e2d");
                } else if (backCheck.equals("14")) {
                    row.createCell(5).setCellValue("\u7ef4\u4fee\u8d39\u7528\u8bc4\u4f30\u4e2d");
                } else if (backCheck.equals("16")) {
                    row.createCell(5).setCellValue("\u7528\u6237\u5df2\u53d6\u6d88");
                }
                row.createCell(6).setCellValue(backOrder.getBackPrice() + "");
                row.createCell(7).setCellValue(backOrder.getBackTime());
                q += list.size();
            }
        }
        String filename = String.valueOf(System.currentTimeMillis()).concat(".xls");
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment;filename=" + filename);
        try {
            ServletOutputStream ouputStream = response.getOutputStream();
            wb.write((OutputStream)ouputStream);
            ouputStream.flush();
            ouputStream.close();
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    @RequestMapping(value={"/deleterepaircost"})
    public ModelAndView deleteRepairCost(HttpServletRequest request, Long repairId) {
        ModelAndView mav = new ModelAndView("jsp/order/repaircostlist");
        this.RepairCostService.deleteRepairCost(repairId);
        System.out.println(123);
        return new ModelAndView((View)new RedirectView("repaircostlist.htm"));
    }

    @RequestMapping(value={"/repaircostlist"})
    public ModelAndView barterOrderList(HttpServletRequest request, PageBean pageBean, String startTime, String endTime, RepairCost repairCost) {
        ModelAndView mav = new ModelAndView("jsp/order/repaircostlist");
        Map result = null;
        pageBean.setUrl("repaircostlist.htm");
        result = this.RepairCostService.searchRepairCostListMix(repairCost, pageBean);
        pageBean = (PageBean)JSON.parseObject((String)JSON.toJSONString(result.get("pageBean")), PageBean.class);
        mav.addObject("map", (Object)result);
        mav.addObject("pageBean", (Object)pageBean);
        mav.addObject("repairCost", (Object)repairCost);
        return mav;
    }

    @RequestMapping(value={"/barterorderlist"})
    public ModelAndView barterOrderList(HttpServletRequest request, BackOrder bkorder, com.qianjiang.util.PageBean pageBean, String startTime, String endTime) {
        bkorder.setBusinessId(0L);
        bkorder.setIsBack("3");
        pageBean.setUrl(BACKORDERLIST_HTM);
        return new ModelAndView(OrderConstants.BARTERORDERLIST, "pageBean", (Object)this.backOrderService.backOrderList(pageBean, bkorder, startTime, endTime)).addObject("businessId", (Object)0);
    }

    @RequestMapping(value={"/backorderlististhird"})
    public ModelAndView backOrderLististhird(HttpServletRequest request, String status, BackOrder bkorder, com.qianjiang.util.PageBean pageBean, String startTime, String endTime) {
        String statusNew = status;
        if (StringUtils.isEmpty((String)statusNew)) {
            statusNew = "1";
        }
        pageBean.setUrl("backorderlististhird.htm");
        return new ModelAndView("jsp/order/backorderlist", "pageBean", (Object)this.backOrderService.backOrderList(pageBean, bkorder, startTime, endTime)).addObject("businessId", (Object)1);
    }

    @RequestMapping(value={"modifyBackOrder"})
    public ModelAndView modifyBackOrderByCheck(BackOrder backOrder, HttpServletRequest request) {
        this.orderLogService.insertSelective(null, backOrder.getOrderId(), request.getSession().getAttribute("name").toString(), "5");
        int count = this.backOrderService.modifyBackBeanCheck(backOrder);
        if (count > 0) {
            return new ModelAndView((View)new RedirectView(BACKORDERLIST_HTM));
        }
        return null;
    }

    @RequestMapping(value={"modifyBackOrderisthird"})
    public ModelAndView modifyBackOrderByCheckisthird(BackOrder backOrder, HttpServletRequest request) {
        this.orderLogService.insertSelective(null, backOrder.getOrderId(), request.getSession().getAttribute("name").toString(), "5");
        int count = this.backOrderService.modifyBackBeanCheck(backOrder);
        if (count > 0) {
            return new ModelAndView((View)new RedirectView("backorderlististhird.htm"));
        }
        return null;
    }

    @RequestMapping(value={"/newbackdetail"})
    public ModelAndView newBackDetail(String backId, String orderId, String businessId) {
        List backOrderLogs = this.backOrderLogService.queryByBackId(Long.valueOf(backId));
        BackOrder backorder = this.backOrderService.backdetail(Long.valueOf(backId), Long.valueOf(orderId));
        BackOrder backOrders = this.backOrderService.selectBackOrderByBackOrderId(backorder.getBackOrderId());
        String[] BackGoodsIdAndSum = backOrders.getBackGoodsIdAndSum().split("-");
        Long goodsInfoIds = 0L;
        for (int i = 0; i < BackGoodsIdAndSum.length; ++i) {
            if (Long.parseLong(BackGoodsIdAndSum[i].substring(0, BackGoodsIdAndSum[i].indexOf(","))) == goodsInfoIds) continue;
            goodsInfoIds = Long.parseLong(BackGoodsIdAndSum[i].substring(0, BackGoodsIdAndSum[i].indexOf(",")));
            Long num = Long.parseLong(BackGoodsIdAndSum[i].substring(BackGoodsIdAndSum[i].indexOf(",") + 1, BackGoodsIdAndSum[i].lastIndexOf(",")));
            backOrders.getBackGoodsList().get(i).setGoodsInfoNum(num);
        }
        RepairCost repairCost = null;
        BigDecimal repairCostPriceSum = null;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("orderBarterId", backId);
        List orderBarterGoodsList = this.orderBarterGoodsService.selectByOrderBarterIdAll(map);
        List goodsProductAll = null;
        if (orderBarterGoodsList.size() > 0) {
            Long[] productGoodsIds = new Long[orderBarterGoodsList.size()];
            int index = 0;
            for (OrderBarterGoods orderBarterGoods : orderBarterGoodsList) {
                productGoodsIds[index] = orderBarterGoods.getGoodsInfoId();
                ++index;
            }
            List<Long> list = Arrays.asList(productGoodsIds);
            goodsProductAll = this.GoodsProductService.selectProductByGoodsInFoId(list);
            for (int i = 0; i < goodsProductAll.size(); ++i) {
                ((GoodsProduct)goodsProductAll.get(i)).setGoodsInfoItemNo(((OrderBarterGoods)orderBarterGoodsList.get(i)).getGoodsInfoItemNoS());
            }
        }
        BackOrderGeneral backOrderGeneral = this.backOrderService.queryBackOrderGeneral(Long.valueOf(backId));
        BigDecimal customerDiscount = this.customerPointServiceMapper.selectCustomerDiscountByCustomerId(backorder.getCustomerId());
        repairCost = this.repairCostService.selectAllByBackOrderId(Long.valueOf(Long.parseLong(backId)));
        BigDecimal sumPrice = new BigDecimal(0);
        if (repairCost != null && (repairCost.getIsAssessment() == "1" || "1".equals(repairCost.getIsAssessment()))) {
            if (repairCost.getOrderType() == "1" || "0".equals(repairCost.getOrderType())) {
                repairCostPriceSum = backorder.getBackPrice().subtract(repairCost.getRepairPrice());
            }
            if (repairCost.getOrderType() == "1" || "1".equals(repairCost.getOrderType())) {
                repairCostPriceSum = repairCost.getRepairPrice();
                for (GoodsProduct goodsProduct : goodsProductAll) {
                    sumPrice = sumPrice.add(goodsProduct.getGoodsInfoPreferPrice());
                }
                repairCostPriceSum = backorder.getBackPrice().subtract(sumPrice.multiply(customerDiscount)).subtract(repairCostPriceSum);
            }
        }
        BackOrder backorder_new = this.backOrderService.backdetail(Long.valueOf(backId), Long.valueOf(orderId));
        return new ModelAndView("jsp/order/backorderdetail").addObject(BACKORDER, (Object)backorder_new).addObject(ORDERLOGS, (Object)this.orderLogService.selectOrderLogByOrderId(Long.valueOf(orderId))).addObject(ORDERID, (Object)orderId).addObject(BACKORDERLOGS, (Object)backOrderLogs).addObject(BACKORDERGENERAL, (Object)backOrderGeneral).addObject("businessId", (Object)businessId).addObject("goodsProductAll", (Object)goodsProductAll).addObject("orderBarterGoodsList", (Object)orderBarterGoodsList).addObject("repairCost", (Object)repairCost).addObject("repairCostPriceSum", (Object)repairCostPriceSum).addObject("customerDiscount", (Object)customerDiscount);
    }

    @RequestMapping(value={"/newbackprice"})
    public ModelAndView newbackprice(String backId, String orderId, String businessId) {
        List backOrderLogs = this.backOrderLogService.queryByBackId(Long.valueOf(backId));
        BackOrderGeneral backOrderGeneral = this.backOrderService.queryBackOrderGeneral(Long.valueOf(backId));
        return new ModelAndView("jsp/order/backorderprice").addObject(BACKORDER, (Object)this.backOrderService.backdetail(Long.valueOf(backId), Long.valueOf(orderId))).addObject(ORDERLOGS, (Object)this.orderLogService.selectOrderLogByOrderId(Long.valueOf(orderId))).addObject(ORDERID, (Object)orderId).addObject(BACKORDERLOGS, (Object)backOrderLogs).addObject(BACKORDERGENERAL, (Object)backOrderGeneral).addObject("businessId", (Object)businessId);
    }

    @RequestMapping(value={"/backorderdetail"})
    public ModelAndView backOrderDetail(Long backOrderId, Long orderId) {
        List backOrderLogs = this.backOrderLogService.queryByBackId(backOrderId);
        Order order = this.orderService.getPayOrder(orderId);
        BackOrderGeneral backOrderGeneral = this.backOrderService.queryBackOrderGeneral(backOrderId);
        return new ModelAndView("jsp/order/newbackorderdetail").addObject(BACKORDER, (Object)this.backOrderService.backdetail(backOrderId, orderId)).addObject(ORDERLOGS, (Object)this.orderLogService.selectOrderLogByOrderId(orderId)).addObject(ORDERID, (Object)orderId).addObject(BACKORDERLOGS, (Object)backOrderLogs).addObject("backPrice", (Object)order.getBackPrice()).addObject(BACKORDERGENERAL, (Object)backOrderGeneral);
    }

    @RequestMapping(value={"back/upload"})
    public void uploadBackImg(MultipartHttpServletRequest request, HttpServletResponse resp, Long orderId) throws IOException {
        PrintWriter out = resp.getWriter();
        String msg = null;
        MultipartFile file = request.getFile("uploadDocument");
        file.getOriginalFilename();
        msg = file.getSize() > 0x400000L ? "101" : (!this.checkExtendsName(file.getOriginalFilename()) ? "102" : (String)UploadUtil.uploadFileByWidth((MultipartFile)request.getFile("uploadDocument")).get("oldimg") + "," + orderId);
        out.append("<script>parent.callback('" + msg + "');</script>");
    }

    public BigDecimal marketingBarter(List<Promotion> markList, OrderBarterGoods orderBarterGoods) {
        BigDecimal sumOldPrice = BigDecimal.valueOf(0L);
        BigDecimal taozhuang = BigDecimal.ZERO;
        BigDecimal prePrice = BigDecimal.valueOf(0L);
        BigDecimal flag = BigDecimal.ZERO;
        BigDecimal bossSumPrice = BigDecimal.ZERO;
        BigDecimal rushSumPrice = BigDecimal.ZERO;
        BigDecimal bossPrePrice = BigDecimal.ZERO;
        BigDecimal rushPrePrice = BigDecimal.ZERO;
        BigDecimal goodsprice = BigDecimal.ZERO;
        BigDecimal totalprice = BigDecimal.ZERO;
        Long goodssum = 0L;
        Object productWare = null;
        BigDecimal marketflag = BigDecimal.ZERO;
        for (Promotion mark : markList) {
            if (CollectionUtils.isNotEmpty((Collection)mark.getFullbuyReduceMarketings())) {
                for (FullbuyReducePromotion fpm : mark.getFullbuyReduceMarketings()) {
                    if (fpm.getFullPrice().compareTo(totalprice) != -1 && fpm.getFullPrice().compareTo(totalprice) != 0 || (prePrice = fpm.getReducePrice()).compareTo(marketflag) != 1 && prePrice.compareTo(marketflag) != 0) continue;
                    marketflag = prePrice;
                }
                bossPrePrice = bossPrePrice.add(marketflag);
                prePrice = marketflag;
                marketflag = BigDecimal.ZERO;
            }
            if (CollectionUtils.isNotEmpty((Collection)mark.getFullbuyDiscountMarketings())) {
                for (FullbuyDiscountPromotion fdm : mark.getFullbuyDiscountMarketings()) {
                    if (fdm.getFullPrice().compareTo(totalprice) != -1 && fdm.getFullPrice().compareTo(totalprice) != 0 || (prePrice = BigDecimal.valueOf(1L).subtract(fdm.getFullbuyDiscount()).multiply(totalprice)).compareTo(marketflag) != 1 && prePrice.compareTo(marketflag) != 0) continue;
                    marketflag = prePrice;
                }
                bossPrePrice = bossPrePrice.add(marketflag);
                prePrice = marketflag;
                marketflag = BigDecimal.ZERO;
            }
            if (CollectionUtils.isNotEmpty((Collection)mark.getFullbuyNoDiscountMarketings())) {
                for (int j = 0; j < mark.getFullbuyNoDiscountMarketings().size(); ++j) {
                    Long packagesNo = ((FullbuyNoDiscountPromotion)mark.getFullbuyNoDiscountMarketings().get(j)).getPackagesNo();
                    if (packagesNo.compareTo(goodssum = orderBarterGoods.getGoodsNum()) != -1 && packagesNo.compareTo(goodssum) != 0 || (prePrice = BigDecimal.valueOf(1L).subtract(((FullbuyNoDiscountPromotion)mark.getFullbuyNoDiscountMarketings().get(j)).getPackagebuyDiscount()).multiply(totalprice)).compareTo(marketflag) != 1 && prePrice.compareTo(marketflag) != 0) continue;
                    marketflag = prePrice;
                }
                bossPrePrice = bossPrePrice.add(marketflag);
                prePrice = marketflag;
                marketflag = BigDecimal.ZERO;
            }
            if (CollectionUtils.isNotEmpty((Collection)mark.getFullbuyNoCountMarketings())) {
                for (int j = 0; j < mark.getFullbuyNoCountMarketings().size(); ++j) {
                    Long countNo = ((FullbuyNoCountPromotion)mark.getFullbuyNoCountMarketings().get(j)).getCountNo();
                    if (countNo.compareTo(goodssum = orderBarterGoods.getGoodsNum()) != -1 && countNo.compareTo(goodssum) != 0 || (prePrice = ((FullbuyNoCountPromotion)mark.getFullbuyNoCountMarketings().get(j)).getCountMoney()).compareTo(marketflag) != 1 && prePrice.compareTo(marketflag) != 0) continue;
                    marketflag = prePrice;
                }
                bossPrePrice = bossPrePrice.add(marketflag);
                prePrice = marketflag;
                marketflag = BigDecimal.ZERO;
            }
            flag = flag.subtract(prePrice);
        }
        for (Promotion mark : markList) {
            if (mark.getMarketingId() == null || mark.getMarketingId() == 0L) continue;
            Promotion marks = this.marketService.marketingDetail(mark.getMarketingId(), orderBarterGoods.getGoodsInfoId());
            if ("1".equals(marks.getCodexType())) {
                flag = flag.subtract(marks.getPriceOffMarketing().getOffValue().multiply(BigDecimal.valueOf(orderBarterGoods.getGoodsNum())));
                bossPrePrice = bossPrePrice.add(marks.getPriceOffMarketing().getOffValue().multiply(BigDecimal.valueOf(orderBarterGoods.getGoodsNum())));
            }
            if (!"11".equals(marks.getCodexType())) continue;
            BigDecimal prePrice1 = BigDecimal.ONE.subtract(((PromotionRush)marks.getRushs().get(0)).getRushDiscount()).multiply(orderBarterGoods.getGoodsInfoOldPrice()).multiply(BigDecimal.valueOf(orderBarterGoods.getGoodsNum()));
            flag = flag.subtract(prePrice1);
            bossPrePrice = bossPrePrice.add(prePrice1);
            rushPrePrice = rushPrePrice.add(prePrice1);
            goodssum = orderBarterGoods.getGoodsNum();
            rushSumPrice = rushSumPrice.add(orderBarterGoods.getGoodsInfoOldPrice().multiply(BigDecimal.valueOf(goodssum)));
        }
        return flag;
    }

    @RequestMapping(value={"back/keepBackOrderInfoprice"})
    public ModelAndView keepBackOrderInfoprice(HttpServletRequest request, BackOrder backOrder) {
        if (this.backOrderService.isBackOrderRecordExist(backOrder.getOrderCode())) {
            LOGGER.error("orderCode :" + backOrder.getOrderCode() + "alerdy exist BackOrderRecord");
            return new ModelAndView((View)new RedirectView("../customer/myorder.html"));
        }
        backOrder.setBusinessId(this.orderService.getPayOrder(backOrder.getOrderId()).getBusinessId());
        backOrder.setBackOrderCode(this.createBackOrderNo());
        backOrder.setBackCheck("6");
        backOrder.setBackTime(new Date());
        int count = this.backOrderService.insertBackOrderInfo(backOrder);
        this.orderService.updateStatusBackById(backOrder.getOrderId(), "15", null);
        if (count > 0) {
            BackOrderLog backOrderLog = new BackOrderLog();
            backOrderLog.setBackLogPerson("customer");
            backOrderLog.setBackLogTime(new Date());
            backOrderLog.setBackLogStatus("1");
            backOrderLog.setBackOrderId(backOrder.getBackOrderId());
            this.backOrderLogService.insert(backOrderLog);
        }
        return new ModelAndView((View)new RedirectView("../customer/myorder.html"));
    }

    @RequestMapping(value={"/checkIsBackGoods"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> checkIsBackGoods(HttpServletRequest req, String orderCode) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("result", false);
        return resultMap;
    }

    @RequestMapping(value={"back/keepBarterOrderInfo"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ModelAndView keepBarterOrderInfo(HttpServletRequest request, BackOrder backOrder, String orderCode, Long[] goodsnum, String[] goodsInfoItemNoSList) {
        int i;
        String[] goods = request.getParameterValues("goods");
        Object[] share = request.getParameterValues("share");
        backOrder.setBusinessId(0L);
        backOrder.setBackCheck("0");
        backOrder.setBackTime(new Date());
        HashMap map = new HashMap();
        ArrayList<OrderGoods> og = new ArrayList<OrderGoods>();
        Order order = this.orderService.getPayOrder(backOrder.getOrderId());
        String[] goodsIdAndSum = backOrder.getBackGoodsIdAndSum().split("-");
        Long backOrderids = null;
        if (!"".equals(backOrder.getBackGoodsIdAndSum())) {
            OrderBackGoodsDomain orderBackGoodsDomain = new OrderBackGoodsDomain();
            HashMap productSon = new HashMap();
            HashMap productSons = new HashMap();
            HashMap<String, String> productSonMap = new HashMap<String, String>();
            String[] goodsProductSonList = new String[goodsInfoItemNoSList.length];
            int goodsProductSonNew = 0;
            boolean index = false;
            Long[] goodsIdP = new Long[goodsInfoItemNoSList.length];
            Long[] goodsNum = new Long[goodsInfoItemNoSList.length];
            HashMap<Long, String> orderGoodsMaps = new HashMap<Long, String>();
            for (int i2 = 0; i2 < goodsInfoItemNoSList.length; ++i2) {
                for (int j = 0; j < goodsIdAndSum.length; ++j) {
                    Long orderGoodsId = Long.parseLong(goodsIdAndSum[j].substring(goodsIdAndSum[j].lastIndexOf(",") + 1));
                    OrderGoods orderGoods = this.orderGoodsService.selectOrderGoodsByOGIds(orderGoodsId);
                    List<String> goodsInfoItemSList = Arrays.asList(orderGoods.getGoodsInfoItemNoS().split(","));
                    if (goodsInfoItemSList.contains(goodsInfoItemNoSList[i2])) {
                        if (orderGoodsMaps.get(orderGoods.getGoodsInfoId()) != null) {
                            orderGoodsMaps.put(orderGoods.getOrderGoodsId(), orderGoodsMaps.get(orderGoods.getOrderGoodsId()) + "," + goodsInfoItemNoSList[i2]);
                        } else {
                            orderGoodsMaps.put(orderGoods.getOrderGoodsId(), goodsInfoItemNoSList[i2]);
                        }
                    }
                    og.add(orderGoods);
                }
            }
            for (Map.Entry entry : orderGoodsMaps.entrySet()) {
                goodsProductSonList[goodsProductSonNew] = (String)entry.getValue();
                ++goodsProductSonNew;
            }
            StringBuilder goodsInfo = new StringBuilder();
            HashMap<String, Object> orderGoodsMap = new HashMap<String, Object>();
            backOrder.setBackOrderCode(this.createBackOrderNo());
            BigDecimal discount = new BigDecimal("0");
            Long backNumLast = 0L;
            String[] BackGoodsIdAndSum = backOrder.getBackGoodsIdAndSum().split("-");
            BigDecimal backOrderSum = new BigDecimal(0);
            BigDecimal onePrice = new BigDecimal(0);
            for (int i3 = 0; i3 < BackGoodsIdAndSum.length; ++i3) {
                Long ordergoodsId = Long.parseLong(BackGoodsIdAndSum[i3].substring(BackGoodsIdAndSum[i3].lastIndexOf(",") + 1));
                OrderGoods orderGoods = this.orderGoodsService.selectOrderGoodsByOGIds(ordergoodsId);
                Long goodsInfoId = Long.parseLong(BackGoodsIdAndSum[i3].substring(0, BackGoodsIdAndSum[i3].indexOf(",")));
                GoodsProductVo goodsProductVo = this.goodsProductService.selectByPrimaryKey(goodsInfoId);
                Long num = Long.parseLong(BackGoodsIdAndSum[i3].substring(BackGoodsIdAndSum[i3].indexOf(",") + 1, BackGoodsIdAndSum[i3].lastIndexOf(",")));
                BigDecimal sumPrice = orderGoods.getGoodsInfoSumPrice().divide(new BigDecimal(orderGoods.getGoodsInfoNum()), 2, RoundingMode.HALF_UP);
                onePrice = onePrice.add(sumPrice.subtract(orderGoods.getGoodsCouponPrice().divide(new BigDecimal(orderGoods.getGoodsInfoNum()), 2, RoundingMode.HALF_UP)).multiply(new BigDecimal(num)));
                backNumLast = backNumLast + num;
                backOrderSum = backOrderSum.add(goodsProductVo.getGoodsInfoPreferPrice().multiply(new BigDecimal(num)));
            }
            BigDecimal customerDiscount = this.customerPointServiceMapper.selectCustomerDiscountByCustomerId(backOrder.getCustomerId());
            if (customerDiscount != null && backOrderSum != null) {
                discount = backOrderSum.multiply(customerDiscount);
            }
            if (share != null && share.length != 0) {
                String uploadDocument = StringUtils.join((Object[])share, (String)",");
                backOrder.setUploadDocuments(uploadDocument);
            }
            backOrder.setOrderCode(this.orderService.orderDetail(((OrderGoods)og.get(0)).getOrderId()).getOrderCode());
            if (order == null) {
                order = this.orderService.getPayOrderByCode(backOrder.getOrderCode());
            }
            List orderGoods = this.orderGoodsService.selectBackGoodsLists(order.getOrderId());
            System.out.println("OrderGoods\u662f\u5426\u6709\u503c" + orderGoods);
            Long orderNum = 0L;
            for (int i4 = 0; i4 < orderGoods.size(); ++i4) {
                System.out.println(((OrderGoods)orderGoods.get(i4)).getGoodsName());
                System.out.println(((OrderGoods)orderGoods.get(i4)).getGoodsInfoNum());
                orderNum = orderNum + ((OrderGoods)orderGoods.get(i4)).getGoodsInfoNum();
            }
            backOrder.setBackPrice(onePrice);
            int count = this.backOrderService.insertBackOrderInfo(backOrder);
            backOrderids = this.backOrderService.selectLastId();
            if (count > 0) {
                BackOrderLog backOrderLog = new BackOrderLog();
                backOrderLog.setBackLogPerson("customer");
                backOrderLog.setBackLogTime(new Date());
                backOrderLog.setBackLogStatus("1");
                backOrderLog.setBackOrderId(backOrder.getBackOrderId());
                this.backOrderLogService.insert(backOrderLog);
            }
            String[] goodsInfoItemNos = null;
            for (int i5 = 0; i5 < goodsProductSonList.length; ++i5) {
                if (goodsProductSonList[i5] == null) continue;
                String[] strArray = goodsProductSonList[i5].split(",");
                productSonMap.put("isUse", "1");
                productSonMap.put("goodsInfoItemNoS", strArray[0]);
                GoodsProductSon goodsPro = this.goodsProductSonService.selectByGoodsItemNoS(productSonMap);
                orderBackGoodsDomain.setBackGoodsPrice(this.goodsProductService.selectByPrimaryKey(goodsPro.getGoodsInfoId()).getGoodsInfoPreferPrice());
                orderBackGoodsDomain.setBackOrderId(backOrderids);
                orderBackGoodsDomain.setBackGoodsTime(new Date());
                orderBackGoodsDomain.setOrderId(((OrderGoods)og.get(i5)).getOrderId());
                orderBackGoodsDomain.setGoodsInfoItemNoS(goodsProductSonList[i5]);
                orderBackGoodsDomain.setBusinessId(Long.valueOf(0L));
                orderBackGoodsDomain.setGoodsInfoId(goodsPro.getGoodsInfoId());
                orderBackGoodsDomain.setGoodsInfoItemNo(goodsPro.getGoodsInfoItemNo());
                Integer goodsNums = strArray.length;
                orderBackGoodsDomain.setGoodsInfoNum(Long.valueOf(goodsNums.longValue()));
                this.orderBackGoodsService.saveOrderBackGood(orderBackGoodsDomain);
                boolean biaoshi = false;
                for (int j2 = 0; j2 < og.size(); ++j2) {
                    goodsInfoItemNos = ((OrderGoods)og.get(j2)).getGoodsInfoItemNoS().split(",");
                    String backGoodsInfoItemNo = "";
                    for (int j = 0; j < goodsInfoItemNos.length; ++j) {
                        String[] goodsProductSon = goodsProductSonList[i5].split(",");
                        for (int k = 0; k < goodsProductSon.length; ++k) {
                            if (!goodsInfoItemNos[j].equals(goodsProductSon[k])) continue;
                            if (((OrderGoods)og.get(j2)).getBackGoodsInfoItemNoS() == null || "".equals(((OrderGoods)og.get(j2)).getBackGoodsInfoItemNoS())) {
                                backGoodsInfoItemNo = backGoodsInfoItemNo + goodsProductSon[k] + ",";
                                biaoshi = true;
                                continue;
                            }
                            backGoodsInfoItemNo = ((OrderGoods)og.get(j2)).getBackGoodsInfoItemNoS() + "," + goodsProductSon[k];
                            biaoshi = false;
                        }
                    }
                    if (backGoodsInfoItemNo == null || "".equals(backGoodsInfoItemNo)) continue;
                    if (!biaoshi) {
                        orderGoodsMap.put("backGoodsInfoItemNoS", backGoodsInfoItemNo);
                    } else {
                        orderGoodsMap.put("backGoodsInfoItemNoS", backGoodsInfoItemNo.substring(0, backGoodsInfoItemNo.length() - 1));
                    }
                    orderGoodsMap.put("orderGoodsId", ((OrderGoods)og.get(j2)).getOrderGoodsId());
                    Long goodsNumNew = 0L;
                    for (int k = 0; k < goodsIdAndSum.length; ++k) {
                        Long orderGoodsId = Long.parseLong(goodsIdAndSum[k].substring(goodsIdAndSum[k].lastIndexOf(",") + 1));
                        Long num = Long.parseLong(goodsIdAndSum[k].substring(goodsIdAndSum[k].indexOf(",") + 1, goodsIdAndSum[k].lastIndexOf(",")));
                        if (((OrderGoods)og.get(j2)).getOrderGoodsId() != orderGoodsId) continue;
                        goodsNumNew = num;
                    }
                    orderGoodsMap.put("backGoodsNum", ((OrderGoods)og.get(j2)).getBackGoodsNum() + goodsNumNew);
                    this.orderGoodsService.updateByPrimaryKeySelective(orderGoodsMap);
                }
            }
        }
        String goodsInfoItemNoCoverS = "";
        for (i = 0; i < og.size(); ++i) {
            goodsInfoItemNoCoverS = goodsInfoItemNoCoverS + ((OrderGoods)og.get(i)).getGoodsInfoItemNoS() + ",";
        }
        for (i = 0; i < goods.length; ++i) {
            JSONObject object = JSONObject.fromObject((Object)goods[i]);
            OrderBarterGoodsDomain orderBarterGoodsDomain = new OrderBarterGoodsDomain();
            if (goodsnum == null) {
                orderBarterGoodsDomain.setGoodsNum(Long.valueOf(1L));
            } else {
                orderBarterGoodsDomain.setGoodsNum(goodsnum[i]);
            }
            GoodsProductSon goodsProductS = new GoodsProductSon();
            Random rand = new Random();
            String goodsProductSonList = "";
            int rands = 0;
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            int j = 0;
            while ((long)j < goodsnum[i]) {
                List goodsProductSon = this.goodsProductSonService.selectAllByGoodsInfoId(object.getString("goodsInfoId"));
                rands = rand.nextInt(goodsProductSon.size());
                goodsProductSonList = goodsProductSonList + ((GoodsProductSon)goodsProductSon.get(rands)).getGoodsInfoItemNoS() + ",";
                goodsProductS.setIsUse("1");
                goodsProductS.setGoodsInfoItemNoS(((GoodsProductSon)goodsProductSon.get(rands)).getGoodsInfoItemNoS());
                this.goodsProductSonService.updateGoodsProductSons(goodsProductS);
                System.out.println("~~~~~~~~~\u8d27\u54c1\u56de\u6eda");
                paramMap.put("stock", -1);
                paramMap.put("productId", object.getString("goodsInfoId"));
                paramMap.put("distinctId", "79");
                this.productWareService.plusStockToWare(paramMap);
                ++j;
            }
            orderBarterGoodsDomain.setGoodsInfoItemNoCoverS(goodsInfoItemNoCoverS.substring(0, goodsInfoItemNoCoverS.length() - 1));
            orderBarterGoodsDomain.setGoodsInfoItemNoCoverS(StringUtils.join((Object[])goodsInfoItemNoSList, (String)","));
            orderBarterGoodsDomain.setGoodsInfoItemNoS(goodsProductSonList.substring(0, goodsProductSonList.length() - 1));
            orderBarterGoodsDomain.setOrderBarterId(backOrderids);
            orderBarterGoodsDomain.setGoodsId(Long.valueOf(Long.parseLong(object.getString("goodsId"))));
            orderBarterGoodsDomain.setGoodsInfoId(Long.valueOf(Long.parseLong(object.getString("goodsInfoId"))));
            orderBarterGoodsDomain.setGoodsIdCover(((OrderGoods)og.get(0)).getGoodsId());
            orderBarterGoodsDomain.setGoodsInfoIdCover(((OrderGoods)og.get(0)).getGoodsInfoId());
            orderBarterGoodsDomain.setGoodsInfoOldPrice(new BigDecimal(object.getString("goodsPrice")).multiply(new BigDecimal(goodsnum[i])));
            orderBarterGoodsDomain.setCreateTiem(new Date());
            orderBarterGoodsDomain.setBarterTime(new Date());
            GoodsProductVo productVo = this.goodsProductService.getGoodsProductVoWithGoods(Long.valueOf(Long.parseLong(object.getString("goodsInfoId"))), Long.valueOf(769L));
            Long activeMarketId = 0L;
            List markList = this.marketService.selectSimpleMarketingByGoodsInfoId(Long.valueOf(Long.parseLong(object.getString("goodsInfoId"))), productVo.getGoods().getBrandId(), productVo.getGoods().getCatId());
            for (Promotion mark : markList) {
                if ("15".equals(mark.getCodexType()) || "12".equals(mark.getCodexType()) || "10".equals(mark.getCodexType())) continue;
                activeMarketId = mark.getMarketingId();
                break;
            }
            orderBarterGoodsDomain.setGoodsActiveMarketingId(activeMarketId);
            this.orderBarterGoodsService.saveOrderBarterGoods(orderBarterGoodsDomain);
            request.getSession().setAttribute("orderBarterGoodsDomain", (Object)orderBarterGoodsDomain);
        }
        this.orderService.updateBarterStatus(((OrderGoods)og.get(0)).getOrderId());
        return new ModelAndView((View)new RedirectView("../customer/myorder.html"));
    }

    @RequestMapping(value={"back/keepBackOrderInfo"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ModelAndView keepBackOrderInfo(HttpServletRequest request, BackOrder backOrder, String orderCode, String isAll, String[] goodsInfoItemNoSList) {
        backOrder.setBusinessId(0L);
        backOrder.setBackCheck("0");
        backOrder.setBackTime(new Date());
        HashMap<String, String> map = new HashMap<String, String>();
        Order order = this.orderService.getPayOrder(backOrder.getOrderId());
        if (!"".equals(backOrder.getBackGoodsIdAndSum())) {
            order.setBackPrice(order.getOrderPrice().subtract(order.getExpressPrice()));
            List og = this.orderService.queryOrderGoods(order.getOrderId());
            List orderGoods = this.orderGoodsService.selectBackGoodsLists(backOrder.getOrderId());
            OrderBackGoodsDomain orderBackGoodsDomain = new OrderBackGoodsDomain();
            HashMap<Long, Long> productSon = new HashMap<Long, Long>();
            HashMap<String, String> productSons = new HashMap<String, String>();
            HashMap<String, String> productSonMap = new HashMap<String, String>();
            String[] goodsProductSonList = new String[goodsInfoItemNoSList.length];
            int goodsProductSonNew = 0;
            int index = 0;
            Long[] goodsIdP = new Long[goodsInfoItemNoSList.length];
            Long[] goodsNum = new Long[goodsInfoItemNoSList.length];
            int numGoods = 0;
            for (int i = 0; i < goodsInfoItemNoSList.length; ++i) {
                map.put("isUse", "1");
                map.put("goodsInfoItemNoS", goodsInfoItemNoSList[i]);
                GoodsProductSon goodsProductSon = this.goodsProductSonService.selectByGoodsItemNoS(map);
                if (index == 0) {
                    productSon.put(goodsProductSon.getGoodsInfoId(), 1L);
                    productSons.put(goodsProductSon.getGoodsInfoItemNo(), goodsProductSon.getGoodsInfoItemNoS());
                    ++index;
                    continue;
                }
                if (productSon.get(goodsProductSon.getGoodsInfoId()) != null) {
                    productSon.put(goodsProductSon.getGoodsInfoId(), Long.parseLong(productSon.get(goodsProductSon.getGoodsInfoId()).toString()) + 1L);
                    productSons.put(goodsProductSon.getGoodsInfoItemNo(), productSons.get(goodsProductSon.getGoodsInfoItemNo()) + "," + goodsProductSon.getGoodsInfoItemNoS());
                    continue;
                }
                productSon.put(goodsProductSon.getGoodsInfoId(), 1L);
                productSons.put(goodsProductSon.getGoodsInfoItemNo(), goodsProductSon.getGoodsInfoItemNoS());
            }
            for (Map.Entry entry : productSon.entrySet()) {
                System.out.println("Key = " + entry.getKey() + ", Value = " + entry.getValue());
                goodsIdP[numGoods] = (Long)entry.getKey();
                goodsNum[numGoods] = (Long)entry.getValue();
                ++numGoods;
            }
            for (Map.Entry entry : productSons.entrySet()) {
                goodsProductSonList[goodsProductSonNew] = (String)entry.getValue();
                ++goodsProductSonNew;
            }
            StringBuilder goodsInfo = new StringBuilder();
            HashMap<String, Object> orderGoodsMap = new HashMap<String, Object>();
            backOrder.setBackOrderCode(this.createBackOrderNo());
            BigDecimal discount = new BigDecimal("0");
            String[] BackGoodsIdAndSum = backOrder.getBackGoodsIdAndSum().split("-");
            Long backNum = 0L;
            BigDecimal orderPrePrice = order.getOrderPrePrice();
            BigDecimal backOrderSum = new BigDecimal(0);
            for (int i = 0; i < BackGoodsIdAndSum.length; ++i) {
                Long goodsInfoId = Long.parseLong(BackGoodsIdAndSum[i].substring(0, BackGoodsIdAndSum[i].indexOf(",")));
                GoodsProductVo goodsProductVo = this.goodsProductService.selectByPrimaryKey(goodsInfoId);
                Long num = Long.parseLong(BackGoodsIdAndSum[i].substring(BackGoodsIdAndSum[i].indexOf(",") + 1, BackGoodsIdAndSum[i].lastIndexOf(",")));
                backNum = backNum + num;
                backOrderSum = backOrderSum.add(goodsProductVo.getGoodsInfoPreferPrice().multiply(new BigDecimal(num)));
            }
            Long orderNum = 0L;
            for (int i = 0; i < orderGoods.size(); ++i) {
                orderNum = orderNum + ((OrderGoods)orderGoods.get(i)).getGoodsInfoNum();
            }
            BigDecimal customerDiscount = this.customerPointServiceMapper.selectCustomerDiscountByCustomerId(backOrder.getCustomerId());
            if (customerDiscount != null && backOrderSum != null) {
                discount = backOrderSum.multiply(customerDiscount);
            }
            BigDecimal backPriceLast = backOrderSum.subtract(new BigDecimal(backNum).multiply(orderPrePrice.divide(new BigDecimal(orderNum), 2, RoundingMode.HALF_UP)));
            backOrder.setBackPrice(backPriceLast);
            int count = this.backOrderService.insertBackOrderInfo(backOrder);
            Long backOrderid = this.backOrderService.selectLastId();
            this.orderService.updateStatusBackById(backOrder.getOrderId(), "30", null);
            if (count > 0) {
                BackOrderLog backOrderLog = new BackOrderLog();
                backOrderLog.setBackLogPerson("customer");
                backOrderLog.setBackLogTime(new Date());
                backOrderLog.setBackLogStatus("1");
                backOrderLog.setBackOrderId(backOrder.getBackOrderId());
                this.backOrderLogService.insert(backOrderLog);
            }
            String[] goodsInfoItemNos = null;
            for (int i = 0; i < goodsProductSonList.length; ++i) {
                if (goodsProductSonList[i] == null) continue;
                String[] strArray = goodsProductSonList[i].split(",");
                productSonMap.put("isUse", "1");
                productSonMap.put("goodsInfoItemNoS", strArray[0]);
                GoodsProductSon goodsPro = this.goodsProductSonService.selectByGoodsItemNoS(productSonMap);
                orderBackGoodsDomain.setBackGoodsPrice(this.goodsProductService.selectByPrimaryKey(goodsPro.getGoodsInfoId()).getGoodsInfoPreferPrice());
                orderBackGoodsDomain.setBackOrderId(backOrderid);
                orderBackGoodsDomain.setBackGoodsTime(new Date());
                orderBackGoodsDomain.setOrderId(order.getOrderId());
                orderBackGoodsDomain.setGoodsInfoItemNoS(goodsProductSonList[i]);
                orderBackGoodsDomain.setBusinessId(Long.valueOf(0L));
                orderBackGoodsDomain.setGoodsInfoId(goodsPro.getGoodsInfoId());
                orderBackGoodsDomain.setGoodsInfoItemNo(goodsPro.getGoodsInfoItemNo());
                Integer goodsNums = strArray.length;
                orderBackGoodsDomain.setGoodsInfoNum(Long.valueOf(goodsNums.longValue()));
                this.orderBackGoodsService.saveOrderBackGood(orderBackGoodsDomain);
                boolean biaoshi = false;
                for (int j2 = 0; j2 < og.size(); ++j2) {
                    goodsInfoItemNos = ((OrderGoods)og.get(j2)).getGoodsInfoItemNoS().split(",");
                    String backGoodsInfoItemNo = "";
                    for (int j = 0; j < goodsInfoItemNos.length; ++j) {
                        String[] goodsProductSon = goodsProductSonList[i].split(",");
                        for (int k = 0; k < goodsProductSon.length; ++k) {
                            if (!goodsInfoItemNos[j].equals(goodsProductSon[k])) continue;
                            if (((OrderGoods)og.get(j2)).getBackGoodsInfoItemNoS() == null || "".equals(((OrderGoods)og.get(j2)).getBackGoodsInfoItemNoS())) {
                                backGoodsInfoItemNo = backGoodsInfoItemNo + goodsProductSon[k] + ",";
                                biaoshi = true;
                                continue;
                            }
                            backGoodsInfoItemNo = ((OrderGoods)og.get(j2)).getBackGoodsInfoItemNoS() + "," + goodsProductSon[k];
                            biaoshi = false;
                        }
                    }
                    if (backGoodsInfoItemNo == null || "".equals(backGoodsInfoItemNo)) continue;
                    if (!biaoshi) {
                        orderGoodsMap.put("backGoodsInfoItemNoS", backGoodsInfoItemNo);
                    } else {
                        orderGoodsMap.put("backGoodsInfoItemNoS", backGoodsInfoItemNo.substring(0, backGoodsInfoItemNo.length() - 1));
                    }
                    orderGoodsMap.put("orderGoodsId", ((OrderGoods)og.get(j2)).getOrderGoodsId());
                    orderGoodsMap.put("backGoodsNum", ((OrderGoods)og.get(j2)).getBackGoodsNum() + goodsNums.longValue());
                    this.orderGoodsService.updateByPrimaryKeySelective(orderGoodsMap);
                }
            }
            List ogs = this.orderService.queryOrderGoods(order.getOrderId());
            boolean backStatus = false;
            for (int j = 0; j < ogs.size(); ++j) {
                if (((OrderGoods)ogs.get(j)).getBackGoodsInfoItemNoS() == null || "".equals(((OrderGoods)ogs.get(j)).getBackGoodsInfoItemNoS())) {
                    this.orderService.updateStatusBackById(backOrder.getOrderId(), "30", null);
                    backStatus = true;
                    continue;
                }
                if (((OrderGoods)ogs.get(j)).getBackGoodsInfoItemNoS().length() == ((OrderGoods)ogs.get(j)).getGoodsInfoItemNoS().length()) {
                    if (backStatus) continue;
                    this.orderService.updateStatusBackById(backOrder.getOrderId(), "14", null);
                    continue;
                }
                this.orderService.updateStatusBackById(backOrder.getOrderId(), "30", null);
            }
        }
        return new ModelAndView((View)new RedirectView("../customer/myorder.html"));
    }

    @RequestMapping(value={"savebackorderdetail"})
    public ModelAndView saveBackOrderDetail(HttpServletRequest request, HttpServletResponse response, BackOrderLog backOrderLog, Long orderId, BigDecimal backPrice) {
        backOrderLog.setBackLogPerson(ADMIN);
        backOrderLog.setBackLogTime(new Date());
        this.backOrderLogService.insert(backOrderLog);
        Order order = this.orderService.getPayOrder(orderId);
        BackOrder backOrder = this.backOrderService.queryBackOrderByOrderCode(order.getOrderCode());
        if (Long.valueOf(backOrderLog.getBackLogStatus()) == 2L) {
            if (Long.valueOf(backOrder.getIsBack()) == 1L) {
                this.orderService.updateStatusBackById(orderId, "30", backPrice);
                this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "9");
            }
            if (Long.valueOf(backOrder.getIsBack()) == 2L) {
                this.orderService.updateStatusBackById(orderId, "12", backPrice);
                this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "3");
            }
        } else if (Long.valueOf(backOrderLog.getBackLogStatus()) == 3L) {
            this.orderService.updateStatusBackById(orderId, "9", backPrice);
            this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "2");
        } else if (Long.valueOf(backOrderLog.getBackLogStatus()) == 5L) {
            this.orderService.updateStatusBackById(orderId, "10", backPrice);
            this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "3");
        } else if (Long.valueOf(backOrderLog.getBackLogStatus()) == 6L) {
            this.orderService.updateStatusBackById(orderId, "16", backPrice);
            this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "8");
        } else if (Long.valueOf(backOrderLog.getBackLogStatus()) == 7L) {
            this.orderService.updateStatusBackById(orderId, "17", backPrice);
            int cont = this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "4");
            if (cont == 1) {
                this.backOrderService.reducePointOrderBack(orderId);
                this.backOrderService.addStockOrderBack(orderId, backOrderLog.getBackOrderId());
            }
        }
        PrintWriter out = null;
        try {
            out = response.getWriter();
            out.append("<script>parent.call_back();</script>");
        }
        catch (IOException e) {
            LOGGER.error("\u65b0\u589e\u4e00\u6761\u9000\u8d27\u64cd\u4f5c\u65e5\u5fd7", (Throwable)e);
        }
        return null;
    }

    @RequestMapping(value={"/newsavebackorderprice"})
    public ModelAndView newsaveBackOrderprice(HttpServletRequest request, HttpServletResponse response, BackOrderLog backOrderLog, Long orderId, BigDecimal backPrice) {
        backOrderLog.setBackLogPerson(ADMIN);
        backOrderLog.setBackLogTime(new Date());
        this.backOrderLogService.insert(backOrderLog);
        Order order = this.orderService.getPayOrder(orderId);
        BackOrder backOrder = this.backOrderService.queryBackOrderByOrderCode(order.getOrderCode());
        if (Long.valueOf(backOrderLog.getBackLogStatus()) == 2L) {
            if (Long.valueOf(backOrder.getIsBack()) == 1L) {
                this.orderService.updateStatusBackById(orderId, "8", backPrice);
                this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "9");
            }
            if (Long.valueOf(backOrder.getIsBack()) == 2L) {
                this.orderService.updateStatusBackById(orderId, "12", backPrice);
                this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "3");
            }
        } else if (Long.valueOf(backOrderLog.getBackLogStatus()) == 3L) {
            this.orderService.updateStatusBackById(orderId, "9", backPrice);
            this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "2");
        } else if (Long.valueOf(backOrderLog.getBackLogStatus()) == 5L) {
            this.orderService.updateStatusBackById(orderId, "10", backPrice);
            this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "3");
        } else if (Long.valueOf(backOrderLog.getBackLogStatus()) == 6L) {
            this.orderService.updateStatusBackById(orderId, "16", backPrice);
            this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "8");
        } else if (Long.valueOf(backOrderLog.getBackLogStatus()) == 7L || Long.valueOf(backOrderLog.getBackLogStatus()) == 8L) {
            this.orderService.updateStatusBackById(orderId, "17", backPrice);
            int cont = this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "4");
            if (cont == 1) {
                this.backOrderService.reducePointOrderBack(orderId);
            }
        } else if (Long.valueOf(backOrderLog.getBackLogStatus()) == 9L) {
            this.orderService.updateStatusBackById(orderId, "13", backPrice);
            int cont = this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "7");
            if (cont == 1) {
                this.backOrderService.reducePointOrderBack(orderId);
            }
        }
        return new ModelAndView((View)new RedirectView(BACKORDERLIST_HTM));
    }

    @RequestMapping(value={"/canelBackOrder"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int canelBackOrder(HttpServletRequest request, HttpServletResponse response, String orderCode, String backOrderId, String orderType) {
        if ("0".equals(orderType) || "1".equals(orderType)) {
            int j;
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            BackOrder backOrders = this.backOrderService.selectBackOrderByBackOrderId(Long.valueOf(Long.parseLong(backOrderId)));
            String[] BackGoodsIdAndSum = backOrders.getBackGoodsIdAndSum().split("-");
            HashMap<String, Long> backMap = new HashMap<String, Long>();
            for (int i = 0; i < BackGoodsIdAndSum.length; ++i) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                Long ordergoodsId = Long.parseLong(BackGoodsIdAndSum[i].substring(BackGoodsIdAndSum[i].lastIndexOf(",") + 1));
                Long goodsInfoId = Long.parseLong(BackGoodsIdAndSum[i].substring(0, BackGoodsIdAndSum[i].indexOf(",")));
                Long num = Long.parseLong(BackGoodsIdAndSum[i].substring(BackGoodsIdAndSum[i].indexOf(",") + 1, BackGoodsIdAndSum[i].lastIndexOf(",")));
                OrderGoods orderGoods = this.orderGoodsService.selectOrderGoodsByOGIds(ordergoodsId);
                map.put("backGoodsNum", orderGoods.getBackGoodsNum() - num);
                map.put("orderGoodsId", ordergoodsId);
                backMap.put("backOrderId", backOrders.getBackOrderId());
                backMap.put("goodsInfoId", goodsInfoId);
                List orderBackGoods = this.orderBackGoodsService.selectAllByMap(backMap);
                List<String> goodsInfoItems = Arrays.asList(orderGoods.getBackGoodsInfoItemNoS().split(","));
                String goodsInfoItemS = "";
                for (j = 0; j < orderBackGoods.size(); ++j) {
                    List<String> backGoodsInfoItemS = Arrays.asList(((OrderBackGoods)orderBackGoods.get(j)).getGoodsInfoItemNoS().split(","));
                    if (backGoodsInfoItemS.size() != 0) {
                        for (String string : goodsInfoItems) {
                            if (backGoodsInfoItemS.contains(string)) continue;
                            System.out.println("\u6362\u8d27\u5546\u54c1\u8868\u91ccOrderId" + ((OrderBackGoods)orderBackGoods.get(j)).getOrderId());
                            System.out.println("\u6362\u8d27\u5546\u54c1\u8868\u91ccOrderId" + orderGoods.getOrderId());
                            if (orderGoods.getOrderId() != ((OrderBackGoods)orderBackGoods.get(j)).getOrderId()) continue;
                            goodsInfoItemS = goodsInfoItemS + string + ",";
                        }
                    }
                    if (goodsInfoItemS == null || "".equals(goodsInfoItemS)) {
                        map.put("backGoodsInfoItemNoS", goodsInfoItemS);
                        continue;
                    }
                    map.put("backGoodsInfoItemNoS", goodsInfoItemS.substring(0, goodsInfoItemS.length() - 1));
                }
                this.orderGoodsService.updateByPrimaryKeySelective(map);
            }
            BackOrder backOrder = new BackOrder();
            backOrder.setCustomerId(customerId);
            backOrder.setOrderCode(backOrders.getBackOrderCode());
            backOrder.setBackCheck("16");
            int result = this.backOrderService.updateBackOrderByOrderCodesMix(backOrder);
            if (result > 0) {
                Order order = new Order();
                order.setOrderCode(orderCode);
                order.setOrderCargoStatus("0");
                order.setOrderStatus("3");
                this.orderService.updateOrderCodes(order);
                GoodsProductSon goodsProductSon = new GoodsProductSon();
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                HashMap<String, String> paramMaps = new HashMap<String, String>();
                if ("1".equals(orderType)) {
                    List orderBarterGoods = this.orderBarterGoodsService.selectByBarterId(Long.valueOf(Long.parseLong(backOrderId)));
                    for (int i = 0; i < orderBarterGoods.size(); ++i) {
                        String[] orderBarterGoodsList = ((OrderBarterGoods)orderBarterGoods.get(i)).getGoodsInfoItemNoS().split(",");
                        for (j = 0; j < orderBarterGoodsList.length; ++j) {
                            System.out.println("~~~~~~~~~\u8d27\u54c1\u56de\u6eda");
                            paramMaps.put("goodsInfoItemNoS", orderBarterGoodsList[j]);
                            paramMaps.put("isUse", "1");
                            paramMap.put("stock", "1");
                            paramMap.put("productId", this.goodsProductSonService.selectByGoodsItemNoS(paramMaps).getGoodsInfoId());
                            paramMap.put("distinctId", "79");
                            this.productWareService.plusStockToWare(paramMap);
                            goodsProductSon.setGoodsInfoItemNoS(orderBarterGoodsList[j]);
                            goodsProductSon.setIsUse("0");
                            this.goodsProductSonService.updateGoodsProductSons(goodsProductSon);
                        }
                    }
                }
                return 1;
            }
        }
        return 0;
    }

    @RequestMapping(value={"/deliverBarterOrder"}, produces={"application/json;charset=UTF-8"})
    public ModelAndView deliverBarterOrder(HttpServletRequest request, HttpServletResponse response) {
        return null;
    }

    @RequestMapping(value={"/barterCostBuy"})
    public ModelAndView barterCostBuy(HttpServletRequest request, HttpServletResponse response, Long orderId, String orderNo, BackOrderLog backOrderLog, BigDecimal backPrice, String repairCostStatus, String goodsPrice, String backOrderId) throws IOException, NoSuchAlgorithmException {
        Order count;
        Object out = null;
        HashMap<String, String> map = new HashMap<String, String>();
        if (backOrderId != null && !"".equals(backOrderId) && (count = this.orderService.selectOrderByBarterIdsNew(Long.valueOf(Long.parseLong(backOrderId)))) != null) {
            String[] orderIds = new String[]{String.valueOf(count.getOrderId())};
            return new ModelAndView("redirect:/toOrderPayPage.htm").addObject("request", (Object)request).addObject("orderIds", (Object)orderIds);
        }
        if (backOrderId == null || backOrderId == "") {
            backOrderId = (String)request.getSession().getAttribute("orderNo");
            backOrderId = (String)request.getSession().getAttribute("backOrderId");
            backPrice = (BigDecimal)request.getSession().getAttribute("backPrice");
        }
        map.put("orderBarterId", backOrderId);
        request.getSession().setAttribute("backOrderId", (Object)backOrderId);
        List orderBarterGodos = this.orderBarterGoodsService.selectByOrderBarterIdAll(map);
        BigDecimal orderBarterPriceSum = new BigDecimal(0);
        BigDecimal orderBarterPriceCustomerPoint = new BigDecimal(0);
        Long[] orderBarterGood = new Long[orderBarterGodos.size()];
        Long resutlNum = 0L;
        int index = 0;
        int index2 = 0;
        for (OrderBarterGoods orderBarterGoods : orderBarterGodos) {
            resutlNum = resutlNum + orderBarterGoods.getGoodsNum();
            ++index2;
        }
        Long[] l = new Long[index2];
        String[] productS = new String[resutlNum.intValue()];
        BigDecimal customerDiscount = this.customerPointServiceMapper.selectCustomerDiscountByCustomerId((Long)request.getSession().getAttribute("customerId"));
        ArrayList<Promotion> promotionLists = new ArrayList<Promotion>();
        BigDecimal youhui = new BigDecimal(0);
        GoodsProductVo productVo = null;
        ArrayList<Promotion> markList = new ArrayList();
        block1: for (OrderBarterGoods orderBarterGoods : orderBarterGodos) {
            BigDecimal goodsNum = new BigDecimal(orderBarterGoods.getGoodsNum());
            productS[index] = orderBarterGoods.getGoodsInfoItemNoS();
            l[index] = orderBarterGoods.getGoodsNum();
            orderBarterGood[index] = orderBarterGoods.getGoodsInfoId();
            GoodsProductVo goodsProduct = this.goodsProductService.selectByPrimaryKey(orderBarterGoods.getGoodsInfoId());
            orderBarterPriceSum = goodsProduct.getGoodsInfoPreferPrice().multiply(goodsNum).add(orderBarterPriceSum);
            orderBarterPriceCustomerPoint = goodsProduct.getGoodsInfoPreferPrice().multiply(goodsNum).multiply(customerDiscount).add(orderBarterPriceCustomerPoint);
            ++index;
            productVo = this.goodsProductService.getGoodsProductVoWithGoods(orderBarterGoods.getGoodsInfoId(), Long.valueOf(769L));
            markList = this.marketService.selectMarketingByGoodsInfoId(orderBarterGoods.getGoodsInfoId(), productVo.getGoods().getBrandId(), productVo.getGoods().getCatId());
            youhui = youhui.add(this.marketingBarter(markList, orderBarterGoods));
            for (Promotion mark : markList) {
                if ("15".equals(mark.getCodexType()) || "12".equals(mark.getCodexType()) || "10".equals(mark.getCodexType())) continue;
                promotionLists.add(mark);
                continue block1;
            }
        }
        ArrayList<Promotion> promotionList = new ArrayList<Promotion>();
        List marketingList = CollectionUtil.defaultList(promotionLists);
        for (Promotion marketing : marketingList) {
            if ("15".equals(marketing.getCodexType()) || "12".equals(marketing.getCodexType())) continue;
            promotionList.add(marketing);
        }
        for (int q = 0; q < promotionList.size() - 1; ++q) {
            for (int p = promotionList.size() - 1; p > q; --p) {
                if (!((Promotion)promotionList.get(p)).getMarketingId().equals(((Promotion)promotionList.get(q)).getMarketingId())) continue;
                promotionList.remove(p);
            }
        }
        HashMap<String, String> repairMap = new HashMap<String, String>();
        repairMap.put("orderType", "1");
        repairMap.put("isAssessment", "1");
        repairMap.put("orderCode", orderNo);
        request.getSession().setAttribute("orderNo", (Object)orderNo);
        request.getSession().setAttribute("backPrice", (Object)backPrice);
        request.getSession().setAttribute("promotionList", promotionList);
        RepairCost repairCost = (RepairCost)JSON.parseObject((String)JSON.toJSONString((Object)this.repairCostService.selectAllByBackOrderId(Long.valueOf(Long.parseLong(backOrderId)))), RepairCost.class);
        double subtractPrice = youhui == BigDecimal.ZERO ? backPrice.subtract(orderBarterPriceCustomerPoint.add(repairCost.getRepairPrice())).doubleValue() : backPrice.subtract(orderBarterPriceCustomerPoint.add(repairCost.getRepairPrice()).subtract(new BigDecimal(String.valueOf(youhui).substring(1, String.valueOf(youhui).length())))).doubleValue();
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        OrderAddress orderAddressNew = new OrderAddress();
        CustomerAddress customerAddress = this.customerAddressServiceMix.queryDefaultAddr(customerId);
        if (null == customerAddress) {
            customerAddress = this.customerAddressServiceMix.selectByCIdFirst(customerId);
        } else if (orderAddressNew.getAddressName() == null || orderAddressNew.getAddressPhone() == null || orderAddressNew.getAddressDetail() == null || orderAddressNew.getAddressDetailInfo() == null) {
            orderAddressNew = new OrderAddress();
            orderAddressNew.setAddressId(customerAddress.getAddressId());
            orderAddressNew.setAddressDetailInfo(customerAddress.getAddressDetail());
            orderAddressNew.setAddressName(customerAddress.getAddressName());
            orderAddressNew.setAddressPhone(customerAddress.getAddressMoblie());
            orderAddressNew.setAddressDetail(customerAddress.getProvince().getProvinceName() + customerAddress.getCity().getCityName() + customerAddress.getDistrict().getDistrictName());
        } else {
            orderAddressNew.setAddressCitySecondStageName(new String(orderAddressNew.getAddressCitySecondStageName().getBytes(ISO_8859_1), "utf-8"));
            orderAddressNew.setAddressCountiesThirdStageName(new String(orderAddressNew.getAddressCountiesThirdStageName().getBytes(ISO_8859_1), "utf-8"));
            orderAddressNew.setAddressDetail(new String(orderAddressNew.getAddressDetail().getBytes(ISO_8859_1), "utf-8"));
            orderAddressNew.setAddressDetailInfo(new String(orderAddressNew.getAddressDetailInfo().getBytes(ISO_8859_1), "utf-8"));
            orderAddressNew.setAddressName(new String(orderAddressNew.getAddressName().getBytes(ISO_8859_1), "utf-8"));
            orderAddressNew.setAddressPhone(new String(orderAddressNew.getAddressPhone().getBytes(ISO_8859_1), "utf-8"));
            orderAddressNew.setProviceFirstStageName(new String(orderAddressNew.getProviceFirstStageName().getBytes(ISO_8859_1), "utf-8"));
        }
        if (subtractPrice < 0.0) {
            BackOrder backOrder = this.backOrderService.selectBackOrderByBackOrderId(Long.valueOf(Long.parseLong(backOrderId)));
            Order order = this.orderService.getPayOrderByCode(backOrder.getOrderCode());
            String[] backGoodsIdAndSum = backOrder.getBackGoodsIdAndSum().split("-");
            ArrayList<OrderGoods> orderGoods = new ArrayList<OrderGoods>();
            for (int i = 0; i < backGoodsIdAndSum.length; ++i) {
                Long orderGoodsId = Long.parseLong(backGoodsIdAndSum[i].substring(backGoodsIdAndSum[i].lastIndexOf(",") + 1));
                Long num = Long.parseLong(backGoodsIdAndSum[i].substring(backGoodsIdAndSum[i].indexOf(",") + 1, backGoodsIdAndSum[i].lastIndexOf(",")));
                orderGoods.add(this.orderGoodsService.selectOrderGoodsByOGIds(orderGoodsId));
                ((OrderGoods)orderGoods.get(i)).setBackGoodsNum(num);
            }
            List<Long> list = Arrays.asList(orderBarterGood);
            List goodsProduct = this.goodsProductService.selectAllShoppingByProIds(list);
            for (int i = 0; i < goodsProduct.size(); ++i) {
                ((GoodsProductVo)goodsProduct.get(i)).setGoodsInfoStock(l[i]);
            }
            request.getSession().setAttribute("promotionList", promotionList);
            request.getSession().setAttribute("expressPrice", (Object)order.getExpressPrice());
            request.getSession().setAttribute("backOrderCusPrice", (Object)backOrder.getBackPrice());
            request.getSession().setAttribute("orderGoodsList", orderGoods);
            request.getSession().setAttribute("goodsProductList", (Object)goodsProduct);
            request.getSession().setAttribute("customerDiscount", (Object)customerDiscount);
            request.getSession().setAttribute("orderAddress", (Object)orderAddressNew);
            BigDecimal youhuis = new BigDecimal(youhui + "");
            request.getSession().setAttribute("youhui", youhui == BigDecimal.ZERO ? Integer.valueOf(0) : String.valueOf(youhuis).substring(1, String.valueOf(youhuis).length()));
            BigDecimal price = new BigDecimal(subtractPrice + "");
            price.add(order.getExpressPrice());
            request.getSession().setAttribute("subtractPrice", (Object)String.valueOf(price).substring(1, String.valueOf(price).length()));
            request.getSession().setAttribute("orderBarterPriceSum", (Object)orderBarterPriceSum);
            request.getSession().setAttribute("orderBarterPriceCustomerPoint", (Object)orderBarterPriceCustomerPoint);
            request.getSession().setAttribute("backGoodsPrice", (Object)backOrder.getBackPrice());
            request.getSession().setAttribute("repairCost", (Object)repairCost);
            request.getSession().setAttribute("orderBarterGoodIndex", (Object)orderBarterGood);
            return new ModelAndView("order/bartersuborder");
        }
        OrderLogger orderLogger = new OrderLogger();
        orderLogger.setName((String)request.getSession().getAttribute("name"));
        orderLogger.setOrderId(orderId.toString());
        orderLogger.setDetail("Customer\u5b9a\u635f\u786e\u8ba4\u5b8c\u6210");
        orderLogger.setType("\u5b9a\u635f\u786e\u8ba4\u7ef4\u4fee");
        orderLogger.setStatus("0");
        this.orderLoggerService.saveLogger(orderLogger);
        List orders = this.returngoods.selectBackOrderId(orderNo);
        BigDecimal backPriceNew = backPrice;
        if (backPriceNew == null) {
            backPriceNew = ((BackOrder)orders.get(0)).getOrderPrice();
        }
        backOrderLog.setBackLogStatus("14");
        backOrderLog.setBackOrderId(Long.parseLong(backOrderId));
        backOrderLog.setBackLogPerson("customer");
        backOrderLog.setBackLogTime(new Date());
        backOrderLog.setBackRemark("\u786e\u8ba4\u5b9a\u635f\u4fe1\u606f");
        backOrderLog.setCustomerRemark("\u786e\u8ba4\u5b9a\u635f\u4fe1\u606f");
        int result = this.backOrderLogService.insert(backOrderLog);
        List ogs = this.orderService.queryOrderGoods(orderId);
        boolean backStatus = false;
        for (int j = 0; j < ogs.size(); ++j) {
            if (((OrderGoods)ogs.get(j)).getBackGoodsInfoItemNoS() == null || "".equals(((OrderGoods)ogs.get(j)).getBackGoodsInfoItemNoS())) {
                this.orderService.updateStatusBackById(orderId, "30", null);
                backStatus = true;
                continue;
            }
            if (((OrderGoods)ogs.get(j)).getBackGoodsInfoItemNoS().length() == ((OrderGoods)ogs.get(j)).getGoodsInfoItemNoS().length()) {
                if (backStatus) continue;
                this.orderService.updateStatusBackById(orderId, "28", backPriceNew);
                continue;
            }
            this.orderService.updateStatusBackById(orderId, "30", null);
        }
        this.backOrderService.modifyBackOrderByCheck(Long.valueOf(Long.parseLong(backOrderId)), "15");
        if (customerAddress == null) {
            customerAddress = this.customerAddressServiceMix.selectByCIdFirst(customerId);
        }
        int newOrderId = this.orderService.saveAddOrderInterfaces(orderBarterPriceSum, new BigDecimal("10"), "25_EMS", "", orderBarterGood, l, Long.valueOf(1690L), Long.valueOf(1L), "", "2", "\u660e\u7ec6", customerAddress, backOrderId, "", productS, "", "");
        System.out.println("\u8c03\u7528\u5411\u5bfc\u9500\u552e\u8ba2\u5355\u63a5\u53e3");
        List goodsProductAll = null;
        String currentRegister = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        String curr = String.valueOf(System.currentTimeMillis() / 1000L);
        String s = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
        String results = "";
        String apisign = "erp_prod_key75dec1805b03407186543937ea09c3bf" + s + "";
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(apisign.getBytes("UTF-8"));
        byte[] b = md5.digest();
        StringBuffer buf = new StringBuffer("");
        for (int offset = 0; offset < b.length; ++offset) {
            int i = b[offset];
            if (i < 0) {
                i += 256;
            }
            if (i < 16) {
                buf.append("0");
            }
            buf.append(Integer.toHexString(i));
        }
        results = buf.toString();
        System.out.println("result = " + results);
        CustomerAllInfo customerAll = this.customerServiceMapper.selectByPrimaryKey(customerId);
        List orderGoods = this.orderGoodsService.selectOrderGoodsLists(orderId);
        String productSon = "";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        Long[] productGoodsIds = new Long[orderGoods.size()];
        int indexs = 0;
        List orderBackGoods = this.orderBackGoodsService.selectByBackOrderId(backOrderLog.getBackOrderId());
        GoodsProductSon goodsProductSon = new GoodsProductSon();
        Long backNum = 0L;
        for (OrderBackGoods orderGood : orderBackGoods) {
            String[] goodsInfoItemNoS;
            backNum = backNum + orderGood.getGoodsInfoNum();
            System.out.println("~~~~~~~~~\u8d27\u54c1\u56de\u6eda");
            paramMap.put("stock", orderGood.getGoodsInfoNum());
            paramMap.put("productId", orderGood.getGoodsInfoId());
            paramMap.put("distinctId", "79");
            this.productWareService.plusStockToWare(paramMap);
            for (String itemNoS : goodsInfoItemNoS = orderGood.getGoodsInfoItemNoS().split(",")) {
                goodsProductSon.setIsUse("0");
                goodsProductSon.setGoodsInfoItemNoS(itemNoS);
                this.goodsProductSonService.updateGoodsProductSons(goodsProductSon);
            }
            productSon = productSon + orderGood.getGoodsInfoItemNoS() + ",";
            productGoodsIds[indexs] = orderGood.getGoodsInfoId();
            ++indexs;
        }
        productSon = productSon.substring(0, productSon.length() - 1);
        List<Long> list = Arrays.asList(productGoodsIds);
        goodsProductAll = this.goodsProductService.selectProductByGoodsInFoId(list);
        String[] strArray = null;
        String barcode = "";
        HashMap<String, String> maps = new HashMap<String, String>();
        strArray = productSon.split(",");
        for (int j2 = 0; j2 < strArray.length; ++j2) {
            maps.put("goodsInfoItemNoS", strArray[j2]);
            maps.put("isUse", "0");
            GoodsProductSon goodsProductSons = this.goodsProductSonService.selectByGoodsItemNoS(maps);
            GoodsProduct goodsProduct = this.goodsProductService.selectByGoodsInfoItemNo(goodsProductSons.getGoodsInfoItemNo());
            barcode = barcode + "{\"barcode\":\"" + strArray[j2] + "\"," + "\"prod_name\":\"" + goodsProduct.getGoodsInfoName() + "\",\"certificate\":\"\",\"style_no\":\"\"," + "\"amt\":\"" + backPrice.divide(new BigDecimal(backNum), 2, RoundingMode.HALF_UP) + "\",\"bill_type\":\"\u6362\u8d27\",\"invoice\":\"false\",\"oldsale_no\":\"" + orderNo + "\"},";
        }
        String barcodes = barcode.substring(0, barcode.length() - 1);
        String orderXD = "{\"apikey\":\"erp_prod_key\",\"apisign\":\"" + results + "\"," + "\"timestamp\":\"" + s + "\",\"vip_no\":\"" + customerAll.getInfoMobile() + "\"," + "\"bill_no\":\"" + ((BackOrder)orders.get(0)).getBackOrderCode() + "\",\"bill_date\":\"" + currentRegister + "\"," + "\"movtel\":\"" + customerAll.getInfoMobile() + "\",\"vip_name\":\"" + customerAll.getInfoMobile() + "\",\"detail\":[" + barcodes + "]}";
        JSONObject resultJsons = HttpRequestUtils.httpPost("http://fsjk.4008713538.cn/Handler/Util/OnlineSale.ashx", JSONObject.fromObject((Object)orderXD));
        System.out.println("Customer\u786e\u8ba4\u5b9a\u635f\u540e\u8c03\u7528\u5411\u5bfc\u6362\u8d27\u63a5\u53e3Json\u6570\u636e:" + orderXD);
        System.out.println("\u63a5\u6536\u5411\u5bfc\u56de\u8c03\u8fc7\u6765\u7684\u503c code =" + resultJsons.getString("code"));
        if (1 == result) {
            Order order = this.orderService.orderDetail(Long.valueOf(newOrderId));
            System.out.println("\u8c03\u7528\u5411\u5bfc\u9500\u552e\u6362\u8d27\u8ba2\u5355\u63a5\u53e3");
            List goodsProductAllNew = null;
            CustomerAllInfo customerAllNew = this.customerServiceMapper.selectByPrimaryKey(order.getCustomerId());
            List orderGoodsNew = this.orderGoodsService.selectOrderGoodsLists(order.getOrderId());
            HashMap<String, String> mapNew = new HashMap<String, String>();
            Long[] productGoodsIdsNew = new Long[orderGoodsNew.size()];
            String[] goodsProSon = new String[orderGoodsNew.size()];
            int indexNew = 0;
            Long orderNum = 0L;
            for (OrderGoods orderGood : orderGoodsNew) {
                orderNum = orderNum + orderGood.getGoodsInfoNum();
                productGoodsIdsNew[indexNew] = orderGood.getGoodsInfoId();
                goodsProSon[indexNew] = orderGood.getGoodsInfoItemNoS();
                ++indexNew;
            }
            List<Long> listNew = Arrays.asList(productGoodsIdsNew);
            goodsProductAllNew = this.goodsProductService.selectProductByGoodsInFoId(listNew);
            String barcodeNew = "";
            for (int j = 0; j < goodsProSon.length; ++j) {
                strArray = goodsProSon[j].split(",");
                for (int j2 = 0; j2 < strArray.length; ++j2) {
                    mapNew.put("isUse", "1");
                    mapNew.put("goodsInfoItemNoS", strArray[j2]);
                    GoodsProductSon goodsProductSonNew = this.goodsProductSonService.selectByGoodsItemNoS(mapNew);
                    GoodsProduct goodsProduct = this.goodsProductService.selectByGoodsInfoItemNo(goodsProductSonNew.getGoodsInfoItemNo());
                    barcodeNew = barcodeNew + "{\"barcode\":\"" + strArray[j2] + "\"," + "\"prod_name\":\"" + goodsProduct.getGoodsInfoName() + "\",\"certificate\":\"\",\"style_no\":\"\"," + "\"amt\":\"" + order.getOrderPrice().divide(new BigDecimal(orderNum), 2, RoundingMode.HALF_UP) + "\",\"bill_type\":\"\u9500\u552e\",\"invoice\":\"false\",\"oldsale_no\":\"" + ((BackOrder)orders.get(0)).getBackOrderCode() + "\"},";
                }
            }
            String barcodesNew = barcodeNew.substring(0, barcodeNew.length() - 1);
            String orderXDNew = "{\"apikey\":\"erp_prod_key\",\"apisign\":\"" + results + "\"," + "\"timestamp\":\"" + s + "\",\"vip_no\":\"" + customerAllNew.getInfoMobile() + "\"," + "\"bill_no\":\"" + order.getOrderCode() + "\",\"bill_date\":\"" + currentRegister + "\"," + "\"movtel\":\"" + customerAllNew.getInfoMobile() + "\",\"vip_name\":\"" + customerAllNew.getInfoMobile() + "\",\"detail\":[" + barcodesNew + "]}";
            JSONObject resultJsonsNew = HttpRequestUtils.httpPost("http://fsjk.4008713538.cn/Handler/Util/OnlineSale.ashx", JSONObject.fromObject((Object)orderXDNew));
            System.out.println("Customer\u786e\u8ba4\u5b9a\u635f\u540e\u8c03\u7528\u5411\u5bfc\u9500\u552e\u63a5\u53e3Json\u6570\u636e:" + orderXDNew);
            System.out.println("\u63a5\u6536\u5411\u5bfc\u56de\u8c03\u8fc7\u6765\u7684\u503c code =" + resultJsonsNew.getString("code"));
            com.qianjiang.util.PageBean pb = new com.qianjiang.util.PageBean();
            pb.setPageNo(1);
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            HashMap<String, Object> paramMap_mav = new HashMap<String, Object>();
            String type = "6";
            paramMap_mav.put("customerId", customerId);
            paramMap_mav.put("type", type);
            pb.setUrl(request.getContextPath() + "/customer/myorder");
            resultMap.put("pb", this.returnGoodsService.queryAllBackOrders(paramMap_mav, pb));
            ModelAndView mav = new ModelAndView("customer/back_order_list");
            resultMap.put("type", type);
            mav.addAllObjects(resultMap);
            return this.seoService.getCurrSeo(mav);
        }
        return new ModelAndView("order/myorder");
    }

    @RequestMapping(value={"/findRepairByOrderCode"})
    public ModelAndView findRepairByOrderCode(HttpServletRequest request, HttpServletResponse response, String orderCode, String isAssessment) {
        HashMap<String, String> repairMap = new HashMap<String, String>();
        isAssessment = "0".equals(isAssessment) ? "0" : "1";
        repairMap.put("isAssessment", isAssessment);
        repairMap.put("orderCode", orderCode);
        RepairCost repairCost = (RepairCost)JSON.parseObject((String)JSON.toJSONString((Object)this.repairCostService.selectRepairCostByCode(repairMap)), RepairCost.class);
        request.getSession().removeAttribute("repairCosts");
        return new ModelAndView("/customer/repair_cost_list").addObject("repairCosts", (Object)repairCost);
    }

    @RequestMapping(value={"/findRepairByOrderCodePc"})
    public ModelAndView findRepairByOrderCodePc(HttpServletRequest request, HttpServletResponse response, String orderCode, String isAssessment) {
        HashMap<String, String> repairMap = new HashMap<String, String>();
        ModelAndView mav = new ModelAndView("/customer/repair_cost_list");
        CustomerAllInfo customerAllInfo = this.customerServiceInterface.queryCustomerById((Long)request.getSession().getAttribute("customerId"));
        customerAllInfo.setInfoPointSum(Integer.valueOf(customerAllInfo.getInfoPointSum() - this.customerPointServiceMapper.getCustomerReducePoint((Long)request.getSession().getAttribute("customerId") + "")));
        isAssessment = "0".equals(isAssessment) ? "0" : "1";
        repairMap.put("isAssessment", isAssessment);
        repairMap.put("orderCode", orderCode);
        RepairCost repairCost = (RepairCost)JSON.parseObject((String)JSON.toJSONString((Object)this.repairCostService.selectRepairCostByCode(repairMap)), RepairCost.class);
        request.getSession().removeAttribute("repairCosts");
        return this.topAndBottomService.getTopAndBottom(mav).addObject("repairCosts", (Object)repairCost).addObject("customer", (Object)customerAllInfo);
    }

    @RequestMapping(value={"/confirmPairCost"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int confirmPairCost(HttpServletRequest request, HttpServletResponse response, Long orderId, String orderNo, BackOrderLog backOrderLog, BigDecimal backPrice, String repairCostStatus, String backOrderId) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if ("0".equals(repairCostStatus)) {
            if ("1".equals("1")) {
                OrderLogger orderLogger = new OrderLogger();
                orderLogger.setName((String)request.getSession().getAttribute("name"));
                orderLogger.setOrderId(orderId.toString());
                orderLogger.setDetail("Customer\u786e\u8ba4\u5b8c\u6210");
                orderLogger.setType("\u786e\u8ba4\u8bc4\u4f30\u7ef4\u4fee");
                orderLogger.setStatus("0");
                this.orderLoggerService.saveLogger(orderLogger);
            }
            List orders = this.returngoods.selectBackOrderId(orderNo);
            BigDecimal backPriceNew = backPrice;
            if (backPriceNew == null) {
                backPriceNew = ((BackOrder)orders.get(0)).getOrderPrice();
            }
            backOrderLog.setBackLogStatus("13");
            backOrderLog.setBackOrderId(((BackOrder)orders.get(0)).getBackOrderId());
            backOrderLog.setBackLogPerson("customer");
            backOrderLog.setBackLogTime(new Date());
            backOrderLog.setBackRemark("\u786e\u8ba4\u8bc4\u4f30\u4fe1\u606f");
            backOrderLog.setCustomerRemark("\u786e\u8ba4\u8bc4\u4f30\u4fe1\u606f");
            int result = this.backOrderLogService.insert(backOrderLog);
            this.orderService.updateStatusBackById(orderId, "8", backPriceNew);
            this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "9");
            if (1 == result) {
                return 1;
            }
        } else if ("1".equals(repairCostStatus)) {
            if ("1".equals("1")) {
                OrderLogger orderLogger = new OrderLogger();
                orderLogger.setName((String)request.getSession().getAttribute("name"));
                orderLogger.setOrderId(orderId.toString());
                orderLogger.setDetail("Customer\u5b9a\u635f\u786e\u8ba4\u5b8c\u6210");
                orderLogger.setType("\u5b9a\u635f\u786e\u8ba4\u7ef4\u4fee");
                orderLogger.setStatus("0");
                this.orderLoggerService.saveLogger(orderLogger);
            }
            List orders = this.returngoods.selectBackOrderId(orderNo);
            BigDecimal customerDiscount = this.customerPointServiceMapper.selectCustomerDiscountByCustomerId(((BackOrder)orders.get(0)).getCustomerId());
            backOrderLog.setBackLogStatus("14");
            backOrderLog.setBackOrderId(Long.parseLong(backOrderId));
            backOrderLog.setBackLogPerson("customer");
            backOrderLog.setBackLogTime(new Date());
            backOrderLog.setBackRemark("\u786e\u8ba4\u5b9a\u635f\u4fe1\u606f");
            backOrderLog.setCustomerRemark("\u786e\u8ba4\u5b9a\u635f\u4fe1\u606f");
            int result = this.backOrderLogService.insert(backOrderLog);
            this.backOrderService.modifyBackOrderByCheck(Long.valueOf(Long.parseLong(backOrderId)), "15");
            List goodsProductAll = null;
            System.out.println("\u4f1a\u5458\u786e\u8ba4\u9000\u8d27\u5b9a\u635f\u540e\u540c\u6b65\u9000\u8d27\u5355\u7ed9\u5411\u5bfc\u300b\u63a8\u9001\u5f00\u59cb");
            String currentRegister = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            String curr = String.valueOf(System.currentTimeMillis() / 1000L);
            String s = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
            String results = "";
            String apisign = "erp_prod_key75dec1805b03407186543937ea09c3bf" + s + "";
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(apisign.getBytes("UTF-8"));
            byte[] b = md5.digest();
            StringBuffer buf = new StringBuffer("");
            for (int offset = 0; offset < b.length; ++offset) {
                int i = b[offset];
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(i));
            }
            results = buf.toString();
            System.out.println("result = " + results);
            List orderGoods = this.orderGoodsService.selectOrderGoodsLists(orderId);
            String productSon = "";
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            Long[] productGoodsIds = new Long[orderGoods.size()];
            int index = 0;
            GoodsProductSon goodsProductSon = new GoodsProductSon();
            List orderBackGoods = this.orderBackGoodsService.selectByBackOrderId(backOrderLog.getBackOrderId());
            Long orderNum = 0L;
            for (OrderBackGoods orderGood : orderBackGoods) {
                String[] goodsInfoItemNoS;
                orderNum = orderNum + orderGood.getGoodsInfoNum();
                System.out.println("~~~~~~~~~\u8d27\u54c1\u56de\u6eda");
                paramMap.put("stock", orderGood.getGoodsInfoNum());
                paramMap.put("productId", orderGood.getGoodsInfoId());
                paramMap.put("distinctId", "79");
                this.productWareService.plusStockToWare(paramMap);
                for (String itemNoS : goodsInfoItemNoS = orderGood.getGoodsInfoItemNoS().split(",")) {
                    goodsProductSon.setIsUse("0");
                    goodsProductSon.setGoodsInfoItemNoS(itemNoS);
                    this.goodsProductSonService.updateGoodsProductSons(goodsProductSon);
                }
                productSon = productSon + orderGood.getGoodsInfoItemNoS() + ",";
                productGoodsIds[index] = orderGood.getGoodsInfoId();
                ++index;
            }
            productSon = productSon.substring(0, productSon.length() - 1);
            List<Long> list = Arrays.asList(productGoodsIds);
            goodsProductAll = this.goodsProductService.selectProductByGoodsInFoId(list);
            BackOrder backOrder = this.backOrderService.selectBackOrderByBackOrderId(backOrderLog.getBackOrderId());
            String[] strArray = null;
            String barcode = "";
            HashMap<String, String> map = new HashMap<String, String>();
            strArray = productSon.split(",");
            for (int j2 = 0; j2 < strArray.length; ++j2) {
                map.put("isUse", "0");
                map.put("goodsInfoItemNoS", strArray[j2]);
                GoodsProductSon goodsProductSons = this.goodsProductSonService.selectByGoodsItemNoS(map);
                GoodsProduct goodsProduct = this.goodsProductService.selectByGoodsInfoItemNo(goodsProductSons.getGoodsInfoItemNo());
                barcode = barcode + "{\"barcode\":\"" + strArray[j2] + "\"," + "\"prod_name\":\"" + goodsProduct.getGoodsInfoName() + "\",\"certificate\":\"\",\"style_no\":\"\"," + "\"amt\":\"" + backOrder.getBackPrice().divide(new BigDecimal(orderNum), 2, RoundingMode.HALF_UP) + "\",\"bill_type\":\"\u9000\u8d27\",\"invoice\":\"false\",\"oldsale_no\":\"" + orderNo + "\"},";
            }
            String barcodes = barcode.substring(0, barcode.length() - 1);
            Order o = this.orderService.orderDetail(orderId);
            CustomerAllInfo customerAll = this.customerServiceMapper.selectByPrimaryKey(o.getCustomerId());
            String orderXD = "{\"apikey\":\"erp_prod_key\",\"apisign\":\"" + results + "\"," + "\"timestamp\":\"" + s + "\",\"vip_no\":\"" + customerAll.getInfoMobile() + "\"," + "\"bill_no\":\"" + ((BackOrder)orders.get(0)).getBackOrderCode() + "\",\"bill_date\":\"" + currentRegister + "\"," + "\"movtel\":\"" + customerAll.getInfoMobile() + "\",\"vip_name\":\"" + customerAll.getInfoMobile() + "\",\"detail\":[" + barcodes + "]}";
            JSONObject resultJsons = HttpRequestUtils.httpPost("http://fsjk.4008713538.cn/Handler/Util/OnlineSale.ashx", JSONObject.fromObject((Object)orderXD));
            System.out.println("\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\u9000\u8d27\u63a8\u9001\u5411\u5bfc\u90a3\u8fb9\u6570\u636e\uff1a" + orderXD);
            System.out.println("\u63a5\u6536\u5411\u5bfc\u56de\u8c03\u8fc7\u6765\u7684\u503c code =" + resultJsons.getString("code"));
            if (1 == result) {
                return 1;
            }
        }
        return 0;
    }

    @RequestMapping(value={"/saveOneRepairCost"})
    public ModelAndView saveOneRepairCost(HttpServletRequest request, HttpServletResponse response, BackOrderLog backOrderLog, Long orderId, BigDecimal backPrice, String orderCode, String goodsBackPrice, String repairPrice, String backOrderId, String isAssessment, String backRemark, String orderType, String barterCycle) throws IOException {
        RepairCostDomain repairCostDomain = new RepairCostDomain();
        String[] goodsInfoItemNo = request.getParameterValues("goodsInfoItemNo");
        Object[] share = request.getParameterValues("share");
        if (share != null && share.length != 0) {
            String uploadDocument = StringUtils.join((Object[])share, (String)",");
            repairCostDomain.setRepairImg(uploadDocument);
        }
        barterCycle = barterCycle == null ? "0" : barterCycle;
        PrintWriter out = null;
        BigDecimal backPriceNew = new BigDecimal(goodsBackPrice);
        backOrderLog.setBackOrderId(Long.parseLong(backOrderId));
        backOrderLog.setBackLogPerson(ADMIN);
        backOrderLog.setBackLogTime(new Date());
        Order order = this.orderService.getPayOrder(orderId);
        if (backPriceNew == null) {
            backPriceNew = order.getOrderPrice();
        }
        if (Long.valueOf(backOrderLog.getBackLogStatus()) == 11L) {
            String result = null;
            for (int i = 0; i < goodsInfoItemNo.length; ++i) {
                repairCostDomain.setCreateTime(new Date());
                repairCostDomain.setGoodsInfoId(Long.valueOf(Long.parseLong(goodsInfoItemNo[i])));
                repairCostDomain.setOrderCode(orderCode);
                repairCostDomain.setRepairPrice(new BigDecimal(Integer.parseInt(repairPrice)));
                repairCostDomain.setOrderType(orderType.equals("0") ? "0" : "1");
                repairCostDomain.setIsAssessment(isAssessment);
                repairCostDomain.setBackOrderId(Long.valueOf(Long.parseLong(backOrderId)));
                repairCostDomain.setBarterCycle(Long.valueOf(Long.parseLong(barterCycle)));
                repairCostDomain.setRepairRemark(backRemark);
                result = this.repairCostService.saveRepairCost(repairCostDomain);
            }
            if (result != "" && result != null) {
                this.orderService.updateStatusBackById(orderId, "26", backPriceNew);
                this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "12");
                if ("1".equals("1")) {
                    OrderLogger orderLogger = new OrderLogger();
                    orderLogger.setName((String)request.getSession().getAttribute("name"));
                    orderLogger.setOrderId(orderId.toString());
                    orderLogger.setDetail("\u7ef4\u4fee\u8d39\u7528\u8bc4\u4f30\u5b8c\u6210");
                    orderLogger.setType("\u8bc4\u4f30\u5b8c\u6210");
                    orderLogger.setStatus("0");
                    this.orderLoggerService.saveLogger(orderLogger);
                }
                backOrderLog.setBackRemark("\u586b\u5199\u8bc4\u4f30\u5355");
                this.backOrderLogService.insert(backOrderLog);
            }
        } else if (Long.valueOf(backOrderLog.getBackLogStatus()) == 12L) {
            String result = null;
            for (int i = 0; i < goodsInfoItemNo.length; ++i) {
                repairCostDomain.setCreateTime(new Date());
                repairCostDomain.setCreateTime(new Date());
                repairCostDomain.setGoodsInfoId(Long.valueOf(Long.parseLong(backOrderId)));
                repairCostDomain.setOrderCode(orderCode);
                repairCostDomain.setRepairPrice(new BigDecimal(Integer.parseInt(repairPrice)));
                repairCostDomain.setOrderType("0");
                repairCostDomain.setIsAssessment(isAssessment);
                repairCostDomain.setGoodsInfoPrice(backPrice);
                repairCostDomain.setBackOrderId(Long.valueOf(Long.parseLong(backOrderId)));
                repairCostDomain.setRepairRemark(backRemark);
                repairCostDomain.setOrderType(orderType.equals("0") ? "0" : "1");
                repairCostDomain.setBarterCycle(Long.valueOf(Long.parseLong(barterCycle)));
                result = this.repairCostService.saveRepairCost(repairCostDomain);
            }
            if (result != "" && result != null) {
                this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "13");
                if ("1".equals("1")) {
                    OrderLogger orderLogger = new OrderLogger();
                    orderLogger.setName((String)request.getSession().getAttribute("name"));
                    orderLogger.setOrderId(orderId.toString());
                    orderLogger.setDetail("\u5b9e\u9645\u5b9a\u635f\u7ef4\u4fee\u8d39\u7528\u8bc4\u4f30\u5b8c\u6210");
                    orderLogger.setType("\u5b9e\u9645\u8bc4\u4f30\u5b8c\u6210");
                    orderLogger.setStatus("0");
                    this.orderLoggerService.saveLogger(orderLogger);
                }
                this.orderService.updateStatusBackById(orderId, "27", backPriceNew);
                this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "13");
            }
            backOrderLog.setBackRemark("\u586b\u5199\u5b9a\u635f\u5355");
            this.backOrderLogService.insert(backOrderLog);
        }
        out = response.getWriter();
        out.append("<script>parent.location.reload();</script>");
        out.flush();
        out.close();
        return null;
    }

    @RequestMapping(value={"/newsavebackorderdetail"})
    public ModelAndView newsaveBackOrderDetail(HttpServletRequest request, HttpServletResponse response, BackOrderLog backOrderLog, Long orderId, BigDecimal backPrice) throws IOException, NoSuchAlgorithmException {
        PrintWriter out = null;
        BigDecimal backPriceNew = backPrice;
        backOrderLog.setBackLogPerson(ADMIN);
        backOrderLog.setBackLogTime(new Date());
        this.backOrderLogService.insert(backOrderLog);
        Order order = this.orderService.getPayOrder(orderId);
        if (backPriceNew == null) {
            backPriceNew = order.getOrderPrice();
        }
        BackOrder backOrder = this.backOrderService.queryBackOrderByOrderCode(order.getOrderCode());
        if (Long.valueOf(backOrderLog.getBackLogStatus()) == 15L) {
            if (order.getPayId() == 1L) {
                try {
                    AlipayUtils alipay = new AlipayUtils();
                    String out_trade_no = order.getOrderCode();
                    BigDecimal refund_amount = backPrice;
                    if (refund_amount == null) {
                        refund_amount = backPriceNew;
                    }
                    String refund_reason = backOrder.getBackRemark();
                    String out_request_no = backOrder.getBackOrderCode();
                    RequestDatas requestData = new RequestDatas(out_trade_no, refund_amount, refund_reason, out_request_no);
                    AlipayUtils.AlipayExecute(requestData);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOGGER.error("\u652f\u4ed8\u5b9d\u9000\u6b3e\u5f02\u5e38", (Throwable)e);
                }
            } else if (order.getPayId() == 3L) {
                try {
                    WxPayExecutingRequest wxpay = new WxPayExecutingRequest();
                    String out_trade_no = order.getOrderCode();
                    String out_refund_no = backOrder.getBackOrderCode();
                    BigDecimal total_fee = order.getOrderPrice();
                    BigDecimal refund_fee = backPrice;
                    if (refund_fee == null) {
                        refund_fee = backPriceNew;
                    }
                    WXPayUtil wxPayUtil = new WXPayUtil();
                    int total_fees = WXPayUtil.changeYtoF(total_fee);
                    int refund_fees = WXPayUtil.changeYtoF(refund_fee);
                    RefundRequestParameter refundRequestParameter = new RefundRequestParameter();
                    refundRequestParameter.setOut_trade_no(out_trade_no);
                    refundRequestParameter.setOut_refund_no(out_refund_no);
                    refundRequestParameter.setTotal_fee(total_fees);
                    refundRequestParameter.setRefund_fee(refund_fees);
                    WxPayExecutingRequest.wxRefundExecuting(refundRequestParameter);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOGGER.error("\u5fae\u4fe1\u9000\u6b3e\u5f02\u5e38", (Throwable)e);
                }
            }
            this.orderService.updateStatusBackById(orderId, "30", backPriceNew);
            this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "4");
            HashMap<String, Number> map = new HashMap<String, Number>();
            map.put("customerId", order.getCustomerId());
            map.put("userTotalPrice", backPrice);
            int result = this.customerService.updateCustomerTotalPrice(map);
            if (result > 0) {
                System.out.println("\u4f1a\u5458\u8d2d\u4e70\u5546\u54c1\u540e\u8c03\u7528\u5411\u5bfc\u63a5\u53e3\u300b\u6263\u6b3e\u5f00\u59cb");
                String currentRegister = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
                String curr = String.valueOf(System.currentTimeMillis() / 1000L);
                String s = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
                String results = "";
                String apisign = "erp_prod_key75dec1805b03407186543937ea09c3bf" + s + "";
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                md5.update(apisign.getBytes("UTF-8"));
                byte[] b = md5.digest();
                StringBuffer buf = new StringBuffer("");
                for (int offset = 0; offset < b.length; ++offset) {
                    int i = b[offset];
                    if (i < 0) {
                        i += 256;
                    }
                    if (i < 16) {
                        buf.append("0");
                    }
                    buf.append(Integer.toHexString(i));
                }
                results = buf.toString();
                System.out.println("result = " + results);
                CustomerAllInfo customerAll = this.customerServiceMapper.selectByPrimaryKey(order.getCustomerId());
                String string = "{\"apikey\":\"erp_prod_key\",\"apisign\":\"" + results + "\",\"timestamp\":\"" + s + "\",\"vip_no\":\"" + customerAll.getInfoMobile() + "\",\"bill_date\"" + ":\"" + currentRegister + "\",\"prepay_amt\":\"" + backPrice + "\",\"free_amt\":\"0.00\",\"cash_amt\":\"0.00\"," + "\"remark\":\"\u5546\u57ce\u9000\u6b3e\u7ed9\u7528\u6237" + backPrice + "\u5143\"}";
                JSONObject resultJsons = HttpRequestUtils.httpPost("http://fsjk.4008713538.cn/Handler/Util/VipPrepayChange.ashx", JSONObject.fromObject((Object)string));
                System.out.println("~~~~~\u5546\u5bb6\u9000\u6b3e\u540e\u8c03\u7528\u5411\u5bfc\u63a5\u53e3~~~~ \u8fd4\u56de\u7684\u54cd\u5e94" + resultJsons.getString("code"));
            }
        } else if (Long.valueOf(backOrderLog.getBackLogStatus()) == 14L) {
            this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "13");
            List ogs = this.orderService.queryOrderGoods(orderId);
            boolean backStatus = false;
            for (int j = 0; j < ogs.size(); ++j) {
                if (((OrderGoods)ogs.get(j)).getBackGoodsInfoItemNoS() == null || "".equals(((OrderGoods)ogs.get(j)).getBackGoodsInfoItemNoS())) {
                    this.orderService.updateStatusBackById(backOrder.getOrderId(), "30", null);
                    backStatus = true;
                    continue;
                }
                if (((OrderGoods)ogs.get(j)).getBackGoodsInfoItemNoS().length() == ((OrderGoods)ogs.get(j)).getGoodsInfoItemNoS().length()) {
                    if (backStatus) continue;
                    this.orderService.updateStatusBackById(orderId, "27", backPriceNew);
                    continue;
                }
                this.orderService.updateStatusBackById(backOrder.getOrderId(), "30", null);
            }
            if ("1".equals("1")) {
                OrderLogger orderLogger = new OrderLogger();
                orderLogger.setName((String)request.getSession().getAttribute("name"));
                orderLogger.setOrderId(orderId.toString());
                orderLogger.setDetail("\u5b9a\u635f\u5b9e\u9645\u8bc4\u4f30\u7528\u5b8c\u6210");
                orderLogger.setType("\u5b9a\u635f\u5b9e\u9645\u8bc4\u4f30\u5b8c\u6210");
                orderLogger.setStatus("0");
                this.orderLoggerService.saveLogger(orderLogger);
            }
        } else if (Long.valueOf(backOrderLog.getBackLogStatus()) == 2L) {
            if (Long.valueOf(backOrder.getIsBack()) == 1L || Long.valueOf(backOrder.getIsBack()) == 3L) {
                List ogs = this.orderService.queryOrderGoods(orderId);
                boolean backStatus = false;
                for (int j = 0; j < ogs.size(); ++j) {
                    if (((OrderGoods)ogs.get(j)).getBackGoodsInfoItemNoS() == null || "".equals(((OrderGoods)ogs.get(j)).getBackGoodsInfoItemNoS())) {
                        this.orderService.updateStatusBackById(orderId, "30", null);
                        backStatus = true;
                        continue;
                    }
                    if (((OrderGoods)ogs.get(j)).getBackGoodsInfoItemNoS().length() == ((OrderGoods)ogs.get(j)).getGoodsInfoItemNoS().length()) {
                        if (backStatus) continue;
                        this.orderService.updateStatusBackById(orderId, "8", backPriceNew);
                        continue;
                    }
                    this.orderService.updateStatusBackById(orderId, "30", null);
                }
                this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "9");
                if ("1".equals("1")) {
                    OrderLogger orderLogger = new OrderLogger();
                    orderLogger.setName((String)request.getSession().getAttribute("name"));
                    orderLogger.setOrderId(orderId.toString());
                    orderLogger.setDetail("\u901a\u8fc7");
                    orderLogger.setType("\u5ba1\u6838\u9000\u8d27");
                    orderLogger.setStatus("0");
                    this.orderLoggerService.saveLogger(orderLogger);
                }
            }
            if (Long.valueOf(backOrder.getIsBack()) == 2L) {
                this.orderService.updateStatusBackById(orderId, "12", backPriceNew);
                this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "3");
            }
        } else if (Long.valueOf(backOrderLog.getBackLogStatus()) == 3L) {
            this.orderService.updateStatusBackById(orderId, "9", backPriceNew);
            if ("1".equals("1")) {
                OrderLogger orderLogger = new OrderLogger();
                orderLogger.setName((String)request.getSession().getAttribute("name"));
                orderLogger.setOrderId(orderId.toString());
                orderLogger.setDetail("\u9a73\u56de");
                orderLogger.setType("\u5ba1\u6838\u9000\u8d27");
                orderLogger.setStatus("0");
                this.orderLoggerService.saveLogger(orderLogger);
            }
            this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "2");
        } else if (Long.valueOf(backOrderLog.getBackLogStatus()) == 5L) {
            this.orderService.updateStatusBackById(orderId, "25", backPriceNew);
            this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "11");
        } else if (Long.valueOf(backOrderLog.getBackLogStatus()) == 6L) {
            this.orderService.updateStatusBackById(orderId, "16", backPriceNew);
            this.backOrderService.modifyBackOrderByCheck(backOrderLog.getBackOrderId(), "8");
        } else if (Long.valueOf(backOrderLog.getBackLogStatus()) == 7L) {
            List ogs = this.orderService.queryOrderGoods(orderId);
            boolean backStatus = false;
            for (int j = 0; j < ogs.size(); ++j) {
                if (((OrderGoods)ogs.get(j)).getBackGoodsInfoItemNoS() == null || "".equals(((OrderGoods)ogs.get(j)).getBackGoodsInfoItemNoS())) {
                    this.orderService.updateStatusBackById(backOrder.getOrderId(), "30", null);
                    backStatus = true;
                    continue;
                }
                if (((OrderGoods)ogs.get(j)).getBackGoodsInfoItemNoS().length() == ((OrderGoods)ogs.get(j)).getGoodsInfoItemNoS().length()) {
                    if (backStatus) continue;
                    this.orderService.updateStatusBackById(orderId, "17", backPriceNew);
                    continue;
                }
                this.orderService.updateStatusBackById(backOrder.getOrderId(), "30", null);
            }
            BackOrder bo = new BackOrder();
            bo.setBackOrderId(backOrder.getBackOrderId());
            bo.setBackPrice(backPriceNew);
            this.backOrderService.updateBackOrderReducePrice(bo);
            int cont = this.backOrderService.modifyBackOrderByCheckNew(backOrderLog.getBackOrderId(), "4");
            if (cont == 1) {
                this.backOrderService.reducePointOrderBack(orderId);
                this.orderCouponService.modifyCouponStatus(orderId);
            }
            this.updateDepositInfo(order, backPrice, backOrder, request);
        } else if (Long.valueOf(backOrderLog.getBackLogStatus()) == 8L) {
            if ("1".equals("1")) {
                OrderLogger orderLogger = new OrderLogger();
                orderLogger.setName((String)request.getSession().getAttribute("name"));
                orderLogger.setOrderId(orderId.toString());
                orderLogger.setDetail("\u901a\u8fc7");
                orderLogger.setType("\u5ba1\u6838\u9000\u6b3e");
                orderLogger.setStatus("0");
                this.orderLoggerService.saveLogger(orderLogger);
            }
            if (order.getPayId() == 1L) {
                try {
                    AlipayUtils alipay = new AlipayUtils();
                    String out_trade_no = order.getOrderCode();
                    BigDecimal refund_amount = backPriceNew;
                    String refund_reason = backOrder.getBackRemark();
                    String out_request_no = backOrder.getBackOrderCode();
                    RequestDatas requestData = new RequestDatas(out_trade_no, refund_amount, refund_reason, out_request_no);
                    AlipayUtils.AlipayExecute(requestData);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOGGER.error("\u652f\u4ed8\u5b9d\u9000\u6b3e\u5f02\u5e38", (Throwable)e);
                }
            } else if (order.getPayId() == 3L) {
                try {
                    WxPayExecutingRequest wxpay = new WxPayExecutingRequest();
                    String out_trade_no = order.getOrderCode();
                    String out_refund_no = backOrder.getBackOrderCode();
                    BigDecimal total_fee = order.getOrderPrice();
                    BigDecimal refund_fee = backPriceNew;
                    WXPayUtil wxPayUtil = new WXPayUtil();
                    int total_fees = WXPayUtil.changeYtoF(total_fee);
                    int refund_fees = WXPayUtil.changeYtoF(refund_fee);
                    RefundRequestParameter refundRequestParameter = new RefundRequestParameter();
                    refundRequestParameter.setOut_trade_no(out_trade_no);
                    refundRequestParameter.setOut_refund_no(out_refund_no);
                    refundRequestParameter.setTotal_fee(total_fees);
                    refundRequestParameter.setRefund_fee(refund_fees);
                    WxPayExecutingRequest.wxRefundExecuting(refundRequestParameter);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOGGER.error("\u5fae\u4fe1\u9000\u6b3e\u5f02\u5e38", (Throwable)e);
                }
            }
            this.orderService.updateStatusBackById(orderId, "18", backPriceNew);
            int cont = this.backOrderService.modifyBackOrderByCheckNew(backOrderLog.getBackOrderId(), "10");
            if (cont == 1) {
                this.backOrderService.reducePointOrderBackNew(orderId);
                this.orderCouponService.modifyCouponStatus(orderId);
            }
            this.updateDepositInfo(order, backPrice, backOrder, request);
        } else if (Long.valueOf(backOrderLog.getBackLogStatus()) == 9L) {
            this.orderService.updateStatusBackById(orderId, "13", backPriceNew);
            int cont = this.backOrderService.modifyBackOrderByCheckNew(backOrderLog.getBackOrderId(), "7");
            if (cont == 1 && "1".equals("1")) {
                OrderLogger orderLogger = new OrderLogger();
                orderLogger.setName((String)request.getSession().getAttribute("name"));
                orderLogger.setOrderId(orderId.toString());
                orderLogger.setDetail("\u9a73\u56de");
                orderLogger.setType("\u5ba1\u6838\u9000\u6b3e");
                orderLogger.setStatus("0");
                this.orderLoggerService.saveLogger(orderLogger);
            }
        }
        out = response.getWriter();
        out.append("<script>parent.location.reload();</script>");
        out.flush();
        out.close();
        return null;
    }

    private boolean checkExtendsName(String fileName) {
        String[] extendNames;
        if (fileName.indexOf(".") < 0) {
            return false;
        }
        String extend = fileName.substring(fileName.lastIndexOf(".") + 1);
        for (String extendName : extendNames = new String[]{"jpg", "jpeg", "bmp", "png", "gif"}) {
            if (!extend.equals(extendName)) continue;
            return true;
        }
        return false;
    }

    public String createBackOrderNo() {
        String d = new SimpleDateFormat("yyyyMMdd").format(Calendar.getInstance().getTime());
        Random r = new Random();
        Double d1 = r.nextDouble();
        String s = d1 + "";
        s = d + s.substring(3, 9);
        return s;
    }

    public BackOrderLogService getBackOrderLogService() {
        return this.backOrderLogService;
    }

    @Resource(name="BackOrderLogService")
    public void setBackOrderLogService(BackOrderLogService backOrderLogService) {
        this.backOrderLogService = backOrderLogService;
    }

    public OrderService getOrderService() {
        return this.orderService;
    }

    @Resource(name="OrderService")
    public void setOrderService(OrderService orderService) {
        this.orderService = orderService;
    }

    public BackOrderService getBackOrderService() {
        return this.backOrderService;
    }

    @Resource(name="BackOrderService")
    public void setBackOrderService(BackOrderService backOrderService) {
        this.backOrderService = backOrderService;
    }

    public OrderLogService getOrderLogService() {
        return this.orderLogService;
    }

    @Resource(name="OrderLogService")
    public void setOrderLogService(OrderLogService orderLogService) {
        this.orderLogService = orderLogService;
    }

    public void updateDepositInfo(Order order, BigDecimal backPrice, BackOrder backOrder, HttpServletRequest request) {
        if (order.getPayId().intValue() == 5) {
            Long customerId = order.getCustomerId();
            DepositInfo depositInfo = this.depositInfoService.selectDepositByCustId(customerId);
            BigDecimal preDepositPrice = depositInfo.getPreDeposit();
            preDepositPrice = backPrice == null || backPrice.intValue() == 0 ? (preDepositPrice == null || preDepositPrice.intValue() == 0 ? order.getOrderPrice() : preDepositPrice.add(order.getOrderPrice())) : (preDepositPrice == null || preDepositPrice.intValue() == 0 ? backPrice : preDepositPrice.add(backPrice));
            depositInfo.setPreDeposit(preDepositPrice);
            if (depositInfo.getFreezePreDeposit() != null && depositInfo.getFreezePreDeposit().intValue() != 0) {
                preDepositPrice = preDepositPrice.add(depositInfo.getFreezePreDeposit());
            }
            TradeInfo tradeInfo = this.getTradeInfo(customerId, backOrder, preDepositPrice, backPrice, order);
            this.tradeInfoService.insertTradeInfo(tradeInfo);
            this.depositInfoService.updateDeposit(depositInfo);
        }
    }

    public TradeInfo getTradeInfo(Long customerId, BackOrder backOrder, BigDecimal currentPrice, BigDecimal backPrice, Order order) {
        TradeInfo tradeInfo = new TradeInfo();
        tradeInfo.setCustomerId(customerId);
        tradeInfo.setOrderCode(backOrder.getOrderCode());
        tradeInfo.setOrderType("1");
        tradeInfo.setOrderStatus("4");
        tradeInfo.setCurrentPrice(currentPrice);
        BigDecimal orderPrice = backPrice == null || backPrice.intValue() == 0 ? backOrder.getBackPrice() : backPrice;
        tradeInfo.setOrderPrice(orderPrice);
        tradeInfo.setCreateTime(new Date());
        tradeInfo.setUpdateTime(new Date());
        tradeInfo.setDelFlag("0");
        tradeInfo.setTradeRemark("\u9000\u6b3e\u8ba2\u5355:" + order.getOrderCode() + ",\u9000\u6b3e\u5355\u53f7:" + backOrder.getBackOrderCode());
        return tradeInfo;
    }
}

