/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.customer.deposit.pay;

import com.qianjiang.site.customer.deposit.pay.AbstractPayStrategy;
import com.qianjiang.site.customer.deposit.pay.AliPay;
import com.qianjiang.system.bean.Pay;
import com.unionpay.acp.sdk.SDKConfig;
import com.unionpay.acp.sdk.SDKUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.util.CollectionUtils;

public class UnionPay
extends AbstractPayStrategy {
    private static Logger LOGGER = Logger.getLogger(AliPay.class);

    @Override
    public String pay() {
        Pay pay = this.getPay();
        Map<String, String> paramMap = this.getParamMap();
        SDKConfig.getConfig().loadPropertiesFromSrc();
        String requestUrl = SDKConfig.getConfig().getFrontRequestUrl();
        String returnUrl = this.getPay().getPayUrl() + "/deposit/synunionpayresult.htm";
        String merId = this.getPay().getPayAccount();
        String notifyUrl = pay.getPayUrl() + "/deposit/unionpaycallback.htm";
        paramMap.put("version", "5.0.0");
        paramMap.put("encoding", "utf-8");
        paramMap.put("signMethod", "01");
        paramMap.put("txnType", "01");
        paramMap.put("txnSubType", "01");
        paramMap.put("bizType", "000201");
        paramMap.put("channelType", "07");
        paramMap.put("accessType", "0");
        paramMap.put("currencyCode", "156");
        paramMap.put("merId", merId);
        paramMap.put("frontUrl", returnUrl);
        paramMap.put("backUrl", notifyUrl);
        paramMap.put("txnTime", this.getDateTime("yyyyMMddHHmmss"));
        Map<String, String> submitFromData = this.signData(this.getParamMap());
        String html = this.buildDom(requestUrl, submitFromData);
        return html;
    }

    public UnionPay(Pay pay) {
        super(pay);
    }

    private Map<String, String> signData(Map<String, ?> contentData) {
        HashMap<String, String> submitFromData = new HashMap<String, String>();
        for (Map.Entry<String, ?> obj : contentData.entrySet()) {
            String value = (String)obj.getValue();
            if (!StringUtils.isNotBlank((String)value)) continue;
            submitFromData.put(obj.getKey(), value.trim());
        }
        SDKUtil.sign(submitFromData, (String)"UTF-8");
        return submitFromData;
    }

    private String buildDom(String action, Map<String, String> fields) {
        StringBuilder sb = new StringBuilder();
        sb.append("<form id = \"form\" action=\"" + action + "\" method=\"post\">");
        Object it = null;
        if (!CollectionUtils.isEmpty(fields)) {
            for (Map.Entry<String, String> entry : fields.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                sb.append("<input type=\"hidden\" name=\"" + key + "\" id=\"" + key + "\" value=\"" + value + "\"/>");
            }
        }
        sb.append("</form>");
        sb.append("<script type=\"text/javascript\">");
        sb.append("document.all.form.submit();");
        sb.append("</script>");
        return sb.toString();
    }

    private String getDateTime(String formatter) {
        Date date = new Date();
        SimpleDateFormat df = new SimpleDateFormat(formatter);
        return df.format(date);
    }
}

