/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.order.controller;

import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.internal.util.AlipaySignature;
import com.qianjiang.common.util.alipay.util.AlipayConfig;
import com.qianjiang.common.util.alipay.util.UtilDate;
import com.qianjiang.customer.service.CustomerCommissionService;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.deposit.bean.Deposit;
import com.qianjiang.deposit.service.impl.DepositService;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.index.service.TopAndBottomService;
import com.qianjiang.order.bean.Order;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.site.customer.deposit.service.SiteDepositService;
import com.qianjiang.site.order.service.IPayService;
import com.qianjiang.site.order.service.SiteOrderService;
import com.qianjiang.site.util.MD5Util;
import com.qianjiang.site.util.PayUtil;
import com.qianjiang.system.bean.Pay;
import com.qianjiang.system.bean.Receivables;
import com.qianjiang.system.service.PayService;
import com.qianjiang.system.service.PaymentService;
import com.qianjiang.system.service.ReceivablesService;
import com.qianjiang.util.MyLogger;
import com.unionpay.acp.sdk.SDKConfig;
import com.unionpay.acp.sdk.SDKUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PaySiteController {
    private static final MyLogger LOGGER = new MyLogger(PaySiteController.class);
    private static final String LOGGERINFO1 = "\u652f\u4ed8\u8bf7\u6c42\u5931\u8d25";
    private static final String UTF_8 = "UTF-8";
    private static final String ISO_8859_1 = "ISO-8859-1";
    private static final String OUT_TRADE_NO = "out_trade_no";
    private static final String TRADE_STATUS = "trade_status";
    private static final String ORDER_PAYSUCCESS = "order/paysuccess";
    private static final String ORDER = "order";
    private static final String PRICE = "price";
    private static final String SUCCESS = "success";
    private static final String UNKNOWN = "unknown";
    private static final String PAYPAL_PAYMENT_STATUS = "payment_status";
    @Resource(name="receivablesService")
    private ReceivablesService receivablesService;
    @Resource(name="payService")
    private PayService payService;
    @Resource(name="PaymentService")
    PaymentService paymentService;
    @Resource(name="SiteOrderService")
    private SiteOrderService siteOrderService;
    @Resource(name="OrderService")
    private OrderService orderser;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceInterface;
    @Resource(name="TopAndBottomService")
    private TopAndBottomService topAndBottomService;
    @Resource(name="IPayService")
    private IPayService iPayService;
    @Resource(name="GoodsProductService")
    private GoodsProductService goodsProductService;
    @Resource(name="depositService")
    private DepositService depositService;
    @Resource(name="customerCommissionService")
    private CustomerCommissionService customerCommissionService;
    private SiteDepositService siteDepositService;

    public void getReceivables(Pay p, HttpServletRequest request, Order order) {
        Receivables receivables1 = this.receivablesService.queryByOrderCode(order.getOrderCode());
        if (null == receivables1) {
            Receivables receivables = new Receivables();
            Random random = new Random();
            int code = random.nextInt(10001);
            String codes = "2015" + code;
            receivables.setCashRegisterCode(codes);
            receivables.setPayIp(this.getIpAddr(request));
            receivables.setCustomerId(order.getCustomerUsername());
            receivables.setPayAccount(p.getPayAccount());
            receivables.setPayTime(new Date());
            receivables.setReceivablesTime(new Date());
            receivables.setPayMode(p.getPayName());
            receivables.setPayType("\u5728\u7ebf\u652f\u4ed8");
            receivables.setPayMoney(order.getOrderPrice());
            receivables.setOrderCode(order.getOrderCode());
            receivables.setPayStatus("1");
            this.receivablesService.addReceivables(receivables);
        } else {
            receivables1.setPayIp(this.getIpAddr(request));
            receivables1.setCustomerId(order.getCustomerUsername());
            receivables1.setPayAccount(p.getPayAccount());
            receivables1.setPayTime(new Date());
            receivables1.setReceivablesTime(new Date());
            receivables1.setPayMode(p.getPayName());
            receivables1.setPayType("\u5728\u7ebf\u652f\u4ed8");
            receivables1.setPayMoney(order.getOrderPrice());
            receivables1.setOrderCode(order.getOrderCode());
            receivables1.setPayStatus("1");
            this.receivablesService.upDateReceivables(receivables1);
        }
    }

    @RequestMapping(value={"/payorder"})
    public void payOrder(Long orderCount, Long orderId, HttpServletRequest request, Long payId, HttpServletResponse response) throws UnsupportedEncodingException {
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        if (customerId == null) {
            return;
        }
        String goodsName = this.orderser.queryGoodsInfoName(orderId);
        Order order = this.siteOrderService.getPayOrder(orderId);
        if (!customerId.equals(order.getCustomerId())) {
            try {
                response.getWriter().write("what are you doing ?????");
                response.getWriter().close();
            }
            catch (Exception e) {
                LOGGER.error("write error", (Throwable)e);
            }
            return;
        }
        BigDecimal payTotalPrice = order.getOrderPrice();
        Pay p = this.payService.findByPayId(payId);
        if (p != null) {
            if (null != orderCount && 1L < orderCount) {
                BigDecimal totalPrice = BigDecimal.ZERO;
                List orderslist = this.siteOrderService.getPayOrderByOldCode(order.getOrderOldCode());
                for (int i = 0; i < orderslist.size(); ++i) {
                    Order childOrder = (Order)orderslist.get(i);
                    if ("1".equals(childOrder.getOrderLinePay())) {
                        this.getReceivables(p, request, childOrder);
                    }
                    totalPrice = totalPrice.add(childOrder.getOrderPrice());
                }
                payTotalPrice = totalPrice;
            } else {
                this.getReceivables(p, request, order);
            }
            if ("1".equals(p.getPayType())) {
                String sHtmlText = this.iPayService.getAlipay(p, order, goodsName, orderCount, payTotalPrice);
                response.setContentType("text/html;charset=UTF-8");
                response.setCharacterEncoding("utf-8");
                try {
                    response.getWriter().write(sHtmlText);
                    LOGGER.info((Object)("\u7ed9\u8ba2\u5355\u53f7\u4e3a\uff1a\u3010" + order.getOrderCode() + "\u3011\u7684\u8ba2\u5355\u4ed8\u6b3e\u6210\u529f"));
                }
                catch (IOException e) {
                    LOGGER.error(LOGGERINFO1 + e);
                }
            } else if ("2".equals(p.getPayType())) {
                String encoding = "utf-8";
                SDKConfig.getConfig().loadPropertiesFromSrc();
                String requestUrl = SDKConfig.getConfig().getFrontRequestUrl();
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("version", "5.0.0");
                data.put("encoding", "utf-8");
                data.put("signMethod", "01");
                data.put("txnType", "01");
                data.put("txnSubType", "01");
                data.put("bizType", "000201");
                data.put("channelType", "07");
                String returnUrl = p.getBackUrl();
                data.put("frontUrl", returnUrl);
                String notifyUrl = p.getPayUrl() + "/unionpaynotifysuccess.html";
                data.put("backUrl", notifyUrl);
                data.put("accessType", "0");
                data.put("merId", p.getPayAccount());
                data.put("orderId", order.getOrderCode());
                data.put("txnTime", UtilDate.getOrderNum());
                data.put("txnAmt", payTotalPrice.multiply(new BigDecimal(100)).setScale(0, 4).toString());
                data.put("currencyCode", "156");
                Map<String, String> submitFromData = PaySiteController.signData(data);
                String html = PaySiteController.createHtml(requestUrl, submitFromData);
                response.setContentType("text/html;charset=UTF-8");
                response.setCharacterEncoding("utf-8");
                try {
                    response.getWriter().write(html);
                }
                catch (IOException e) {
                    LOGGER.error(LOGGERINFO1 + e);
                }
            } else if ("4".equals(p.getPayType())) {
                PayUtil pay = new PayUtil();
                if (null != orderCount && 1L < orderCount) {
                    order = this.checkOrder(order);
                    pay.setCallBackUrl(p.getPayUrl() + "qmpaysussmulti.htm");
                    pay.setNotifyUrl(p.getPayUrl() + "qmpaysussymulti.htm");
                } else {
                    pay.setNotifyUrl(p.getPayUrl() + "qmpaysucasy.htm");
                    pay.setCallBackUrl(p.getBackUrl());
                }
                pay.setOrderNo(order.getOrderCode());
                pay.setBuyerUserId(p.getPayAccount());
                pay.setSellerUserId(p.getPayAccount());
                pay.setSettleAmount(order.getOrderPrice());
                pay.setProductName(goodsName);
                pay.setAdminUserId(p.getSecretKey());
                try {
                    pay.setFromIp(InetAddress.getLocalHost().getHostAddress());
                }
                catch (UnknownHostException e) {
                    LOGGER.error("", (Throwable)e);
                    LOGGER.info((Object)e);
                }
                pay.setTradeChannel("SYY");
                pay.setGoodsUrl(p.getPayUrl() + "customer/detail-" + order.getOrderId() + ".html");
                pay.setSettleType("1");
                pay.setAmount(order.getOrderPrice());
                pay.setSysId("901");
                pay.setCssStyle("style-orange.css");
                String key = p.getApiKey();
                String s = pay.getAdminUserId() + pay.getAmount() + pay.getBuyerUserId() + pay.getCallBackUrl() + pay.getCssStyle() + pay.getFromIp() + pay.getGoodsUrl() + pay.getNotifyUrl() + pay.getOrderNo() + pay.getProductName() + pay.getSellerUserId() + pay.getSettleAmount() + pay.getSettleType() + pay.getSysId() + pay.getTradeChannel() + key;
                String sign = MD5Util.md5Hex(MD5Util.getContentBytes(s, UTF_8));
                HashMap<String, String> sParaTemp = new HashMap<String, String>();
                sParaTemp.put("orderNo", pay.getOrderNo());
                sParaTemp.put("buyerUserId", pay.getBuyerUserId());
                sParaTemp.put("sellerUserId", pay.getSellerUserId());
                sParaTemp.put("settleAmount", pay.getSettleAmount().toString());
                sParaTemp.put("productName", pay.getProductName());
                sParaTemp.put("adminUserId", pay.getAdminUserId());
                sParaTemp.put("callBackUrl", pay.getCallBackUrl());
                sParaTemp.put("fromIp", pay.getFromIp());
                sParaTemp.put("tradeChannel", pay.getTradeChannel());
                sParaTemp.put("goodsUrl", pay.getGoodsUrl());
                sParaTemp.put("settleType", pay.getSettleType());
                sParaTemp.put("amount", pay.getAmount().toString());
                sParaTemp.put("sysId", pay.getSysId());
                sParaTemp.put("cssStyle", pay.getCssStyle());
                sParaTemp.put("notifyUrl", pay.getNotifyUrl());
                sParaTemp.put("sign", sign);
                String html = PaySiteController.createHtml("https://cashier.qianjiang.com/home/payment", sParaTemp);
                response.setContentType("text/html;charset=UTF-8");
                request.setCharacterEncoding(UTF_8);
                response.setCharacterEncoding("utf-8");
                try {
                    response.getWriter().write(html);
                }
                catch (IOException e) {
                    LOGGER.error(LOGGERINFO1, (Throwable)e);
                }
            } else if ("5".equals(p.getPayType())) {
                response.setCharacterEncoding(UTF_8);
                response.setContentType("application/json; charset=utf-8");
                JSONObject retjson = new JSONObject();
                BigDecimal ttotalFee = payTotalPrice;
                String torderCode = order.getOrderCode();
                Long torderId = order.getOrderId();
                String status = order.getOrderStatus();
                if (!"0".equals(status)) {
                    retjson.put("retcode", (Object)"-1");
                    retjson.put("msg", (Object)"\u8ba2\u5355\u72b6\u6001\u4e0d\u662f\u672a\u4ed8\u6b3e");
                    try {
                        response.getWriter().println(retjson);
                        return;
                    }
                    catch (IOException e) {
                        LOGGER.error(LOGGERINFO1, (Throwable)e);
                    }
                }
                JSONObject json = new JSONObject();
                String payPassword = request.getParameter("payPassword");
                HashMap<String, Long> queryMap = new HashMap<String, Long>();
                queryMap.put("customerId", customerId);
                Deposit deposit = this.depositService.getDeposit(queryMap);
                JSONObject payjson = this.siteDepositService.pay(payTotalPrice, deposit, payPassword, torderId, torderCode);
                try {
                    response.getWriter().println(payjson);
                }
                catch (IOException e) {
                    LOGGER.error(LOGGERINFO1, (Throwable)e);
                }
            } else if ("7".equals(p.getPayType())) {
                String html = this.paypalGetHtml(order, goodsName, p);
                response.setContentType("text/html;charset=UTF-8");
                response.setCharacterEncoding("utf-8");
                try {
                    response.getWriter().write(html);
                    LOGGER.info((Object)("\u7ed9\u8ba2\u5355\u53f7\u4e3a\uff1a\u3010" + order.getOrderCode() + "\u3011\u7684\u8ba2\u5355\u4ed8\u6b3e\u6210\u529f"));
                }
                catch (IOException e) {
                    LOGGER.error(LOGGERINFO1 + e);
                }
            }
        }
    }

    @RequestMapping(value={"/checkdepositpay"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public JSONObject preCheckDepositPay(Long orderCount, Long orderId, HttpServletRequest request, Long payId, HttpServletResponse response) {
        JSONObject retjson = new JSONObject();
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        if (customerId == null) {
            retjson.put("retcode", (Object)"-1");
            retjson.put("msg", (Object)"\u8bf7\u5148\u767b\u5f55");
            return retjson;
        }
        Order order = this.siteOrderService.getPayOrder(orderId);
        BigDecimal payTotalPrice = order.getOrderPrice();
        if (!customerId.equals(order.getCustomerId())) {
            retjson.put("retcode", (Object)"-1");
            retjson.put("msg", (Object)"what are you doing ?????");
            return retjson;
        }
        BigDecimal ttotalFee = payTotalPrice;
        String torderCode = order.getOrderCode();
        Long torderId = order.getOrderId();
        String payPassword = request.getParameter("payPassword");
        HashMap<String, Long> queryMap = new HashMap<String, Long>();
        queryMap.put("customerId", customerId);
        Deposit deposit = this.depositService.getDeposit(queryMap);
        int errorCount = deposit.getPasswordErrorCount();
        String tpayPassword = deposit.getPayPassword();
        JSONObject payjson = this.siteDepositService.preCheck(payTotalPrice, deposit, payPassword, torderId, torderCode);
        return payjson;
    }

    @RequestMapping(value={"/depositpaysuccess"})
    public ModelAndView depositPaysuccess(Long orderId, HttpServletRequest request) {
        Order order = this.siteOrderService.getPayOrder(orderId);
        List orderslist = this.siteOrderService.getPayOrderByOldCode(order.getOrderOldCode());
        BigDecimal totalPrice = BigDecimal.ZERO;
        int i = 0;
        if (!CollectionUtils.isEmpty((Collection)orderslist)) {
            i = orderslist.size();
        }
        Order tempOrder = null;
        for (int k = 0; k < i; ++k) {
            tempOrder = (Order)orderslist.get(k);
            totalPrice = totalPrice.add(tempOrder.getOrderPrice());
        }
        ModelAndView mav = new ModelAndView("order/depositpaysuccess");
        mav.addObject(ORDER, (Object)order);
        mav.addObject("totalPrice", (Object)totalPrice);
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    private Order checkOrder(Order order) {
        List orders;
        BigDecimal orderSumPrice = new BigDecimal(0.0);
        if (null != order.getOrderOldCode() && null != (orders = this.siteOrderService.getPayOrderByOldCode(order.getOrderOldCode())) && orders.size() >= 1) {
            for (int i = 0; i < orders.size(); ++i) {
                Order childOrder = (Order)orders.get(i);
                if ("0".equals(childOrder.getOrderLinePay())) continue;
                orderSumPrice = orderSumPrice.add(childOrder.getOrderPrice());
            }
            order.setOrderPrice(orderSumPrice);
            order.setOrderCode(order.getOrderOldCode());
        }
        return order;
    }

    public static String createHtml(String action, Map<String, String> hiddens) {
        StringBuilder sf = new StringBuilder();
        sf.append("<form id = \"sform\" action=\"" + action + "\" method=\"post\">");
        if (null != hiddens && !hiddens.isEmpty()) {
            Set<Map.Entry<String, String>> set = hiddens.entrySet();
            for (Map.Entry<String, String> ey : set) {
                String key = ey.getKey();
                String value = ey.getValue();
                sf.append("<input type=\"hidden\" name=\"" + key + "\" id=\"" + key + "\" value=\"" + value + "\"/>");
            }
        }
        sf.append("</form>");
        sf.append("</body>");
        sf.append("<script type=\"text/javascript\">");
        sf.append("document.all.sform.submit();");
        sf.append("</script>");
        return sf.toString();
    }

    @RequestMapping(value={"/paysucccess"})
    public ModelAndView paySuccess(HttpServletRequest request) {
        Pay p = this.payService.findByPayId(Long.valueOf(25L));
        AlipayConfig.partner = p.getApiKey();
        AlipayConfig.key = p.getSecretKey();
        AlipayConfig.seller_email = p.getPayAccount();
        CustomerAllInfo ca = null;
        Map map = null;
        List orderslist = null;
        ArrayList<Order> orderList = new ArrayList<Order>();
        BigDecimal price = new BigDecimal(0);
        HashMap<String, String> params = new HashMap<String, String>();
        Map requestParams = request.getParameterMap();
        for (String name : requestParams.keySet()) {
            String[] values = (String[])requestParams.get(name);
            String valueStr = "";
            for (int i = 0; i < values.length; ++i) {
                StringBuilder buf = new StringBuilder();
                if (i == values.length - 1) {
                    buf.append(values[i]);
                } else {
                    buf.append(values[i]);
                    buf.append(",");
                }
                valueStr = valueStr + buf.toString();
            }
            try {
                valueStr = new String(valueStr.getBytes(ISO_8859_1), UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.info((Object)("\u652f\u4ed8\u5931\u8d25" + e));
            }
            params.put(name, valueStr);
        }
        try {
            String outTradeNo = new String(request.getParameter(OUT_TRADE_NO).getBytes(ISO_8859_1), UTF_8);
            if (outTradeNo != null) {
                Order orderOne = this.siteOrderService.getPayOrderByCode(outTradeNo);
                if (null != orderOne) {
                    price = price.add(orderOne.getOrderPrice());
                    ca = this.customerServiceInterface.selectByPrimaryKey(orderOne.getCustomerId());
                    request.getSession().setAttribute("cust", (Object)ca);
                    request.getSession().setAttribute("customerId", (Object)ca.getCustomerId());
                    map = this.siteOrderService.queryGoodsProduceByOrderId(orderOne.getOrderId(), null);
                    orderList.add(orderOne);
                } else {
                    orderslist = this.siteOrderService.getPayOrderByOldCode(outTradeNo);
                    if (null != orderslist) {
                        for (int i = 0; i < orderslist.size(); ++i) {
                            Order childOrder = (Order)orderslist.get(i);
                            price = price.add(childOrder.getOrderPrice());
                            if (null == ca) {
                                ca = this.customerServiceInterface.selectByPrimaryKey(childOrder.getCustomerId());
                                request.getSession().setAttribute("cust", (Object)ca);
                                request.getSession().setAttribute("customerId", (Object)ca.getCustomerId());
                            }
                            if (null == map) {
                                map = this.siteOrderService.queryGoodsProduceByOrderId(childOrder.getOrderId(), null);
                            }
                            orderList.add(childOrder);
                        }
                    }
                }
                this.customerCommissionService.getCustomerCommission(orderOne.getCustomerId(), orderOne.getPayTime(), orderOne.getOrderCode());
            }
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.info((Object)("" + e));
        }
        ModelAndView mav = new ModelAndView(ORDER_PAYSUCCESS).addObject(ORDER, orderList).addObject("gs", map.get("list")).addObject(PRICE, (Object)price);
        return this.topAndBottomService.getSimpleTopAndBottom(mav);
    }

    @RequestMapping(value={"/paysucccessyb"})
    public void paySuccessyb(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Pay p = this.payService.findByPayId(Long.valueOf(25L));
        AlipayConfig.partner = p.getApiKey();
        AlipayConfig.key = p.getSecretKey();
        AlipayConfig.seller_email = p.getPayAccount();
        HashMap<String, String> params = new HashMap<String, String>();
        Map requestParams = request.getParameterMap();
        for (String name : requestParams.keySet()) {
            String[] values = (String[])requestParams.get(name);
            String valueStr = "";
            for (int i = 0; i < values.length; ++i) {
                valueStr = i == values.length - 1 ? valueStr + values[i] : valueStr + values[i] + ",";
            }
            params.put(name, valueStr);
        }
        String outTradeNo = new String(request.getParameter(OUT_TRADE_NO).getBytes(ISO_8859_1), "utf-8");
        String tradeStatus = new String(request.getParameter(TRADE_STATUS).getBytes(ISO_8859_1), "utf-8");
        boolean signVerified = false;
        try {
            signVerified = AlipaySignature.rsaCheckV1(params, (String)p.getSecretKey(), (String)"utf-8", (String)"RSA2");
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
        }
        if (signVerified) {
            this.chechOrderStatus(tradeStatus, outTradeNo);
            this.sendSucess(response, SUCCESS);
        } else {
            this.sendSucess(response, "fail");
        }
    }

    @RequestMapping(value={"/paysucccessybmulti"})
    public void paySuccessybmulti(HttpServletRequest request, HttpServletResponse response) throws IOException {
        int i;
        Pay p = this.payService.findByPayId(Long.valueOf(25L));
        AlipayConfig.partner = p.getApiKey();
        AlipayConfig.key = p.getSecretKey();
        AlipayConfig.seller_email = p.getPayAccount();
        HashMap<String, String> params = new HashMap<String, String>();
        Map requestParams = request.getParameterMap();
        for (String name : requestParams.keySet()) {
            String[] values = (String[])requestParams.get(name);
            StringBuilder valueStr = new StringBuilder();
            for (i = 0; i < values.length; ++i) {
                if (i == values.length - 1) {
                    valueStr.append(values[i]);
                    continue;
                }
                valueStr.append(values[i]);
                valueStr.append(",");
            }
            params.put(name, valueStr.toString());
        }
        String outTradeNo = new String(request.getParameter(OUT_TRADE_NO).getBytes(ISO_8859_1), "utf-8");
        String tradeStatus = new String(request.getParameter(TRADE_STATUS).getBytes(ISO_8859_1), "utf-8");
        boolean signVerified = false;
        try {
            signVerified = AlipaySignature.rsaCheckV1(params, (String)p.getSecretKey(), (String)"utf-8", (String)"RSA2");
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
        }
        if (signVerified) {
            List orderslist = this.siteOrderService.getPayOrderByOldCode(outTradeNo);
            if (null != orderslist && orderslist.size() > 0) {
                for (i = 0; i < orderslist.size(); ++i) {
                    Order childOrder = (Order)orderslist.get(i);
                    this.chechOrderStatus(tradeStatus, childOrder.getOrderCode());
                }
            }
            this.sendSucess(response, SUCCESS);
        } else {
            this.sendSucess(response, "fail");
        }
    }

    public void chechOrderStatus(String tradeStatus, String outTradeNo) {
        Order or;
        Receivables receivables = this.receivablesService.queryByOrderCode(outTradeNo);
        if ("TRADE_FINISHED".equals(tradeStatus)) {
            Order or2 = this.siteOrderService.getPayOrderByCode(outTradeNo);
            if ("0".equals(or2.getOrderStatus())) {
                this.siteOrderService.payOrder(or2.getOrderId());
                if (null != receivables) {
                    receivables.setReceivablesTime(new Date());
                    this.receivablesService.updatePayStatus(receivables);
                    this.siteOrderService.paySuccessSendSms(or2);
                }
            }
        } else if ("TRADE_SUCCESS".equals(tradeStatus) && "0".equals((or = this.siteOrderService.getPayOrderByCode(outTradeNo)).getOrderStatus())) {
            this.siteOrderService.payOrder(or.getOrderId());
            if (null != receivables) {
                receivables.setReceivablesTime(new Date());
                this.receivablesService.updatePayStatus(receivables);
                this.siteOrderService.paySuccessSendSms(or);
            }
        }
    }

    @RequestMapping(value={"qmpaysuc"})
    public ModelAndView qmpaysuc(HttpServletRequest request) {
        String orderOldCode = request.getParameter("orderno");
        ArrayList<Order> orderslist = new ArrayList<Order>();
        Order or = this.siteOrderService.getPayOrderByCode(orderOldCode);
        orderslist.add(or);
        CustomerAllInfo ca = this.customerServiceInterface.selectByPrimaryKey(or.getCustomerId());
        request.getSession().setAttribute("cust", (Object)ca);
        request.getSession().setAttribute("customerId", (Object)ca.getCustomerId());
        Map map = this.siteOrderService.queryGoodsProduceByOrderId(or.getOrderId(), null);
        ModelAndView mav = new ModelAndView(ORDER_PAYSUCCESS).addObject(ORDER, orderslist).addObject("gs", map.get("list")).addObject(PRICE, (Object)or.getOrderPrice());
        return this.topAndBottomService.getSimpleTopAndBottom(mav);
    }

    @RequestMapping(value={"qmpaysussmulti"})
    public ModelAndView qmpaysussmulti(HttpServletRequest request) {
        String orderOldCode = request.getParameter("orderno");
        List orderslist = this.siteOrderService.getPayOrderByOldCode(orderOldCode);
        BigDecimal price = new BigDecimal(0);
        for (int i = 0; i < orderslist.size(); ++i) {
            price = price.add(((Order)orderslist.get(i)).getOrderPrice());
        }
        CustomerAllInfo ca = this.customerServiceInterface.selectByPrimaryKey(((Order)orderslist.get(0)).getCustomerId());
        request.getSession().setAttribute("cust", (Object)ca);
        request.getSession().setAttribute("customerId", (Object)ca.getCustomerId());
        Map map = this.siteOrderService.queryGoodsProduceByOrderId(((Order)orderslist.get(0)).getOrderId(), null);
        ModelAndView mav = new ModelAndView(ORDER_PAYSUCCESS).addObject(ORDER, (Object)orderslist).addObject("gs", map.get("list")).addObject(PRICE, (Object)price);
        return this.topAndBottomService.getSimpleTopAndBottom(mav);
    }

    @RequestMapping(value={"/qmpaysucasy"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String qmpaysucasy(String orderNo, String sign) {
        Pay pay = this.payService.findByPayId(Long.valueOf(39L));
        String date = orderNo + pay.getApiKey();
        String s = MD5Util.md5Hex(date);
        String suc = "";
        if (s.equals(sign)) {
            Order or = this.siteOrderService.getPayOrderByCode(orderNo);
            Receivables receivables = this.receivablesService.queryByOrderCode(or.getOrderCode());
            if ("0".equals(or.getOrderStatus())) {
                this.siteOrderService.payOrder(or.getOrderId());
                if (null != receivables) {
                    receivables.setReceivablesTime(new Date());
                    this.receivablesService.updatePayStatus(receivables);
                }
            }
            suc = SUCCESS;
        }
        return suc;
    }

    @RequestMapping(value={"/qmpaysussymulti"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String qmpaysussymulti(String orderNo, String sign) {
        Pay pay = this.payService.findByPayId(Long.valueOf(39L));
        String date = orderNo + pay.getApiKey();
        String s = MD5Util.md5Hex(date);
        String suc = "";
        if (s.equals(sign)) {
            List orderslist = this.siteOrderService.getPayOrderByOldCode(orderNo);
            if (null != orderslist && orderslist.size() >= 1) {
                for (int i = 0; i < orderslist.size(); ++i) {
                    Receivables receivables = this.receivablesService.queryByOrderCode(((Order)orderslist.get(i)).getOrderCode());
                    this.siteOrderService.payOrder(((Order)orderslist.get(i)).getOrderId());
                    if (null == receivables) continue;
                    receivables.setReceivablesTime(new Date());
                    this.receivablesService.updatePayStatus(receivables);
                }
            }
            suc = SUCCESS;
        }
        return suc;
    }

    public void sendSucess(HttpServletResponse response, String msg) throws IOException {
        PrintWriter out = response.getWriter();
        out.println(msg);
        out.flush();
        out.close();
    }

    public String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static Map<String, String> signData(Map<String, ?> contentData) {
        Map.Entry<String, ?> obj2 = null;
        HashMap<String, String> submitFromData = new HashMap<String, String>();
        for (Map.Entry<String, ?> obj2 : contentData.entrySet()) {
            String value = (String)obj2.getValue();
            if (!StringUtils.isNotBlank((String)value)) continue;
            submitFromData.put(obj2.getKey(), value.trim());
            System.out.println(obj2.getKey() + "-->" + String.valueOf(value));
        }
        if (null != submitFromData) {
            SDKUtil.sign(submitFromData, (String)UTF_8);
        }
        return submitFromData;
    }

    @RequestMapping(value={"/paypalPaysucccess"})
    public void paypalPaysucccess(HttpServletRequest request, HttpServletResponse response) throws RuntimeException {
        try {
            LOGGER.info((Object)"\u6267\u884cpayPal\u652f\u4ed8\u56de\u8c03\u63a5\u53e3\u5f00\u59cb");
            HashMap<String, String> params = new HashMap<String, String>();
            Map requestParams = request.getParameterMap();
            for (String name : requestParams.keySet()) {
                String[] values = (String[])requestParams.get(name);
                StringBuilder valueStr = new StringBuilder();
                for (int i = 0; i < values.length; ++i) {
                    if (i == values.length - 1) {
                        valueStr.append(values[i]);
                        continue;
                    }
                    valueStr.append(values[i]);
                    valueStr.append(",");
                }
                params.put(name, valueStr.toString());
            }
            LOGGER.info((Object)("\u6240\u6709\u53c2\u6570[" + ((Object)params).toString() + "]"));
            String outTradeNo = new String(request.getParameter("invoice").getBytes(ISO_8859_1), "utf-8");
            String tradeStatus = new String(request.getParameter(PAYPAL_PAYMENT_STATUS).getBytes(ISO_8859_1), "utf-8");
            String payer_status = new String(request.getParameter("payer_status").getBytes(ISO_8859_1), "utf-8");
            LOGGER.info((Object)("outTradeNo==[" + outTradeNo + "];tradeStatus===[" + tradeStatus + "];payer_status==[" + payer_status + "]"));
            if (("Completed".equals(tradeStatus) || "Pending".equals(tradeStatus)) && "verified".equals(payer_status)) {
                LOGGER.info((Object)"papal\u652f\u4ed8\u6210\u529f\uff0c\u5f00\u59cb\u66f4\u65b0\u8ba2\u5355\u72b6\u6001");
                this.paypalUpdateOrderStatus(outTradeNo);
                this.sendSucess(response, SUCCESS);
                LOGGER.info((Object)"papal\u652f\u4ed8\u6210\u529f\uff0c\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u7ed3\u675f");
            } else {
                LOGGER.info((Object)"papal\u652f\u4ed8\u5931\u8d25");
                this.sendSucess(response, "fail");
            }
            LOGGER.info((Object)"payPal\u652f\u4ed8\u56de\u8c03\u63a5\u53e3\u7ed3\u675f");
        }
        catch (Exception e) {
            LOGGER.error("payPal\u652f\u4ed8\u56de\u8c03\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void paypalUpdateOrderStatus(String outTradeNo) {
        Receivables receivables = this.receivablesService.queryByOrderCode(outTradeNo);
        Order or = this.siteOrderService.getPayOrderByCode(outTradeNo);
        if ("0".equals(or.getOrderStatus())) {
            LOGGER.info((Object)"\u8be5\u8ba2\u5355\u72b6\u6001\u4e3a\u672a\u4ed8\u6b3e\uff0c\u66f4\u65b0\u72b6\u6001\u4e3a\u652f\u4ed8\u6210\u529f\u672a\u53d1\u8d27");
            this.siteOrderService.payOrder(or.getOrderId());
            if (null != receivables) {
                LOGGER.info((Object)"\u66f4\u65b0\u652f\u4ed8\u8bb0\u5f55\u7684\u72b6\u6001\u4e3a\u652f\u4ed8\u6210\u529f");
                receivables.setReceivablesTime(new Date());
                this.receivablesService.updatePayStatus(receivables);
            }
        }
    }

    public String paypalGetHtml(Order order, String goodsName, Pay p) {
        String notifyUrl;
        String account = p.getPayAccount();
        String action_url = "https://www.sandbox.paypal.com/cgi-bin/webscr";
        String data_order_id = order.getOrderCode();
        BigDecimal data_amount = order.getOrderPrice();
        String return_url = p.getBackUrl();
        String currency_code = "USD";
        String cancel_url = notifyUrl = p.getPayUrl() + "/paypalPaysucccess.htm";
        String def_html = "<br/><form style=\"text-align:center;\" name=\"fomr\" action=\"" + action_url + "\" method=\"post\">" + "<input type='hidden' name='cmd' value='_xclick'>" + "<input type='hidden' name='business' value='" + account + "'>" + "<input type='hidden' name='item_name' value='" + goodsName + "'>" + "<input type='hidden' name='amount' value='" + data_amount + "'>" + "<input type='hidden' name='currency_code' value='" + currency_code + "'>" + "<input type='hidden' name='return' value='" + return_url + "'>" + "<input type='hidden' name='invoice' value='" + data_order_id + "'>" + "<input type='hidden' name='charset' value='utf-8'>" + "<input type='hidden' name='no_shipping' value='1'>" + "<input type='hidden' name='no_note' value=''>" + "<input type='hidden' name='notify_url' value='" + notifyUrl + "'>" + "<input type='hidden' name='rm' value='2'>" + "<input type='hidden' name='cancel_return' value='" + cancel_url + "'>" + "<input type='submit' style='display:none;' value='Check out'>" + "</form><br /><script type='text/javascript'>document.fomr.submit();</script>";
        return def_html;
    }
}

