/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.giftshop.controller;

import com.qianjiang.customer.service.CustomerPointServiceMapper;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.gift.bean.Gift;
import com.qianjiang.gift.bean.GiftOrder;
import com.qianjiang.gift.bean.GiftSearchVo;
import com.qianjiang.gift.service.GiftOrderService;
import com.qianjiang.gift.service.GiftShopSiteService;
import com.qianjiang.gift.vo.GiftOrderVo;
import com.qianjiang.index.service.TopAndBottomService;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class GiftShopSiteController {
    private static final MyLogger LOGGER = new MyLogger(GiftShopSiteController.class);
    private OrderService orderService;
    private static final String CUSTOMERID = "customerId";
    private static final String GIFTORDER_HTML = "/giftorder.html";
    @Resource(name="TopAndBottomService")
    private TopAndBottomService topAndBottomService;
    private GiftShopSiteService giftShopSiteService;
    private CustomerServiceMapper customerServiceMapper;
    private PrintWriter pw;
    private GiftOrderService giftOrderService;
    @Resource(name="customerPointServiceMapper")
    private CustomerPointServiceMapper customerPointServiceMapper;

    @RequestMapping(value={"/giftshop"})
    public ModelAndView giftShop(HttpServletRequest request, PageBean pb, GiftSearchVo gift) {
        ModelAndView mav = new ModelAndView("giftshop/gift_list");
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        if (customerId != null) {
            resultMap.put("cusId", customerId);
            CustomerAllInfo customerAllInfo = this.customerServiceMapper.selectByPrimaryKey(customerId);
            customerAllInfo.setInfoPointSum(Integer.valueOf(customerAllInfo.getInfoPointSum() - this.customerPointServiceMapper.getCustomerReducePoint(customerId + "")));
            resultMap.put("cusInfo", customerAllInfo);
        }
        resultMap.put("catelist", this.giftShopSiteService.searchGiftCate());
        resultMap.put("pb", this.giftShopSiteService.searchGiftList(gift, pb));
        resultMap.put("pCate", this.giftShopSiteService.selectByParentId(gift.getGiftParentId()));
        resultMap.put("sCate", this.giftShopSiteService.selectByCateId(gift.getGiftCateId()));
        resultMap.put("gift", gift != null ? gift : null);
        resultMap.put("orderlist", this.giftOrderService.orderList());
        LOGGER.info((Object)"\u83b7\u53d6\u79ef\u5206\u5546\u57ce\u5217\u8868");
        return this.topAndBottomService.getTopAndBottom(mav).addAllObjects(resultMap);
    }

    @RequestMapping(value={"/giftdetail"})
    public ModelAndView giftDetail(Long giftId, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView mav = new ModelAndView("giftshop/gift_detail");
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        if (customerId != null) {
            resultMap.put("cusId", customerId);
            resultMap.put("cusInfo", this.customerServiceMapper.selectByPrimaryKey(customerId));
        }
        Gift gift = this.giftShopSiteService.selectByGiftId(giftId);
        resultMap.put("pCate", this.giftShopSiteService.selectByParentId(gift.getGiftParentId()));
        resultMap.put("sCate", this.giftShopSiteService.selectByCateId(gift.getGiftCateId()));
        resultMap.put("catelist", this.giftShopSiteService.searchGiftCate());
        resultMap.put("gift", gift);
        resultMap.put("orderlist", this.giftOrderService.orderList());
        LOGGER.info((Object)("\u8d60\u54c1\u8be6\u60c5\u9875,\u8d60\u54c1ID\u4e3a\uff1a" + giftId));
        return this.topAndBottomService.getTopAndBottom(mav).addAllObjects(resultMap);
    }

    @RequestMapping(value={"/giftorder"})
    public ModelAndView giftOrder(HttpServletRequest request, PageBean pb, String date, String type) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        HashMap<String, String> resultMap = new HashMap<String, String>();
        ModelAndView mav = new ModelAndView("customer/newgiftorder");
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        if (customerId == null) {
            mav = new ModelAndView("/login/redirect").addObject("url", (Object)"/customer/giftorder.html");
        } else {
            paramMap.put(CUSTOMERID, (Long)request.getSession().getAttribute(CUSTOMERID));
            paramMap.put("date", date);
            paramMap.put("type", type);
            pb.setUrl("customer/newgiftorder");
            resultMap.put("type", type);
            resultMap.put("date", date);
            resultMap.put("pb", (String)this.giftOrderService.queryGiftOrder(pb, paramMap));
        }
        return this.topAndBottomService.getTopAndBottom(mav).addAllObjects(resultMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"subgiftorder"})
    public ModelAndView subGiftOrder(GiftOrder giftOrder, HttpServletRequest request, HttpServletResponse response, Long giftStock) {
        response.setContentType("text/html;charset=UTF-8");
        try {
            this.pw = response.getWriter();
            Long customerId = (long)((Long)request.getSession().getAttribute(CUSTOMERID));
            if (giftOrder != null && giftOrder.getCustomerId().equals(customerId) && giftOrder.getOrderIntegral() >= 0L && giftOrder.getOrderNum() > 0) {
                this.pw.print(this.giftOrderService.subOrder(giftOrder, giftStock));
                LOGGER.info((Object)"\u63d0\u4ea4\u8d60\u54c1\u8ba2\u5355\u6210\u529f");
            } else {
                this.pw.print(-1);
            }
        }
        catch (IOException e) {
            LOGGER.error("\u5151\u6362\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (this.pw != null) {
                this.pw.close();
            }
        }
        return null;
    }

    @RequestMapping(value={"/comfirmofgiftorder"})
    public ModelAndView comfirmogift(HttpServletRequest request, Long giftOrderId, String fromUrl) {
        ModelAndView mav = null;
        Object cust = request.getSession().getAttribute(CUSTOMERID);
        Long customerId = (Long)cust;
        if (customerId == null) {
            mav = new ModelAndView("/login/redirect").addObject("url", (Object)"/customer/giftorder.html");
        } else {
            this.giftOrderService.updateOrderVice(giftOrderId);
            if ("index".equals(fromUrl)) {
                mav = new ModelAndView((View)new RedirectView(request.getContextPath() + "/customer" + "/index.html"));
            } else if ("giftorder".equals(fromUrl)) {
                mav = new ModelAndView((View)new RedirectView(request.getContextPath() + "/customer" + GIFTORDER_HTML));
            }
        }
        return mav;
    }

    @RequestMapping(value={"/giftorderdetail"})
    public ModelAndView giftOrderDetails(Long giftOrderId, HttpServletRequest request) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        ModelAndView mav = null;
        mav = new ModelAndView("customer/giftorderdetail");
        GiftOrderVo order = this.giftOrderService.orderDetail(giftOrderId);
        if (order.getCustomerId().equals(customerId)) {
            resultMap.put("order", order);
            if (order.getTemp2() != null && !"".equals(order.getTemp2()) && order.getTemp3() != null && !"".equals(order.getTemp3())) {
                resultMap.put("relations", this.orderService.queryExpressInfoUrl(Integer.parseInt(order.getTemp2()), order.getTemp3()));
            }
            return this.topAndBottomService.getTopAndBottom(mav).addAllObjects(resultMap);
        }
        mav = new ModelAndView("/login/redirect").addObject("url", (Object)"/customer/myorder.html");
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"/jumpgift"})
    public ModelAndView jumpgift(Long cateId) {
        return new ModelAndView((View)new RedirectView("../giftshop/" + this.giftShopSiteService.selectSonCateId(cateId) + ".html"));
    }

    public GiftShopSiteService getGiftShopSiteService() {
        return this.giftShopSiteService;
    }

    @Resource(name="GiftShopSiteService")
    public void setGiftShopSiteService(GiftShopSiteService giftShopSiteService) {
        this.giftShopSiteService = giftShopSiteService;
    }

    @Resource(name="customerServiceMapper")
    public void setCustomerServiceMapper(CustomerServiceMapper customerServiceMapper) {
        this.customerServiceMapper = customerServiceMapper;
    }

    @Resource(name="GiftOrderWebService")
    public void setGiftOrderService(GiftOrderService giftOrderService) {
        this.giftOrderService = giftOrderService;
    }

    @Resource(name="OrderService")
    public void setOrderService(OrderService orderService) {
        this.orderService = orderService;
    }
}

