/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.returns.controller;

import com.alibaba.fastjson.JSON;
import com.qianjiang.comment.bean.GoodsProductReleSpecVo;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.goods.bean.GoodsProduct;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.goods.vo.GoodsProductDetailViewVo;
import com.qianjiang.index.service.TopAndBottomService;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.order.bean.BackOrder;
import com.qianjiang.order.bean.BackOrderGeneral;
import com.qianjiang.order.bean.Order;
import com.qianjiang.order.bean.OrderGoods;
import com.qianjiang.order.service.BackOrderLogService;
import com.qianjiang.order.service.BackOrderService;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.order.service.ReturnGoodsService;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.other.bean.GoodsBean;
import com.qianjiang.other.bean.OrderInfoBean;
import com.qianjiang.site.order.service.SiteOrderService;
import com.qianjiang.system.bean.SystemsSet;
import com.qianjiang.system.service.IsBackOrderService;
import com.qianjiang.util.MyLogger;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ReturnGoodsController {
    private static final MyLogger LOGGER = new MyLogger(ReturnGoodsController.class);
    private static final String LOGGERINFO1 = "\u3011-->\u7528\u6237\u540d\uff1a";
    private static final String ORDER = "order";
    private static final String BACKORDER = "backorder";
    private ReturnGoodsService goodsService;
    private TopAndBottomService topAndBottomService;
    private SiteOrderService siteOrderService;
    private BackOrderService backOrderService;
    private OrderService orderService;
    private BackOrderLogService backOrderLogService;
    private IsBackOrderService isbackOrderService;
    private CustomerServiceMapper customerServiceInterface;
    @Resource(name="GoodsProductService")
    private GoodsProductService goodsProductService;

    @RequestMapping(value={"/saveBackOrderGeneral"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int saveBackOrderGeneral(HttpServletRequest request, String wlname, String wlno, String orderNo) {
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        CustomerAllInfo customerAllInfo = this.customerServiceInterface.selectByPrimaryKey(customerId);
        if (null != orderNo) {
            LOGGER.info((Object)"\u65b0\u589e\u4e00\u6761\u9000\u8d27\u7684\u7269\u6d41\u4fe1\u606f");
            OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)customerAllInfo.getCustomerUsername(), (String)"\u65b0\u589e\u9000\u5355\u7269\u6d41\u4fe1\u606f", (String)("\u65b0\u589e\u9000\u5355\u7269\u6d41\u4fe1\u606f-->\u9700\u8981\u6267\u884c\u9000\u5355\u64cd\u4f5c\u7684\u8ba2\u5355\u53f7\u3010" + orderNo + "\u3011,\u7269\u6d41\u4fe1\u606f\uff1a\u540d\u79f0\u3010" + wlname + "\u3011,\u7269\u6d41\u5355\u53f7\u3010" + wlno + LOGGERINFO1 + customerAllInfo.getCustomerUsername()));
        }
        return this.goodsService.saveBackOrderGeneral(wlname, wlno, orderNo);
    }

    @RequestMapping(value={"/saveReturnGoodsTake"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int saveReturnGoodsTake(HttpServletRequest request, HttpServletResponse response, Long orderId, String returnyuanyin, String tuikuanyuanyin) throws Exception {
        String returnyuanyinNew = returnyuanyin;
        Boolean bool = true;
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        String tuikuanyuanyin1 = tuikuanyuanyin;
        CustomerAllInfo customerAllInfo = this.customerServiceInterface.selectByPrimaryKey(customerId);
        if (null != tuikuanyuanyin1) {
            bool = this.goodsService.saveReturnGoodsDetail(orderId, tuikuanyuanyin1 = URLDecoder.decode(tuikuanyuanyin1, "utf-8"), Long.valueOf(0L));
            if (bool.booleanValue()) {
                OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)customerAllInfo.getCustomerUsername(), (String)"\u65b0\u589e\u9000\u6b3e\u8bb0\u5f55", (String)("\u65b0\u589e\u9000\u6b3e\u8bb0\u5f55-->\u9000\u6b3e\u539f\u56e0\u3010" + tuikuanyuanyin + LOGGERINFO1 + customerAllInfo.getCustomerUsername()));
            }
        } else {
            bool = this.goodsService.saveReturnGoodsDetail(orderId, returnyuanyinNew = URLDecoder.decode(returnyuanyinNew, "utf-8"), Long.valueOf(1L));
            if (bool.booleanValue()) {
                OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)customerAllInfo.getCustomerUsername(), (String)"\u65b0\u589e\u9000\u5355\u8bb0\u5f55", (String)("\u65b0\u589e\u9000\u5355\u8bb0\u5f55-->\u9000\u5355\u539f\u56e0\u3010" + returnyuanyinNew + LOGGERINFO1 + customerAllInfo.getCustomerUsername()));
            }
        }
        if (bool.booleanValue()) {
            return 1;
        }
        return 0;
    }

    @RequestMapping(value={"customer/applybackmoneyprice"})
    public ModelAndView applybackmoneyprice(HttpServletRequest request, Long orderId) {
        ModelAndView mav = null;
        Order order = this.siteOrderService.getPayOrder(orderId);
        mav = new ModelAndView("customer/applybackmoneyprice");
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        OrderInfoBean backorder = this.customerServiceInterface.queryOrderByCustIdAndOrderId(orderId, customerId);
        String str = "";
        for (int i = 0; i < backorder.getGoods().size(); ++i) {
            Long goodsids = ((GoodsBean)backorder.getGoods().get(i)).getGoodsId();
            Long goodsNum = ((GoodsBean)backorder.getGoods().get(i)).getGoodsNum();
            str = str + goodsids + "," + goodsNum + "-";
        }
        SystemsSet systemsSet = this.isbackOrderService.getIsBackOrder();
        return this.topAndBottomService.getTopAndBottom(mav).addObject(ORDER, (Object)order).addObject(BACKORDER, (Object)backorder).addObject("backPriceRemark", (Object)systemsSet.getBackPriceRemark()).addObject("backGoodsIdAndSum", (Object)str);
    }

    @RequestMapping(value={"customer/applybackmoney"})
    public ModelAndView applyBackMoney(HttpServletRequest request, Long orderId) {
        int i;
        ModelAndView mav = null;
        Order order = this.siteOrderService.getPayOrder(orderId);
        mav = new ModelAndView("customer/applybackmoney");
        BigDecimal price = new BigDecimal(0);
        String staCheck = "0";
        String isUseCoupon = "0";
        if (!"0.00".equals(order.getOrderPrePrice().toString()) || order.getOrderIntegral() != null && order.getOrderIntegral() > 0L) {
            price = order.getOrderPrice().subtract(order.getExpressPrice());
            int calcPrice = price.intValue();
            if (calcPrice < 0) {
                price = new BigDecimal(0.01);
            }
            staCheck = "1";
        }
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        OrderInfoBean backorder = this.customerServiceInterface.queryOrderByCustIdAndOrderId(orderId, customerId);
        BigDecimal total = BigDecimal.ZERO;
        for (i = 0; i < backorder.getGoods().size(); ++i) {
            total = ((GoodsBean)backorder.getGoods().get(i)).getGoodsCouponPrice() == null ? total.add(((GoodsBean)backorder.getGoods().get(i)).getGoodsInfoSumPrice()) : total.add(((GoodsBean)backorder.getGoods().get(i)).getGoodsInfoSumPrice()).subtract(((GoodsBean)backorder.getGoods().get(i)).getGoodsCouponPrice());
        }
        for (i = 0; i < backorder.getGoods().size(); ++i) {
            GoodsProductDetailViewVo goodsProductDetailViewVo = this.goodsProductService.queryViewVoByProductId(((GoodsBean)backorder.getGoods().get(i)).getGoodsId());
            ((GoodsBean)backorder.getGoods().get(i)).setSpecVo(JSON.parseArray((String)JSON.toJSONString((Object)goodsProductDetailViewVo.getSpecVo()), GoodsProductReleSpecVo.class));
            OrderGoods orderGoods = this.orderService.queryOrderGoodsByIds(backorder.getOrderId(), goodsProductDetailViewVo.getGoodsInfoId(), ((GoodsBean)backorder.getGoods().get(i)).getGoodsCouponPrice());
            ((GoodsBean)backorder.getGoods().get(i)).setReturnMoney(orderGoods.getGoodsBackPrice());
            ((GoodsBean)backorder.getGoods().get(i)).setOrderGoodsId(orderGoods.getOrderGoodsId());
        }
        Map map = this.isbackOrderService.queryBackInfoRemark();
        String backInfoRemark = (String)map.get("queryBackInfoRemark");
        return this.topAndBottomService.getTopAndBottom(mav).addObject(ORDER, (Object)order).addObject(BACKORDER, (Object)backorder).addObject("backInfoRemark", (Object)backInfoRemark).addObject("price", (Object)price).addObject("staCheck", (Object)staCheck).addObject("cusId", (Object)customerId).addObject("isUseCoupon", (Object)isUseCoupon);
    }

    @RequestMapping(value={"customer/backdetailprice"})
    public ModelAndView backDetailInfoprice(HttpServletRequest request, Long orderId) {
        ModelAndView mav = null;
        mav = new ModelAndView("customer/backdetailprice");
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        if (customerId == null) {
            return new ModelAndView((View)new RedirectView("/login.html"));
        }
        Order order = this.siteOrderService.queryOrderDetailByIds(orderId, customerId);
        if (order == null) {
            return new ModelAndView((View)new RedirectView("/login.html"));
        }
        Order backorder = this.orderService.getPayOrder(orderId);
        BackOrder bOrder = this.backOrderService.queryBackOrderByOrderCodeAndIsback(backorder.getOrderCode(), "2");
        ArrayList<String> imglist = null;
        if (bOrder.getUploadDocuments() != null && !"".equals(bOrder.getUploadDocuments())) {
            imglist = new ArrayList<String>();
            String[] imgs = bOrder.getUploadDocuments().split(",");
            for (int i = 0; i < imgs.length; ++i) {
                imglist.add(imgs[i]);
            }
        }
        List backOrderLogs = this.backOrderLogService.queryByBackId(bOrder.getBackOrderId());
        return this.topAndBottomService.getTopAndBottom(mav).addObject(ORDER, (Object)order).addObject(BACKORDER, (Object)backorder).addObject("bOrder", (Object)bOrder).addObject("imglist", imglist).addObject("backOrderLogs", (Object)backOrderLogs);
    }

    @RequestMapping(value={"customer/backdetail"})
    public ModelAndView backDetailInfo(HttpServletRequest request, Long orderId) {
        ModelAndView mav = null;
        mav = new ModelAndView("customer/backdetail");
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        if (customerId == null) {
            return new ModelAndView((View)new RedirectView("/login.html"));
        }
        Order order = this.siteOrderService.queryOrderDetailByIds(orderId, customerId);
        if (order == null) {
            return new ModelAndView((View)new RedirectView("/login.html"));
        }
        Order backorder = this.orderService.getPayOrder(orderId);
        BackOrder bOrder = this.backOrderService.queryBackOrderByOrderCodeAndIsback(backorder.getOrderCode(), "1");
        BackOrderGeneral general = this.backOrderService.queryBackOrderGeneral(bOrder.getBackOrderId());
        ArrayList<String> imglist = new ArrayList<String>();
        if (bOrder.getUploadDocuments() != null) {
            String[] imgs = bOrder.getUploadDocuments().split(",");
            for (int i = 0; i < imgs.length; ++i) {
                if (!StringUtils.isNotEmpty((String)imgs[i])) continue;
                imglist.add(imgs[i]);
            }
        }
        List backOrderLogs = this.backOrderLogService.queryByBackId(bOrder.getBackOrderId());
        List goodslist = this.orderService.queryOrderGoodsByOrderIdAndBackCode(orderId, bOrder.getBackOrderCode());
        for (int j = 0; j < goodslist.size(); ++j) {
            GoodsProduct goodsProduct = this.goodsProductService.queryProductByGoodsId(((OrderGoods)goodslist.get(j)).getGoodsInfoId());
            ((OrderGoods)goodslist.get(j)).setGoodsImg(goodsProduct.getGoodsInfoImgId());
            ((OrderGoods)goodslist.get(j)).setGoodsName(goodsProduct.getGoodsInfoName());
            ((OrderGoods)goodslist.get(j)).setGoodsCode(goodsProduct.getGoodsInfoItemNo());
        }
        this.removeOrderList(backorder.getOrderGoodsList(), bOrder.getBackGoodsIdAndSum());
        return this.topAndBottomService.getTopAndBottom(mav).addObject(ORDER, (Object)order).addObject(BACKORDER, (Object)backorder).addObject("bOrder", (Object)bOrder).addObject("goodslist", (Object)goodslist).addObject("imglist", imglist).addObject("backOrderLogs", (Object)backOrderLogs).addObject("general", (Object)general);
    }

    private void removeOrderList(List<OrderGoods> orderGoodses, String acutalId) {
        List<Long> ids = this.getActalIds(acutalId);
        List<Long> orderGoodsIds = this.getOrderGoodsIds(acutalId);
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ArrayList<OrderGoods> removeOrderGoods = new ArrayList<OrderGoods>();
        for (OrderGoods orderGoods : orderGoodses) {
            if (orderGoodsIds.contains(orderGoods.getOrderGoodsId())) continue;
            removeOrderGoods.add(orderGoods);
        }
        orderGoodses.removeAll(removeOrderGoods);
    }

    private List<Long> getActalIds(String acutalId) {
        ArrayList<Long> ids = new ArrayList<Long>();
        try {
            String[] idAndSums;
            for (String idAndSum : idAndSums = acutalId.split("-")) {
                if (!StringUtils.isNotEmpty((String)idAndSum)) continue;
                String[] id = idAndSum.split(",");
                ids.add(Long.parseLong(id[0]));
            }
            return ids;
        }
        catch (Exception e) {
            LOGGER.error("GetActalIds fail...");
            return ids;
        }
    }

    private List<Long> getOrderGoodsIds(String acutalId) {
        ArrayList<Long> ids = new ArrayList<Long>();
        try {
            String[] idAndSums;
            for (String idAndSum : idAndSums = acutalId.split("-")) {
                if (!StringUtils.isNotEmpty((String)idAndSum)) continue;
                String[] id = idAndSum.split(",");
                ids.add(Long.parseLong(id[2]));
            }
            return ids;
        }
        catch (Exception e) {
            LOGGER.error("getOrderGoodsIds fail...");
            return ids;
        }
    }

    public ReturnGoodsService getGoodsService() {
        return this.goodsService;
    }

    @Resource(name="ReturnGoodsService")
    public void setGoodsService(ReturnGoodsService goodsService) {
        this.goodsService = goodsService;
    }

    public CustomerServiceMapper getCustomerServiceInterface() {
        return this.customerServiceInterface;
    }

    @Resource(name="customerServiceMapper")
    public void setCustomerServiceInterface(CustomerServiceMapper customerServiceInterface) {
        this.customerServiceInterface = customerServiceInterface;
    }

    public OrderService getOrderService() {
        return this.orderService;
    }

    @Resource(name="OrderService")
    public void setOrderService(OrderService orderService) {
        this.orderService = orderService;
    }

    public BackOrderService getBackOrderService() {
        return this.backOrderService;
    }

    @Resource(name="BackOrderService")
    public void setBackOrderService(BackOrderService backOrderService) {
        this.backOrderService = backOrderService;
    }

    public SiteOrderService getSiteOrderService() {
        return this.siteOrderService;
    }

    public IsBackOrderService getIsbackOrderService() {
        return this.isbackOrderService;
    }

    @Resource(name="IsBackOrderService")
    public void setIsbackOrderService(IsBackOrderService isbackOrderService) {
        this.isbackOrderService = isbackOrderService;
    }

    public BackOrderLogService getBackOrderLogService() {
        return this.backOrderLogService;
    }

    @Resource(name="BackOrderLogService")
    public void setBackOrderLogService(BackOrderLogService backOrderLogService) {
        this.backOrderLogService = backOrderLogService;
    }

    @Resource(name="SiteOrderService")
    public void setSiteOrderService(SiteOrderService siteOrderService) {
        this.siteOrderService = siteOrderService;
    }

    public TopAndBottomService getTopAndBottomService() {
        return this.topAndBottomService;
    }

    @Resource(name="TopAndBottomService")
    public void setTopAndBottomService(TopAndBottomService topAndBottomService) {
        this.topAndBottomService = topAndBottomService;
    }
}

