/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.thirdseller.controller;

import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.index.service.TopAndBottomService;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.site.thirdseller.bean.CollectionSeller;
import com.qianjiang.site.thirdseller.bean.ThirdStoreInfo;
import com.qianjiang.site.thirdseller.service.CollectionSellerService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class CollectionSellerController {
    private static final MyLogger LOGGER = new MyLogger(CollectionSellerController.class);
    private static final String CUSTOMERID = "customerId";
    @Resource(name="CollectionSellerService")
    private CollectionSellerService collectionSellerService;
    @Resource(name="TopAndBottomService")
    private TopAndBottomService topAndBottomService;
    private CustomerServiceMapper customerServiceInterface;

    @Resource(name="customerServiceMapper")
    public void setCustomerServiceInterface(CustomerServiceMapper customerServiceInterface) {
        this.customerServiceInterface = customerServiceInterface;
    }

    @RequestMapping(value={"/addcollectionseller"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int addCollectionSeller(HttpServletRequest request, CollectionSeller collectionSeller) {
        int result = 0;
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        try {
            CustomerAllInfo customerAllInfo = this.customerServiceInterface.selectByPrimaryKey(customerId);
            ThirdStoreInfo thirdStoreInfo = this.collectionSellerService.selectStoreByCustomerId(collectionSeller.getCollectionThirdId());
            if (customerId != null) {
                collectionSeller.setCollectionCustomerId(customerId);
                result = this.collectionSellerService.addCollectionSeller(collectionSeller);
                if (null != thirdStoreInfo.getStoreName()) {
                    OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)customerAllInfo.getCustomerUsername(), (String)"\u6536\u85cf\u5e97\u94fa\u6210\u529f", (String)("\u6536\u85cf\u5e97\u94fa\u6210\u529f-->\u5e97\u94fa\u540d\u79f0\u3010" + thirdStoreInfo.getStoreName() + "\u3011-->\u7528\u6237\u540d\uff1a" + customerAllInfo.getCustomerUsername()));
                }
            } else {
                result = 3;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6536\u85cf\u5e97\u94fa\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"sellermyfollw"})
    public ModelAndView sellerMyFollw(HttpServletRequest request, PageBean pageBean) {
        ModelAndView mav = new ModelAndView("customer/newsellerfollow");
        pageBean.setUrl("customer/sellermyfollw");
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        mav.addObject("pb", (Object)this.collectionSellerService.sellerMyFollw(customerId, pageBean));
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"customer/delmyfollw"})
    public ModelAndView delMyFollw(HttpServletRequest request, Long collectionSellerId) {
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        this.collectionSellerService.delMyFollw(customerId, collectionSellerId);
        return new ModelAndView((View)new RedirectView("sellermyfollw.html"));
    }

    public CustomerServiceMapper getCustomerServiceInterface() {
        return this.customerServiceInterface;
    }
}

