/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.threepart.controller;

import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.service.CustomerService;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.other.util.IPAddress;
import com.qianjiang.site.threepart.util.QQWeiBoMessage;
import com.qianjiang.site.threepart.util.StringUtil;
import com.qianjiang.system.bean.Auth;
import com.qianjiang.system.service.AuthService;
import com.qianjiang.threepart.bean.ThreePart;
import com.qianjiang.threepart.service.ThreePartService;
import com.qianjiang.util.MyLogger;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class AfterLoginQQWeiboController {
    private static final MyLogger LOGGER = new MyLogger(AfterLoginQQWeiboController.class);
    private AuthService authService;
    private CustomerServiceMapper customerServiceMapper;
    private ThreePartService threePartService;
    @Resource(name="customerService")
    private CustomerService customerService;

    @RequestMapping(value={"afterloginqqweibo"})
    public ModelAndView doGet(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("text/html; charset=utf-8");
        Auth auth = this.authService.findAuthByAuthType("3");
        if (auth != null) {
            String appID = auth.getAuthClientId();
            String appKEY = auth.getAuthClientSecret();
            String redirectURI = auth.getAuthRedirectUri();
            String code = request.getParameter("code");
            String url = "https://open.t.qq.com/cgi-bin/oauth2/access_token?client_id=" + appID + "&client_secret=" + appKEY + "&redirect_uri=" + redirectURI + "&grant_type=authorization_code&code=" + code;
            GetMethod getMethod = new GetMethod(url);
            HttpClient client = new HttpClient();
            Map<String, String> pmap = null;
            try {
                client.executeMethod((HttpMethod)getMethod);
                String userInfo = getMethod.getResponseBodyAsString();
                pmap = StringUtil.formatString(userInfo);
            }
            catch (Exception e) {
                LOGGER.error("QQ\u5fae\u535a\u9519\u8bef" + e);
            }
            if (pmap == null) {
                return new ModelAndView((View)new RedirectView("404.html"));
            }
            String openid = request.getParameter("openid");
            String accessToken = pmap.get("access_token");
            ThreePart tp = this.threePartService.selectThreePart(openid);
            if (tp != null) {
                CustomerAllInfo cus = this.customerServiceMapper.queryCustomerById(tp.getThreePartMemberId());
                request.getSession().setAttribute("cust", (Object)cus);
                request.getSession().setAttribute("customerId", (Object)cus.getCustomerId());
            } else {
                Map<String, String> userData = null;
                try {
                    userData = QQWeiBoMessage.getQQWeiBoMessage(appID, accessToken, openid);
                }
                catch (IOException e1) {
                    LOGGER.error("QQ\u5fae\u535a\u9519\u8bef" + e1);
                }
                CustomerAllInfo allInfo = new CustomerAllInfo();
                allInfo.setLoginIp(IPAddress.getIpAddr((HttpServletRequest)request));
                allInfo.setPointLevelId(Long.valueOf(2L));
                allInfo.setCustomerUsername(userData.get("nickname"));
                allInfo.setCustomerPassword("");
                allInfo.setCustomerNickname(userData.get("nickname"));
                allInfo.setInfoGender("1".equals(userData.get("gender")) ? "1" : "2");
                allInfo.setCustomerImg(userData.get("headimg"));
                int f = this.customerServiceMapper.addCustomer(allInfo);
                if (f == 1) {
                    HashMap<String, String> paramMap = new HashMap<String, String>();
                    paramMap.put("username", userData.get("nickname"));
                    paramMap.put("password", "");
                    Customer customer = this.customerService.selectCustomerByNamePwd(paramMap);
                    tp = new ThreePart();
                    tp.setThreePartUid(openid);
                    tp.setThreePartToken(accessToken);
                    tp.setThreePartMemberId(customer.getCustomerId());
                    this.threePartService.insertThreePart(tp);
                }
                CustomerAllInfo cus = this.customerServiceMapper.queryCustomerById(tp.getThreePartMemberId());
                request.getSession().setAttribute("cust", (Object)cus);
                request.getSession().setAttribute("customerId", (Object)cus.getCustomerId());
            }
        }
        return new ModelAndView((View)new RedirectView("index.html"));
    }

    public AuthService getAuthService() {
        return this.authService;
    }

    @Resource(name="authService")
    public void setAuthService(AuthService authService) {
        this.authService = authService;
    }

    public CustomerServiceMapper getCustomerServiceMapper() {
        return this.customerServiceMapper;
    }

    @Resource(name="customerServiceMapper")
    public void setCustomerServiceMapper(CustomerServiceMapper customerServiceMapper) {
        this.customerServiceMapper = customerServiceMapper;
    }

    public ThreePartService getThreePartService() {
        return this.threePartService;
    }

    @Resource(name="ThreePartService")
    public void setThreePartService(ThreePartService threePartService) {
        this.threePartService = threePartService;
    }
}

