/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.customer.controller;

import com.qianjiang.comment.bean.Comment;
import com.qianjiang.comment.service.CommentServiceMapper;
import com.qianjiang.comment.service.ShareService;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.goods.service.GoodsReleTagService;
import com.qianjiang.goods.vo.GoodsReleTagVo;
import com.qianjiang.index.service.TopAndBottomService;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.other.util.IPAddress;
import com.qianjiang.other.util.LoginUtil;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.temp.service.MegawizardService;
import com.qianjiang.temp.service.TempService;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class GoodCommentController {
    private CommentServiceMapper commentServiceMapper;
    private GoodsReleTagService goodsReleTagService;
    private ShareService shareServiceMapper;
    private CustomerServiceMapper customerServiceMapper;
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;
    private TopAndBottomService topAndBottomService;
    public static final int NUM24 = 24;
    private MegawizardService megawizardSerivce;
    private TempService tempService;
    private CustomerServiceMapper customerServiceInterface;

    @RequestMapping(value={"/tocomment"})
    public ModelAndView toShare(HttpServletRequest request, Long orderId, PageBean pb) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ModelAndView mav = null;
        pb.setPageSize(5);
        pb.setUrl("comment-" + orderId);
        if (LoginUtil.checkLoginStatus((HttpServletRequest)request)) {
            resultMap.put("pb", this.commentServiceMapper.queryCommentByCust(orderId, (Long)request.getSession().getAttribute("customerId"), pb));
            resultMap.put("explain", this.megawizardSerivce.selectByType(1, Long.valueOf(Long.parseLong(this.tempService.getCurrTemp().getTempId() + ""))));
            mav = new ModelAndView("customer/newcomment");
            mav.addAllObjects(resultMap);
            return this.topAndBottomService.getTopAndBottom(mav);
        }
        return new ModelAndView((View)new RedirectView("login.html?customer/myorder.html"));
    }

    @RequestMapping(value={"/loadgoodstag"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<GoodsReleTagVo> loadGoodsTag(Long goodsId) {
        return this.goodsReleTagService.queryreleListByProductId(goodsId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/tradecomment"})
    public ModelAndView toGoodsComment(HttpServletRequest request, Long goodsId, Long orderId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            resultMap.put("tagList", this.goodsReleTagService.queryreleListByProductId(goodsId));
            resultMap.put("good", this.commentServiceMapper.selectOrderGoodsToComment(goodsId, orderId, (Long)request.getSession().getAttribute("customerId")));
            resultMap.put("orderId", orderId);
            ModelAndView modelAndView = this.topAndBottomService.getTopAndBottom(new ModelAndView("customer/commgood").addAllObjects(resultMap));
            return modelAndView;
        }
        finally {
            resultMap = null;
        }
    }

    @RequestMapping(value={"/addgoodscomment"})
    public ModelAndView addGoodsComment(HttpServletRequest request, @Valid Comment comment, Long orderId) {
        if (LoginUtil.checkLoginStatus((HttpServletRequest)request)) {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            CustomerAllInfo customerAllInfo = this.customerServiceInterface.selectByPrimaryKey(customerId);
            if (null != comment.getGoodsName()) {
                OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)customerAllInfo.getCustomerUsername(), (String)"\u6dfb\u52a0\u5546\u54c1\u8bc4\u8bba", (String)("\u6dfb\u52a0\u8bc4\u8bba\u7684\u5546\u54c1\u4e3a\u3010" + comment.getGoodsName() + "\u3011"));
            }
            this.commentServiceMapper.addGoodsComment(IPAddress.getIpAddr((HttpServletRequest)request), comment, orderId);
            return this.topAndBottomService.getTopAndBottom(new ModelAndView((View)new RedirectView(request.getContextPath() + "/comment-" + orderId + ".html")));
        }
        return new ModelAndView((View)new RedirectView(request.getContextPath() + "/login.html?url=customer/myorder.html"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/viewcomment"})
    public ModelAndView viewComment(HttpServletRequest request, Long goodsId, Long orderId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            CustomerAllInfo customerAllInfo = this.customerServiceInterface.selectByPrimaryKey(customerId);
            Comment comment = this.commentServiceMapper.selectGoodsComment(goodsId, orderId, customerId);
            if (null != comment.getGoodsName()) {
                OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)customerAllInfo.getCustomerUsername(), (String)"\u6dfb\u52a0\u5546\u54c1\u8bc4\u8bba", (String)("\u6dfb\u52a0\u8bc4\u8bba\u7684\u5546\u54c1\u4e3a\u3010" + comment.getGoodsName() + "\u3011"));
            }
            if (LoginUtil.checkLoginStatus((HttpServletRequest)request)) {
                resultMap.put("comment", comment);
                resultMap.put("good", this.commentServiceMapper.selectOrderGoods(goodsId, orderId, (Long)request.getSession().getAttribute("customerId")));
                ModelAndView modelAndView = this.topAndBottomService.getTopAndBottom(new ModelAndView("customer/showcommgood").addAllObjects(resultMap));
                return modelAndView;
            }
            ModelAndView modelAndView = new ModelAndView((View)new RedirectView(request.getContextPath() + "/login.html?url=customer/myorder.html"));
            return modelAndView;
        }
        finally {
            resultMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/consult"})
    public ModelAndView toViewConsult(HttpServletRequest request, PageBean pageBean, String flag) {
        pageBean.setUrl("2".equals(flag) ? "customer/consult" : "customer/consult-" + flag);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        pageBean.setPageSize(5);
        try {
            resultMap.put("pb", this.commentServiceMapper.queryCustConsult((Long)request.getSession().getAttribute("customerId"), flag, pageBean));
            resultMap.put("flag", flag);
            if (LoginUtil.checkLoginStatus((HttpServletRequest)request)) {
                ModelAndView modelAndView = this.topAndBottomService.getTopAndBottom(new ModelAndView("customer/newconsult").addAllObjects(resultMap));
                return modelAndView;
            }
            ModelAndView modelAndView = new ModelAndView((View)new RedirectView(request.getContextPath() + "/login.html?url=customer/consult.html"));
            return modelAndView;
        }
        finally {
            resultMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/comment"})
    public ModelAndView toViewComment(HttpServletRequest request, PageBean pageBean) {
        pageBean.setUrl("customer/comment");
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        pageBean.setPageSize(5);
        try {
            resultMap.put("pb", this.commentServiceMapper.queryCommentByCust(null, (Long)request.getSession().getAttribute("customerId"), pageBean));
            resultMap.put("explain", this.megawizardSerivce.selectByType(1, Long.valueOf(Long.parseLong(this.tempService.getCurrTemp().getTempId() + ""))));
            if (LoginUtil.checkLoginStatus((HttpServletRequest)request)) {
                ModelAndView modelAndView = this.topAndBottomService.getTopAndBottom(new ModelAndView("customer/newcomment").addAllObjects(resultMap));
                return modelAndView;
            }
            ModelAndView modelAndView = new ModelAndView((View)new RedirectView(request.getContextPath() + "/login.html?url=customer/comment.html"));
            return modelAndView;
        }
        finally {
            resultMap = null;
        }
    }

    @RequestMapping(value={"/findCommentShare"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Comment findCommentShare(HttpServletRequest request, Long orderGoodsId) {
        if (LoginUtil.checkLoginStatus((HttpServletRequest)request)) {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            return this.commentServiceMapper.queryCommentByOrderGoodsId(orderGoodsId, customerId);
        }
        return null;
    }

    @RequestMapping(value={"/share/detail"})
    public ModelAndView bB(HttpServletRequest request, Long shareId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("share", this.shareServiceMapper.queryShareById(shareId));
        map.put("topShare", this.shareServiceMapper.getTopShare(24));
        map.put("good", this.shareServiceMapper.getTopShare(24));
        map.put("bs", this.basicSetService.findBasicSet());
        return this.topAndBottomService.getTopAndBottom(new ModelAndView("/customer/sharedetail").addObject("map", map));
    }

    @RequestMapping(value={"/checkcommgoodflag"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Long checkCommGoodFlag(Long orderId, Long goodsId) {
        return this.commentServiceMapper.checkCommGoodFlag(orderId, goodsId);
    }

    public CommentServiceMapper getCommentServiceMapper() {
        return this.commentServiceMapper;
    }

    @Resource(name="commentServiceMapper")
    public void setCommentServiceMapper(CommentServiceMapper commentServiceMapper) {
        this.commentServiceMapper = commentServiceMapper;
    }

    public GoodsReleTagService getGoodsReleTagService() {
        return this.goodsReleTagService;
    }

    @Resource(name="GoodsReleTagService")
    public void setGoodsReleTagService(GoodsReleTagService goodsReleTagService) {
        this.goodsReleTagService = goodsReleTagService;
    }

    public TopAndBottomService getTopAndBottomService() {
        return this.topAndBottomService;
    }

    @Resource(name="TopAndBottomService")
    public void setTopAndBottomService(TopAndBottomService topAndBottomService) {
        this.topAndBottomService = topAndBottomService;
    }

    public ShareService getShareServiceMapper() {
        return this.shareServiceMapper;
    }

    @Resource(name="shareServiceNew")
    public void setShareServiceMapper(ShareService shareServiceMapper) {
        this.shareServiceMapper = shareServiceMapper;
    }

    public CustomerServiceMapper getCustomerServiceMapper() {
        return this.customerServiceMapper;
    }

    @Resource(name="customerServiceMapper")
    public void setCustomerServiceMapper(CustomerServiceMapper customerServiceMapper) {
        this.customerServiceMapper = customerServiceMapper;
    }

    public MegawizardService getMegawizardSerivce() {
        return this.megawizardSerivce;
    }

    @Resource(name="MegawizardService")
    public void setMegawizardSerivce(MegawizardService megawizardSerivce) {
        this.megawizardSerivce = megawizardSerivce;
    }

    public TempService getTempService() {
        return this.tempService;
    }

    @Resource(name="TempService")
    public void setTempService(TempService tempService) {
        this.tempService = tempService;
    }

    public CustomerServiceMapper getCustomerServiceInterface() {
        return this.customerServiceInterface;
    }

    @Resource(name="customerServiceMapper")
    public void setCustomerServiceInterface(CustomerServiceMapper customerServiceInterface) {
        this.customerServiceInterface = customerServiceInterface;
    }
}

