/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.customer.deposit.pay;

import com.qianjiang.common.util.alipay.util.AlipayConfig;
import com.qianjiang.common.util.alipay.util.AlipayNotify;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.deposit.bean.Deposit;
import com.qianjiang.deposit.bean.Trade;
import com.qianjiang.deposit.service.TradeService;
import com.qianjiang.deposit.service.impl.DepositService;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.site.customer.deposit.bean.TradeConst;
import com.qianjiang.site.customer.deposit.pay.AbstractPayStrategy;
import com.qianjiang.site.customer.deposit.pay.AliPay;
import com.qianjiang.site.customer.deposit.pay.PayContext;
import com.qianjiang.site.customer.deposit.pay.QianJiangPay;
import com.qianjiang.site.customer.deposit.pay.UnionPay;
import com.qianjiang.system.bean.Pay;
import com.qianjiang.system.service.PayService;
import com.qianjiang.util.UtilDate;
import com.unionpay.acp.sdk.SDKUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class DepositPayController {
    private static Logger LOGGER = Logger.getLogger(DepositPayController.class);
    private static final String UTF_8 = "UTF-8";
    private static final String ISO_8859_1 = "ISO-8859-1";
    private static final String OUT_TRADE_NO = "out_trade_no";
    private static final String TRADE_STATUS = "trade_status";
    private static final String SUCCESS = "success";
    private static final String FAIL = "success";
    @Resource(name="payService")
    private PayService payService;
    @Autowired
    private TradeService tradeService;
    @Autowired
    private DepositService depositService;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceInterface;

    @RequestMapping(value={"/deposit/recharge"})
    public void pay(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Pay p;
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        if (customerId == null) {
            response.getWriter().write("what are you doing ?????");
            return;
        }
        String _payId = request.getParameter("payId");
        Long payId = null;
        if (StringUtils.isNumeric((CharSequence)_payId)) {
            payId = Long.valueOf(_payId);
        }
        if ((p = this.payService.findByPayId(payId)) == null) {
            response.getWriter().write("\u8bf7\u914d\u7f6e\u652f\u4ed8\u4fe1\u606f!");
            return;
        }
        String totalFee = request.getParameter("totalFee");
        BigDecimal test = null;
        try {
            test = new BigDecimal(totalFee);
        }
        catch (Exception ex) {
            response.getWriter().write("\u8bf7\u8f93\u5165\u5408\u6cd5\u6570\u5b57!");
            return;
        }
        if (test != null && test.compareTo(BigDecimal.ZERO) < 0) {
            response.getWriter().write("\u8bf7\u8f93\u5165\u5408\u6cd5\u6570\u5b57!");
            return;
        }
        if (test.compareTo(TradeConst.MAX_PER_RECHARGE) > 0) {
            response.getWriter().write("\u5145\u503c\u5927\u4e8e\u4e0a\u9650!");
            return;
        }
        PayContext payContext = null;
        AbstractPayStrategy tPay = null;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        int randomNum = new Random().nextInt(9000) + 1000;
        String orderCode = "R" + UtilDate.mathString((Date)new Date()) + randomNum;
        BigDecimal totalPrice = new BigDecimal(totalFee);
        String remark = null;
        if ("1".equals(p.getPayType())) {
            remark = "\u5728\u7ebf\u5145\u503c-\u652f\u4ed8\u5b9d";
            tPay = new AliPay(p);
            String subject = customerId + "\u5145\u503c\u8ba2\u5355";
            String body = customerId + "\u9884\u5b58\u6b3e\u5145\u503c";
            paramMap.put(OUT_TRADE_NO, orderCode);
            paramMap.put("subject", subject);
            paramMap.put("total_fee", totalFee);
            paramMap.put("body", body);
            tPay.withParamMap(paramMap);
            payContext = new PayContext(tPay);
        } else if ("2".equals(p.getPayType())) {
            remark = "\u5728\u7ebf\u5145\u503c-\u94f6\u8054";
            tPay = new UnionPay(p);
            paramMap.put("orderId", orderCode);
            BigDecimal payTotalPrice = new BigDecimal(totalFee);
            paramMap.put("txnAmt", payTotalPrice.multiply(new BigDecimal(100)).setScale(0, 4).toString());
            tPay.withParamMap(paramMap);
            payContext = new PayContext(tPay);
        } else if ("4".equals(p.getPayType())) {
            remark = "\u5728\u7ebf\u5145\u503c-\u5343\u5320\u6536\u94f6\u53f0";
            paramMap.put("orderCode", orderCode);
            paramMap.put("totalFee", totalFee);
            paramMap.put("productName", customerId + "\u9884\u5b58\u6b3e\u5145\u503c");
            tPay = new QianJiangPay(p);
            tPay.withParamMap(paramMap);
            payContext = new PayContext(tPay);
        }
        this.saveTrade(customerId, orderCode, totalPrice, remark);
        String dom = null;
        if (payContext != null) {
            dom = payContext.pay();
        }
        response.setContentType("text/html;charset=UTF-8");
        request.setCharacterEncoding(ISO_8859_1);
        response.setCharacterEncoding("utf-8");
        response.getWriter().write(dom);
    }

    private int saveTrade(Long customerId, String orderCode, BigDecimal totalPrice, String remark) {
        HashMap<String, Long> qParam = new HashMap<String, Long>();
        qParam.put("customerId", customerId);
        Deposit deposit = this.depositService.getDeposit(qParam);
        BigDecimal preDeposit = deposit.getPreDeposit();
        BigDecimal freezePreDeposit = deposit.getFreezePreDeposit();
        BigDecimal currentPrice = preDeposit.add(freezePreDeposit);
        Trade tTrade = new Trade();
        tTrade.setCustomerId(customerId);
        tTrade.setCreatePerson(customerId);
        tTrade.setCreateTime(new Date());
        tTrade.setOrderPrice(totalPrice);
        tTrade.setDelFlag("0");
        tTrade.setOrderCode(orderCode);
        tTrade.setOrderStatus("5");
        tTrade.setOrderType("0");
        tTrade.setTradeRemark(remark);
        tTrade.setCurrentPrice(currentPrice);
        int ret = this.tradeService.saveTrade(tTrade);
        return ret;
    }

    @RequestMapping(value={"/deposit/alipaycallback"})
    public void AliPayCallback(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Pay p = this.payService.findByPayId(Long.valueOf(25L));
        AlipayConfig.partner = p.getApiKey();
        AlipayConfig.key = p.getSecretKey();
        AlipayConfig.seller_email = p.getPayAccount();
        HashMap<String, String> params = new HashMap<String, String>();
        Map paramMap = request.getParameterMap();
        for (String name : paramMap.keySet()) {
            String[] values = (String[])paramMap.get(name);
            StringBuilder valueStr = new StringBuilder();
            for (int i = 0; i < values.length; ++i) {
                if (i == values.length - 1) {
                    valueStr.append(values[i]);
                    continue;
                }
                valueStr.append(values[i]).append(",");
            }
            params.put(name, valueStr.toString());
        }
        String outTradeNo = new String(request.getParameter(OUT_TRADE_NO).getBytes(ISO_8859_1), UTF_8);
        boolean verifyResult = AlipayNotify.verify(params);
        if (verifyResult) {
            HashMap<String, String> qMap = new HashMap<String, String>();
            qMap.put("orderCode", outTradeNo);
            Trade trade = this.tradeService.findByOrderCodeAndCustomerId(qMap);
            if (trade == null) {
                LOGGER.debug((Object)"\u6ca1\u6709\u67e5\u5230\u5145\u503c\u8ba2\u5355\u4fe1\u606f");
                return;
            }
            Long customerId = trade.getCustomerId();
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("orderCode", outTradeNo);
            param.put("status", "6");
            param.put("customerId", customerId);
            if (StringUtils.isBlank((CharSequence)outTradeNo)) {
                LOGGER.info((Object)"==============\u94f6\u8054\u56de\u8c03\u8ba2\u5355\u53f7\u4e3a\u7a7a===========");
                return;
            }
            this.tradeService.recharge(param);
        }
    }

    @RequestMapping(value={"/deposit/unionpaycallback"})
    public void unionPayCallback(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug((Object)"\u652f\u4ed8\u5f02\u6b65\u56de\u8c03\u5f00\u59cb");
        try {
            request.setCharacterEncoding(ISO_8859_1);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)("\u652f\u4ed8\u56de\u8c03\uff0c\u5b57\u7b26\u8f6c\u6362\u9519\u8bef" + e));
        }
        Map<String, String> respParam = this.getAllParam(request);
        LOGGER.debug((Object)("\u652f\u4ed8\u5f02\u6b65\u56de\u8c03\u5f00\u59cb" + respParam.toString()));
        String encoding = request.getParameter("encoding");
        HashMap<String, String> valideData = null;
        if (null != respParam && !respParam.isEmpty()) {
            Iterator<Map.Entry<String, String>> it = respParam.entrySet().iterator();
            valideData = new HashMap<String, String>();
            while (it.hasNext()) {
                Map.Entry<String, String> e = it.next();
                String key = e.getKey();
                String value = e.getValue();
                value = new String(value.getBytes(ISO_8859_1), encoding);
                valideData.put(key, value);
            }
        }
        if (!SDKUtil.validate(valideData, (String)encoding)) {
            LOGGER.info((Object)"==============\u94f6\u8054\u5f02\u6b65\u56de\u8c03\u9a8c\u8bc1\u51fa\u9519===============");
            return;
        }
        if (!"00".equals(respParam.get("respCode"))) {
            LOGGER.info((Object)"==============\u94f6\u8054\u652f\u4ed8\u5f02\u6b65\u9a8c\u8bc1respCode\u51fa\u9519===========");
            return;
        }
        String orderCode = respParam.get("orderId");
        HashMap<String, String> qMap = new HashMap<String, String>();
        qMap.put("orderCode", orderCode);
        Trade trade = this.tradeService.findByOrderCodeAndCustomerId(qMap);
        if (trade == null) {
            LOGGER.debug((Object)"\u6ca1\u6709\u67e5\u5230\u5145\u503c\u8ba2\u5355\u4fe1\u606f");
            return;
        }
        Long customerId = trade.getCustomerId();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orderCode", orderCode);
        param.put("status", "6");
        param.put("customerId", customerId);
        if (StringUtils.isBlank((CharSequence)orderCode)) {
            LOGGER.info((Object)"==============\u94f6\u8054\u5f02\u6b65\u56de\u8c03\u8ba2\u5355\u53f7\u4e3a\u7a7a===========");
            return;
        }
        this.tradeService.recharge(param);
        LOGGER.info((Object)("=================\u94f6\u8054\u652f\u4ed8\u5f02\u6b65\u56de\u8c03\u5b8c\u6210===========" + orderCode));
    }

    @RequestMapping(value={"/deposit/qianjiangpaycallback"})
    public void qianjiangPayCallback(HttpServletRequest request, HttpServletResponse response) {
        String orderCode = request.getParameter("orderNo");
        HashMap<String, String> qMap = new HashMap<String, String>();
        qMap.put("orderCode", orderCode);
        Trade trade = this.tradeService.findByOrderCodeAndCustomerId(qMap);
        if (trade == null) {
            LOGGER.debug((Object)"\u6ca1\u6709\u67e5\u5230\u5145\u503c\u8ba2\u5355\u4fe1\u606f");
            return;
        }
        Long customerId = trade.getCustomerId();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orderCode", orderCode);
        param.put("status", "6");
        param.put("customerId", customerId);
        if (StringUtils.isBlank((CharSequence)orderCode)) {
            LOGGER.info((Object)"==============\u5343\u5320\u56de\u8c03\u8ba2\u5355\u53f7\u4e3a\u7a7a===========");
            return;
        }
        this.tradeService.recharge(param);
        LOGGER.info((Object)("=================\u5343\u5320\u56de\u8c03\u652f\u4ed8===========" + orderCode));
    }

    public Map<String, String> getAllParam(HttpServletRequest request) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        Enumeration temp = request.getParameterNames();
        while (temp.hasMoreElements()) {
            String en = (String)temp.nextElement();
            String value = request.getParameter(en);
            paramMap.put(en, value);
        }
        return paramMap;
    }

    @RequestMapping(value={"/deposit/synunionpayresult"})
    public ModelAndView synUnionPayCallback(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ModelAndView mav = null;
        String msg = null;
        try {
            request.setCharacterEncoding(ISO_8859_1);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)("\u652f\u4ed8\u56de\u8c03\uff0c\u5b57\u7b26\u8f6c\u6362\u9519\u8bef" + e));
            mav = new ModelAndView("deposit/syncresult");
            msg = "\u652f\u4ed8\u56de\u8c03\uff0c\u5b57\u7b26\u8f6c\u6362\u9519\u8bef";
            mav.addObject("msg", (Object)msg);
            return mav;
        }
        Map<String, String> respParam = this.getAllParam(request);
        String encoding = request.getParameter("encoding");
        HashMap<String, String> valideData = null;
        if (null != respParam && !respParam.isEmpty()) {
            Iterator<Map.Entry<String, String>> it = respParam.entrySet().iterator();
            valideData = new HashMap<String, String>();
            while (it.hasNext()) {
                Map.Entry<String, String> e = it.next();
                String key = e.getKey();
                String value = e.getValue();
                value = new String(value.getBytes(ISO_8859_1), encoding);
                valideData.put(key, value);
            }
        }
        String orderCode = respParam.get("orderId");
        if (!SDKUtil.validate(valideData, (String)encoding)) {
            LOGGER.info((Object)"==============\u94f6\u8054\u540c\u6b65\u56de\u8c03\u9a8c\u8bc1\u51fa\u9519===============");
            msg = "\u94f6\u8054\u5145\u503c\u5931\u8d25";
            mav = new ModelAndView("deposit/syncresult");
            msg = "\u94f6\u8054\u540c\u6b65\u56de\u8c03\u9a8c\u8bc1\u51fa\u9519";
            mav.addObject("msg", (Object)msg);
            return mav;
        }
        if (!"00".equals(respParam.get("respCode"))) {
            LOGGER.info((Object)"==============\u94f6\u8054\u652f\u4ed8\u9a8c\u8bc1respCode\u51fa\u9519===========");
            msg = "\u94f6\u8054\u5145\u503c\u5931\u8d25";
            mav = new ModelAndView("deposit/syncresult");
            msg = "\u94f6\u8054\u652f\u4ed8\u9a8c\u8bc1respCode\u51fa\u9519";
            mav.addObject("msg", (Object)msg);
            return mav;
        }
        HashMap<String, String> qMap = new HashMap<String, String>();
        qMap.put("orderCode", orderCode);
        Trade trade = this.tradeService.findByOrderCodeAndCustomerId(qMap);
        if (trade == null) {
            LOGGER.debug((Object)"\u6ca1\u6709\u67e5\u5230\u5145\u503c\u8ba2\u5355\u4fe1\u606f");
            mav = new ModelAndView("deposit/syncresult");
            msg = "\u6ca1\u6709\u67e5\u5230\u5145\u503c\u8ba2\u5355\u4fe1\u606f";
            mav.addObject("msg", (Object)msg);
            return mav;
        }
        Long customerId = trade.getCustomerId();
        CustomerAllInfo ca = this.customerServiceInterface.selectByPrimaryKey(customerId);
        request.getSession().setAttribute("cust", (Object)ca);
        request.getSession().setAttribute("customerId", (Object)ca.getCustomerId());
        String status = trade.getOrderStatus();
        if ("5".equals(status)) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("orderCode", orderCode);
            param.put("status", "6");
            param.put("customerId", customerId);
            this.tradeService.recharge(param);
            msg = "\u5145\u503c\u6210\u529f";
        } else {
            msg = "6".equals(status) ? "\u5145\u503c\u6210\u529f" : "\u5176\u4ed6\u8ba2\u5355\u72b6\u6001";
        }
        mav = new ModelAndView("deposit/syncresult");
        mav.addObject("msg", (Object)msg);
        LOGGER.info((Object)("=================\u94f6\u8054\u652f\u4ed8===========" + orderCode));
        return mav;
    }

    @RequestMapping(value={"/deposit/synalipayresult"})
    public ModelAndView synAliPayCallback(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ModelAndView mav = null;
        String msg = null;
        Object map = null;
        HashMap<String, String> params = new HashMap<String, String>();
        Map requestParams = request.getParameterMap();
        for (String name : requestParams.keySet()) {
            String[] values = (String[])requestParams.get(name);
            String valueStr = "";
            StringBuilder buf = null;
            for (int i = 0; i < values.length; ++i) {
                buf = new StringBuilder();
                if (i == values.length - 1) {
                    buf.append(values[i]);
                } else {
                    buf.append(values[i]);
                    buf.append(",");
                }
                valueStr = valueStr + buf.toString();
            }
            try {
                valueStr = new String(valueStr.getBytes(ISO_8859_1), UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.info((Object)("\u652f\u4ed8\u5931\u8d25" + e));
                mav = new ModelAndView("deposit/syncresult");
                msg = "\u652f\u4ed8\u5b9d\u540c\u6b65\u56de\u8c03\u7f16\u7801\u51fa\u9519\u3002";
                mav.addObject("msg", (Object)msg);
                return mav;
            }
            params.put(name, valueStr);
        }
        Long customerId = null;
        String status = null;
        try {
            String orderCode = new String(request.getParameter(OUT_TRADE_NO).getBytes(ISO_8859_1), UTF_8);
            String tradeStatus = new String(request.getParameter(TRADE_STATUS).getBytes(ISO_8859_1), UTF_8);
            boolean verifyResult = AlipayNotify.verify(params);
            HashMap<String, String> qMap = new HashMap<String, String>();
            qMap.put("orderCode", orderCode);
            Trade trade = this.tradeService.findByOrderCodeAndCustomerId(qMap);
            if (trade == null) {
                LOGGER.debug((Object)"\u6ca1\u6709\u67e5\u5230\u5145\u503c\u8ba2\u5355\u4fe1\u606f");
                mav = new ModelAndView("deposit/syncresult");
                msg = "\u6ca1\u6709\u67e5\u5230\u5145\u503c\u8ba2\u5355\u4fe1\u606f";
                mav.addObject("msg", (Object)msg);
                return mav;
            }
            customerId = trade.getCustomerId();
            status = trade.getOrderStatus();
            if ("TRADE_FINISHED".equals(tradeStatus) || "TRADE_SUCCESS".equals(tradeStatus)) {
                if ("5".equals(status)) {
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put("orderCode", orderCode);
                    param.put("status", "6");
                    param.put("customerId", customerId);
                    this.tradeService.recharge(param);
                    msg = "\u5145\u503c\u6210\u529f";
                } else {
                    msg = "6".equals(status) ? "\u5145\u503c\u6210\u529f" : "\u5176\u4ed6\u8ba2\u5355\u72b6\u6001";
                }
            } else {
                msg = "\u652f\u4ed8\u5b9d\u5145\u503c\u5931\u8d25";
            }
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.info((Object)("" + e));
            msg = "\u7f16\u7801\u89e3\u6790\u51fa\u9519\uff0c\u5145\u503c\u5931\u8d25";
        }
        CustomerAllInfo ca = this.customerServiceInterface.selectByPrimaryKey(customerId);
        request.getSession().setAttribute("cust", (Object)ca);
        request.getSession().setAttribute("customerId", (Object)ca.getCustomerId());
        mav = new ModelAndView("deposit/syncresult");
        mav.addObject("msg", (Object)msg);
        return mav;
    }

    @RequestMapping(value={"/deposit/synqianjiangpayresult"})
    public ModelAndView synQianjiangPayCallback(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ModelAndView mav = null;
        String msg = null;
        String orderCode = request.getParameter("orderno");
        if (StringUtils.isBlank((CharSequence)orderCode)) {
            LOGGER.debug((Object)"\u5343\u5320\u540c\u6b65\u56de\u8c03\u8ba2\u5355\u53f7\u4e3a\u7a7a");
            mav = new ModelAndView("deposit/syncresult");
            msg = "\u5343\u5320\u540c\u6b65\u56de\u8c03\u8ba2\u5355\u53f7\u4e3a\u7a7a";
            mav.addObject("msg", (Object)msg);
            return mav;
        }
        HashMap<String, String> qMap = new HashMap<String, String>();
        qMap.put("orderCode", orderCode);
        Trade trade = this.tradeService.findByOrderCodeAndCustomerId(qMap);
        if (trade == null) {
            LOGGER.debug((Object)"\u6ca1\u6709\u67e5\u5230\u5145\u503c\u8ba2\u5355\u4fe1\u606f");
            mav = new ModelAndView("deposit/syncresult");
            msg = "\u6ca1\u6709\u67e5\u5230\u5145\u503c\u8ba2\u5355\u4fe1\u606f";
            mav.addObject("msg", (Object)msg);
            return mav;
        }
        Long customerId = trade.getCustomerId();
        String status = trade.getOrderStatus();
        if ("5".equals(status)) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("orderCode", orderCode);
            param.put("status", "6");
            param.put("customerId", customerId);
            this.tradeService.recharge(param);
            msg = "\u5145\u503c\u6210\u529f";
        } else {
            msg = "6".equals(status) ? "\u5145\u503c\u6210\u529f" : "\u5176\u4ed6\u8ba2\u5355\u72b6\u6001";
        }
        CustomerAllInfo ca = this.customerServiceInterface.selectByPrimaryKey(customerId);
        request.getSession().setAttribute("cust", (Object)ca);
        request.getSession().setAttribute("customerId", (Object)ca.getCustomerId());
        mav = new ModelAndView("deposit/syncresult");
        mav.addObject("msg", (Object)msg);
        return mav;
    }

    private void echo(HttpServletResponse response, String msg) throws IOException {
        PrintWriter out = response.getWriter();
        out.println(msg);
        out.flush();
        out.close();
    }
}

