/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.customer.deposit.service;

import com.alibaba.fastjson.JSONObject;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.deposit.bean.Bank;
import com.qianjiang.deposit.bean.Deposit;
import com.qianjiang.deposit.bean.Trade;
import com.qianjiang.deposit.bean.Withdraw;
import com.qianjiang.deposit.bean.WithdrawForm;
import com.qianjiang.deposit.service.BankService;
import com.qianjiang.deposit.service.TradeService;
import com.qianjiang.deposit.service.impl.WithdrawService;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.site.customer.deposit.bean.DepositConst;
import com.qianjiang.site.customer.deposit.service.SiteDepositService;
import com.qianjiang.site.customer.deposit.vo.WithdrawVo;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.UtilDate;
import com.qianjiang.util.web.ReturnJsonBuilder;
import com.qianjiang.util.web.ReturnJsonBuilderFactory;
import com.qianjiang.utils.SecurityUtil;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SiteWithdrawService
extends WithdrawService {
    private Logger LOGGER = Logger.getLogger(SiteWithdrawService.class);
    @Autowired
    private SiteDepositService depositService;
    @Autowired
    private TradeService tradeService;
    @Autowired
    private BankService bankService;
    @Autowired
    private CustomerServiceMapper customerService;

    @Transactional
    public JSONObject create(WithdrawVo vo) throws IllegalArgumentException {
        JSONObject returnVal = new JSONObject();
        Long customerId = vo.getCustomerId();
        CustomerAllInfo customer = this.customerService.queryCustomerById(customerId);
        String encodePwd = SecurityUtil.getStoreLogpwd((String)customer.getUniqueCode(), (String)vo.getPayPwd(), (String)customer.getSaltVal());
        BigDecimal amount = vo.getAmount();
        Deposit deposit = this.depositService.findByCustomerId(customerId);
        BigDecimal nextDeposit = deposit.getPreDeposit().subtract(amount);
        BigDecimal nextFrozenDeposit = deposit.getFreezePreDeposit().add(amount);
        vo.setCurrentPrice(deposit.getPreDeposit().add(deposit.getFreezePreDeposit()));
        String payPassword = deposit.getPayPassword();
        if (StringUtils.isBlank((CharSequence)payPassword)) {
            return ReturnJsonBuilderFactory.builder().code("1").msg(DepositConst.NOT_SET_DEPOSIT_PAY_PASSWORD).build();
        }
        if (deposit.getPasswordErrorCount() >= DepositConst.ERROR_TRY_COUNT) {
            returnVal.put("code", (Object)"2");
            returnVal.put("msg", (Object)DepositConst.CANNOT_WITHDRAW);
            return returnVal;
        }
        if (!encodePwd.equals(payPassword)) {
            int nextErrorCount = deposit.addPwdErrorCount();
            this.depositService.updateErrorCount(customerId, nextErrorCount);
            returnVal.put("code", (Object)"3");
            returnVal.put("msg", (Object)MessageFormat.format(DepositConst.PIN_ERROR, 3 - nextErrorCount));
            return returnVal;
        }
        if (nextDeposit.compareTo(BigDecimal.ZERO) == -1) {
            returnVal.put("code", (Object)"4");
            returnVal.put("msg", (Object)DepositConst.INSUFFICIENCE_DEPOSIT);
            return returnVal;
        }
        if (nextFrozenDeposit.compareTo(BigDecimal.valueOf(0L)) <= 0) {
            returnVal.put("code", (Object)"4");
            returnVal.put("msg", (Object)DepositConst.INVALID_PRICE);
            return returnVal;
        }
        if (nextFrozenDeposit.compareTo(BigDecimal.valueOf(9.999999999E7)) == 1) {
            returnVal.put("code", (Object)"4");
            returnVal.put("msg", (Object)DepositConst.FROZNE_DEPOSIT_OUT_OF_RANGE);
            return returnVal;
        }
        Long bankId = vo.getReceivingBank();
        if (bankId != -1L) {
            Bank bank = this.bankService.findById(bankId);
            vo.setBankName(bank.getBankName());
        }
        this.freezeDeposit(deposit, amount);
        Date createTime = new Date();
        String orderCode = this.saveTrade(vo, createTime);
        Trade nextTrade = this.tradeService.findByOrderCode(orderCode);
        Long tradeId = nextTrade.getId();
        Withdraw withdraw = new Withdraw();
        BeanUtils.copyProperties((Object)vo, (Object)withdraw);
        withdraw.setTradeInfoId(tradeId);
        withdraw.setCreateTime(createTime);
        this.save(withdraw);
        returnVal.put("code", (Object)"0");
        returnVal.put("msg", (Object)"success");
        return ReturnJsonBuilderFactory.builder().data("tradeId", (Object)tradeId).defaultVal();
    }

    private String saveTrade(WithdrawVo vo, Date createTime) {
        Long customerId = vo.getCustomerId();
        String orderCode = "W" + UtilDate.mathString((Date)createTime) + (RandomUtils.nextInt((int)9000) + 1000);
        Trade trade = new Trade();
        trade.setCustomerId(customerId);
        trade.setCreatePerson(customerId);
        trade.setOrderPrice(vo.getAmount());
        trade.setCurrentPrice(vo.getCurrentPrice());
        trade.setOrderCode(orderCode);
        trade.setOrderStatus("0");
        trade.setOrderType("2");
        trade.setTradeRemark(vo.getRemark());
        trade.setCreateTime(createTime);
        this.tradeService.saveTrade(trade);
        return orderCode;
    }

    public PageBean findByCustomerIdAndStatus(WithdrawForm withdrawForm) {
        PageBean pb = new PageBean();
        pb.setPageNo(withdrawForm.getPageNo().intValue());
        pb.setPageSize(withdrawForm.getPageSize().intValue());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("customerId", withdrawForm.getCustomerId());
        String status = withdrawForm.getStatus();
        if (StringUtils.isNotBlank((CharSequence)status)) {
            if (status.equals("3")) {
                map.put("statuses", new String[]{"2", "3"});
            } else {
                map.put("statuses", new String[]{status});
            }
        }
        map.put("types", new String[]{"2"});
        PageBean pageBean = this.tradeService.pageTrade(map, pb);
        return pageBean;
    }

    public JSONObject cancel(Long id, Long customerId) {
        Trade nextTrade = new Trade();
        nextTrade.setOrderStatus("8");
        Integer result = this.tradeService.updateByIdAndStatus(nextTrade, id, customerId, "0");
        if (result == 0) {
            return ReturnJsonBuilderFactory.builder().code("1").msg("\u53c2\u6570\u9519\u8bef,\u64cd\u4f5c\u5931\u8d25").build();
        }
        Trade trade = this.tradeService.findById(id);
        Deposit deposit = this.depositService.findByCustomerId(customerId);
        this.unFreezeDeposit(deposit, trade.getOrderPrice());
        return new ReturnJsonBuilder().code("0").msg("success").build();
    }

    @Transactional
    public JSONObject confirm(Long id, Long customerId) {
        Trade nextTrade = new Trade();
        nextTrade.setOrderStatus("4");
        Integer result = this.tradeService.updateByIdAndStatus(nextTrade, id, customerId, "3");
        if (result == 0) {
            return ReturnJsonBuilderFactory.builder().code("1").msg("\u786e\u8ba4\u6536\u6b3e\u5931\u8d25").build();
        }
        Trade trade = this.tradeService.findById(id);
        Deposit deposit = this.depositService.findByCustomerId(customerId);
        this.consumeDeposit(deposit, trade.getOrderPrice());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", id);
        map.put("status", "4");
        BigDecimal currentPrice = deposit.getFreezePreDeposit().add(deposit.getPreDeposit()).subtract(trade.getOrderPrice());
        map.put("currentPrice", currentPrice);
        this.tradeService.updateById(map);
        return new ReturnJsonBuilder().code("0").msg("success").build();
    }

    private Integer unFreezeDeposit(Deposit deposit, BigDecimal amount) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", deposit.getId());
        paramMap.put("customerId", deposit.getCustomerId());
        paramMap.put("preDeposit", deposit.getPreDeposit().add(amount));
        BigDecimal freezePreDeposit = deposit.getFreezePreDeposit().subtract(amount);
        paramMap.put("freezePreDeposit", freezePreDeposit);
        if (freezePreDeposit.compareTo(BigDecimal.ZERO) == 0) {
            paramMap.put("freezePreDeposit", "0");
        }
        return this.depositService.updateDeposit(paramMap);
    }

    private Integer freezeDeposit(Deposit deposit, BigDecimal amount) {
        HashMap<String, Number> paramMap = new HashMap<String, Number>();
        paramMap.put("id", deposit.getId());
        paramMap.put("customerId", deposit.getCustomerId());
        paramMap.put("preDeposit", deposit.getPreDeposit().subtract(amount));
        paramMap.put("freezePreDeposit", deposit.getFreezePreDeposit().add(amount));
        return this.depositService.updateDeposit(paramMap);
    }
}

