/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.threepart.controller;

import com.qianjiang.site.threepart.util.StringUtil;
import com.qianjiang.system.bean.Auth;
import com.qianjiang.system.service.AuthService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.RanddomMath;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class LoginNetEasyController {
    private static final MyLogger LOGGER = new MyLogger(LoginNetEasyController.class);
    private AuthService authService;

    @RequestMapping(value={"loginneteasy"})
    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        Auth auth = this.authService.findAuthByAuthType("5");
        if (auth != null) {
            String appID = auth.getAuthClientId();
            String appKEY = auth.getAuthClientSecret();
            String redirectURI = auth.getAuthRedirectUri();
            String url = "http://api.t.163.com/oauth/request_token?auth_consumer_key=" + appID + "&oauth_signature_method=HMAC-SHA1&oauth_signature=" + appKEY + "&oauth_timestamp=" + System.currentTimeMillis() + "&oauth_nonce=" + RanddomMath.randomString((int)32) + "&oauth_version=OAuth 1.0a";
            GetMethod getMethod = new GetMethod(url);
            HttpClient client = new HttpClient();
            Map<String, String> pmap = null;
            try {
                client.executeMethod((HttpMethod)getMethod);
                String userInfo = getMethod.getResponseBodyAsString();
                pmap = StringUtil.formatNetEasyString(userInfo);
            }
            catch (Exception e) {
                LOGGER.error("\u7f51\u6613\u767b\u9646\u62a5\u9519" + e);
            }
            String token = pmap.get("oauth_token");
            String reurl = "http://api.t.163.com/oauth/request_token?oauth_token=" + token + "&oauth_callback=" + redirectURI;
            try {
                response.sendRedirect(reurl);
            }
            catch (IOException e) {
                LOGGER.error("\u7f51\u6613\u767b\u9646\u62a5\u9519" + e);
            }
        }
    }

    public AuthService getAuthService() {
        return this.authService;
    }

    @Resource(name="authService")
    public void setAuthService(AuthService authService) {
        this.authService = authService;
    }
}

