/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.customer.controller;

import com.qianjiang.customer.bean.Vocationinfo;
import com.qianjiang.customer.service.VocationinfoServiceMapper;
import com.qianjiang.util.MyLogger;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="vocationController")
public class VocationinfoController {
    private VocationinfoServiceMapper vocationinfoServiceMapper;
    private static final MyLogger LOGGER = new MyLogger(VocationinfoController.class);

    @RequestMapping(value={"/insertvocation"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int insertVocation(HttpServletRequest request, @Valid Vocationinfo vocationinfo) {
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        if (customerId != null) {
            vocationinfo.setCustomerId(customerId);
            if (null != vocationinfo.getCompanyName()) {
                LOGGER.info((Object)("\u6dfb\u52a0\u516c\u53f8\u540d\u79f0\u4e3a\uff1a" + vocationinfo.getCompanyName()));
            }
            return this.vocationinfoServiceMapper.insert(vocationinfo);
        }
        return 0;
    }

    @RequestMapping(value={"/delvocation"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int delVocation(HttpServletRequest request, long vocationId) {
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        Vocationinfo vocationinfo = this.vocationinfoServiceMapper.selectByPrimaryKey(Long.valueOf(vocationId));
        if (vocationinfo.getCustomerId().equals(customerId)) {
            if (null != vocationinfo.getCompanyName()) {
                LOGGER.info((Object)("\u5220\u9664\u516c\u53f8\u540d\u79f0\u4e3a\uff1a" + vocationinfo.getCompanyName()));
            }
            return this.vocationinfoServiceMapper.deleteByPrimaryKey(Long.valueOf(vocationId));
        }
        return 0;
    }

    @RequestMapping(value={"/updatevocation"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int updateVocation(HttpServletRequest request, @Valid Vocationinfo vocationinfo) {
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        Vocationinfo vocation = this.vocationinfoServiceMapper.selectByPrimaryKey(vocationinfo.getVocationId());
        if (null != vocation.getCompanyName()) {
            LOGGER.info((Object)("\u4fee\u6539\u516c\u53f8\u540d\u79f0\u4e3a\uff1a" + vocationinfo.getCompanyName()));
        }
        if (vocation.getCustomerId().equals(customerId)) {
            return this.vocationinfoServiceMapper.updateByPrimaryKey(vocationinfo);
        }
        return 0;
    }

    @RequestMapping(value={"/selectvobyid"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Vocationinfo selectVocationById(HttpServletRequest request, long vocationId) {
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        Vocationinfo vocation = this.vocationinfoServiceMapper.selectByPrimaryKey(Long.valueOf(vocationId));
        if (vocation != null && vocation.getCustomerId().equals(customerId)) {
            LOGGER.info((Object)("\u83b7\u53d6\u516c\u53f8\u540d\u79f0\u4e3a\uff1a" + vocation.getCompanyName()));
        } else {
            vocation = null;
        }
        return vocation;
    }

    @RequestMapping(value={"/selectall"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<Vocationinfo> selectAll(HttpServletRequest request) {
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        return this.vocationinfoServiceMapper.selectAllVocation(customerId.longValue());
    }

    public VocationinfoServiceMapper getVocationinfoServiceMapper() {
        return this.vocationinfoServiceMapper;
    }

    @Resource(name="vocationinfoServiceMapper")
    public void setVocationinfoServiceMapper(VocationinfoServiceMapper vocationinfoServiceMapper) {
        this.vocationinfoServiceMapper = vocationinfoServiceMapper;
    }
}

