/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.index;

import com.qianjiang.channel.bean.Channel;
import com.qianjiang.channel.service.ChannelAdverService;
import com.qianjiang.channel.service.ChannelSalesGoodsService;
import com.qianjiang.channel.service.SysChannelService;
import com.qianjiang.index.bean.IndexGoodsBean;
import com.qianjiang.index.service.ChannelSiteService;
import com.qianjiang.information.service.InformationService;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.util.MyLogger;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class BarChannelSiteController {
    private static final MyLogger LOGGER = new MyLogger(BarChannelSiteController.class);
    private static final Long ATID1 = 157L;
    private static final Long ATID2 = 159L;
    private static final Long ATID3 = 161L;
    private static final Long ADVERTTYPE = 151L;
    private static final int ADVERTNUM = 3;
    @Resource(name="SysChannelService")
    private SysChannelService channelService;
    @Resource(name="ChannelSiteService")
    private ChannelSiteService channelSiteService;
    @Resource(name="ChannelAdverService")
    private ChannelAdverService channelAdverService;
    @Resource(name="InformationService")
    private InformationService infoService;
    @Resource(name="ChannelSalesGoodsService")
    private ChannelSalesGoodsService channelSalesGoodsService;
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;

    @ResponseBody
    @RequestMapping(value={"/barchannelCateNavViewText"}, produces={"application/json;charset=UTF-8"})
    public Object channelCateNavViewText(HttpServletRequest request, Long channelId, Long tempId) {
        return this.channelSiteService.getClassifyBar(channelId, tempId);
    }

    @ResponseBody
    @RequestMapping(value={"/barchannelStoreyViewText"}, produces={"application/json;charset=UTF-8"})
    public Object channelStoreyViewText(HttpServletRequest request, Long channelId, Long tempId) {
        return this.channelSiteService.getStoreys(channelId, tempId);
    }

    @RequestMapping(value={"/barchannelView"})
    public ModelAndView channelView(HttpServletRequest request, String barId) {
        ModelAndView mav = new ModelAndView();
        Channel channel = this.getChannel(barId);
        if (null != channel) {
            mav.setViewName("channel/bar_channelIndex");
            mav.addObject("sys", (Object)this.basicSetService.findBasicSet());
            mav.addObject("channel", (Object)channel);
            mav.addObject("floor", (Object)this.channelSiteService.getStoreys(channel.getChannelId(), null));
            String infoName = channel.getInfoName();
            mav.addObject("infoName", (Object)infoName);
            mav.addObject("infoList", (Object)this.infoService.selectByInfoType(channel.getInfoTypeId()));
            mav.addObject("avc", (Object)this.channelAdverService.selectchannelAdverByParamForSite(channel.getChannelId(), null, null, null, ATID1, ADVERTTYPE, null, "0", null, null));
            mav.addObject("avs", (Object)this.channelAdverService.selectchannelAdverByParamForSite(channel.getChannelId(), null, null, null, ATID2, ADVERTTYPE, null, "0", null, null));
            mav.addObject("pageAdvs", (Object)this.channelAdverService.selectchannelAdverByParamForSite(channel.getChannelId(), null, null, null, ATID3, ADVERTTYPE, null, "0", null, null));
            mav.addObject("channelGoodsFlag0", (Object)this.channelSalesGoodsService.selectChannelGoodsByFlag(channel.getChannelId(), "0", 3));
            mav.addObject("channelGoodsFlag1", (Object)this.channelSalesGoodsService.selectChannelGoodsByFlag(channel.getChannelId(), "1", 3));
            mav.addObject("channelGoodsFlag2", (Object)this.channelSalesGoodsService.selectChannelGoodsByFlag(channel.getChannelId(), "2", 3));
            return mav;
        }
        mav.setView((View)new RedirectView(request.getContextPath() + "/index.html"));
        return mav;
    }

    @RequestMapping(value={"/barloadstoreytagproduct"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<IndexGoodsBean> loadStoreyTagProduct(Long tagId) {
        return this.channelSiteService.selectStoreyTagProductsByTagId(tagId);
    }

    private Channel getChannel(String barId) {
        Channel channel = this.channelService.selectByBarId(barId);
        if (channel != null && channel.getChannelName() != null) {
            LOGGER.debug("===============\u52a0\u8f7d\u5bfc\u822a\u9891\u9053,\u9891\u9053\u540d\u79f0\u662f\uff1a" + channel.getChannelName());
            return channel;
        }
        return null;
    }
}

