/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.goods.controller;

import com.qianjiang.common.kuaidi.KuaiDiUtil;
import com.qianjiang.goods.bean.GoodsDetailBean;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.index.service.TopAndBottomService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class GoodsCompareController {
    @Resource(name="GoodsProductService")
    private GoodsProductService goodsProductService;
    @Resource(name="TopAndBottomService")
    private TopAndBottomService topAndBottomService;
    private static final String DISTINCTID = "distinctId";

    @RequestMapping(value={"/compare"})
    public ModelAndView compare(String goodsIds, HttpServletRequest request) {
        HashMap<String, List> map = new HashMap<String, List>();
        Long distinctId = null;
        if (null != request.getSession().getAttribute(DISTINCTID)) {
            distinctId = Long.parseLong(request.getSession().getAttribute(DISTINCTID).toString());
        }
        map.put("list", this.goodsProductService.execCompProduct(this.getIds(goodsIds, ","), distinctId));
        ModelAndView mav = new ModelAndView("goods/compare").addObject("map", map);
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"/getCompareGoods"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<GoodsDetailBean> compareGoods(String goodsIds, HttpServletRequest request) {
        return this.goodsProductService.execCompProduct(this.getIds(goodsIds, "-"));
    }

    public List<Long> getIds(String goodsIds, String reg) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (String id : goodsIds.split(reg)) {
            if ("0".equals(id)) continue;
            ids.add(Long.parseLong(id));
        }
        return ids;
    }

    @RequestMapping(value={"/execLookExpress"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String execLookExpress(String expressType, String expressNo) {
        return KuaiDiUtil.execLookKuaiDi(expressType, expressNo);
    }
}

