/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.thirdseller.controller;

import com.qianjiang.channel.service.ChannelAdverService;
import com.qianjiang.channel.service.ChannelGoodsService;
import com.qianjiang.comment.service.CommentServiceMapper;
import com.qianjiang.common.util.NpCookieUtil;
import com.qianjiang.customer.bean.PunishRecord;
import com.qianjiang.customer.service.PunishRecordService;
import com.qianjiang.goods.bean.SolrGoodsInfo;
import com.qianjiang.goods.service.GoodsService;
import com.qianjiang.goods.util.SearchPageBean;
import com.qianjiang.index.service.TopAndBottomService;
import com.qianjiang.site.thirdseller.bean.ThirdGoodsSearchBean;
import com.qianjiang.site.thirdseller.service.ThirdCateService;
import com.qianjiang.site.thirdseller.service.ThirdSellerSiteService;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.system.util.BasicSetUtil;
import com.qianjiang.temp.bean.SysTemp;
import com.qianjiang.temp.service.ClassifyBarService;
import com.qianjiang.temp.service.ThirdTempService;
import com.qianjiang.thirdaudit.service.AuditService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.StringCommonUtil;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ThirdSellerSiteController {
    private static final MyLogger LOGGER = new MyLogger(ThirdSellerSiteController.class);
    private static final String THIRDID = "thirdId";
    private static final String CLASSBAR = "classBar";
    private static final String PAGEADVS = "pageAdvs";
    private static final String THIRDCATE = "thirdCate";
    private static final String NOWCATE = "nowcate";
    private static final String COMMENT = "comment";
    private static final String STOREINFO = "storeInfo";
    private static final String SEARCH = "search";
    private static final String THIRDSTOREINDEX_FALSE = "thirdseller/thirdstoreindex_false";
    @Resource(name="TopAndBottomService")
    private TopAndBottomService topAndBottomService;
    @Resource(name="ClassifyBarService")
    private ClassifyBarService classifyBarService;
    @Resource(name="ThirdTempService")
    private ThirdTempService thirdTempService;
    @Resource(name="ChannelAdverService")
    private ChannelAdverService channelAdverService;
    @Resource(name="ThirdSellerSiteService")
    private ThirdSellerSiteService siteService;
    @Resource(name="ChannelGoodsService")
    private ChannelGoodsService channelGoodsService;
    @Resource(name="ThirdCateService")
    private ThirdCateService thirdCateService;
    @Resource(name="GoodsService")
    private GoodsService goodsService;
    @Resource(name="commentServiceMapper")
    private CommentServiceMapper commentService;
    @Resource(name="PunishRecordService")
    private PunishRecordService punishRecordService;
    @Resource(name="auditService")
    private AuditService auditService;
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;

    @ResponseBody
    @RequestMapping(value={"/getThirdStoreURL"}, produces={"application/json;charset=UTF-8"})
    public String getThirdStoreURL() {
        String bsetThirdAddress = BasicSetUtil.getAddress((String)this.basicSetService.findBasicSet().getBsetThirdAddress());
        return bsetThirdAddress;
    }

    @ResponseBody
    @RequestMapping(value={"/checkThirdIndex"}, produces={"application/json;charset=UTF-8"})
    public Map<String, Object> checkThirdIndex(HttpServletRequest request, Long thirdId, String checkThirdIndex) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Long storeIndex = this.thirdCateService.selectByCustomerId(thirdId);
        map.put("state", 0L != storeIndex);
        map.put("checkThirdIndex", checkThirdIndex);
        return map;
    }

    @RequestMapping(value={"/thirdstoreindexfalse"})
    public ModelAndView thirdstoreindexfalse(HttpServletRequest request, Long thirdId) {
        request.getSession().setAttribute(THIRDID, (Object)thirdId);
        return new ModelAndView(THIRDSTOREINDEX_FALSE);
    }

    @RequestMapping(value={"/thirdstoreindex"})
    public ModelAndView thirdStoreIndexEs(String top, HttpServletRequest request, Long thirdId, SearchPageBean<SolrGoodsInfo> pb, ThirdGoodsSearchBean searchBean) {
        ModelAndView mav = new ModelAndView();
        pb.setPageSize(20);
        try {
            int count;
            String delflag = this.thirdCateService.findStoreFlag(thirdId);
            if (delflag != null && "1".equals(delflag)) {
                mav.setViewName("/indexview");
                return this.topAndBottomService.getBottom(mav);
            }
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            if (top != null && !"".equals(top)) {
                resultMap.put("top", top);
            } else {
                resultMap.put("top", "0");
            }
            List punishRecordList = this.punishRecordService.queryInfoByTidandDate(thirdId);
            if (CollectionUtils.isNotEmpty((Collection)punishRecordList)) {
                for (int i = 0; i < punishRecordList.size(); ++i) {
                    PunishRecord punishRecord = (PunishRecord)punishRecordList.get(i);
                    if (punishRecord.getPunishId() != 1L) continue;
                    mav.setViewName("/register/closestoretip");
                    return this.topAndBottomService.getBottom(mav);
                }
            }
            if ((count = this.auditService.selectStoreTimeByThirdId(thirdId)) == 0) {
                mav.setViewName("/register/overtimetip");
                return this.topAndBottomService.getBottom(mav);
            }
            Long storeIndex = this.thirdCateService.selectByCustomerId(thirdId);
            if (0 == storeIndex.intValue()) {
                mav.setView((View)new RedirectView("thirdstoreindexfalse.htm?thirdId=" + thirdId));
                return this.topAndBottomService.getBottom(mav);
            }
            SysTemp temp = (SysTemp)this.thirdTempService.querySystempByType(Long.valueOf(137L)).get(0);
            resultMap.put(CLASSBAR, this.classifyBarService.selectClassifyBarByParamThirdSite(Long.valueOf(temp.getTempId()), null, thirdId.toString()));
            resultMap.put("channelAdvs", this.channelAdverService.selectchannelAdverByParamForSite(null, Long.valueOf(temp.getTempId()), null, null, Long.valueOf(157L), Long.valueOf(151L), null, null, thirdId.toString(), null));
            resultMap.put("channelSadvs", this.channelAdverService.selectchannelAdverByParamForSite(null, Long.valueOf(temp.getTempId()), null, null, Long.valueOf(159L), Long.valueOf(151L), null, null, thirdId.toString(), null));
            resultMap.put(PAGEADVS, this.channelAdverService.selectchannelAdverByParamForSite(null, Long.valueOf(temp.getTempId()), null, null, Long.valueOf(161L), Long.valueOf(151L), null, null, thirdId.toString(), null));
            resultMap.put("hotSale", this.channelGoodsService.selectchannelStoreyGoodsByParamForSite(String.valueOf(temp.getTempId()), null, thirdId.toString()));
            resultMap.put("floor", this.siteService.getStoreys(Long.valueOf(temp.getTempId()), thirdId));
            List thirdCate = this.thirdCateService.getAllCalcThirdCate(thirdId);
            resultMap.put(THIRDCATE, thirdCate);
            if (searchBean.getCateId() == null) {
                searchBean.setCateId(0L);
            }
            resultMap.put(NOWCATE, this.thirdCateService.queryThirdCateById(searchBean.getCateId()));
            Long distinctId = null;
            searchBean.setTitle(searchBean.getTitle().replace("\"", "").replace("'", "").trim());
            Map dataMap = this.goodsService.thirdGoodsListEs(pb, searchBean, distinctId, thirdId, null);
            resultMap.put(COMMENT, this.commentService.selectSellerComment(thirdId));
            resultMap.put(STOREINFO, this.siteService.selectByThirdId(thirdId));
            resultMap.put(SEARCH, searchBean);
            resultMap.put(THIRDID, thirdId);
            mav.addObject("map", resultMap);
            mav.addObject("data", (Object)dataMap);
            mav.setViewName("thirdseller/es_newStoreIndex");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("pc\u7aef\u7b2c\u4e09\u65b9\u5e97\u94fa\u9996\u9875\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"/storegoodslist"})
    public ModelAndView storeGoodsList(HttpServletRequest request, HttpServletResponse response, Long thirdId, SearchPageBean<SolrGoodsInfo> pb, ThirdGoodsSearchBean searchBean) {
        ModelAndView mav = new ModelAndView("thirdseller/storeGoodsList");
        if (StringCommonUtil.checkSpecialCharacter((String)searchBean.getTitle())) {
            this.addCookieToSearchProduct(searchBean.getTitle(), request, response);
        }
        SysTemp temp = (SysTemp)this.thirdTempService.querySystempByType(Long.valueOf(137L)).get(0);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put(CLASSBAR, this.classifyBarService.selectClassifyBarByParamSite(Long.valueOf(temp.getTempId()), null, thirdId.toString()));
        resultMap.put(PAGEADVS, this.channelAdverService.selectchannelAdverByParamForSite(null, Long.valueOf(temp.getTempId()), null, null, Long.valueOf(161L), Long.valueOf(151L), null, null, thirdId.toString(), null));
        resultMap.put(THIRDCATE, this.thirdCateService.getAllCalcThirdCate(thirdId));
        if (searchBean.getCateId() != null) {
            resultMap.put(NOWCATE, this.thirdCateService.queryThirdCateById(searchBean.getCateId()));
        }
        Long distinctId = null;
        resultMap.put(COMMENT, this.commentService.selectSellerComment(thirdId));
        resultMap.put(STOREINFO, this.siteService.selectByThirdId(thirdId));
        resultMap.put("distinctId", distinctId);
        Map dataMap = this.goodsService.thirdGoodsListEs(pb, searchBean, distinctId, thirdId, null);
        resultMap.put("pb", pb);
        resultMap.put(SEARCH, searchBean);
        resultMap.put(THIRDID, thirdId);
        return this.topAndBottomService.getTopAndBottom(mav).addObject("map", resultMap).addObject("data", (Object)dataMap);
    }

    private void addCookieToSearchProduct(String title, HttpServletRequest request, HttpServletResponse response) {
        String list = null;
        try {
            Cookie cookie = NpCookieUtil.getCookieByName(request, "searchProduct");
            if (null != cookie) {
                list = URLDecoder.decode(cookie.getValue(), "utf-8");
                if (list.indexOf(title) == -1) {
                    list = title + "," + list;
                }
            } else {
                list = title + ",";
            }
            int maxAge = 259200;
            NpCookieUtil.addCookie(response, "searchProduct", list, maxAge);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5728cookie\u91cc\u6dfb\u52a0\u641c\u7d22\u8bb0\u5f55\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
    }
}

