/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.customer.controller;

import com.qianjiang.common.util.FeedBackEmail;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.customer.vo.FreeBackVo;
import com.qianjiang.index.service.TopAndBottomService;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.util.MyLogger;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class FreeBackController {
    private CustomerServiceMapper customerServiceInterface;
    private BasicSetService basicSetService;
    private FeedBackEmail feedBacKEmail;
    private static final MyLogger LOGGER = new MyLogger(FreeBackController.class);
    private TopAndBottomService topAndBottomService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"customer/feedback"})
    public ModelAndView feedback(HttpServletRequest request) {
        ModelAndView mav = null;
        HashMap<String, CustomerAllInfo> resultMap = new HashMap<String, CustomerAllInfo>();
        Long customerId = null;
        try {
            if (this.checkLoginStatus(request)) {
                customerId = (Long)request.getSession().getAttribute("customerId");
                CustomerAllInfo customerAllInfo = this.customerServiceInterface.selectByPrimaryKey(customerId);
                if (null != customerAllInfo.getCustomerUsername()) {
                    LOGGER.info((Object)("\u8df3\u8f6c\u5230\u4f1a\u5458\u3010" + customerAllInfo.getCustomerUsername() + "\u3011\u7684\u7528\u6237\u53cd\u9988\u9875\u9762"));
                }
                resultMap.put("customer", this.customerServiceInterface.queryCustomerById(customerId));
                mav = new ModelAndView("customer/feedback");
                mav.addAllObjects(resultMap);
            } else {
                mav = new ModelAndView("/login/redirect").addObject("url", (Object)"/customer/securitycenter.html");
            }
            ModelAndView modelAndView = this.topAndBottomService.getTopAndBottom(mav);
            return modelAndView;
        }
        finally {
            mav = null;
            resultMap = null;
            customerId = null;
        }
    }

    @RequestMapping(value={"/sendemailuser"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Object sendEmailToStore(HttpServletRequest request, @Valid FreeBackVo freeBack) {
        if (this.checkLoginStatus(request)) {
            return this.feedBacKEmail.sendToStore(this.basicSetService.findBasicSet().getBsetEmail(), "\u6765\u81ea\u7528\u6237" + freeBack.getFeedbackname() + "\u7684\u53cd\u9988\uff1a<br/>\u53cd\u9988\u5185\u5bb9\u5173\u4e8e\uff1a" + freeBack.getFeedbacktype() + "<br/>\u53cd\u9988\u5185\u5bb9\u4e3a\uff1a" + freeBack.getFeedbackcontent());
        }
        return -1;
    }

    private boolean checkLoginStatus(HttpServletRequest request) {
        return request.getSession().getAttribute("cust") != null;
    }

    public TopAndBottomService getTopAndBottomService() {
        return this.topAndBottomService;
    }

    @Resource(name="TopAndBottomService")
    public void setTopAndBottomService(TopAndBottomService topAndBottomService) {
        this.topAndBottomService = topAndBottomService;
    }

    public CustomerServiceMapper getCustomerServiceInterface() {
        return this.customerServiceInterface;
    }

    @Resource(name="customerServiceMapper")
    public void setCustomerServiceInterface(CustomerServiceMapper customerServiceInterface) {
        this.customerServiceInterface = customerServiceInterface;
    }

    public FeedBackEmail getFeedBacKEmail() {
        return this.feedBacKEmail;
    }

    @Resource(name="feedBackEmail")
    public void setFeedBacKEmail(FeedBackEmail feedBacKEmail) {
        this.feedBacKEmail = feedBacKEmail;
    }

    public BasicSetService getBasicSetService() {
        return this.basicSetService;
    }

    @Resource(name="basicSetService")
    public void setBasicSetService(BasicSetService basicSetService) {
        this.basicSetService = basicSetService;
    }
}

