/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.information;

import com.qianjiang.index.service.TopAndBottomService;
import com.qianjiang.information.bean.Information;
import com.qianjiang.information.bean.InformationOnePage;
import com.qianjiang.information.bean.InformationType;
import com.qianjiang.information.service.InfoUserDefinedService;
import com.qianjiang.information.service.InformationOnePageService;
import com.qianjiang.information.service.InformationService;
import com.qianjiang.information.service.InformationTypeService;
import com.qianjiang.information.vo.InformationTypeVo;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.SelectBean;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class InformationSiteController {
    private static final MyLogger LOGGER = new MyLogger(InformationSiteController.class);
    private static final String BASICSET = "basicSet";
    private InformationService infoService;
    private InformationTypeService infoTypeService;
    private InfoUserDefinedService infoUDService;
    private InformationOnePageService infoOPService;
    private BasicSetService basicSetService;
    @Resource(name="TopAndBottomService")
    private TopAndBottomService topAndBottomService;

    @ResponseBody
    @RequestMapping(value={"/queryInfoOPByTagId"}, produces={"application/json;charset=UTF-8"})
    public List<InformationOnePage> queryInfoOPByTagId(HttpServletRequest request, HttpServletResponse response, Long tempId, Long infoOPTagId) {
        return this.infoOPService.selectInfoOPByTempAndTag(tempId, infoOPTagId);
    }

    @RequestMapping(value={"/queryInfoList"})
    public ModelAndView queryInfoList(HttpServletRequest request, HttpServletResponse response, PageBean pb, Long typeId, String infoName, Integer pageNo) throws UnsupportedEncodingException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        SelectBean selectBean = new SelectBean();
        if (null != infoName && !"".equals(infoName)) {
            String name = new String(infoName.getBytes("ISO-8859-1"), "utf-8");
            if (!"\u6587\u7ae0\u540d\u79f0".equals(name)) {
                selectBean.setSearchText(name);
                selectBean.setCondition("1");
                map.put("infoName", name);
            }
        } else {
            selectBean.setCondition("");
        }
        List infoTypes = this.infoTypeService.selectAll();
        for (int i = 0; i < infoTypes.size(); ++i) {
            InformationTypeVo infoType = (InformationTypeVo)infoTypes.get(i);
            if (infoType.getGrade() == 1) continue;
            infoTypes.remove(infoType);
            --i;
        }
        map.put("infoTypes", infoTypes);
        if (null != typeId && typeId != -1L) {
            InformationType cInfoType = this.infoTypeService.selectByPrimaryKey(typeId);
            if (null != cInfoType) {
                map.put("cInfoType", cInfoType);
            }
            pb.setUrl("information/list/typeId=" + typeId);
        } else {
            pb.setUrl("information/list/");
        }
        if (null != pageNo) {
            pb.setPageNo(pageNo.intValue());
        }
        map.put("pb", this.infoService.queryByPageBeanForSite(pb, selectBean, typeId));
        map.put(BASICSET, this.basicSetService.findBasicSet());
        ModelAndView mav = new ModelAndView();
        mav.setViewName("information/infolist");
        mav.addObject("map", map);
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"/showInfo"})
    public ModelAndView toHelpCenter(HttpServletRequest request, HttpServletResponse response, Long infoId) {
        ModelAndView mav = new ModelAndView();
        List list = this.infoTypeService.selectAll();
        for (int i = 0; i < list.size(); ++i) {
            InformationTypeVo infoType = (InformationTypeVo)list.get(i);
            if (infoType.getGrade() == 1) continue;
            list.remove(infoType);
            --i;
        }
        Information info = new Information();
        InformationType cInfoType = new InformationType();
        if (infoId != null) {
            info = this.infoService.selectByPrimaryKey(infoId);
            if (null != info) {
                cInfoType = this.infoTypeService.selectByPrimaryKey(info.getInfoTypeId());
            } else {
                return new ModelAndView((View)new RedirectView("list/"));
            }
        }
        mav.setViewName("information/infodetail");
        mav.addObject(BASICSET, (Object)this.basicSetService.findBasicSet());
        mav.addObject("infoTypes", (Object)list);
        mav.addObject("info", (Object)info);
        mav.addObject("cInfoType", (Object)cInfoType);
        if (null != info.getTitle()) {
            LOGGER.info((Object)("\u663e\u793a\u6807\u9898\u4e3a\u3010" + info.getTitle() + "\u3011\u6587\u7ae0"));
        }
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"/showOnePage"})
    public ModelAndView showOnePage(Long infoOPId) {
        if (infoOPId != null) {
            InformationOnePage informationOnePage = this.infoOPService.getInfoOnePageByID(infoOPId);
            ModelAndView mav = new ModelAndView();
            mav.setViewName("information/one_page_detail");
            mav.addObject("onePage", (Object)informationOnePage);
            mav.addObject(BASICSET, (Object)this.basicSetService.findBasicSet());
            if (null != informationOnePage.getTitle()) {
                LOGGER.info((Object)("\u663e\u793a\u6807\u9898\u4e3a\u3010" + informationOnePage.getTitle() + "\u3011\u5355\u9875"));
            }
            return this.topAndBottomService.getTopAndBottom(mav);
        }
        return new ModelAndView((View)new RedirectView("index.html"));
    }

    public InformationService getInfoService() {
        return this.infoService;
    }

    @Resource(name="InformationService")
    public void setInfoService(InformationService infoService) {
        this.infoService = infoService;
    }

    public InformationTypeService getInfoTypeService() {
        return this.infoTypeService;
    }

    @Resource(name="InformationTypeService")
    public void setInfoTypeService(InformationTypeService infoTypeService) {
        this.infoTypeService = infoTypeService;
    }

    public InfoUserDefinedService getInfoUDService() {
        return this.infoUDService;
    }

    @Resource(name="InfoUserDefinedService")
    public void setInfoUDService(InfoUserDefinedService infoUDService) {
        this.infoUDService = infoUDService;
    }

    public BasicSetService getBasicSetService() {
        return this.basicSetService;
    }

    @Resource(name="basicSetService")
    public void setBasicSetService(BasicSetService basicSetService) {
        this.basicSetService = basicSetService;
    }

    public InformationOnePageService getInfoOPService() {
        return this.infoOPService;
    }

    @Resource(name="InformationOnePageService")
    public void setInfoOPService(InformationOnePageService infoOPService) {
        this.infoOPService = infoOPService;
    }
}

