/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.marketingrush.controller;

import com.qianjiang.channel.service.ChannelAdverService;
import com.qianjiang.customer.bean.CustomerAddress;
import com.qianjiang.goods.bean.GoodsDetailBean;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.goods.service.GoodsReleTagService;
import com.qianjiang.index.service.TopAndBottomService;
import com.qianjiang.order.service.OrderViceService;
import com.qianjiang.promotion.bean.Promotion;
import com.qianjiang.promotion.service.PromotionService;
import com.qianjiang.site.goods.service.BrowerService;
import com.qianjiang.site.goods.service.GoodsProductService1;
import com.qianjiang.site.marketingrush.bean.MarketingRushUtil;
import com.qianjiang.site.marketingrush.service.MarketingRushService;
import com.qianjiang.site.shoppingcart.service.ShoppingCartService;
import com.qianjiang.system.service.PayService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class MarketingRushSiteController {
    private static final String CHADDRESS = "chAddress";
    private static final String CHPROVINCE = "chProvince";
    private static final String CHCITY = "chCity";
    private static final String CHDISTINCT = "chDistinct";
    private static final String ISO_8859_1 = "ISO-8859-1";
    private static final String UTF_8 = "utf-8";
    private static final String DISTINCTID = "distinctId";
    private static final Long ATID1 = 157L;
    private static final Long ADVERTTYPE = 151L;
    private static final MyLogger LOGGER = new MyLogger(MarketingRushSiteController.class);
    @Resource(name="MarketingRushService")
    private MarketingRushService marketingRushService;
    @Resource(name="payService")
    private PayService payService;
    @Resource(name="OrderViceService")
    private OrderViceService orderViceService;
    @Resource(name="MarketingService")
    private PromotionService marketingService;
    @Resource(name="BrowerService")
    private BrowerService browerService;
    @Resource(name="ShoppingCartService1")
    private ShoppingCartService cartService;
    @Resource(name="TopAndBottomService")
    private TopAndBottomService topAndBottomService;
    @Resource(name="GoodsProductService")
    private GoodsProductService goodsProductService;
    @Resource(name="ChannelAdverService")
    private ChannelAdverService channelAdverService;
    @Resource(name="GoodsReleTagService")
    private GoodsReleTagService goodsReleTagService;
    @Autowired
    private GoodsProductService1 goodsProductServiceBean;

    @RequestMapping(value={"selectmrlist"})
    public ModelAndView selectMarketingRushList(PageBean pb, HttpServletRequest request) {
        PageBean pb1 = pb;
        pb1.setPageSize(15);
        Long distinctId = Long.parseLong(request.getSession().getAttribute(DISTINCTID).toString());
        pb1 = this.goodsProductServiceBean.selectMarketingRushList(pb1, distinctId);
        pb1.setUrl("marketingrushlist");
        int tempId = this.topAndBottomService.getIndexDefalutTemp().getTempId();
        ModelAndView mav = new ModelAndView("marketingrush/marketingrushlist").addObject("pb", (Object)pb1).addObject("avs", (Object)this.channelAdverService.selectchannelAdverByParamForSite(null, Long.valueOf(tempId), null, null, ATID1, ADVERTTYPE, null, "0", null, "6"));
        LOGGER.info((Object)"\u83b7\u53d6\u62a2\u8d2d\u79d2\u6740\u5217\u8868");
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/marketingrush"})
    public ModelAndView goodsDetail(Long productId, Long distinctId, String chAddress, HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException {
        Long distinctId1 = distinctId;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null == distinctId1) {
            if (null != request.getSession().getAttribute("address") && null == request.getSession().getAttribute(CHADDRESS)) {
                distinctId1 = ((CustomerAddress)request.getSession().getAttribute("address")).getDistrict().getDistrictId();
                map.put(CHADDRESS, ((CustomerAddress)request.getSession().getAttribute("address")).getProvince().getProvinceName() + ((CustomerAddress)request.getSession().getAttribute("address")).getCity().getCityName() + ((CustomerAddress)request.getSession().getAttribute("address")).getDistrict().getDistrictName());
                map.put(CHPROVINCE, ((CustomerAddress)request.getSession().getAttribute("address")).getProvince().getProvinceName());
                map.put(CHCITY, ((CustomerAddress)request.getSession().getAttribute("address")).getCity().getCityName());
                map.put(CHDISTINCT, ((CustomerAddress)request.getSession().getAttribute("address")).getDistrict().getDistrictName());
            } else if (null == request.getSession().getAttribute(CHADDRESS)) {
                distinctId1 = new Long(749L);
                map.put(CHADDRESS, null == chAddress ? "\u4e0a\u6d77\u5f90\u6c47\u533a" : new String(chAddress.getBytes(ISO_8859_1), UTF_8));
                map.put(CHPROVINCE, "\u4e0a\u6d77");
                map.put(CHCITY, "\u4e0a\u6d77\u5e02");
                map.put(CHDISTINCT, "\u5f90\u6c47\u533a");
            } else {
                map.put(CHPROVINCE, request.getSession().getAttribute(CHPROVINCE));
                map.put(CHADDRESS, request.getSession().getAttribute(CHADDRESS));
                map.put(CHCITY, request.getSession().getAttribute(CHCITY));
                map.put(CHDISTINCT, request.getSession().getAttribute(CHDISTINCT));
                distinctId1 = Long.parseLong(request.getSession().getAttribute(DISTINCTID).toString());
            }
        } else {
            map.put(CHADDRESS, new String(chAddress.getBytes(ISO_8859_1), UTF_8));
            map.put(CHPROVINCE, new String(request.getParameter(CHPROVINCE).getBytes(ISO_8859_1), UTF_8));
            map.put(CHCITY, new String(request.getParameter(CHCITY).getBytes(ISO_8859_1), UTF_8));
            map.put(CHDISTINCT, new String(request.getParameter(CHDISTINCT).getBytes(ISO_8859_1), UTF_8));
        }
        map.put(DISTINCTID, distinctId1);
        request.getSession().setAttribute(CHPROVINCE, map.get(CHPROVINCE));
        request.getSession().setAttribute(CHADDRESS, map.get(CHADDRESS));
        request.getSession().setAttribute(CHCITY, map.get(CHCITY));
        request.getSession().setAttribute(CHDISTINCT, map.get(CHDISTINCT));
        request.getSession().setAttribute(DISTINCTID, map.get(DISTINCTID));
        GoodsDetailBean detailBean = this.goodsProductService.queryDetailBeanByProductId(productId, distinctId1);
        try {
            if (null != detailBean.getProductVo()) {
                detailBean = this.cartService.forPurchasing(detailBean, (Long)request.getSession().getAttribute("customerId"));
                map.put("detailBean", detailBean);
                map.put("tags", this.goodsReleTagService.queryreleListByProductId(detailBean.getProductVo().getGoodsInfoId()));
                this.browerService.saveBrowerHis(request, response, productId);
                Promotion marketing = this.marketingService.selectRushMarket(productId, Long.valueOf(5L), detailBean.getProductVo().getGoods().getCatId(), detailBean.getBrand().getBrandId());
                String rushs = this.goodsProductServiceBean.compareTime(marketing.getMarketingBegin(), marketing.getMarketingEnd());
                ModelAndView mav = new ModelAndView("marketingrush/mrushdetails", "map", map);
                mav.addObject("market", (Object)marketing).addObject("rushTime", (Object)rushs);
                if (null != detailBean.getProductVo().getProductName()) {
                    LOGGER.info((Object)("\u8fdb\u5165\u62a2\u8d2d\u79d2\u6740\u8d27\u54c1\u3010" + detailBean.getProductVo().getProductName() + "\u3011\u8be6\u60c5\u9875"));
                }
                ModelAndView modelAndView = this.topAndBottomService.getTopAndBottom(mav);
                return modelAndView;
            }
            ModelAndView modelAndView = this.topAndBottomService.getTopAndBottom(new ModelAndView("/goods/no_exit"));
            return modelAndView;
        }
        finally {
            detailBean = null;
        }
    }

    @RequestMapping(value={"submrorder"})
    public ModelAndView subMROrder(Long productId, Long distinctId, HttpServletRequest request) {
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        if (customerId == null) {
            return new ModelAndView((View)new RedirectView("../login.html"));
        }
        MarketingRushUtil mrutil = new MarketingRushUtil();
        GoodsDetailBean detailBean = this.goodsProductService.queryDetailBeanByProductId(productId, distinctId);
        mrutil.setMarketing(this.marketingService.selectRushMarket(productId, Long.valueOf(5L), detailBean.getProductVo().getGoods().getCatId(), detailBean.getBrand().getBrandId()));
        mrutil.setGoodsProductVo(detailBean.getProductVo());
        ModelAndView mav = new ModelAndView("marketingrush/mrushorder");
        mav.addObject("rushs", (Object)mrutil);
        if (null != detailBean.getProductVo().getProductName()) {
            LOGGER.info((Object)("\u8fdb\u5165\u62a2\u8d2d\u79d2\u6740\u8d27\u54c1\u3010" + detailBean.getProductVo().getProductName() + "\u3011\u7684\u8ba2\u5355"));
        }
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"submitmrorder"})
    public ModelAndView submitGrouponOrder(HttpServletRequest request, Long custAddress, String chInvoiceTitle, String chInvoiceType, String chInvoiceContent, Long productId, Long productNum) throws UnsupportedEncodingException {
        String chInvoiceTitle1 = chInvoiceTitle;
        String chInvoiceContent1 = chInvoiceContent;
        chInvoiceTitle1 = new String(chInvoiceTitle1.getBytes(ISO_8859_1), UTF_8);
        chInvoiceContent1 = new String(chInvoiceContent1.getBytes(ISO_8859_1), UTF_8);
        String orderCode = this.marketingRushService.subMarketingRushOrder(request, custAddress, chInvoiceTitle1, chInvoiceType, chInvoiceContent1, productId, productNum);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("order", this.orderViceService.payOrder(orderCode));
        map.put("paylist", this.payService.queryAllPaySet());
        ModelAndView mav = new ModelAndView("groupon/subsuccess").addObject("map", map);
        if (null != orderCode) {
            LOGGER.info((Object)("\u63d0\u4ea4\u62a2\u8d2d\u8ba2\u5355\u3010" + orderCode + "\u3011"));
        }
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"paymrorder"})
    public ModelAndView payMROrder(String orderCode, Long payId) {
        ModelAndView mav = new ModelAndView();
        mav.addObject("sHtmlText", (Object)this.marketingRushService.payMarketingRushOrder(orderCode, payId));
        mav.setViewName("order/netbank");
        if (null != orderCode) {
            LOGGER.info((Object)("\u62a2\u8d2d\u652f\u4ed8\u8ba2\u5355\u3010" + orderCode + "\u3011"));
        }
        return this.topAndBottomService.getTopAndBottom(mav);
    }
}

