/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.register.controller;

import com.qianjiang.common.util.BaseSiteController;
import com.qianjiang.coupon.bean.CouponNo;
import com.qianjiang.coupon.service.CouponNoService;
import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.bean.RegisterPoint;
import com.qianjiang.customer.service.CustomerPointServiceMapper;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.index.service.TopAndBottomService;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.other.bean.IntegralSet;
import com.qianjiang.other.util.IPAddress;
import com.qianjiang.promotion.bean.RegisterMarketing;
import com.qianjiang.promotion.service.PromotionService;
import com.qianjiang.redis.RedisAdapter;
import com.qianjiang.redis.RedisUtil;
import com.qianjiang.site.login.service.LoginService;
import com.qianjiang.system.service.AuthService;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.util.MyLogger;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class RegisterController
extends BaseSiteController {
    private static final MyLogger LOGGER = new MyLogger(RegisterController.class);
    private static final String CUSTOMERID = "customerId";
    private static final String REGISTER_SUCCESS = "/register/success";
    Date startTime = null;
    Date endTime = null;
    int count = 0;
    int pointCount = 0;
    private CustomerServiceMapper customerServiceMapper;
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;
    private LoginService loginService;
    private CustomerPointServiceMapper customerPointServiceMapper;
    @Resource(name="MarketingService")
    private PromotionService marketingService;
    @Resource(name="CouponNoService")
    private CouponNoService couponNoService;
    private TopAndBottomService topAndBottomService;
    @Resource(name="authService")
    private AuthService authService;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceInterface;

    @RequestMapping(value={"/customer/register"})
    public ModelAndView jumpRegister() {
        ModelAndView mav = new ModelAndView();
        try {
            List findByShow = this.authService.findByShow();
            mav.addObject("t", (Object)findByShow);
            mav = this.topAndBottomService.getBottom(new ModelAndView("/register/registerfirst"));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u8df3\u8f6c\u6ce8\u518c\u9875\u9762");
        }
        return mav;
    }

    @RequestMapping(value={"/customer/registersecond"})
    public ModelAndView registersecond(HttpServletRequest request, String mobile) {
        if (request.getSession().getAttribute("mobile") != null) {
            if (mobile.equals(request.getSession().getAttribute("mobile").toString())) {
                return this.topAndBottomService.getBottom(new ModelAndView("/register/registersecond").addObject("mobile", (Object)mobile).addObject("sign", (Object)0));
            }
            return new ModelAndView((View)new RedirectView(request.getContextPath() + "/index.html"));
        }
        return new ModelAndView((View)new RedirectView(request.getContextPath() + "/index.html"));
    }

    @RequestMapping(value={"/customer/registerthird"})
    public ModelAndView registerThird(HttpServletRequest request, String checkCode) {
        if (request.getSession().getAttribute("mcCode") == null || checkCode == null) {
            return this.topAndBottomService.getBottom(new ModelAndView("/register/registersecond").addObject("sign", (Object)1));
        }
        String patchca = String.valueOf(request.getSession().getAttribute("mcCode"));
        if (!checkCode.equals(patchca)) {
            if (request.getSession().getAttribute("submitCount") == null) {
                request.getSession().setAttribute("submitCount", (Object)1);
                return this.topAndBottomService.getBottom(new ModelAndView("/register/registersecond").addObject("sign", (Object)1));
            }
            request.getSession().setAttribute("submitCount", (Object)((Integer)request.getSession().getAttribute("submitCount") + 1));
            int submitCount = (Integer)request.getSession().getAttribute("submitCount");
            if (submitCount > 5) {
                request.getSession().setAttribute("mcCode", null);
                request.getSession().setAttribute("submitCount", null);
                return this.topAndBottomService.getBottom(new ModelAndView("/register/registersecond").addObject("sign", (Object)2));
            }
            return this.topAndBottomService.getBottom(new ModelAndView("/register/registersecond").addObject("sign", (Object)1));
        }
        request.getSession().setAttribute("mcCode", null);
        if (request.getSession().getAttribute("mobile") != null) {
            String real = request.getSession().getAttribute("mobile").toString();
            if (!real.equals(request.getSession().getAttribute("userMobile").toString())) {
                return this.topAndBottomService.getBottom(new ModelAndView("/register/registersecond").addObject("mobile", (Object)real).addObject("sign", (Object)1));
            }
            return this.topAndBottomService.getBottom(new ModelAndView("/register/registerthird").addObject("mobile", (Object)real));
        }
        return new ModelAndView((View)new RedirectView(request.getContextPath() + "/index.html"));
    }

    @RequestMapping(value={"/customer/registerfourth"})
    public ModelAndView registerFourth(HttpServletRequest request) {
        if (request.getSession().getAttribute("mobile") != null) {
            String real = request.getSession().getAttribute("mobile").toString();
            return this.topAndBottomService.getBottom(new ModelAndView("/register/registerfourth").addObject("mobile", (Object)real)).addObject("cust", request.getSession().getAttribute("cust"));
        }
        return new ModelAndView((View)new RedirectView(request.getContextPath() + "/index.html"));
    }

    @RequestMapping(value={"checkRegsiter"})
    public ModelAndView checkRegsiter(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String getIp = IPAddress.getIpAddr((HttpServletRequest)request);
        PrintWriter out = response.getWriter();
        out.print(getIp);
        return null;
    }

    @RequestMapping(value={"/registerFirst"})
    public ModelAndView registerFirst(HttpServletRequest request, String mobile, String custId, String checkCode, Model model) {
        request.getSession().setAttribute("mobile", (Object)mobile);
        if (custId.equals("null")) {
            request.getSession().setAttribute("custId", null);
        } else {
            request.getSession().setAttribute("custId", (Object)custId);
        }
        String patchca = (String)request.getSession().getAttribute("PATCHCA");
        if (checkCode == null || patchca == null || !checkCode.equals(patchca)) {
            model.addAttribute("codeError", (Object)"yes");
            model.addAttribute("msg", (Object)"\u9a8c\u8bc1\u7801\u9519\u8bef");
            return this.topAndBottomService.getBottom(new ModelAndView("/register/registerfirst"));
        }
        request.getSession().setAttribute("PATCHCA", null);
        Long result = this.customerServiceMapper.checkMobileExist(mobile);
        if (result == 1L) {
            model.addAttribute("mobileError", (Object)"yes");
            model.addAttribute("msg", (Object)"\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u6ce8\u518c");
            return this.topAndBottomService.getBottom(new ModelAndView("/register/registerfirst"));
        }
        return new ModelAndView((View)new RedirectView(request.getContextPath() + "/registersecond.html")).addObject("mobile", (Object)mobile);
    }

    @RequestMapping(value={"/regsendcode"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int regsendcode(HttpServletRequest request, String mobile) throws IOException {
        if (mobile == null || "".equals(mobile)) {
            return -1;
        }
        int result = this.customerServiceInterface.sendSMS(request, mobile);
        if (result == 1) {
            return result;
        }
        return result;
    }

    @RequestMapping(value={"/checkMobileExist"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Long checkMobileNumberExist(String mobile) {
        return this.customerServiceMapper.checkMobileExist(mobile);
    }

    @RequestMapping(value={"/checkregcaptcha"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int checkCaptcha(HttpServletRequest request, String code) throws IOException {
        if (!code.equals((Integer)request.getSession().getAttribute("mcCode") + "")) {
            return 0;
        }
        return 1;
    }

    @RequestMapping(value={"/addcustNew"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int addcustNew(HttpServletRequest request, String mobile, String password, String code, String checkCode) throws IOException {
        String patchca = (String)RedisAdapter.getNew((String)RedisUtil.getRedisKeyByKeyAndParameter((String)RedisUtil.CAPTCHA, (String)request.getSession().getId()));
        if (code == null || "".equals(code) || !code.equals(patchca)) {
            return 1;
        }
        String mcCode = (String)RedisAdapter.getNew((String)RedisUtil.getRedisKeyByKeyAndParameter((String)RedisUtil.SMSCODE, (String)request.getSession().getId()));
        if (checkCode == null || "".equals(checkCode) || !checkCode.equals(mcCode)) {
            return 2;
        }
        String userMobile = (String)RedisAdapter.getNew((String)RedisUtil.getRedisKeyByKeyAndParameter((String)RedisUtil.REGISTERMOBILE, (String)request.getSession().getId()));
        if (mobile == null || "".equals(mobile) || !mobile.equals(userMobile)) {
            return 3;
        }
        Long result = this.customerServiceMapper.checkMobileExist(mobile);
        if (result == 1L) {
            return 4;
        }
        if (password == null || "".equals(password)) {
            return 5;
        }
        CustomerAllInfo allInfo = new CustomerAllInfo();
        allInfo.setCustomerUsername(mobile);
        allInfo.setCustomerPassword(password);
        allInfo.setStartRowNum(0);
        allInfo.setEndRowNum(0);
        allInfo.setInfoMobile(mobile);
        allInfo.setLoginIp(IPAddress.getIpAddr((HttpServletRequest)request));
        allInfo.setIsSeller("0");
        allInfo.setIsMobile("1");
        String pwd = allInfo.getCustomerPassword();
        int register = this.customerServiceMapper.addCustomer(allInfo);
        if (null != allInfo.getCustomerUsername() && register == 1) {
            LOGGER.info((Object)("\u4f1a\u5458\u3010" + allInfo.getCustomerUsername() + "\u3011\u6ce8\u518c\u6210\u529f\u3002"));
        }
        this.loginService.checkCustomerExists(request, allInfo.getCustomerUsername(), pwd);
        Object custId = request.getSession().getAttribute("custId");
        if (null != custId && !"".equals(custId.toString()) && register == 1) {
            Long cusId = Long.valueOf(custId.toString());
            this.customerPointServiceMapper.addIntegralByType(cusId, "5");
            this.registPoint(request, cusId, allInfo.getCustomerUsername());
        }
        this.customerPointServiceMapper.addIntegralByType(this.customerId(), "0");
        this.customerPointServiceMapper.addIntegralByType(this.customerId(), "1");
        RegisterMarketing registerMarketing = this.marketingService.findRegisterMarketing();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (registerMarketing != null && registerMarketing.getIsUsed() != null && Integer.parseInt(registerMarketing.getIsUsed()) == 1) {
            try {
                this.startTime = sdf.parse(registerMarketing.getStartTime());
                this.endTime = sdf.parse(registerMarketing.getEndTime());
            }
            catch (ParseException e) {
                // empty catch block
            }
            Date date = new Date();
            if (this.startTime.before(date) && this.endTime.after(date)) {
                this.count = this.couponNoService.selectCouponNoByStatus(registerMarketing.getRegisterCouponId());
                if (this.count > 0) {
                    CouponNo couponNo = this.couponNoService.selectNoByCouponIdByStatus(registerMarketing.getRegisterCouponId());
                    this.couponNoService.updateCouponCustomer(couponNo.getCodeId(), this.customerId());
                    ++this.pointCount;
                }
            }
        }
        return 0;
    }

    @RequestMapping(value={"/customer/addcust"})
    public ModelAndView addcust(HttpServletRequest request, @Valid CustomerAllInfo allInfo) {
        if (allInfo.getCustomerUsername() == null || allInfo.getCustomerPassword() == null) {
            throw new NullPointerException();
        }
        Object mobile = request.getSession().getAttribute("mobile");
        if (mobile != null && allInfo.getInfoMobile().equals(mobile.toString())) {
            allInfo.setLoginIp(IPAddress.getIpAddr((HttpServletRequest)request));
            allInfo.setIsSeller("0");
            allInfo.setIsMobile("1");
            Long isUsernameFlag = this.customerServiceMapper.selectCustomerByName(allInfo.getCustomerUsername());
            if (isUsernameFlag == 0L) {
                String pwd = allInfo.getCustomerPassword();
                int register = this.customerServiceMapper.addCustomer(allInfo);
                if (null != allInfo.getCustomerUsername() && register == 1) {
                    LOGGER.info((Object)("\u4f1a\u5458\u3010" + allInfo.getCustomerUsername() + "\u3011\u6ce8\u518c\u6210\u529f\u3002"));
                }
                this.loginService.checkCustomerExists(request, allInfo.getCustomerUsername(), pwd);
                Object custId = request.getSession().getAttribute("custId");
                if (null != custId && !"".equals(custId.toString()) && register == 1) {
                    Long cusId = Long.valueOf(custId.toString());
                    this.customerPointServiceMapper.addIntegralByType(cusId, "5");
                    this.registPoint(request, cusId, allInfo.getCustomerUsername());
                }
                this.customerPointServiceMapper.addIntegralByType(this.customerId(), "0");
                this.customerPointServiceMapper.addIntegralByType(this.customerId(), "1");
                RegisterMarketing registerMarketing = this.marketingService.findRegisterMarketing();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                if (registerMarketing != null && registerMarketing.getIsUsed() != null && Integer.parseInt(registerMarketing.getIsUsed()) == 1) {
                    try {
                        this.startTime = sdf.parse(registerMarketing.getStartTime());
                        this.endTime = sdf.parse(registerMarketing.getEndTime());
                    }
                    catch (ParseException e) {
                        // empty catch block
                    }
                    Date date = new Date();
                    if (this.startTime.before(date) && this.endTime.after(date)) {
                        this.count = this.couponNoService.selectCouponNoByStatus(registerMarketing.getRegisterCouponId());
                        if (this.count > 0) {
                            CouponNo couponNo = this.couponNoService.selectNoByCouponIdByStatus(registerMarketing.getRegisterCouponId());
                            this.couponNoService.updateCouponCustomer(couponNo.getCodeId(), this.customerId());
                            ++this.pointCount;
                        }
                    }
                    return new ModelAndView((View)new RedirectView(request.getContextPath() + "/success.html"));
                }
                return new ModelAndView((View)new RedirectView(request.getContextPath() + "/registerfourth.html"));
            }
            return new ModelAndView((View)new RedirectView(request.getContextPath() + "/index.html"));
        }
        return new ModelAndView((View)new RedirectView(request.getContextPath() + "/index.html"));
    }

    @RequestMapping(value={"/customer/addcustomer"})
    public ModelAndView register(HttpServletRequest request, @Valid CustomerAllInfo allInfo, Long cusId, String user, String psd, String varification) {
        if (allInfo.getCustomerUsername() == null || allInfo.getCustomerPassword() == null) {
            throw new NullPointerException();
        }
        allInfo.setLoginIp(IPAddress.getIpAddr((HttpServletRequest)request));
        allInfo.setIsSeller("0");
        Long isUsernameFlag = this.customerServiceMapper.selectCustomerByName(allInfo.getCustomerUsername());
        String patchca = (String)request.getSession().getAttribute("PATCHCA");
        if (isUsernameFlag == 0L && patchca.equals(varification)) {
            boolean regMarketingEnable;
            String userpwd = allInfo.getCustomerPassword();
            int register = this.customerServiceMapper.addCustomer(allInfo);
            if (null != allInfo.getCustomerUsername() && register == 1) {
                LOGGER.info((Object)("\u4f1a\u5458\u3010" + allInfo.getCustomerUsername() + "\u3011\u6ce8\u518c\u6210\u529f\u3002"));
            }
            this.loginService.checkCustomerExists(request, allInfo.getCustomerUsername(), userpwd);
            RegisterMarketing registerMarketing = this.marketingService.findRegisterMarketing();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                this.startTime = sdf.parse(registerMarketing.getStartTime());
                this.endTime = sdf.parse(registerMarketing.getEndTime());
            }
            catch (ParseException e) {
                // empty catch block
            }
            Date date = new Date();
            boolean bl = regMarketingEnable = registerMarketing != null && registerMarketing.getIsUsed() != null && Integer.parseInt(registerMarketing.getIsUsed()) == 1;
            if (null != cusId && register == 1) {
                this.customerPointServiceMapper.addIntegralByType(cusId, "5");
                this.registPoint(request, cusId, allInfo.getCustomerUsername());
            }
            if (regMarketingEnable && this.startTime.before(date) && this.endTime.after(date)) {
                this.customerPointServiceMapper.addIntegralByType(this.customerId(), "0");
                ++this.pointCount;
            } else {
                this.customerPointServiceMapper.updateIntegralById(Integer.valueOf(0));
                this.customerPointServiceMapper.addIntegralByType(this.customerId(), "0");
            }
            if (regMarketingEnable) {
                if (this.startTime.before(date) && this.endTime.after(date)) {
                    this.count = this.couponNoService.selectCouponNoByStatus(registerMarketing.getRegisterCouponId());
                    if (this.count > 0) {
                        CouponNo couponNo = this.couponNoService.selectNoByCouponIdByStatus(registerMarketing.getRegisterCouponId());
                        this.couponNoService.updateCouponCustomer(couponNo.getCodeId(), this.customerId());
                    }
                } else if (registerMarketing.getRegisterIntegral() != null && registerMarketing.getRegisterIntegral() > 0L) {
                    this.customerPointServiceMapper.updateIntegralById(Integer.valueOf(0));
                }
            }
            return new ModelAndView((View)new RedirectView(request.getContextPath() + "/success.html"));
        }
        return new ModelAndView((View)new RedirectView(request.getContextPath() + "/index.html"));
    }

    protected int registPoint(HttpServletRequest request, Long customerId, String customerUsername) {
        int result = 0;
        IntegralSet inte = this.customerPointServiceMapper.findPointSet();
        Customer customer = this.customerPointServiceMapper.selectCusById(customerId);
        RegisterPoint point = new RegisterPoint();
        point.setRegPointReferee(customer.getCustomerUsername());
        point.setRegPointRecom(customerUsername);
        point.setRegPointNumber(inte.getPsetUser());
        point.setRegPointTime(new Date());
        result = this.customerPointServiceMapper.insertRegisterPoint(point);
        if (null != customer.getCustomerUsername() && null != customerUsername && 1 == result) {
            LOGGER.info((Object)("\u4f1a\u5458\u3010" + customer.getCustomerUsername() + "\u3011\u63a8\u8350\u7528\u6237\u3010" + customerUsername + "\u3011\u6ce8\u518c\u6210\u529f\uff0c\u5e76\u4e14\u6210\u529f\u83b7\u53d6\u79ef\u5206\u5956\u52b1\uff01"));
        }
        return result;
    }

    @RequestMapping(value={"/customer/success"})
    public ModelAndView success(HttpServletRequest request) {
        RegisterMarketing registerMarketing = this.marketingService.findRegisterMarketing();
        if (this.count > 0 || this.pointCount > 0) {
            if (Integer.parseInt(registerMarketing.getIsUsed()) == 1) {
                Date date = new Date();
                if (this.startTime.before(date) && this.endTime.after(date)) {
                    return this.topAndBottomService.getBottom(new ModelAndView("/register/registersuc").addObject("registerIntegral", (Object)registerMarketing.getRegisterIntegral()).addObject("basicSet", (Object)this.basicSetService.findBasicSet()).addObject("couponId", (Object)registerMarketing.getRegisterCouponId()));
                }
                return new ModelAndView((View)new RedirectView(request.getContextPath() + "/registerfourth.html"));
            }
            return new ModelAndView((View)new RedirectView(request.getContextPath() + "/registerfourth.html"));
        }
        return new ModelAndView((View)new RedirectView(request.getContextPath() + "/registerfourth.html"));
    }

    public CustomerServiceMapper getCustomerServiceMapper() {
        return this.customerServiceMapper;
    }

    @Resource(name="customerServiceMapper")
    public void setCustomerServiceMapper(CustomerServiceMapper customerServiceMapper) {
        this.customerServiceMapper = customerServiceMapper;
    }

    public LoginService getLoginService() {
        return this.loginService;
    }

    @Resource(name="LoginService")
    public void setLoginService(LoginService loginService) {
        this.loginService = loginService;
    }

    public CustomerPointServiceMapper getCustomerPointServiceMapper() {
        return this.customerPointServiceMapper;
    }

    @Resource(name="customerPointServiceMapper")
    public void setCustomerPointServiceMapper(CustomerPointServiceMapper customerPointServiceMapper) {
        this.customerPointServiceMapper = customerPointServiceMapper;
    }

    public TopAndBottomService getTopAndBottomService() {
        return this.topAndBottomService;
    }

    @Resource(name="TopAndBottomService")
    public void setTopAndBottomService(TopAndBottomService topAndBottomService) {
        this.topAndBottomService = topAndBottomService;
    }
}

