/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.common.util;

import com.qianjiang.system.bean.EmailServer;
import com.qianjiang.system.service.EmailServerService;
import com.qianjiang.util.MyLogger;
import java.util.Date;
import java.util.Properties;
import javax.annotation.Resource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.springframework.stereotype.Service;

@Service(value="feedBackEmail")
public class FeedBackEmail {
    public static final MyLogger LOGGER = new MyLogger(FeedBackEmail.class);
    private static EmailServer emailServer;
    private EmailServerService emailServerMapper;

    public EmailServerService getEmailServerMapper() {
        return this.emailServerMapper;
    }

    @Resource(name="emailServerService")
    public void setEmailServerMapper(EmailServerService emailServerMapper) {
        this.emailServerMapper = emailServerMapper;
    }

    public int sendToStore(String toEmail, String content) {
        Session session = this.getSession();
        try {
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(emailServer.getSmtpaccount()));
            InternetAddress[] address = new InternetAddress[]{new InternetAddress(toEmail)};
            msg.setRecipients(Message.RecipientType.TO, (Address[])address);
            msg.setSubject("\u7528\u6237\u53cd\u9988");
            msg.setSentDate(new Date());
            msg.setContent((Object)content, "text/html;charset=gbk");
            Transport.send((Message)msg);
            return 1;
        }
        catch (Exception mex) {
            LOGGER.error("", (Throwable)mex);
            return 0;
        }
    }

    public Session getSession() {
        emailServer = this.emailServerMapper.selectEmailServer();
        Properties props = new Properties();
        props.setProperty("mail.transport.protocol", "smtp");
        props.setProperty("mail.smtp.host", emailServer.getSmtpserver());
        props.setProperty("mail.smtp.port", emailServer.getSmtpport());
        props.setProperty("mail.smtp.auth", "true");
        props.put("mail.smtp.socketFactory.fallback", "true");
        return Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(emailServer.getSmtpaccount(), emailServer.getSmtppass());
            }
        });
    }
}

