/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.customer.controller;

import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.bean.CustomerPoint;
import com.qianjiang.customer.bean.CustomerPointLevel;
import com.qianjiang.customer.bean.RegisterPoint;
import com.qianjiang.customer.service.CustomerPointServiceMapper;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.customer.service.PointLevelServiceMapper;
import com.qianjiang.customer.util.DateUtil;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import net.sf.json.JSONArray;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class CustomerPointController {
    private static final String PAGEBEAN = "pageBean";
    private static final String QUERYCUSTPOINTBYCUSTPOINT = "querycustpointbycustpoint.htm";
    private static final String LOGGERINFO1 = "\u67e5\u8be2\u63a8\u8350\u4eba\uff1a";
    private static final String LOGGERINFO2 = "\u7684\u63a8\u5e7f\u8fd4\u79ef\u5206\u8bb0\u5f55";
    private CustomerPointServiceMapper customerPointServiceMapper;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceMapper;
    @Resource(name="pointLevelServiceMapper")
    private PointLevelServiceMapper pointLevelServiceMapper;
    private static final MyLogger LOGGER = new MyLogger(CustomerPointController.class);

    @RequestMapping(value={"/initcustomerpoint"})
    public ModelAndView initCustomerPoint(PageBean pageBean) {
        pageBean.setUrl("initcustomerpoint.htm");
        return new ModelAndView("jsp/customer/customerpoint").addObject(PAGEBEAN, (Object)this.customerPointServiceMapper.selectAllCustomerPoint(pageBean));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/deletecustomerpoint"})
    public ModelAndView deleteCustomerPoint(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pr = null;
        try {
            pr = response.getWriter();
            pr.print(this.customerPointServiceMapper.deleteCustomerPoint(request.getParameterValues("parameterIds[]")));
        }
        finally {
            LOGGER.debug("\u5220\u9664\u4f1a\u5458\u79ef\u5206");
            pr = null;
        }
        return null;
    }

    @RequestMapping(value={"/deletenewcustomerpoint"})
    public ModelAndView deleteNewCustomerPoint(HttpServletRequest request, HttpServletResponse response, Long pointId) throws IOException {
        String[] pointIds = new String[]{"" + pointId + ""};
        this.customerPointServiceMapper.deleteCustomerPoint(pointIds);
        return new ModelAndView((View)new RedirectView(QUERYCUSTPOINTBYCUSTPOINT));
    }

    @RequestMapping(value={"/deletenewallcustomerpoint"})
    public ModelAndView deleteNewAllCustomerPoint(HttpServletRequest request, HttpServletResponse response, Long pointId) throws IOException {
        String[] pointIds = request.getParameterValues("pointId");
        this.customerPointServiceMapper.deleteCustomerPoint(pointIds);
        return new ModelAndView((View)new RedirectView(QUERYCUSTPOINTBYCUSTPOINT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/querycustpointbycustpoint"})
    public ModelAndView queryCustPointByCustPoint(@Valid CustomerPoint point, PageBean pageBean, String createTimeF, String createTimeT, String showFlag, String[] attr) throws ParseException {
        pageBean.setUrl(QUERYCUSTPOINTBYCUSTPOINT);
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            point.setCreateTime(createTimeF == null || "".equals(createTimeF) ? null : formatDate.parse(createTimeF));
            point.setCreateTimeTo(createTimeT == null || "".equals(createTimeT) ? null : DateUtil.getLastTime((Date)formatDate.parse(createTimeT)));
            resultMap.put(PAGEBEAN, this.customerPointServiceMapper.selectCustPointByCustPoint(point, pageBean));
            resultMap.put("showFlag", showFlag);
            resultMap.put("attr", attr);
            resultMap.put("point", point);
            ModelAndView modelAndView = new ModelAndView("jsp/customer/customerpoint").addAllObjects(resultMap).addObject("logindatet", (Object)createTimeF).addObject("logindateto", (Object)createTimeT);
            return modelAndView;
        }
        finally {
            formatDate = null;
            resultMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/queryregisterpoint"})
    public ModelAndView queryregisterpoint(@Valid RegisterPoint registerPoint, PageBean pageBean) throws ParseException {
        pageBean.setUrl("queryregisterpoint.htm");
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            if (null != registerPoint.getCreateTimeF() && !"".equals(registerPoint.getCreateTimeF())) {
                Date createTimeF = formatDate.parse(registerPoint.getCreateTimeF());
                registerPoint.setStartTime(createTimeF);
            }
            if (null != registerPoint.getCreateTimeT() && !"".equals(registerPoint.getCreateTimeT())) {
                Date createTimeT = DateUtil.getLastTime((Date)formatDate.parse(registerPoint.getCreateTimeT()));
                registerPoint.setEndTime(createTimeT);
            }
            resultMap.put("point", registerPoint);
            resultMap.put(PAGEBEAN, this.customerPointServiceMapper.queryregisterpoint(registerPoint, pageBean));
            if (null != registerPoint.getRegPointReferee()) {
                LOGGER.info((Object)(LOGGERINFO1 + registerPoint.getRegPointReferee() + LOGGERINFO2));
            }
            if (null != registerPoint.getRegPointRecom()) {
                LOGGER.info((Object)(LOGGERINFO1 + registerPoint.getRegPointRecom() + LOGGERINFO2));
            }
            if (null != registerPoint.getRegPointReferee()) {
                LOGGER.info((Object)(LOGGERINFO1 + registerPoint.getRegPointReferee() + LOGGERINFO2));
            }
            ModelAndView modelAndView = new ModelAndView("jsp/customer/registerpoint").addAllObjects(resultMap);
            return modelAndView;
        }
        finally {
            formatDate = null;
            resultMap = null;
        }
    }

    @RequestMapping(value={"/tomemberLevel"})
    public ModelAndView tomemberLevel(HttpServletRequest request, PageBean pageBean, Long pointLevelId, String customerNickname) {
        pageBean.setUrl("tomemberLevel.htm");
        List levelList = this.pointLevelServiceMapper.selectAllPointLevel();
        ArrayList<String> lList = new ArrayList<String>();
        for (int i = 0; i < levelList.size(); ++i) {
            CustomerPointLevel cpl = (CustomerPointLevel)levelList.get(i);
            lList.add(cpl.getPointLevelName());
        }
        JSONArray levelLists = JSONArray.fromObject(lList);
        List<Customer> customers = this.getCustomerInfo();
        List cusList = this.customerServiceMapper.queryCusLevleInfos(customers, levelList);
        ArrayList<String> cList = new ArrayList<String>();
        for (int i = 0; i < cusList.size(); ++i) {
            Customer cus = (Customer)cusList.get(i);
            String levelName = cus.getPointLevelName();
            if (levelName == null) {
                levelName = "\u5176\u4ed6";
            }
            cList.add("{value:" + cus.getLevelCount() + ",name:'" + levelName + "'}");
        }
        JSONArray cusLists = JSONArray.fromObject(cList);
        HashMap resultMap = new HashMap();
        resultMap.put("levelList", levelList);
        resultMap.put("cusList", cusList);
        resultMap.put("levelLists", levelLists);
        resultMap.put("cusLists", cusLists);
        request.setAttribute("pId", (Object)pointLevelId);
        request.setAttribute("customerNickname", (Object)customerNickname);
        return new ModelAndView("jsp/customer/member_level").addAllObjects(resultMap);
    }

    private List<Customer> getCustomerInfo() {
        return this.customerServiceMapper.getCustomerInfo();
    }

    @RequestMapping(value={"/upCusLevel"})
    public ModelAndView upCusLevel(Long customerId, String pointLevelId, String pointLevelName) {
        if (null != customerId) {
            CustomerAllInfo customerAllInfo = this.customerServiceMapper.queryCustomerInfo(customerId);
            LOGGER.info((Object)("\u624b\u52a8\u66f4\u65b0\u4f1a\u5458\u3010" + customerAllInfo.getInfoRealname() + "\u3011\u7b49\u7ea7"));
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("customerId", customerId);
        paramMap.put("pointLevelId", pointLevelId);
        paramMap.put("pointLevelName", pointLevelName);
        this.customerServiceMapper.upCusLevel(paramMap);
        return new ModelAndView((View)new RedirectView("tomemberLevel.htm"));
    }

    public CustomerPointServiceMapper getCustomerPointServiceMapper() {
        return this.customerPointServiceMapper;
    }

    @Resource(name="customerPointServiceMapper")
    public void setCustomerPointServiceMapper(CustomerPointServiceMapper customerPointServiceMapper) {
        this.customerPointServiceMapper = customerPointServiceMapper;
    }
}

