/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.controller;

import com.qianjiang.excel.ImportGoods;
import com.qianjiang.goods.bean.GoodsTypeExpandParamValue;
import com.qianjiang.goods.service.GoodsTypeBrandService;
import com.qianjiang.goods.service.GoodsTypeExpandParamService;
import com.qianjiang.goods.service.GoodsTypeExpandParamValueService;
import com.qianjiang.goods.service.GoodsTypeParamService;
import com.qianjiang.goods.service.GoodsTypeService;
import com.qianjiang.goods.service.GoodsTypeSpecService;
import com.qianjiang.goods.vo.GoodsTypeExpandParamVo;
import com.qianjiang.goods.vo.GoodsTypeVo;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.util.MyLogger;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AjaxTypeController {
    private static final MyLogger LOGGER = new MyLogger(AjaxTypeController.class);
    private GoodsTypeService goodsTypeService;
    private GoodsTypeExpandParamValueService goodsTypeExpandParamValueService;
    private GoodsTypeExpandParamService goodsTypeExpandParamService;
    private GoodsTypeParamService goodsTypeParamService;
    private GoodsTypeBrandService goodsTypeBrandService;
    private GoodsTypeSpecService goodsTypeSpecService;
    private ImportGoods importGoods;

    public GoodsTypeSpecService getGoodsTypeSpecService() {
        return this.goodsTypeSpecService;
    }

    @Resource(name="GoodsTypeSpecService")
    public void setGoodsTypeSpecService(GoodsTypeSpecService goodsTypeSpecService) {
        this.goodsTypeSpecService = goodsTypeSpecService;
    }

    public GoodsTypeBrandService getGoodsTypeBrandService() {
        return this.goodsTypeBrandService;
    }

    @Resource(name="GoodsTypeBrandService")
    public void setGoodsTypeBrandService(GoodsTypeBrandService goodsTypeBrandService) {
        this.goodsTypeBrandService = goodsTypeBrandService;
    }

    public GoodsTypeParamService getGoodsTypeParamService() {
        return this.goodsTypeParamService;
    }

    @Resource(name="GoodsTypeParamService")
    public void setGoodsTypeParamService(GoodsTypeParamService goodsTypeParamService) {
        this.goodsTypeParamService = goodsTypeParamService;
    }

    public GoodsTypeExpandParamService getGoodsTypeExpandParamService() {
        return this.goodsTypeExpandParamService;
    }

    @Resource(name="GoodsTypeExpandParamService")
    public void setGoodsTypeExpandParamService(GoodsTypeExpandParamService goodsTypeExpandParamService) {
        this.goodsTypeExpandParamService = goodsTypeExpandParamService;
    }

    public GoodsTypeService getGoodsTypeService() {
        return this.goodsTypeService;
    }

    @Resource(name="GoodsTypeService")
    public void setGoodsTypeService(GoodsTypeService goodsTypeService) {
        this.goodsTypeService = goodsTypeService;
    }

    public GoodsTypeExpandParamValueService getGoodsTypeExpandParamValueService() {
        return this.goodsTypeExpandParamValueService;
    }

    @Resource(name="GoodsTypeExpandParamValueService")
    public void setGoodsTypeExpandParamValueService(GoodsTypeExpandParamValueService goodsTypeExpandParamValueService) {
        this.goodsTypeExpandParamValueService = goodsTypeExpandParamValueService;
    }

    public ImportGoods getImportGoods() {
        return this.importGoods;
    }

    @Resource(name="ImportGoods")
    public void setImportGoods(ImportGoods importGoods) {
        this.importGoods = importGoods;
    }

    @RequestMapping(value={"/findTypeVoByTypeId"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public GoodsTypeVo queryByTypeId(Long typeId) {
        GoodsTypeVo goodsTypeVo = this.goodsTypeService.queryTypeVoByTypeId(typeId);
        if (null != goodsTypeVo.getTypeName()) {
            LOGGER.info((Object)("AJAX\u6839\u636e\u7c7b\u578bID\u67e5\u8be2\u7c7b\u578b\u4fe1\u606f,\u7c7b\u578b\u540d\u79f0\u4e3a\uff1a" + goodsTypeVo.getTypeName()));
        }
        return goodsTypeVo;
    }

    @RequestMapping(value={"/queryParamValueByParamId"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<GoodsTypeExpandParamValue> queryExpandParamValueByParamId(Long paramId) {
        LOGGER.info((Object)("AJAX\u6839\u636e\u6269\u5c55\u5c5e\u6027ID\u67e5\u8be2\u6269\u5c55\u5c5e\u6027\u503c\u7684\u5217\u8868\u62d3\u5c55\u5c5e\u6027ID\u662f\uff1a" + paramId));
        return this.goodsTypeExpandParamValueService.queryParamValueByParamId(paramId);
    }

    @RequestMapping(value={"/updateExpandParamValue"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int updateExpandParamValue(HttpServletRequest request) {
        LOGGER.info((Object)"\u66f4\u65b0\u5546\u54c1\u7c7b\u578b\u6269\u5c55\u5c5e\u6027\u503c");
        String[] expandParamId = request.getParameterValues("expandParamId[]");
        String[] paramIds = request.getParameterValues("paramId[]");
        String[] expandParamValueId = request.getParameterValues("expandParamValueId[]");
        String[] expandParamValueDelFlag = request.getParameterValues("expandParamValueDelFlag[]");
        String[] expandParamValueName = request.getParameterValues("expandParamValueName[]");
        String[] expandParamValueSort = request.getParameterValues("expandParamValueSort[]");
        boolean paramFlag = false;
        for (int i = 0; i < paramIds.length; ++i) {
            if (Long.parseLong(paramIds[i]) <= -1L) continue;
            paramFlag = true;
            break;
        }
        if (!paramFlag) {
            paramIds = expandParamId;
        }
        this.goodsTypeExpandParamValueService.updateParamValues(paramIds, expandParamValueId, expandParamValueDelFlag, expandParamValueName, expandParamValueSort, (String)request.getSession().getAttribute("name"));
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u66f4\u65b0\u5546\u54c1\u7c7b\u578b\u6269\u5c55\u5c5e\u6027\u503c", (String)((String)request.getSession().getAttribute("operaPath") + ",\u7528\u6237\u540d\uff1a" + (String)request.getSession().getAttribute("name")));
        return 1;
    }

    @RequestMapping(value={"/queryParamListByTypeId"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<GoodsTypeExpandParamVo> queryParamListByTypeId(Long typeId) {
        LOGGER.info((Object)("\u6839\u636e\u7c7b\u578bID\u67e5\u8be2\u6269\u5c55\u53c2\u6570,\u5546\u54c1\u7c7b\u578bID\u4e3a\uff1a" + typeId));
        return this.goodsTypeExpandParamService.queryParamListByTypeId(typeId);
    }

    @RequestMapping(value={"/queryTypeVoByCatId"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public GoodsTypeVo queryTypeVoByCatId(Long catId) {
        GoodsTypeVo goodsTypeVo = this.goodsTypeService.queryTypeVoByCatId(catId);
        if (null != goodsTypeVo.getTypeName()) {
            LOGGER.info((Object)("AJAX\u6839\u636e\u5546\u54c1\u5206\u7c7bID\u67e5\u8be2\u5546\u54c1\u7c7b\u578b,\u7c7b\u578b\u540d\u79f0\u4e3a\uff1a" + goodsTypeVo.getTypeName()));
        }
        return goodsTypeVo;
    }

    @RequestMapping(value={"/checkTypeName"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean checkTypeName(String typeName, String id) {
        boolean isCanUse = this.goodsTypeService.checkTypeName(typeName, id);
        if (isCanUse) {
            LOGGER.info((Object)("\u5546\u54c1\u7c7b\u578b\u3010" + isCanUse + "\u3011\u4e0d\u53ef\u7528\uff01"));
        }
        return isCanUse;
    }
}

