/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.controller;

import com.qianjiang.goods.bean.GoodsCate;
import com.qianjiang.goods.service.GoodsCateService;
import com.qianjiang.util.MyLogger;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AjaxCategoryController {
    private static final MyLogger LOGGER = new MyLogger(AjaxCategoryController.class);
    @Autowired
    private GoodsCateService goodsCateService;

    @RequestMapping(value={"/checkCateName"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> checkCateName(HttpServletRequest req, HttpServletResponse resp) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String catName = req.getParameter("catName").trim();
        try {
            GoodsCate goodsCate = this.goodsCateService.queryCateByCateName(catName);
            if (goodsCate == null) {
                result.put("result", true);
            } else {
                result.put("result", false);
            }
        }
        catch (Exception e) {
            result.put("result", false);
            e.printStackTrace();
            LOGGER.error("\u9a8c\u8bc1\u5206\u7c7b\u540d\u79f0\u662f\u5426\u91cd\u590d\u67e5\u8be2\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/queryCateById"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> queryByCateId(HttpServletRequest req, HttpServletResponse resp, Long catId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            GoodsCate goodsCate = this.goodsCateService.findGoodsCateById(catId);
            Long parentId = goodsCate.getCatParentId();
            GoodsCate parentGoodsCate = this.goodsCateService.findGoodsCateById(parentId);
            String parentName = parentGoodsCate.getCatName();
            Integer parentGrade = parentGoodsCate.getCatGrade();
            resultMap.put("goodsCate", goodsCate);
            resultMap.put("parentName", parentName);
            resultMap.put("parentGrade", parentGrade);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u7f16\u8f91\u5206\u7c7b\u6839\u636e\u5206\u7c7bid\u67e5\u8be2\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return resultMap;
    }
}

