/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.controller;

import com.alibaba.fastjson.JSON;
import com.qianjiang.goods.bean.GoodsBrand;
import com.qianjiang.goods.bean.PageBean;
import com.qianjiang.goods.service.GoodsBrandService;
import com.qianjiang.goods.util.SelectBean;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.system.util.BasicSetUtil;
import com.qianjiang.uploadfileset.service.UploadFileSetService;
import com.qianjiang.util.MyLogger;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AjaxBrandController {
    private static final MyLogger LOGGER = new MyLogger(AjaxBrandController.class);
    private static final String LOGGERINFO1 = "-->\u54c1\u724c\u540d\u79f0\u3010";
    private static final String LOGGERINFO2 = "\u3011,\u7528\u6237\u540d\uff1a";
    private GoodsBrandService goodsBrandService;
    @Resource(name="UploadFileSetService")
    private UploadFileSetService uploadFileSetService;
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;

    public GoodsBrandService getGoodsBrandService() {
        return this.goodsBrandService;
    }

    @Resource(name="GoodsBrandService")
    public void setGoodsBrandService(GoodsBrandService goodsBrandService) {
        this.goodsBrandService = goodsBrandService;
    }

    @RequestMapping(value={"/queryallbrand"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<GoodsBrand> queryAllBrandList() {
        LOGGER.info((Object)"\u67e5\u8be2\u6240\u6709\u7684\u5546\u54c1\u54c1\u724c");
        return this.goodsBrandService.queryAllBrand();
    }

    @RequestMapping(value={"/queryallbrandbyName"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<GoodsBrand> queryallbrandbyName(String brandName) {
        if (null != brandName) {
            LOGGER.info((Object)("\u6839\u636e" + brandName + "\u5173\u952e\u5b57" + "\u67e5\u8be2\u6240\u6709\u7684\u5546\u54c1\u54c1\u724c"));
        }
        return this.goodsBrandService.queryallbrandbyName(brandName);
    }

    @RequestMapping(value={"/delBrand"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String delBrand(Long brandId, HttpServletRequest request, PageBean pb) {
        GoodsBrand goodsBrand = this.goodsBrandService.queryBrandById(brandId);
        int result = this.goodsBrandService.deleteGoodsBrand(brandId, (String)request.getSession().getAttribute("name"));
        if (null != goodsBrand.getBrandName() && 1 == result) {
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u5220\u9664\u5546\u54c1\u54c1\u724c", (String)((String)request.getSession().getAttribute("operaPath") + LOGGERINFO1 + goodsBrand.getBrandName() + LOGGERINFO2 + (String)request.getSession().getAttribute("name")));
            LOGGER.info((Object)("\u5220\u9664\u5546\u54c1\u54c1\u724c\u4fe1\u606f\u5220\u9664\u54c1\u724c\u4e3a" + goodsBrand.getBrandNickname() + "\u54c1\u724c\u4fe1\u606f"));
        }
        PageBean pbDb = this.goodsBrandService.searchByPageBean(pb, new SelectBean());
        int sum = pbDb.getRows();
        int totalpage = 0;
        totalpage = sum % pbDb.getPageSize() == 0 ? sum / pbDb.getPageSize() : sum / pbDb.getPageSize() + 1;
        return JSON.toJSONString((Object)("findAllBrand.htm?pageNo=" + (pb.getPageNo() > totalpage ? totalpage : pb.getPageNo())));
    }

    @RequestMapping(value={"/isbrandlinked"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int isBrandLinked(Long[] brandIds) {
        return this.goodsBrandService.isBrandLinked(brandIds);
    }

    @RequestMapping(value={"/queryBrandById"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public GoodsBrand queryById(Long brandId) {
        GoodsBrand goodsBrand = this.goodsBrandService.queryBrandById(brandId);
        if (null != goodsBrand.getBrandNickname()) {
            LOGGER.info((Object)("\u6839\u636e\u54c1\u724cID\u67e5\u8be2\u54c1\u724c\u4fe1\u606f\u6240\u67e5\u8be2\u7684\u54c1\u724c\u540d\u79f0\u4e3a" + goodsBrand.getBrandNickname()));
        }
        return goodsBrand;
    }

    @RequestMapping(value={"/loadAllBrand"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<GoodsBrand> queryAllBrand() {
        LOGGER.info((Object)"AJAX\u67e5\u8be2\u6240\u6709\u7684\u54c1\u724c");
        return this.goodsBrandService.queryAllBrand();
    }

    @RequestMapping(value={"/checkBrandName"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean checkBrandName(String brandName) {
        if (null != brandName) {
            LOGGER.info((Object)("\u9a8c\u8bc1\u54c1\u724c\u540d\u79f0\u662f\u5426\u53ef\u7528:\u5224\u65ad" + brandName + "\u662f\u5426\u5df2\u7ecf\u5b58\u5728\uff01"));
        }
        return this.goodsBrandService.checkBrandName(brandName);
    }

    @RequestMapping(value={"/checkThirdBrandName"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean checkThirdBrandName(HttpServletRequest request, String brandName) {
        String brandNameNew = brandName;
        LOGGER.info((Object)"\u9a8c\u8bc1\u54c1\u724c\u540d\u79f0\u662f\u5426\u53ef\u7528");
        try {
            brandNameNew = URLDecoder.decode(brandNameNew, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("\u8f6c\u7801\u5931\u8d25\uff01", (Throwable)e);
        }
        return this.goodsBrandService.checkBrandName(brandNameNew) && this.goodsBrandService.checkThirdApplayBrandName((Long)request.getSession().getAttribute("thirdId"), brandNameNew);
    }

    @RequestMapping(value={"/selectByBrandName"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int selectByBrandName(String brandName) {
        LOGGER.info((Object)"\u9a8c\u8bc1\u54c1\u724c\u540d\u79f0\u662f\u5426\u53ef\u7528");
        return this.goodsBrandService.selectByBrandName(brandName);
    }

    @RequestMapping(value={"/ajaxFindAllBrand"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> ajaxFindAllBrand(HttpServletRequest request, HttpServletResponse response, PageBean pb, SelectBean selectBean) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("pb", this.goodsBrandService.searchByPageBean(pb, selectBean));
        result.put("ufs", this.uploadFileSetService.getCurrUploadFileSet());
        String mobileAddress = this.basicSetService.findBasicSet().getMobileAddress();
        mobileAddress = BasicSetUtil.getAddress((String)mobileAddress);
        result.put("address", mobileAddress);
        return result;
    }
}

