/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.controller;

import com.qianjiang.customer.bean.Browserecord;
import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.service.BrowserecordService;
import com.qianjiang.customer.service.CustomerFollowServiceMapper;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.goods.bean.GoodsProduct;
import com.qianjiang.goods.bean.PageBean;
import com.qianjiang.goods.bean.ProductWare;
import com.qianjiang.goods.service.GoodsBrandService;
import com.qianjiang.goods.service.GoodsCateService;
import com.qianjiang.goods.service.GoodsImageService;
import com.qianjiang.goods.service.GoodsOpenSpecService;
import com.qianjiang.goods.service.GoodsOpenSpecValueService;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.goods.service.GoodsProductSuppService;
import com.qianjiang.goods.service.GoodsService;
import com.qianjiang.goods.service.GoodsSpecService;
import com.qianjiang.goods.service.ProductCardService;
import com.qianjiang.goods.service.ProductWareService;
import com.qianjiang.goods.service.SearchAsyncService;
import com.qianjiang.goods.service.WareHouseService;
import com.qianjiang.goods.util.GoodsSearchBean;
import com.qianjiang.goods.util.SelectBean;
import com.qianjiang.goods.vo.GoodsProductVo;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.shoppingcart.bean.ShoppingCart;
import com.qianjiang.shoppingcart.service.ShoppingCartService;
import com.qianjiang.system.service.DistrictService;
import com.qianjiang.system.service.ServiceSupportMapperService;
import com.qianjiang.system.service.StockWarningService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.UtilDate;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AjaxProductController {
    private static final MyLogger LOGGER = new MyLogger(AjaxProductController.class);
    private static final String CUSTOMERID = "customerId";
    private static final String GOODSID = "goodsId";
    private static final String SUPPORT = "support";
    private static final String SPECID = "specId";
    private static final String SPECDETAILID = "specDetailId";
    private static final String SPECREMARK = "specRemark";
    private static final String CATEID = "cateId";
    private static final String THIRDID = "thirdId";
    @Resource(name="GoodsImageService")
    private GoodsImageService goodsImageService;
    @Autowired
    private ProductCardService productCardService;
    private GoodsProductService goodsProductService;
    private GoodsSpecService goodsSpecService;
    private WareHouseService wareHouseService;
    private DistrictService districtService;
    private GoodsService goodsService;
    private GoodsBrandService goodsBrandService;
    private GoodsCateService goodsCateService;
    private CustomerServiceMapper customerServiceMapper;
    private CustomerFollowServiceMapper customerFollowServiceMapper;
    private ProductWareService productWareService;
    private GoodsOpenSpecService goodsOpenSpecService;
    @Autowired
    private SearchAsyncService searchAsyncService;
    @Resource(name="GoodsProductSuppService")
    private GoodsProductSuppService goodsProductSuppService;
    @Resource(name="serviceSupportMapperService")
    private ServiceSupportMapperService serviceSupportMapperService;
    @Resource(name="GoodsOpenSpecValueService")
    private GoodsOpenSpecValueService goodsOpenSpecValueService;
    @Autowired
    private GoodsProductService GoodsProductService;
    @Autowired
    private ShoppingCartService shoppingCartService;
    @Autowired
    private BrowserecordService browserecordService;
    private StockWarningService stockwarningService;

    public GoodsCateService getGoodsCateService() {
        return this.goodsCateService;
    }

    @Resource(name="GoodsCateService")
    public void setGoodsCateService(GoodsCateService goodsCateService) {
        this.goodsCateService = goodsCateService;
    }

    public GoodsBrandService getGoodsBrandService() {
        return this.goodsBrandService;
    }

    @Resource(name="GoodsBrandService")
    public void setGoodsBrandService(GoodsBrandService goodsBrandService) {
        this.goodsBrandService = goodsBrandService;
    }

    public GoodsService getGoodsService() {
        return this.goodsService;
    }

    @Resource(name="GoodsService")
    public void setGoodsService(GoodsService goodsService) {
        this.goodsService = goodsService;
    }

    public CustomerServiceMapper getCustomerServiceMapper() {
        return this.customerServiceMapper;
    }

    @Resource(name="customerServiceMapper")
    public void setCustomerServiceMapper(CustomerServiceMapper customerServiceMapper) {
        this.customerServiceMapper = customerServiceMapper;
    }

    public CustomerFollowServiceMapper getCustomerFollowServiceMapper() {
        return this.customerFollowServiceMapper;
    }

    @Resource(name="customerFollowServiceMapper")
    public void setCustomerFollowServiceMapper(CustomerFollowServiceMapper customerFollowServiceMapper) {
        this.customerFollowServiceMapper = customerFollowServiceMapper;
    }

    public GoodsSpecService getGoodsSpecService() {
        return this.goodsSpecService;
    }

    @Resource(name="GoodsSpecService")
    public void setGoodsSpecService(GoodsSpecService goodsSpecService) {
        this.goodsSpecService = goodsSpecService;
    }

    public GoodsProductService getGoodsProductService() {
        return this.goodsProductService;
    }

    @Resource(name="GoodsProductService")
    public void setGoodsProductService(GoodsProductService goodsProductService) {
        this.goodsProductService = goodsProductService;
    }

    @RequestMapping(value={"/selectAllBarter"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int selectAllBarter(HttpServletRequest request) {
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        List shoppingCart = this.shoppingCartService.selectShoppingCartListByCustomerId(customerId);
        Long[] productGoodsIds = new Long[shoppingCart.size()];
        int index = 0;
        for (ShoppingCart shoppingCart2 : shoppingCart) {
            productGoodsIds[index] = shoppingCart2.getGoodsInfoId();
            ++index;
        }
        List<Long> list = Arrays.asList(productGoodsIds);
        List productShoppingCart = null;
        if (list.size() > 0) {
            productShoppingCart = this.GoodsProductService.selectProductByGoodsInFoId(list);
        }
        List browserecordList = this.browserecordService.selectByCustomerBrowse(customerId);
        System.out.println("!!!!!!" + ((Browserecord)browserecordList.get(0)).getProduct().getGoodsInfoId());
        request.getSession().setAttribute("browserecordList", (Object)browserecordList);
        request.getSession().setAttribute("productShoppingCart", (Object)productShoppingCart);
        request.getSession().setAttribute("goodsProductList", (Object)this.GoodsProductService.selectAll());
        return 1;
    }

    @RequestMapping(value={"/queryProductVoByProductId"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public GoodsProductVo queryProductVoByProductId(Long productId) {
        GoodsProductVo goodsProductVo = this.goodsProductService.queryByPrimaryId(productId);
        if (null != goodsProductVo.getGoodsInfoName()) {
            LOGGER.info((Object)("\u83b7\u53d6\u8d27\u54c1\u3010" + goodsProductVo.getGoodsInfoName() + "\u3011\u7684\u8be6\u7ec6\u4fe1\u606f\uff01"));
        }
        return goodsProductVo;
    }

    @RequestMapping(value={"/queryAllDetailProduct"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public PageBean queryAllProduct(Long groupId, PageBean pb) {
        if (null != groupId) {
            LOGGER.info((Object)("\u67e5\u8be2\u5bf9\u5e94\u7ec4\u5408\u4e0b\u9762\u6240\u6709\u7684\u8d27\u54c1\u8be6\u7ec6\u4fe1\u606f\u7ec4\u5408ID\u4e3a:" + groupId));
        } else {
            LOGGER.info((Object)"\u67e5\u8be2\u5bf9\u5e94\u7ec4\u5408\u4e0b\u9762\u6240\u6709\u7684\u8d27\u54c1\u8be6\u7ec6\u4fe1\u606f");
        }
        return this.goodsProductService.queryProductDetailInfoByPageBean(groupId, pb);
    }

    @RequestMapping(value={"/queryProductForCoupon"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public PageBean queryProductForCoupon(HttpServletRequest request, PageBean pb, String productNo, Long marketType, String sTime, String eTime, String productName, Long brandId, Long catId, Integer haveStock, String searchText, String flag) {
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        String[] cateIds = request.getParameterValues(CATEID);
        String[] brandIds = request.getParameterValues("brandId");
        String productNoNew = productNo;
        try {
            LOGGER.info((Object)"\u6839\u636e\u5206\u7c7bID\u548c\u54c1\u724cID\u67e5\u8be2\u8d27\u54c1ID");
            if (productNoNew != null && !"".equals(productNoNew)) {
                productNoNew = URLDecoder.decode(productNoNew, "UTF-8");
            }
            pb = marketType != null ? this.goodsProductService.queryProductForCoupon(pb, cateIds, brandIds, thirdId, productNoNew, marketType, sTime, eTime, searchText) : this.goodsProductService.queryProductForCouponLife(pb, cateIds, brandIds, thirdId, productNoNew, productName, brandId, catId, haveStock, flag);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u5206\u7c7bID\u548c\u54c1\u724cID\u67e5\u8be2\u8d27\u54c1\u5217\u8868\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return pb;
    }

    @RequestMapping(value={"/newqueryProductForCoupon"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public PageBean newqueryProductForCoupon(HttpServletRequest request, PageBean pb, GoodsSearchBean searchBean, Long marketType) {
        PageBean queryBossProductList = null;
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        try {
            LOGGER.info((Object)"\u6839\u636e\u5206\u7c7bID\u548c\u54c1\u724cID\u67e5\u8be2\u8d27\u54c1ID");
            if (searchBean.getGoodsName() != null && !"".equals(searchBean.getGoodsName())) {
                String goodsName = URLDecoder.decode(searchBean.getGoodsName(), "UTF-8");
                searchBean.setGoodsName(goodsName);
            }
            queryBossProductList = this.goodsProductService.queryBossProductList(pb, thirdId, searchBean, marketType);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u65b0\u4fc3\u9500 \u67e5\u8be2boss\u8d27\u54c1\u5931\u8d25" + e.getMessage());
        }
        return queryBossProductList;
    }

    @RequestMapping(value={"/queryProductForFullbuyPresent"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public PageBean queryProductForFullbuyPresent(HttpServletRequest request, PageBean pb, GoodsSearchBean searchBean, Long marketType) {
        PageBean queryProductListForPresent = null;
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        try {
            LOGGER.info((Object)"\u6839\u636e\u5206\u7c7bID\u548c\u54c1\u724cID\u67e5\u8be2\u8d27\u54c1ID");
            if (searchBean.getGoodsName() != null && !"".equals(searchBean.getGoodsName())) {
                String goodsName = URLDecoder.decode(searchBean.getGoodsName(), "UTF-8");
                searchBean.setGoodsName(goodsName);
            }
            queryProductListForPresent = this.goodsProductService.queryProductListForPresent(pb, thirdId, searchBean, marketType);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6ee1\u8d60\u65f6\u9009\u62e9\u53c2\u52a0\u4fc3\u9500\u7684\u8d27\u54c1\u67e5\u8be2\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return queryProductListForPresent;
    }

    @RequestMapping(value={"/checkProductNo"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean checkProductNo(String productNo) {
        boolean flag = false;
        try {
            flag = this.goodsProductService.checkProuctNo(productNo);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u67e5\u8be2\u8d27\u54c1\u7f16\u53f7\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/checkParam"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean checkParam(Long paramLength, Long[] paramIds, Long goodsId) {
        LOGGER.info((Object)"AJAX\u9a8c\u8bc1\u8d27\u54c1\u7684\u53c2\u6570\u662f\u5426\u5df2\u7ecf\u751f\u6210\u8fc7");
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("params", paramIds);
            map.put("paramLength", paramLength);
            map.put(GOODSID, goodsId);
            boolean bl = this.goodsProductService.checkProductParams(map);
            return bl;
        }
        finally {
            map = null;
        }
    }

    @RequestMapping(value={"/queryStockWarnCount"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Integer queryStockWarnCount(Integer flag, SelectBean selectBean) {
        if (null != flag) {
            if (flag == 1) {
                LOGGER.info((Object)"\u6839\u636e\u67e5\u8be2\u6807\u8bb0\u67e5\u8be2\u8d27\u54c1\u884c\u6570,\u6807\u8bb0\u662f\uff1a\u6240\u6709\u5546\u54c1");
            } else if (flag == 2) {
                LOGGER.info((Object)"\u6839\u636e\u67e5\u8be2\u6807\u8bb0\u67e5\u8be2\u8d27\u54c1\u884c\u6570,\u6807\u8bb0\u662f\uff1a\u5df2\u4e0b\u67b6\u5546\u54c1");
            } else if (flag == 3) {
                LOGGER.info((Object)"\u6839\u636e\u67e5\u8be2\u6807\u8bb0\u67e5\u8be2\u8d27\u54c1\u884c\u6570,\u6807\u8bb0\u662f\uff1a\u7f3a\u8d27\u5546\u54c1");
            } else if (flag == 4) {
                LOGGER.info((Object)"\u6839\u636e\u67e5\u8be2\u6807\u8bb0\u67e5\u8be2\u8d27\u54c1\u884c\u6570,\u6807\u8bb0\u662f\uff1a\u5e93\u5b58\u62a5\u8b66\u5546\u54c1");
            }
        } else {
            LOGGER.info((Object)"\u6839\u636e\u67e5\u8be2\u6807\u8bb0\u67e5\u8be2\u8d27\u54c1\u884c\u6570");
        }
        return this.goodsProductService.queryStockWarnCount(flag, selectBean);
    }

    @RequestMapping(value={"/queryProductForCouponByThird"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public PageBean queryProductForCouponByThird(HttpServletRequest request, PageBean pb, Long productNo) {
        LOGGER.info((Object)"\u6839\u636e\u5206\u7c7bID\u548c\u54c1\u724cID\u67e5\u8be2\u8d27\u54c1ID");
        String[] cateIds = request.getParameterValues(CATEID);
        String[] brandIds = request.getParameterValues("brandIds");
        return this.goodsProductService.queryProductForCouponByThird(pb, cateIds, brandIds, Long.valueOf(0L), productNo);
    }

    @RequestMapping(value={"/queryProductForCouponByGoodsIds"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public PageBean queryProductForCouponByGoodsIds(HttpServletRequest request, PageBean pb, Long[] goodsInfoIds) {
        LOGGER.info((Object)"\u6839\u636e\u5206\u7c7bID\u548c\u54c1\u724cID\u67e5\u8be2\u8d27\u54c1ID");
        return this.goodsProductService.queryProductForCouponByGoodsInfoIds(pb, goodsInfoIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/newUploadProduct"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int newUploadProduct(@Valid GoodsProduct product, HttpServletRequest request, Long[] ware, Long[] wareStock, BigDecimal[] warePrice, String addedTime) {
        String[] specIds = request.getParameterValues(SPECID);
        String[] specDetailId = request.getParameterValues(SPECDETAILID);
        String[] specRemark = request.getParameterValues(SPECREMARK);
        String[] images = request.getParameterValues("image");
        String[] supportId = request.getParameterValues(SUPPORT);
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        try {
            int newId;
            map.put("wareId", ware);
            map.put("productStocks", wareStock);
            map.put("productPrices", warePrice);
            map.put(SPECREMARK, specRemark);
            product.setIsThird("0");
            product.setThirdId(0L);
            product.setThirdName("BOSS");
            String catName = null;
            Map catName_map = this.goodsService.selectCatNameByGoodsId(product.getGoodsId());
            if (catName_map != null) {
                catName = (String)catName_map.get("cat_name");
            }
            if ("\u793c\u54c1\u5361".equals(catName)) {
                product.setIsCard("1");
            } else {
                product.setIsCard("0");
            }
            if ("4".equals(product.getGoodsInfoAdded())) {
                product.setGoodsInfoAddedTime(UtilDate.stringToDate((String)addedTime));
            }
            if (1 == (newId = this.goodsProductService.saveProduct(product, (String)request.getSession().getAttribute("name"), specIds, specDetailId, map)) && null != product.getGoodsInfoName()) {
                LOGGER.info((Object)("\u4fdd\u5b58\u3010" + product.getGoodsInfoName() + "\u3011\u6210\u529f"));
            }
            Customer cust = (Customer)request.getSession().getAttribute("cust");
            String ip = IPAddress.getIpAddr((HttpServletRequest)request);
            Long loginUserId = (Long)request.getSession().getAttribute("loginUserId");
            String name = (String)request.getSession().getAttribute("name");
            this.productWareService.calcProductWare(cust, ip, name, loginUserId, Long.valueOf(Long.parseLong(String.valueOf(newId))), wareStock, warePrice, ware);
            this.goodsImageService.batchSaveImageWithDefaultPic(images, newId, (String)request.getSession().getAttribute("name"));
            this.goodsProductSuppService.batchInsert(supportId, newId);
            this.searchAsyncService.insertOneGoodsIndexToEs(product.getGoodsId());
            if (newId > 0 && "\u793c\u54c1\u5361".equals(catName)) {
                product.setGoodsInfoId(new Long(newId));
                List wareList = this.productWareService.queryAllByProductId(product.getGoodsInfoId());
                if (wareList != null && wareList.size() > 0) {
                    product.setGoodsInfoStock(((ProductWare)wareList.get(0)).getWareStock());
                    int insertCardNum = this.productCardService.insertListCard(product);
                    if ((long)insertCardNum == product.getGoodsInfoStock()) {
                        LOGGER.info((Object)("\u751f\u6210\u3010" + product.getGoodsInfoName() + ":\u793c\u54c1\u5361\u3011\u6210\u529f"));
                    }
                }
            }
            int n = newId;
            return n;
        }
        finally {
            supportId = null;
            images = null;
            specIds = null;
            specDetailId = null;
            map = null;
        }
    }

    @RequestMapping(value={"/chooseProductByChecked"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<Object> chooseProductByChecked(String[] productIds, HttpServletResponse response) {
        Long[] proIds = null;
        if (productIds != null && productIds.length > 0) {
            proIds = new Long[productIds.length];
            for (int i = 0; i < productIds.length; ++i) {
                proIds[i] = Long.parseLong(productIds[i]);
            }
        }
        return this.goodsProductService.queryAllProductByProductIdsForExport(proIds);
    }

    @RequestMapping(value={"/checkGoodsProductNo"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean checkGoodsProductNo(HttpServletRequest request) {
        boolean flag = false;
        try {
            GoodsProduct product;
            String productNo = request.getParameter("productNo");
            String productId = request.getParameter("productId");
            if (!(StringUtils.isEmpty((String)productNo) || StringUtils.isEmpty((String)productId) || (product = this.goodsProductService.selectByProductNo(productNo)) != null && product.getGoodsInfoId().intValue() != Long.valueOf(productId).intValue())) {
                flag = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u67e5\u8be2\u8d27\u54c1\u7f16\u53f7\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return flag;
    }

    public WareHouseService getWareHouseService() {
        return this.wareHouseService;
    }

    @Resource(name="WareHouseService")
    public void setWareHouseService(WareHouseService wareHouseService) {
        this.wareHouseService = wareHouseService;
    }

    public ProductWareService getProductWareService() {
        return this.productWareService;
    }

    @Resource(name="ProductWareService")
    public void setProductWareService(ProductWareService productWareService) {
        this.productWareService = productWareService;
    }

    public GoodsOpenSpecService getGoodsOpenSpecService() {
        return this.goodsOpenSpecService;
    }

    @Resource(name="GoodsOpenSpecService")
    public void setGoodsOpenSpecService(GoodsOpenSpecService goodsOpenSpecService) {
        this.goodsOpenSpecService = goodsOpenSpecService;
    }

    public DistrictService getDistrictService() {
        return this.districtService;
    }

    @Resource(name="DistrictService")
    public void setDistrictService(DistrictService districtService) {
        this.districtService = districtService;
    }

    public StockWarningService getStockwarningService() {
        return this.stockwarningService;
    }

    @Resource(name="StockWarningService")
    public void setStockwarningService(StockWarningService stockwarningService) {
        this.stockwarningService = stockwarningService;
    }
}

