/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.controller;

import com.qianjiang.goods.bean.PageBean;
import com.qianjiang.goods.service.GoodsBrandService;
import com.qianjiang.goods.service.GoodsCateService;
import com.qianjiang.goods.service.GoodsImportService;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.goods.service.GoodsRelatedGoodsService;
import com.qianjiang.goods.service.GoodsService;
import com.qianjiang.goods.service.GoodsTagService;
import com.qianjiang.goods.service.ProductWareService;
import com.qianjiang.goods.service.SearchAsyncService;
import com.qianjiang.goods.service.WareHouseService;
import com.qianjiang.goods.util.GoodsSearchBean;
import com.qianjiang.goods.vo.GoodsMoifiedVo;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.system.service.ServiceSupportMapperService;
import com.qianjiang.util.MyLogger;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AjaxGoodsController {
    private static final MyLogger LOGGER = new MyLogger(AjaxGoodsController.class);
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;
    private GoodsService goodsService;
    private GoodsBrandService goodsBrandService;
    private GoodsTagService goodsTagService;
    private GoodsCateService goodsCateService;
    private ProductWareService productWareService;
    @Resource(name="GoodsProductService")
    private GoodsProductService goodsProductService;
    @Resource(name="serviceSupportMapperService")
    private ServiceSupportMapperService serviceSupportMapperService;
    private WareHouseService wareHouseService;
    @Autowired
    private SearchAsyncService searchAsyncService;
    @Resource(name="GoodsRelatedGoodsService")
    private GoodsRelatedGoodsService relatedGoodsService;
    @Resource(name="GoodsImportService")
    private GoodsImportService goodsImportService;

    @RequestMapping(value={"/checkgoods"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int checkgoods(int goodsId) {
        String flag = this.goodsService.selectCheckGoods(goodsId);
        if ("1".equals(flag)) {
            return 1;
        }
        return 0;
    }

    @RequestMapping(value={"/searchGoodsAll"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public PageBean searchGoodsAll(PageBean pb) {
        LOGGER.info((Object)"AJAX\u67e5\u8be2\u6240\u6709\u7684\u5546\u54c1\u5217\u8868");
        return this.goodsService.queryListVo(pb, "0");
    }

    @RequestMapping(value={"/searchGoodsAllisthird"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public PageBean searchGoodsAllisthird(PageBean pb) {
        LOGGER.info((Object)"AJAX\u67e5\u8be2\u6240\u6709\u7684\u5546\u54c1\u5217\u8868");
        return this.goodsService.queryListVo(pb, "1");
    }

    @RequestMapping(value={"/findGoodByCatId"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<Object> queryGoodsByCatId(Long catId) {
        LOGGER.info((Object)("AJAX\u6839\u636e\u5206\u7c7bID\u67e5\u8be2\u5546\u54c1\u5217\u8868\u5206\u7c7bID:\u4e3a" + catId));
        return this.goodsService.queryGoodsListByCatId(catId);
    }

    @RequestMapping(value={"/findModifiedGoodsVoByGoodsId"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public GoodsMoifiedVo queryModifiedByGoodsId(Long goodsId) {
        GoodsMoifiedVo goodsMoifiedVo = this.goodsService.queryModeifiedVoByGoodsId(goodsId);
        if (null != goodsMoifiedVo.getGoodsName()) {
            LOGGER.info((Object)("AJAX\u6839\u636e\u5546\u54c1ID\u67e5\u8be2\u5546\u54c1\u8be6\u7ec6\u4fe1\u606f,\u67e5\u8be2\u7684\u5546\u54c1\u540d\u79f0\u4e3a:" + goodsMoifiedVo.getGoodsName()));
        }
        return this.goodsService.queryModeifiedVoByGoodsId(goodsId);
    }

    @RequestMapping(value={"/queryByParamAjax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public PageBean queryByParamAjax(PageBean pb, GoodsSearchBean searchBean) {
        pb.setUrl("queryByParamAjax.htm");
        LOGGER.info((Object)"\u9ad8\u7ea7\u67e5\u8be2");
        return this.goodsService.searchBySearchBeanAndPageBean(pb, searchBean);
    }

    @RequestMapping(value={"/queryThirdGoodsByParamAjax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public PageBean queryThirdGoodsByParamAjax(PageBean pb, GoodsSearchBean searchBean, HttpServletRequest request) {
        searchBean.setThirdId(String.valueOf(request.getSession().getAttribute("thirdId")));
        searchBean.setIsThird("1");
        pb.setUrl("queryThirdGoodsByParamAjax.htm");
        return this.goodsService.searchThirdBySearchBeanAndPageBean(pb, searchBean);
    }

    @RequestMapping(value={"/checkGoodsNo"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean checkGoodsNo(String goodsNo) {
        LOGGER.info((Object)("AJAX\u9a8c\u8bc1\u5546\u54c1\u7f16\u53f7\u662f\u5426\u53ef\u7528,\u9a8c\u8bc1\u7684\u5546\u54c1\u7f16\u53f7\u4e3a" + goodsNo));
        return this.goodsService.queryCountByGoodsNo(goodsNo);
    }

    @RequestMapping(value={"/createIndex"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean createIndex() {
        LOGGER.info((Object)"\u521b\u5efaLucence\u7d22\u5f15");
        return this.goodsService.createIndex();
    }

    @RequestMapping(value={"/queryGoodsForCoupon"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public PageBean queryGoodsForCoupon(HttpServletRequest request, PageBean pb, String productNo) {
        LOGGER.info((Object)"\u6839\u636e\u5206\u7c7bID\u548c\u54c1\u724cID\u67e5\u8be2\u5546\u54c1ID");
        return this.goodsService.queryGoodsForCoupon(pb, (Long)request.getSession().getAttribute("thirdId"), productNo);
    }

    public ProductWareService getProductWareService() {
        return this.productWareService;
    }

    public GoodsBrandService getGoodsBrandService() {
        return this.goodsBrandService;
    }

    @Resource(name="GoodsBrandService")
    public void setGoodsBrandService(GoodsBrandService goodsBrandService) {
        this.goodsBrandService = goodsBrandService;
    }

    public GoodsTagService getGoodsTagService() {
        return this.goodsTagService;
    }

    @Resource(name="GoodsTagServiceImpl")
    public void setGoodsTagService(GoodsTagService goodsTagService) {
        this.goodsTagService = goodsTagService;
    }

    public GoodsCateService getGoodsCateService() {
        return this.goodsCateService;
    }

    @Resource(name="GoodsCateService")
    public void setGoodsCateService(GoodsCateService goodsCateService) {
        this.goodsCateService = goodsCateService;
    }

    public GoodsService getGoodsService() {
        return this.goodsService;
    }

    @Resource(name="GoodsService")
    public void setGoodsService(GoodsService goodsService) {
        this.goodsService = goodsService;
    }

    @Resource(name="ProductWareService")
    public void setProductWareService(ProductWareService productWareService) {
        this.productWareService = productWareService;
    }

    public WareHouseService getWareHouseService() {
        return this.wareHouseService;
    }

    @Resource(name="WareHouseService")
    public void setWareHouseService(WareHouseService wareHouseService) {
        this.wareHouseService = wareHouseService;
    }
}

