/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.controller;

import com.qianjiang.goods.bean.GoodsSpec;
import com.qianjiang.goods.service.GoodsSpecService;
import com.qianjiang.goods.vo.GoodsSpecVo;
import com.qianjiang.util.MyLogger;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AjaxSpecController {
    private static final MyLogger LOGGER = new MyLogger(AjaxSpecController.class);
    private GoodsSpecService goodsSpecService;

    public GoodsSpecService getGoodsSpecService() {
        return this.goodsSpecService;
    }

    @Resource(name="GoodsSpecService")
    public void setGoodsSpecService(GoodsSpecService goodsSpecService) {
        this.goodsSpecService = goodsSpecService;
    }

    @RequestMapping(value={"/isspecvaluecandelete"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int isSpecValueCanDelete(Long specvalueId) {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(specvalueId);
        return this.goodsSpecService.isSpecValueCanDelete(list) ? 0 : 1;
    }

    @RequestMapping(value={"/queryCateVoById"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public GoodsSpecVo findCateVoById(Long specId) {
        LOGGER.info((Object)("\u6839\u636e\u89c4\u683cID\u67e5\u8be2\u89c4\u683c\u4fe1\u606f\u89c4\u683cID\u4e3a:" + specId));
        return this.goodsSpecService.queryBySpecPrimaryKey(specId);
    }

    @RequestMapping(value={"/queryAllSpec"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<GoodsSpec> queryAllSpec() {
        LOGGER.info((Object)"AJAX\u67e5\u8be2\u6240\u6709\u7684\u89c4\u683c\u4fe1\u606f");
        return this.goodsSpecService.queryAllSpec();
    }

    @RequestMapping(value={"/checkSpecName"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean checkSpecName(String specName) {
        if (null != specName) {
            LOGGER.info((Object)("AJAX\u9a8c\u8bc1\u89c4\u683c\u503c\u662f\u5426\u53ef\u7528\u89c4\u683c\u503c\u4e3a:" + specName));
        } else {
            LOGGER.info((Object)"AJAX\u9a8c\u8bc1\u89c4\u683c\u503c\u662f\u5426\u53ef\u7528");
        }
        return this.goodsSpecService.checkSpecName(specName);
    }

    @RequestMapping(value={"/isspeccandelete"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int isSpecCanDelete(Long[] specIds) {
        return this.goodsSpecService.isSpecCanDelete(specIds) ? 0 : 1;
    }

    @RequestMapping(value={"/isspeccandeleteone"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int isSpecCanDeleteOne(Long specId) {
        Long[] ids = new Long[]{specId};
        return this.goodsSpecService.isSpecCanDelete(ids) ? 0 : 1;
    }
}

