/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.controller;

import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.goods.service.WareHouseService;
import com.qianjiang.goods.vo.WareHouseVo;
import com.qianjiang.other.bean.CityBean;
import com.qianjiang.other.bean.DistrictBean;
import com.qianjiang.other.bean.ProvinceBean;
import com.qianjiang.util.MyLogger;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AjaxWareController {
    private static final MyLogger LOGGER = new MyLogger(AjaxWareController.class);
    private WareHouseService wareHouseService;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceMapper;

    @RequestMapping(value={"/getprovincebyware"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<ProvinceBean> getAllProvinceByWare() {
        return this.customerServiceMapper.selectAllProvince();
    }

    @RequestMapping(value={"/selectalldistrict"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<DistrictBean> selectAllDistrict(Long wareId) {
        return this.wareHouseService.selectCityIdByWareId(wareId);
    }

    @RequestMapping(value={"/selectallcitydistrict"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<CityBean> selectAllCityDistrict(Long wareId) {
        return this.wareHouseService.selectCityIdByDid(wareId);
    }

    @RequestMapping(value={"/queryWareHouseByWareId"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public WareHouseVo queryWareHouseByWareId(Long wareId) {
        if (null != wareId) {
            LOGGER.info((Object)("AJAX\u6839\u636e\u4ed3\u5e93ID\u67e5\u8be2\u4ed3\u5e93\u4fe1\u606f,\u4ed3\u5e93ID\u4e3a\uff1a" + wareId));
        } else {
            LOGGER.info((Object)"AJAX\u6839\u636e\u4ed3\u5e93ID\u67e5\u8be2\u4ed3\u5e93\u4fe1\u606f");
        }
        return this.wareHouseService.selectWareByWareId(wareId);
    }

    @RequestMapping(value={"/checkWareName"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean checkWareName(String wareName, Long wareId) {
        String wareNameNew = wareName;
        if (!"".equals(wareNameNew)) {
            try {
                wareNameNew = URLDecoder.decode(wareNameNew, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("" + e);
            }
        }
        LOGGER.info((Object)("AJAX\u9a8c\u8bc1\u4ed3\u5e93\u540d\u79f0\u662f\u5426\u53ef\u7528,\u9a8c\u8bc1\u7684\u4ed3\u5e93\u540d\u79f0\u4e3a\uff1a" + wareNameNew));
        if (wareId != null) {
            return this.wareHouseService.checkWareNameHaveId(wareNameNew, wareId);
        }
        return this.wareHouseService.checkWareName(wareNameNew);
    }

    @RequestMapping(value={"/checkidentityid"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int checkIdentityId(String identityId) {
        return this.wareHouseService.identifyIsExist(identityId);
    }

    @RequestMapping(value={"/iswarecandelete"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int isWareCanDelete(Long[] wareId) {
        return this.wareHouseService.isWareCanDelete(wareId);
    }

    @RequestMapping(value={"/getallwarehousedistrict"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<DistrictBean> getAllWareHouseDistrict() {
        return this.wareHouseService.getAllWareHouseDistrict();
    }

    public WareHouseService getWareHouseService() {
        return this.wareHouseService;
    }

    @Resource(name="WareHouseService")
    public void setWareHouseService(WareHouseService wareHouseService) {
        this.wareHouseService = wareHouseService;
    }
}

