/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.controller;

import com.qianjiang.comment.service.EmailUtilsSiteService;
import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.bean.CustomerFollow;
import com.qianjiang.customer.bean.CustomerInfo;
import com.qianjiang.customer.service.CustomerFollowServiceMapper;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.excel.ExportGoodsList;
import com.qianjiang.goods.bean.FollowAndCityVo;
import com.qianjiang.goods.bean.Goods;
import com.qianjiang.goods.bean.GoodsProduct;
import com.qianjiang.goods.bean.GoodsProductSon;
import com.qianjiang.goods.bean.PageBean;
import com.qianjiang.goods.service.GoodsBrandService;
import com.qianjiang.goods.service.GoodsCateService;
import com.qianjiang.goods.service.GoodsOpenSpecService;
import com.qianjiang.goods.service.GoodsOpenSpecValueService;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.goods.service.GoodsProductSonService;
import com.qianjiang.goods.service.GoodsProductSuppService;
import com.qianjiang.goods.service.GoodsService;
import com.qianjiang.goods.service.GoodsSpecService;
import com.qianjiang.goods.service.ProductWareService;
import com.qianjiang.goods.service.SearchAsyncService;
import com.qianjiang.goods.service.WareHouseService;
import com.qianjiang.goods.util.SelectBean;
import com.qianjiang.goods.vo.GoodsMoifiedVo;
import com.qianjiang.goods.vo.GoodsProductDetailViewVo;
import com.qianjiang.goods.vo.GoodsProductVo;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.system.bean.District;
import com.qianjiang.system.service.DistrictService;
import com.qianjiang.system.service.ServiceSupportMapperService;
import com.qianjiang.system.service.StockWarningService;
import com.qianjiang.system.util.StorkWarningUtil;
import com.qianjiang.util.MyLogger;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import net.sf.json.JSONArray;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ProductController {
    private static final MyLogger LOGGER = new MyLogger(ProductController.class);
    private static final String SPECS = "specs";
    private static final String WAREHOUSE = "wareHouse";
    private static final String SELECTBEAN = "selectBean";
    private static final String GOODSID = "goodsId";
    private static final String SUPPORT = "support";
    private static final String LOGGERINFO1 = ",\u7528\u6237\u540d\uff1a";
    private static final String SPECID = "specId";
    private static final String SPECDETAILID = "specDetailId";
    private static final String SPECREMARK = "specRemark";
    private static final String CATEID = "cateId";
    private static final String THIRDID = "thirdId";
    @Resource(name="emailSiteUtils")
    private EmailUtilsSiteService emailUtilsSiteService;
    private GoodsProductService goodsProductService;
    private GoodsSpecService goodsSpecService;
    private WareHouseService wareHouseService;
    private DistrictService districtService;
    private GoodsService goodsService;
    private GoodsBrandService goodsBrandService;
    private GoodsCateService goodsCateService;
    private CustomerServiceMapper customerServiceMapper;
    private CustomerFollowServiceMapper customerFollowServiceMapper;
    private ProductWareService productWareService;
    private GoodsOpenSpecService goodsOpenSpecService;
    @Autowired
    private SearchAsyncService searchAsyncService;
    @Autowired
    private GoodsProductSonService goodsProductSonService;
    @Resource(name="GoodsProductSuppService")
    private GoodsProductSuppService goodsProductSuppService;
    @Resource(name="serviceSupportMapperService")
    private ServiceSupportMapperService serviceSupportMapperService;
    @Resource(name="GoodsOpenSpecValueService")
    private GoodsOpenSpecValueService goodsOpenSpecValueService;
    private StockWarningService stockwarningService;

    public GoodsCateService getGoodsCateService() {
        return this.goodsCateService;
    }

    @Resource(name="GoodsCateService")
    public void setGoodsCateService(GoodsCateService goodsCateService) {
        this.goodsCateService = goodsCateService;
    }

    public GoodsBrandService getGoodsBrandService() {
        return this.goodsBrandService;
    }

    @Resource(name="GoodsBrandService")
    public void setGoodsBrandService(GoodsBrandService goodsBrandService) {
        this.goodsBrandService = goodsBrandService;
    }

    public GoodsService getGoodsService() {
        return this.goodsService;
    }

    @Resource(name="GoodsService")
    public void setGoodsService(GoodsService goodsService) {
        this.goodsService = goodsService;
    }

    public CustomerServiceMapper getCustomerServiceMapper() {
        return this.customerServiceMapper;
    }

    @Resource(name="customerServiceMapper")
    public void setCustomerServiceMapper(CustomerServiceMapper customerServiceMapper) {
        this.customerServiceMapper = customerServiceMapper;
    }

    public CustomerFollowServiceMapper getCustomerFollowServiceMapper() {
        return this.customerFollowServiceMapper;
    }

    @Resource(name="customerFollowServiceMapper")
    public void setCustomerFollowServiceMapper(CustomerFollowServiceMapper customerFollowServiceMapper) {
        this.customerFollowServiceMapper = customerFollowServiceMapper;
    }

    public GoodsSpecService getGoodsSpecService() {
        return this.goodsSpecService;
    }

    @Resource(name="GoodsSpecService")
    public void setGoodsSpecService(GoodsSpecService goodsSpecService) {
        this.goodsSpecService = goodsSpecService;
    }

    public GoodsProductService getGoodsProductService() {
        return this.goodsProductService;
    }

    @Resource(name="GoodsProductService")
    public void setGoodsProductService(GoodsProductService goodsProductService) {
        this.goodsProductService = goodsProductService;
    }

    @RequestMapping(value={"/queryAllByGoodsId"})
    public ModelAndView queryAllByGoodsId(HttpServletRequest request, Long goodsId, String queryStatus, PageBean pb, SelectBean selectBean) {
        ModelAndView mav = new ModelAndView();
        try {
            pb = this.goodsProductService.queryByGoodsId(goodsId, pb, selectBean);
            Goods g = this.goodsService.queryGoodsByGoodsId(goodsId);
            if ("0".equals(g.getIsThird())) {
                List queryOpenListByGoodsIdInBoss = this.goodsOpenSpecService.queryOpenListByGoodsIdInBoss(goodsId);
                List queryAllWareHouse = this.wareHouseService.queryAllWareHouse();
                List selectAll = this.serviceSupportMapperService.selectAll();
                mav.addObject("pageBean", (Object)pb);
                mav.addObject(SPECS, (Object)queryOpenListByGoodsIdInBoss);
                mav.addObject(GOODSID, (Object)goodsId);
                mav.addObject(SELECTBEAN, (Object)selectBean);
                mav.addObject(WAREHOUSE, (Object)queryAllWareHouse);
                mav.addObject(SUPPORT, (Object)selectAll);
                mav.addObject("pageNo", (Object)pb.getPageNo());
                mav.addObject("queryStatus", (Object)queryStatus);
                mav.setViewName("jsp/goods/goods_product");
                return mav;
            }
            List queryOpenListByGoodsIdInBoss = this.goodsOpenSpecService.queryOpenListByGoodsIdInBoss(goodsId);
            List queryAllWareHouse = this.wareHouseService.queryAllWareHouse();
            List selectAll = this.serviceSupportMapperService.selectAll();
            mav.addObject("pb", (Object)pb);
            mav.addObject(SPECS, (Object)queryOpenListByGoodsIdInBoss);
            mav.addObject(GOODSID, (Object)goodsId);
            mav.addObject(SELECTBEAN, (Object)selectBean);
            mav.addObject(WAREHOUSE, (Object)queryAllWareHouse);
            mav.addObject(SUPPORT, (Object)selectAll);
            mav.setViewName("jsp/goods/third_goods_product");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u5546\u54c1ID\u67e5\u8be2\u5546\u54c1\u4e0b\u7684\u8d27\u54c1\u4fe1\u606f\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/queryAllByGoodsIdNew"})
    public ModelAndView queryAllByGoodsIdNew(Long goodsId, PageBean pb, SelectBean selectBean) {
        PageBean pbNew = pb;
        pbNew = this.goodsProductService.queryByGoodsIdNew(goodsId, pbNew, selectBean);
        Goods g = this.goodsService.queryGoodsByGoodsId(goodsId);
        if ("0".equals(g.getIsThird())) {
            return new ModelAndView("jsp/goods/goods_product", "pageBean", (Object)pbNew).addObject(SPECS, (Object)this.goodsOpenSpecService.queryOpenListByGoodsIdInBoss(goodsId)).addObject(GOODSID, (Object)goodsId).addObject(SELECTBEAN, (Object)selectBean).addObject(WAREHOUSE, (Object)this.wareHouseService.queryAllWareHouse()).addObject(SUPPORT, (Object)this.serviceSupportMapperService.selectAll());
        }
        return new ModelAndView("jsp/goods/third_goods_product", "pb", (Object)pbNew).addObject(SPECS, (Object)this.goodsOpenSpecService.queryOpenListByGoodsIdInBoss(goodsId)).addObject(GOODSID, (Object)goodsId).addObject(SELECTBEAN, (Object)selectBean).addObject(WAREHOUSE, (Object)this.wareHouseService.queryAllWareHouse()).addObject(SUPPORT, (Object)this.serviceSupportMapperService.selectAll());
    }

    @RequestMapping(value={"/delProduct"})
    public ModelAndView delProduct(Long productId, Long goodsId, Integer flag, HttpServletRequest request) {
        GoodsProductVo goodsProductVo = this.goodsProductService.queryByPrimaryId(productId);
        this.goodsProductService.delProductByProductId(productId, (String)request.getSession().getAttribute("name"));
        ArrayList<Long> goodsInfoIds = new ArrayList<Long>();
        goodsInfoIds.add(productId);
        this.goodsProductService.delShoppingGoodsByGoodsInfoIds(goodsInfoIds);
        this.searchAsyncService.deleteGoodsIndexToEs(productId);
        if (null == flag && null != goodsId && null != goodsProductVo.getGoodsInfoName()) {
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u5220\u9664\u8d27\u54c1", (String)((String)request.getSession().getAttribute("operaPath") + "\u540d\u79f0\u3010" + goodsProductVo.getGoodsInfoName() + "\u3011-->\u7528\u6237\u540d\uff1a" + (String)request.getSession().getAttribute("name")));
            return new ModelAndView((View)new RedirectView("queryAllByGoodsId.htm?goodsId=" + goodsId));
        }
        return new ModelAndView((View)new RedirectView("queryProductListBySomeParam.htm?flag=" + flag));
    }

    @RequestMapping(value={"/batchDelProduct"})
    public ModelAndView batchDelProduct(Long[] productIds, Long goodsId, Integer flag, HttpServletRequest request) {
        LOGGER.info((Object)"\u6279\u91cf\u5220\u9664\u8d27\u54c1\u4fe1\u606f");
        this.goodsProductService.batchDelProduct(productIds, (String)request.getSession().getAttribute("name"));
        ArrayList<Long> list = new ArrayList<Long>();
        for (int i = 0; i < productIds.length; ++i) {
            list.add(productIds[i]);
        }
        this.goodsProductService.delShoppingGoodsByGoodsInfoIds(list);
        this.searchAsyncService.batchDeleteGoodsIndexToEs(list);
        if (null == flag && null != goodsId) {
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u6279\u91cf\u5220\u9664\u8d27\u54c1\u4fe1\u606f", (String)((String)request.getSession().getAttribute("operaPath") + LOGGERINFO1 + (String)request.getSession().getAttribute("name")));
            return new ModelAndView((View)new RedirectView("queryAllByGoodsId.htm?goodsId=" + goodsId));
        }
        return new ModelAndView((View)new RedirectView("queryProductListBySomeParam.htm?flag=" + flag));
    }

    @RequestMapping(value={"/batchUpload"})
    public ModelAndView batchUploadedProduct(Long[] productIds, Long goodsId, Integer flag, HttpServletRequest request) {
        LOGGER.info((Object)"\u6279\u91cf\u6267\u884c\u4e0a\u4e0b\u67b6\u64cd\u4f5c");
        this.goodsProductService.batchUploadProduct((String)request.getSession().getAttribute("name"), productIds, Integer.valueOf(1));
        this.searchAsyncService.updateOneGoodsIndexToEs(goodsId);
        if (null != goodsId) {
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u6279\u91cf\u6267\u884c\u4e0a\u4e0b\u67b6\u64cd\u4f5c", (String)((String)request.getSession().getAttribute("operaPath") + LOGGERINFO1 + (String)request.getSession().getAttribute("name")));
            return new ModelAndView((View)new RedirectView("queryAllByGoodsId.htm?goodsId=" + goodsId));
        }
        return new ModelAndView((View)new RedirectView("queryProductListBySomeParam.htm?flag=" + flag));
    }

    @RequestMapping(value={"/batchDown"})
    public ModelAndView batchDown(Long[] productIds, Long goodsId, Integer flag, HttpServletRequest request) {
        LOGGER.info((Object)"\u6279\u91cf\u6267\u884c\u4e0a\u4e0b\u67b6\u64cd\u4f5c");
        this.goodsProductService.batchUploadProduct((String)request.getSession().getAttribute("name"), productIds, Integer.valueOf(0));
        this.searchAsyncService.deleteGoodsIndexToEs(goodsId);
        if (null != goodsId) {
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u6279\u91cf\u6267\u884c\u4e0a\u4e0b\u67b6\u64cd\u4f5c", (String)((String)request.getSession().getAttribute("operaPath") + LOGGERINFO1 + (String)request.getSession().getAttribute("name")));
            return new ModelAndView((View)new RedirectView("queryAllByGoodsId.htm?goodsId=" + goodsId));
        }
        return new ModelAndView((View)new RedirectView("queryProductListBySomeParam.htm?flag=" + flag));
    }

    @RequestMapping(value={"/batchShow"})
    public ModelAndView batchShow(Long[] productIds, Long goodsId, Integer flag, Integer sta, HttpServletRequest request) {
        LOGGER.info((Object)"\u6279\u91cf\u6267\u884c\u4e0a\u4e0b\u67b6\u64cd\u4f5c");
        this.goodsProductService.batchShowOrHide((String)request.getSession().getAttribute("name"), productIds, sta);
        this.searchAsyncService.updateOneGoodsIndexToEs(goodsId);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u6279\u91cf\u663e\u793a\u9690\u85cf\u8d27\u54c1\u5230\u5217\u8868\u9875", (String)((String)request.getSession().getAttribute("operaPath") + LOGGERINFO1 + (String)request.getSession().getAttribute("name")));
        if (null != goodsId) {
            return new ModelAndView((View)new RedirectView("queryAllByGoodsId.htm?goodsId=" + goodsId));
        }
        return new ModelAndView((View)new RedirectView("queryProductListBySomeParam.htm?flag=" + flag));
    }

    @RequestMapping(value={"/batchShowMobile"})
    public ModelAndView batchShowMobile(Long[] productIds, Long goodsId, Integer flag, Integer sta, HttpServletRequest request) {
        LOGGER.info((Object)"\u6279\u91cf\u6267\u884c\u4e0a\u4e0b\u67b6\u64cd\u4f5c");
        this.goodsProductService.batchShowOrHideMobile((String)request.getSession().getAttribute("name"), productIds, sta);
        this.searchAsyncService.insertOneGoodsIndexToEs(goodsId);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u6279\u91cf\u663e\u793a\u9690\u85cf\u8d27\u54c1\u5230\u624b\u673a\u7248", (String)((String)request.getSession().getAttribute("operaPath") + LOGGERINFO1 + (String)request.getSession().getAttribute("name")));
        if (null == flag && null != goodsId) {
            return new ModelAndView((View)new RedirectView("queryAllByGoodsId.htm?goodsId=" + goodsId));
        }
        return new ModelAndView((View)new RedirectView("queryProductListBySomeParam.htm?flag=" + flag));
    }

    @RequestMapping(value={"/saveProduct"})
    public ModelAndView saveProduct(@Valid GoodsProduct product, HttpServletRequest request, Long[] wareId, Long[] productStocks, BigDecimal[] productPrices, PageBean pb) {
        LOGGER.info((Object)"\u4fdd\u5b58\u8d27\u54c1\u4fe1\u606f");
        String[] specIds = request.getParameterValues(SPECID);
        String[] specDetailId = request.getParameterValues(SPECDETAILID);
        String[] specRemark = request.getParameterValues(SPECREMARK);
        String[] suppIds = request.getParameterValues("productSupp");
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        map.put("wareId", wareId);
        map.put("productStocks", productStocks);
        map.put("productPrices", productPrices);
        map.put(SPECREMARK, specRemark);
        this.goodsOpenSpecValueService.queryOpenListByGoodsAndSpecValueId(product.getGoodsId(), specDetailId);
        product.setIsThird("0");
        product.setThirdId(0L);
        product.setThirdName("BOSS");
        int newId = this.goodsProductService.saveProduct(product, (String)request.getSession().getAttribute("name"), specIds, specDetailId, map);
        Customer cust = (Customer)request.getSession().getAttribute("cust");
        String ip = IPAddress.getIpAddr((HttpServletRequest)request);
        Long loginUserId = (Long)request.getSession().getAttribute("loginUserId");
        String name = (String)request.getSession().getAttribute("name");
        this.productWareService.calcProductWare(cust, ip, name, loginUserId, Long.valueOf(Long.parseLong(String.valueOf(newId))), productStocks, productPrices, wareId);
        String[] goodsInfoItemNoS_arr = request.getParameterValues("goodsInfoItemNoS");
        if (goodsInfoItemNoS_arr != null && goodsInfoItemNoS_arr.length > 0) {
            for (int i = 0; i < goodsInfoItemNoS_arr.length; ++i) {
                GoodsProductSon goodsProductSon = new GoodsProductSon();
                goodsProductSon.setGoodsInfoId(Long.valueOf(newId));
                goodsProductSon.setIsUse("0");
                goodsProductSon.setGoodsInfoItemNo(product.getGoodsInfoItemNo());
                goodsProductSon.setGoodsInfoItemNoS(goodsInfoItemNoS_arr[i]);
                goodsProductSon.setGoodsInfoName(product.getGoodsInfoName());
                int saveSon_result = this.goodsProductSonService.inserGoodsProductSon(goodsProductSon);
                if (saveSon_result > 0) {
                    LOGGER.info((Object)("\u751f\u6210\u6210\u529f:\u5b50\u8d27\u54c1\u7f16\u7801:" + goodsProductSon.getGoodsInfoItemNoS() + "\u8d27\u54c1\u7f16\u7801:" + goodsProductSon.getGoodsInfoItemNo()));
                    continue;
                }
                LOGGER.error("\u751f\u6210\u5931\u8d25:\u5b50\u8d27\u54c1\u7f16\u7801:" + goodsProductSon.getGoodsInfoItemNoS() + "\u8d27\u54c1\u7f16\u7801:" + goodsProductSon.getGoodsInfoItemNo());
            }
        }
        this.goodsProductSuppService.batchInsert(suppIds, newId);
        this.searchAsyncService.insertOneGoodsIndexToEs(product.getGoodsId());
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u4fdd\u5b58\u8d27\u54c1\u4fe1\u606f", (String)((String)request.getSession().getAttribute("operaPath") + "\u540d\u79f0\u4e3a\u3010" + product.getGoodsInfoName() + "\u3011,\u7528\u6237\u540d\uff1a" + (String)request.getSession().getAttribute("name")));
        return new ModelAndView((View)new RedirectView("queryAllByGoodsId.htm?goodsId=" + product.getGoodsId() + "&pageNo=" + pb.getPageNo() + "&pageSize=" + pb.getPageSize()));
    }

    @RequestMapping(value={"/updateProduct"})
    public ModelAndView udpateProduct(@Valid GoodsProduct goodsProduct, Integer flag, HttpServletRequest request, Long[] wareId, Long[] productStocks, BigDecimal[] productPrices, String oldPrice, PageBean pb) {
        LOGGER.info((Object)"\u66f4\u65b0\u8d27\u54c1\u4fe1\u606f");
        String[] specId = request.getParameterValues(SPECID);
        String[] specDetailId = request.getParameterValues(SPECDETAILID);
        String[] specRemark = request.getParameterValues(SPECREMARK);
        String[] suppIds = request.getParameterValues("productSupp");
        this.goodsProductService.updateProduct(goodsProduct, (String)request.getSession().getAttribute("name"), specId, specDetailId, specRemark);
        this.goodsOpenSpecValueService.queryOpenListByGoodsAndSpecValueId(goodsProduct.getGoodsId(), specDetailId);
        for (int i = 0; i < wareId.length; ++i) {
            List andCityVo = this.wareHouseService.selectFollow(wareId[i], productPrices[i], goodsProduct.getGoodsInfoId());
            if (null == andCityVo || andCityVo.isEmpty()) continue;
            for (int j = 0; j < andCityVo.size(); ++j) {
                FollowAndCityVo cityVo = (FollowAndCityVo)andCityVo.get(j);
                CustomerInfo infoEmails = this.customerServiceMapper.email(cityVo.getCustId());
                CustomerInfo mobiles = this.customerServiceMapper.mobile(cityVo.getCustId());
                District district = this.districtService.findDistrictByPrimaryKey(cityVo.getDistrictId());
                goodsProduct.setOfollowPrice(cityVo.getFollowPrice());
                goodsProduct.setNfollowPrice(productPrices[i]);
                goodsProduct.setDisName(district.getDistrictName());
                if (infoEmails == null || infoEmails.getInfoEmail() != null) {
                    // empty if block
                }
                if (mobiles == null || mobiles.getInfoMobile() != null) {
                    // empty if block
                }
                CustomerFollow customerFollow = new CustomerFollow();
                customerFollow.setFollowId(cityVo.getAtteId());
                customerFollow.setFollowPrice(productPrices[i]);
                customerFollow.setCreateTime(new Date());
                this.goodsProductService.updateFollow(customerFollow);
            }
        }
        Customer cust = (Customer)request.getSession().getAttribute("cust");
        String ip = IPAddress.getIpAddr((HttpServletRequest)request);
        Long loginUserId = (Long)request.getSession().getAttribute("loginUserId");
        String name = (String)request.getSession().getAttribute("name");
        this.productWareService.calcProductWare(cust, ip, name, loginUserId, goodsProduct.getGoodsInfoId(), productStocks, productPrices, wareId);
        this.goodsProductSuppService.delAll(goodsProduct.getGoodsInfoId());
        this.goodsProductSuppService.batchInsert(suppIds, Integer.parseInt(goodsProduct.getGoodsInfoId().toString()));
        this.searchAsyncService.updateOneGoodsIndexToEs(goodsProduct.getGoodsId());
        if (request.getParameterValues("newgoodsInfoItemNoS") != null) {
            JSONArray jsonArray = JSONArray.fromObject((Object)request.getParameterValues("newgoodsInfoItemNoS"));
            List newGoodsInfoItemNo_list = (List)JSONArray.toCollection((JSONArray)jsonArray, GoodsProductSon.class);
            for (GoodsProductSon goodsProductSon : newGoodsInfoItemNo_list) {
                if (!"".equals(goodsProductSon.getSid()) && !"null".equals(goodsProductSon.getSid())) continue;
                goodsProductSon.setSid(null);
            }
            this.goodsProductSonService.updateByGoodsItemNoSBySid(newGoodsInfoItemNo_list, goodsProduct);
        }
        if (null == flag) {
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u66f4\u65b0\u8d27\u54c1\u4fe1\u606f", (String)((String)request.getSession().getAttribute("operaPath") + LOGGERINFO1 + (String)request.getSession().getAttribute("name")));
            return new ModelAndView((View)new RedirectView("queryAllByGoodsId.htm?goodsId=" + goodsProduct.getGoodsId() + "&pageNo=" + pb.getPageNo() + "&pageSize=" + pb.getPageSize()));
        }
        return new ModelAndView((View)new RedirectView("queryProductListBySomeParam.htm?flag=" + flag + "&pageNo=" + pb.getPageNo() + "&pageSize=" + pb.getPageSize()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/updateProSta"})
    public ModelAndView udpateProductSta(GoodsProduct goodsProduct, Integer flag, HttpServletRequest request, PageBean pb) {
        GoodsProductVo goodsProductVo = this.goodsProductService.queryByPrimaryId(goodsProduct.getGoodsInfoId());
        GoodsProduct pro = new GoodsProduct();
        try {
            ModelAndView modelAndView;
            pro.setGoodsInfoId(goodsProduct.getGoodsInfoId());
            pro.setGoodsId(goodsProduct.getGoodsId());
            if (null != goodsProduct.getGoodsInfoAdded() && !"".equals(goodsProduct.getGoodsInfoAdded())) {
                pro.setGoodsInfoAdded(goodsProduct.getGoodsInfoAdded());
                if ("1".equals(goodsProduct.getGoodsInfoAdded())) {
                    Goods goods = new Goods();
                    goods.setGoodsId(goodsProductVo.getGoodsId());
                    goods.setGoodsAdded("1");
                    this.goodsService.updateGoodsDesc(goods);
                }
            }
            if (null != goodsProduct.getShowList() && !"".equals(goodsProduct.getShowList())) {
                pro.setShowList(goodsProduct.getShowList());
            }
            if (null != goodsProduct.getShowMobile() && !"".equals(goodsProduct.getShowMobile())) {
                pro.setShowMobile(goodsProduct.getShowMobile());
            }
            this.goodsProductService.updateProduct(pro, (String)request.getSession().getAttribute("name"), null, null, null);
            this.searchAsyncService.updateOneGoodsIndexToEs(goodsProduct.getGoodsId());
            if (null == flag && null != goodsProductVo.getGoodsInfoName()) {
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u66f4\u65b0\u8d27\u54c1\u4fe1\u606f", (String)((String)request.getSession().getAttribute("operaPath") + "\u8d27\u54c1\u540d\u79f0\u3010" + goodsProductVo.getGoodsInfoName() + "\u3011,\u7528\u6237\u540d\uff1a" + (String)request.getSession().getAttribute("name")));
                modelAndView = new ModelAndView((View)new RedirectView("queryAllByGoodsId.htm?goodsId=" + pro.getGoodsId() + "&pageNo=" + pb.getPageNo() + "&pageSize=" + pb.getPageSize()));
                return modelAndView;
            }
            modelAndView = new ModelAndView((View)new RedirectView("queryProductListBySomeParam.htm?flag=" + flag + "&pageNo=" + pb.getPageNo() + "&pageSize=" + pb.getPageSize()));
            return modelAndView;
        }
        finally {
            pro = null;
        }
    }

    @RequestMapping(value={"/queryProductForChannel"})
    public ModelAndView queryProductForChannel(PageBean pb, Long cateId, Long brandId, String goodsInfoName, HttpServletRequest request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] cateIds = null;
        if (null != cateId && cateId > 0L) {
            cateIds = new String[]{cateId.toString()};
        }
        String[] brandIds = null;
        if (null != brandId) {
            brandIds = new String[]{brandId.toString()};
        }
        map.put(CATEID, cateId);
        map.put("brandId", brandId);
        map.put("goodsInfoName", goodsInfoName);
        map.put("pb", this.goodsProductService.queryProductForCouponLife(pb, cateIds, brandIds, (Long)request.getSession().getAttribute(THIRDID), null, goodsInfoName, null, null, null, null));
        map.put("brandList", this.goodsBrandService.queryAllBrand());
        return new ModelAndView("jsp/channel/choose_product", "map", map);
    }

    @RequestMapping(value={"/queryProductViewVoByProductId"})
    public ModelAndView queryProductViewVoByProductId(Long productId) {
        GoodsProductDetailViewVo goodsProductDetailViewVo = this.goodsProductService.queryViewVoByProductId(productId);
        if (null != goodsProductDetailViewVo.getGoodsInfoName()) {
            LOGGER.info((Object)("\u83b7\u53d6\u3010" + goodsProductDetailViewVo.getGoodsInfoName() + "\u3011\u7684\u8be6\u7ec6\u4fe1\u606f\uff01"));
        }
        return new ModelAndView("jsp/goods/product_detail").addObject("productDetail", (Object)goodsProductDetailViewVo);
    }

    @RequestMapping(value={"/queryProductListBySomeParam"})
    public ModelAndView queryProductListBySomeParam(Integer flag, PageBean pageBean, SelectBean selectBean) {
        if (null != flag) {
            if (flag == 1) {
                LOGGER.info((Object)"\u6839\u636e\u67e5\u8be2\u6807\u8bb0\u67e5\u8be2\u8d27\u54c1\u5217\u8868,\u6807\u8bb0\u662f\uff1a\u6240\u6709\u5546\u54c1");
            } else if (flag == 2) {
                LOGGER.info((Object)"\u6839\u636e\u67e5\u8be2\u6807\u8bb0\u67e5\u8be2\u8d27\u54c1\u5217\u8868,\u6807\u8bb0\u662f\uff1a\u5df2\u4e0b\u67b6\u5546\u54c1");
            } else if (flag == 3) {
                LOGGER.info((Object)"\u6839\u636e\u67e5\u8be2\u6807\u8bb0\u67e5\u8be2\u8d27\u54c1\u5217\u8868,\u6807\u8bb0\u662f\uff1a\u7f3a\u8d27\u5546\u54c1");
            } else if (flag == 4) {
                LOGGER.info((Object)"\u6839\u636e\u67e5\u8be2\u6807\u8bb0\u67e5\u8be2\u8d27\u54c1\u5217\u8868,\u6807\u8bb0\u662f\uff1a\u5e93\u5b58\u62a5\u8b66\u5546\u54c1");
            }
        } else {
            LOGGER.info((Object)"\u6839\u636e\u67e5\u8be2\u6807\u8bb0\u67e5\u8be2\u8d27\u54c1\u5217\u8868");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pageBean", this.goodsProductService.queryProductListBySomeParam(flag, pageBean, selectBean));
        map.put("flag", flag);
        map.put(SELECTBEAN, selectBean);
        return new ModelAndView("jsp/goods/wel_product_list", "map", map);
    }

    @RequestMapping(value={"/exportProductList"})
    public void exportProductList(Long goodsId, SelectBean selectBean, HttpServletResponse response) {
        GoodsMoifiedVo goods = this.goodsService.queryModeifiedVoByGoodsId(goodsId);
        if (null != goods.getGoodsName()) {
            LOGGER.info((Object)("\u83b7\u53d6\u3010" + goods.getGoodsName() + "\u3011\u4e0b\u9762\u6240\u6709\u7684\u8d27\u54c1\u4fe1\u606f\uff01"));
        }
        try {
            ExportGoodsList.exportProductList((List)this.goodsProductService.queryAllProductByGoodsIdForExport(goodsId, selectBean), (ProductWareService)this.productWareService, (HttpServletResponse)response);
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u51fa\u8d27\u54c1\u5217\u8868\u9519\u8bef" + e);
        }
    }

    @RequestMapping(value={"/exportProductPage"})
    public void exportProductPage(Long goodsId, PageBean pb, SelectBean selectBean, HttpServletResponse response) {
        LOGGER.info((Object)"\u5bfc\u51fa\u5f53\u524d\u663e\u793a\u7684\u8d27\u54c1\u9875\u5217\u8868");
        try {
            ExportGoodsList.exportProductList((List)this.goodsProductService.queryByGoodsId(goodsId, pb, selectBean).getList(), (ProductWareService)this.productWareService, (HttpServletResponse)response);
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u51fa\u5f53\u524d\u663e\u793a\u7684\u8d27\u54c1\u5217\u8868\u9519\u8bef" + e);
        }
    }

    @RequestMapping(value={"/exportProductByChecked"})
    public void exportProductByChecked(Long[] productIds, HttpServletResponse response) {
        LOGGER.info((Object)"\u6839\u636e\u9009\u4e2d\u7684\u8d27\u54c1\u5bfc\u51faExcel");
        try {
            ExportGoodsList.exportProductList((List)this.goodsProductService.queryAllProductByProductIdsForExport(productIds), (ProductWareService)this.productWareService, (HttpServletResponse)response);
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u51faExcel\u9519\u8bef" + e);
        }
    }

    @RequestMapping(value={"/goodsProductSalesRank"})
    public ModelAndView queryGoodsProductSalesRank(PageBean pageBean, String startTime, String endTime, HttpServletRequest request) {
        request.setAttribute("startTime", (Object)startTime);
        request.setAttribute("endTime", (Object)endTime);
        ModelAndView mav = new ModelAndView();
        mav.setViewName("jsp/goods/goodsproduct_salesrank");
        mav.addObject("pageBean", (Object)this.goodsProductService.queryGoodsProductSalesRank(pageBean, startTime, endTime));
        return mav;
    }

    @RequestMapping(value={"/updateproductwarn"})
    public ModelAndView updateProductwarn(HttpServletRequest request, Long[] stockid, Long[] stock, Long[] wareid, Long productId) {
        if (stockid != null && stockid.length != 0) {
            for (int i = 0; i < stockid.length; ++i) {
                StorkWarningUtil sw = new StorkWarningUtil();
                sw.setStockid(stockid[i]);
                sw.setStock(stock[i]);
                this.stockwarningService.updatestock(sw);
                if (stock[i] <= 0L) continue;
                Customer cust = (Customer)request.getSession().getAttribute("cust");
                String ip = IPAddress.getIpAddr((HttpServletRequest)request);
                Long loginUserId = (Long)request.getSession().getAttribute("loginUserId");
                String name = (String)request.getSession().getAttribute("name");
                this.goodsService.updateArrivalNotice(cust, ip, name, loginUserId, productId, wareid[i]);
            }
        }
        return new ModelAndView((View)new RedirectView("warninggoods.htm"));
    }

    public WareHouseService getWareHouseService() {
        return this.wareHouseService;
    }

    @Resource(name="WareHouseService")
    public void setWareHouseService(WareHouseService wareHouseService) {
        this.wareHouseService = wareHouseService;
    }

    public ProductWareService getProductWareService() {
        return this.productWareService;
    }

    @Resource(name="ProductWareService")
    public void setProductWareService(ProductWareService productWareService) {
        this.productWareService = productWareService;
    }

    public GoodsOpenSpecService getGoodsOpenSpecService() {
        return this.goodsOpenSpecService;
    }

    @Resource(name="GoodsOpenSpecService")
    public void setGoodsOpenSpecService(GoodsOpenSpecService goodsOpenSpecService) {
        this.goodsOpenSpecService = goodsOpenSpecService;
    }

    public DistrictService getDistrictService() {
        return this.districtService;
    }

    @Resource(name="DistrictService")
    public void setDistrictService(DistrictService districtService) {
        this.districtService = districtService;
    }

    public StockWarningService getStockwarningService() {
        return this.stockwarningService;
    }

    @Resource(name="StockWarningService")
    public void setStockwarningService(StockWarningService stockwarningService) {
        this.stockwarningService = stockwarningService;
    }
}

