/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goodsCollection.controller;

import com.qianjiang.goodsCollection.bean.OutImg;
import com.qianjiang.goodsCollection.bean.OutKeys;
import com.qianjiang.goodsCollection.bean.OutParam;
import com.qianjiang.goodsCollection.bean.OutSeo;
import com.qianjiang.goodsCollection.bean.OutValues;
import com.qianjiang.util.MyLogger;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class GoodsSpecCollectionController {
    private static final MyLogger LOGGER = new MyLogger(GoodsSpecCollectionController.class);
    private static final String ERROR = "\u6ca1\u6709\u83b7\u53d6\u5230\u4fe1\u606f";

    @RequestMapping(value={"/triggeraddgoods"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> triggeraddgoods(String httpUrl) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (httpUrl.contains("item.jd.com")) {
            String[] params = httpUrl.split("\\?");
            String oo = params[0];
            String regEx = "[^0-9]";
            Pattern p = Pattern.compile(regEx);
            Matcher m1 = p.matcher(oo);
            String code = m1.replaceAll("").trim();
            LOGGER.info((Object)("\u6253\u5370\u6293\u53d6\u5546\u54c1\u7f16\u7801\u7684code......" + code));
            String url = "http://p.3.cn/prices/mgets?skuIds=J_";
            String getPriceUrl = url + code;
            LOGGER.info((Object)("\u6253\u5370\u62fc\u63a5\u540e\u7684\u83b7\u53d6\u4eac\u4e1c\u4ef7\u683c\u7684\u8def\u5f84......." + getPriceUrl));
            String priceHtmlArray = GoodsSpecCollectionController.getHtmlByUrl(getPriceUrl);
            LOGGER.info((Object)("\u6293\u53d6\u4eac\u4e1c\u9875\u9762\u901a\u8fc7ajax\u5f02\u6b65\u52a0\u8f7d\u7684\u6570\u636e\u4eac\u4e1c\u4ef7\u683c,\u6570\u7ec4......" + priceHtmlArray));
            String JDPrice = priceHtmlArray.substring(1, priceHtmlArray.indexOf(93));
            LOGGER.info((Object)("\u6253\u5370JDPrice\u683c\u5f0f......" + JDPrice));
            JSONObject result = JSONObject.fromObject((Object)JDPrice);
            String goodsprice = result.getString("p");
            LOGGER.info((Object)("\u6700\u7ec8\u5f97\u5230\u5546\u54c1\u7684\u4eac\u4e1c\u4ef7\u683c......" + goodsprice));
            map.put("goodPrice", goodsprice);
            map.put("imgList", this.returnImgList(code));
            map.put("mimgList", this.returnImgList(code));
            map.put("goodInfos", this.getName(httpUrl));
            map.put("seo", this.getSeo(httpUrl));
        } else if (httpUrl.contains("detail.tmall.com")) {
            Connection conn = Jsoup.connect((String)httpUrl).userAgent("Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/38.0.2125.122 Safari/537.36 SE 2.X MetaSr 1.0");
            conn.referrer(httpUrl);
            Document doc = conn.get();
            String goodsName = doc.select("meta[name=keywords]").attr("content");
            LOGGER.info((Object)("\u5546\u54c1\u540d\u79f0\u540d\u5b57\u3002\u3002" + goodsName));
            String doctStr1 = doc.toString();
            LOGGER.info((Object)("==========" + doc.toString()));
            LOGGER.info((Object)("\u5929\u732b\u5546\u54c1\u540d\u79f0\u540d\u5b57\u3002\u3002" + goodsName));
            String[] doctStr2 = doctStr1.split("httpsDescUrl");
            String[] sunxtringStr = doctStr2[1].split("apiAddCart");
            String imgUrl = sunxtringStr[0];
            LOGGER.info((Object)("\u6253\u5370\u56fe\u7247\u5f02\u6b65\u52a0\u8f7d\u8def\u5f84:\u3002\u3002\u3002\u3002\u3002" + imgUrl));
            System.err.println(imgUrl);
            String aa = StringUtils.substringBeforeLast((String)imgUrl, (String)"}");
            String[] params = aa.split("//");
            String param1 = params[1];
            String[] param1_1 = param1.split("\"");
            String imgSrc = param1_1[0];
            System.err.println(imgSrc);
            String head = "https://";
            String imgSrcstr = head + imgSrc;
            map.put("imgList", this.returnImgListByTmall(imgSrcstr));
            map.put("mimgList", this.returnImgListByTmall(imgSrcstr));
            map.put("goodPrice", this.getPriceByTamll(httpUrl));
            map.put("goodInfos", this.getGoodsNameByTmall(goodsName));
            map.put("seo", GoodsSpecCollectionController.getSeoByTmall(httpUrl));
        } else if (httpUrl.contains("item.taobao.com")) {
            Connection conn = Jsoup.connect((String)httpUrl).userAgent("Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/38.0.2125.122 Safari/537.36 SE 2.X MetaSr 1.0");
            conn.referrer(httpUrl);
            Document doc = conn.get();
            LOGGER.info((Object)("\u6253\u5370doc2\u7684\u6570\u636e\uff1a\u3002\u3002\u3002" + doc));
            String doctStr = doc.toString();
            LOGGER.info((Object)("==========" + doctStr));
            Elements linksParam = doc.select("title");
            LOGGER.info((Object)("dayin...." + linksParam));
            String title = linksParam.toString();
            String taobaoGoodName = title.substring(title.indexOf("<title>") + 7, title.lastIndexOf("</title>"));
            LOGGER.info((Object)("\u6dd8\u5b9d\u5546\u54c1\u7684\u540d\u5b57\u3002\u3002\u3002\u3002" + taobaoGoodName));
            String pictureUrl = null;
            String[] descUrl = doctStr.split("dsc.taobaocdn.com");
            if (descUrl.length > 0 && descUrl[1] != null && !descUrl[1].equals("")) {
                String decs = descUrl[1];
                String P = decs.substring(decs.indexOf("/"), decs.indexOf("'"));
                String httpHerrer = "http://dsc.taobaocdn.com";
                if (P != null && !P.equals("")) {
                    pictureUrl = httpHerrer + P;
                }
            }
            map.put("imgList", this.returnImgListByTmall(pictureUrl));
            map.put("mimgList", this.returnImgListByTmall(pictureUrl));
            map.put("goodPrice", this.getPriceByTaoBao(httpUrl));
            map.put("goodInfos", this.getGoodsNameByTmall(taobaoGoodName));
            map.put("seo", GoodsSpecCollectionController.getSeoByTaobao(httpUrl));
        }
        return map;
    }

    @RequestMapping(value={"/goodsCateList"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<OutKeys> goodsCateList(String httpUrl) throws IOException {
        ArrayList<OutKeys> outKeys;
        block16: {
            block15: {
                outKeys = new ArrayList<OutKeys>();
                if (!httpUrl.contains("list.jd.com")) break block15;
                String newhttpUrl = httpUrl.replace("|", "%");
                String html = GoodsSpecCollectionController.getHtmlByUrl(newhttpUrl);
                Document doc = Jsoup.parse((String)html);
                Elements linksParam1 = doc.select("div#J_searchWrap>div#J_container>div#J_selector>div.J_selectorLine");
                String param_name = null;
                for (int i = 0; i < linksParam1.size() - 1; ++i) {
                    OutKeys ok = new OutKeys();
                    Elements link = linksParam1.eq(i);
                    Elements link_strong = link.select("div.J_selectorLine>div.sl-wrap>div.sl-key");
                    for (Element ele : link_strong) {
                        String[] param = ele.select("div").text().split("\uff1a");
                        param_name = param[0];
                        LOGGER.info((Object)("\u7b2c...." + i + "...\u4e2a\u89c4\u683c\u7684strong\u6807\u7b7e\u7684\u540d\u5b57:" + param_name));
                        ok.setOutKey(param_name);
                    }
                    Elements link_strong_li_name = link.select("ul.J_valueList>li");
                    ArrayList<OutValues> outValues = new ArrayList<OutValues>();
                    for (Element ele : link_strong_li_name) {
                        OutValues ov = new OutValues();
                        String param = ele.select("li").text();
                        LOGGER.info((Object)("\u7b2c...." + i + "...\u4e2a\u89c4\u683c\u7684\u540d\u5b57:" + param));
                        ov.setOutValue(param);
                        outValues.add(ov);
                        ok.setValues(outValues);
                    }
                    outKeys.add(ok);
                    LOGGER.info((Object)("dayin..." + outKeys.size()));
                }
                break block16;
            }
            if (!httpUrl.contains("s.taobao.com")) break block16;
            String urld = "https://s.taobao.com/search?q=%E5%A5%B3%E9%9E%8B&imgfile=&js=1&stats_click=search_radio_tmall%3A1&initiative_id=staobaoz_20170907&tab=mall&ie=utf8";
            Connection conn = Jsoup.connect((String)urld).userAgent("Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/38.0.2125.122 Safari/537.36 SE 2.X MetaSr 1.0");
            conn.referrer(httpUrl);
            Document doc1 = conn.get();
            LOGGER.info((Object)("aaa" + doc1));
            Elements document = doc1.select("script");
            String aaa = document.eq(7).toString();
            try {
                String[] aaaaa = aaa.split("<script>");
                String bbb = aaaaa[1];
                String[] bbb_1 = bbb.split("</script>");
                String jsonStr = bbb_1[0].trim();
                LOGGER.info((Object)("jsonStr\u7684\u957f\u7684\u90fd..." + jsonStr.length()));
                LOGGER.info((Object)("dayin...." + jsonStr));
                String[] jsonStr1 = jsonStr.split("=");
                String bnmj = jsonStr1[1];
                bnmj.lastIndexOf("}");
                String aa111 = bnmj.substring(0, bnmj.lastIndexOf("}"));
                String we = "}";
                String ere = aa111 + we;
                JSONObject result = JSONObject.fromObject((Object)ere);
                String bbccb = result.getString("mods");
                JSONObject result1 = JSONObject.fromObject((Object)bbccb);
                String ccdd = result1.getString("nav");
                ArrayList<String> listJson = new ArrayList<String>();
                JSONObject result2 = JSONObject.fromObject((Object)ccdd);
                String ccdd_data = result2.getString("data");
                JSONObject result3 = JSONObject.fromObject((Object)ccdd_data);
                String ccdd_data_common = result3.getString("common");
                String[] guige = ccdd_data_common.split("forceShowMore");
                LOGGER.info((Object)("\u89c4\u683c\u6570\u7ec4\u7684\u957f\u5ea6:" + guige.length));
                String newtoStr1 = null;
                int startIndex = guige[0].indexOf("[");
                int endIndex = guige[0].lastIndexOf(",");
                String toStr1 = guige[0].substring(startIndex + 1, endIndex);
                newtoStr1 = toStr1 + "}";
                if (newtoStr1.startsWith("{")) {
                    LOGGER.info((Object)("\u6253\u5370\u7b2c\u4e00\u7ec4\u89c4\u683c:" + newtoStr1));
                    listJson.add(newtoStr1);
                } else {
                    String newtoStr2 = newtoStr1.substring(newtoStr1.indexOf("{"), newtoStr1.lastIndexOf("}")) + "}";
                    listJson.add(newtoStr2);
                }
                int startIndex2 = guige[1].indexOf("}");
                int endIndex2 = guige[1].lastIndexOf(",");
                String toStr2 = guige[1].substring(startIndex2 + 2, endIndex2);
                String newtoStr2 = toStr2 + "}";
                LOGGER.info((Object)("\u6253\u5370\u7b2c2\u7ec4\u89c4\u683c:" + newtoStr2));
                if (newtoStr2.startsWith("{")) {
                    listJson.add(newtoStr2);
                } else {
                    newtoStr2 = newtoStr2.substring(newtoStr2.indexOf("{"), newtoStr2.lastIndexOf("}")) + "}";
                }
                listJson.add(newtoStr2);
                String newtoStr3 = null;
                newtoStr3 = guige[2].substring(guige[2].indexOf("}") + 2, guige[2].lastIndexOf(",")) + "}";
                if (newtoStr3.startsWith("{")) {
                    LOGGER.info((Object)("\u6253\u5370\u7b2c3\u7ec4\u89c4\u683c:" + newtoStr3));
                } else {
                    newtoStr3 = newtoStr3.substring(newtoStr3.indexOf("{"), newtoStr3.lastIndexOf("}")) + "}";
                }
                listJson.add(newtoStr3);
                int startIndex4 = guige[3].indexOf("}");
                int endIndex4 = guige[3].lastIndexOf(",");
                String toStr4 = guige[3].substring(startIndex4 + 2, endIndex4);
                String newtoStr4 = null;
                newtoStr4 = toStr4 + "}";
                if (newtoStr4.startsWith("{")) {
                    LOGGER.info((Object)("\u6253\u5370\u7b2c4\u7ec4\u89c4\u683c:" + newtoStr4));
                } else {
                    newtoStr4 = newtoStr4.substring(newtoStr4.indexOf("{"), newtoStr4.lastIndexOf("}")) + "}";
                }
                listJson.add(newtoStr4);
                for (int i = 0; i < listJson.size(); ++i) {
                    JSONObject result_guige = JSONObject.fromObject(listJson.get(i));
                    String result_brand = result_guige.getString("text");
                    JSONArray result_sub = result_guige.getJSONArray("sub");
                    Iterator result_it = result_sub.iterator();
                    OutKeys ok = new OutKeys();
                    ok.setOutKey(result_brand);
                    ArrayList<OutValues> outValues = new ArrayList<OutValues>();
                    while (result_it.hasNext()) {
                        JSONObject ob = (JSONObject)result_it.next();
                        String name = null;
                        OutValues ov = new OutValues();
                        if (ob.getString("text") == null) continue;
                        name = ob.getString("text");
                        ov.setOutValue(name);
                        outValues.add(ov);
                        ok.setValues(outValues);
                    }
                    outKeys.add(ok);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return outKeys;
    }

    @RequestMapping(value={"/triggerlist"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<OutParam> triggerlist(String httpUrl) {
        try {
            Elements plist;
            Document doc = Jsoup.connect((String)httpUrl).get();
            Elements links = doc.select("table.Ptable");
            ArrayList<OutParam> outPrams = new ArrayList<OutParam>();
            if (links != null && !links.isEmpty()) {
                Elements elist = links.get(0).select("tr");
                if (elist != null && !elist.isEmpty()) {
                    for (int i = 0; i < elist.size(); ++i) {
                        if (elist.get(i).childNodes().size() != 2) continue;
                        OutParam op = new OutParam();
                        op.setOutParam(elist.get(i).child(0).text());
                        outPrams.add(op);
                    }
                }
                return outPrams;
            }
            Elements paramlinks = doc.select("ul.p-parameter-list");
            if (paramlinks != null && !paramlinks.isEmpty() && (plist = paramlinks.get(0).select("li")) != null && !plist.isEmpty()) {
                for (int j = 0; j < plist.size(); ++j) {
                    OutParam op = new OutParam();
                    op.setOutParam(plist.get(j).text().split("\uff1a")[0]);
                    outPrams.add(op);
                }
            }
            return outPrams;
        }
        catch (Exception e) {
            LOGGER.error(ERROR, (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<OutImg> returnImgList(String code) {
        ArrayList<OutImg> imglist = new ArrayList<OutImg>();
        String imgUrl2 = "http://dx.3.cn/desc/" + code;
        LOGGER.info((Object)("dayn....." + imgUrl2));
        String imgcontent = GoodsSpecCollectionController.getHtmlByUrl(imgUrl2);
        LOGGER.info((Object)("dayin...." + imgcontent));
        if (imgcontent != null && !"".equals(imgcontent)) {
            String[] imgother = imgcontent.split("360buyimg.com");
            LOGGER.info((Object)("\u6253\u5370\u6570\u7ec4\u3002\u3002\u3002\u3002\u3002\u3002\u3002" + imgcontent));
            for (int p = 1; p < imgother.length; ++p) {
                String returnUrl = imgother[p];
                if (imgother[p].indexOf("\\\"") != -1) {
                    returnUrl = returnUrl.substring(0, imgother[p].indexOf("\\\""));
                }
                if (returnUrl.indexOf(")") != -1) {
                    returnUrl = returnUrl.substring(0, returnUrl.indexOf(")"));
                }
                OutImg oi = new OutImg();
                String imgUrl = "http://img30.360buyimg.com" + returnUrl;
                LOGGER.info((Object)("\u6253\u5370\u3002\u3002\u3002\u3002\u3002" + imgUrl));
                oi.setImgUrl(imgUrl);
                imglist.add(oi);
            }
        }
        return imglist;
    }

    public List<OutImg> returnImgListByTmall(String imgSrcstr) {
        LOGGER.info((Object)("dayn....." + imgSrcstr));
        ArrayList<OutImg> imglist = new ArrayList<OutImg>();
        String imgcontent = GoodsSpecCollectionController.getHtmlByUrl(imgSrcstr);
        Document doc = Jsoup.parse((String)imgcontent);
        Elements linksParam1 = doc.select("img");
        for (Element ele : linksParam1) {
            OutImg oi = new OutImg();
            String param = ele.absUrl("src");
            if (!param.contains("img.alicdn.com")) continue;
            System.err.println("\u5355\u4e2a\u56fe\u7247\u8def\u5f84...." + param);
            oi.setImgUrl(param);
            imglist.add(oi);
        }
        return imglist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHtmlByUrl(String url) {
        String html = null;
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpGet httpget = new HttpGet(url);
        try {
            HttpEntity entity;
            CloseableHttpResponse responce = httpClient.execute((HttpUriRequest)httpget);
            int resStatu = responce.getStatusLine().getStatusCode();
            if (resStatu == 200 && (entity = responce.getEntity()) != null) {
                html = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
                LOGGER.info((Object)html);
            }
        }
        catch (Exception e) {
            LOGGER.info((Object)("\u8bbf\u95ee\u3010" + url + "\u3011\u51fa\u73b0\u5f02\u5e38!"));
            e.printStackTrace();
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
        return html;
    }

    private Map<String, Object> getName(String httpUrl) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String goodsName = "";
        String goodHeight = "";
        try {
            Document doc = Jsoup.connect((String)httpUrl).get();
            Elements goodsInfoName = doc.select("div.p-parameter>ul.parameter2>li:eq(0)");
            for (Element ele : goodsInfoName) {
                goodsName = ele.select("li").text();
                String[] name = goodsName.split("\\\uff1a");
                resultMap.put("goodsName", name[1]);
                LOGGER.info((Object)("dayin\u5546\u54c1\u540d\u79f0......" + goodsName));
            }
            Elements goodsInfos = doc.select("div.p-parameter>ul.parameter2>li");
            for (Element ele : goodsInfos) {
                goodHeight = ele.select("li").text();
                if (!goodHeight.contains("\u5546\u54c1\u6bdb\u91cd")) continue;
                String[] height = goodHeight.split("\\\uff1a");
                resultMap.put("goodHeight", height[1]);
                LOGGER.info((Object)("dayin\u5546\u54c1\u91cd\u91cf......" + goodHeight));
            }
        }
        catch (IOException e) {
            goodsName = null;
            LOGGER.error(ERROR, (Throwable)e);
        }
        return resultMap;
    }

    private OutSeo getSeo(String httpUrl) throws IOException {
        Document doc;
        if (httpUrl.contains("detail.tmall.com")) {
            Connection conn = Jsoup.connect((String)httpUrl).userAgent("Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/38.0.2125.122 Safari/537.36 SE 2.X MetaSr 1.0");
            conn.referrer(httpUrl);
            Document document = conn.get();
        }
        OutSeo os = new OutSeo();
        try {
            doc = Jsoup.connect((String)httpUrl).get();
        }
        catch (IOException e) {
            LOGGER.error(ERROR, (Throwable)e);
            return os;
        }
        Elements d = doc.getElementsByTag("title");
        os.setSeoTitle(d.get(0).text());
        Elements contents = doc.getElementsByTag("meta");
        if (CollectionUtils.isNotEmpty((Collection)contents)) {
            for (Element content : contents) {
                String tagName = content.attr("name");
                if ("keywords".equals(tagName)) {
                    os.setSeoKeywords(content.attr("content"));
                    continue;
                }
                if (!"description".equals(tagName)) continue;
                os.setSeoDescription(content.attr("content"));
            }
        }
        return os;
    }

    public static OutSeo getSeoByTmall(String httpUrl) throws IOException {
        Document doc = null;
        if (httpUrl.contains("detail.tmall.com")) {
            Connection conn = Jsoup.connect((String)httpUrl).userAgent("Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/38.0.2125.122 Safari/537.36 SE 2.X MetaSr 1.0");
            conn.referrer(httpUrl);
            doc = conn.get();
        }
        OutSeo os = new OutSeo();
        Elements d = doc.getElementsByTag("title");
        LOGGER.info((Object)("title..." + d.eq(0).text()));
        os.setSeoTitle(d.eq(0).text());
        Elements contents = doc.getElementsByTag("meta");
        if (CollectionUtils.isNotEmpty((Collection)contents)) {
            for (Element content : contents) {
                String tagName = content.attr("name");
                if ("keywords".equals(tagName)) {
                    os.setSeoKeywords(content.attr("content"));
                    continue;
                }
                if (!"description".equals(tagName)) continue;
                os.setSeoDescription(content.attr("content"));
            }
        }
        return os;
    }

    public String getPriceByTamll(String urld) {
        String[] numbers = urld.split("&");
        String m2 = null;
        String numbers2 = null;
        for (int i = 0; i < numbers.length; ++i) {
            numbers2 = "&" + numbers[i];
            if (!numbers2.contains("&id=")) continue;
            m2 = numbers[i].substring(numbers[i].indexOf("=") + 1, numbers[i].length() - numbers[i].indexOf("=") + 2);
            LOGGER.info((Object)("\u6253\u5370\u3002\u3002\u3002\u3002" + m2));
        }
        String newurl = "https://ext-mdskip.taobao.com/extension/queryTmallCombo.do?itemId=";
        String AA = newurl + m2;
        LOGGER.info((Object)("\u6253\u5370\u3002\u3002\u3002\u3002" + AA));
        String priceHtmlArray = GoodsSpecCollectionController.getHtmlByUrl(AA);
        int beginNumber = priceHtmlArray.indexOf(":") + 1;
        int endNumber = priceHtmlArray.lastIndexOf("success") - 2;
        String prices = priceHtmlArray.substring(beginNumber, endNumber);
        JSONObject result = JSONObject.fromObject((Object)prices);
        String itemsJson = result.getString("items");
        if (!itemsJson.equals("null")) {
            JSONObject result1 = JSONObject.fromObject((Object)itemsJson);
            LOGGER.info((Object)("\u6253\u5370\u3002\u3002\u3002" + result1));
            String item = m2;
            String spiltItemJson = result1.getString(item);
            LOGGER.info((Object)("\u6253\u5370\u5b57\u7b26\u4e32\u3002\u3002\u3002" + spiltItemJson));
            int beginNumber2 = spiltItemJson.lastIndexOf(":") + 2;
            int endNumber2 = spiltItemJson.lastIndexOf("\"");
            String title = spiltItemJson.substring(beginNumber2, endNumber2);
            this.getGoodsNameByTmall(title);
            JSONObject result2 = JSONObject.fromObject((Object)spiltItemJson);
            String skuMap = result2.getString("skuMap");
            JSONObject json = JSONObject.fromObject((Object)skuMap);
            Iterator itt = json.keys();
            ArrayList<String> prices2 = new ArrayList<String>();
            while (itt.hasNext()) {
                String key = itt.next().toString();
                String value = json.getString(key);
                String price = null;
                JSONObject result22 = JSONObject.fromObject((Object)value);
                String comboPrice = result22.getString("comboPrice").trim();
                if (!comboPrice.equals("null")) {
                    price = comboPrice;
                } else {
                    String comboPrice2 = result22.getString("price").trim();
                    if (!comboPrice2.equals("null")) {
                        price = comboPrice2;
                    }
                }
                prices2.add(price);
            }
            return (String)prices2.get(0);
        }
        return "0";
    }

    public BigDecimal getPriceByTaoBao(String url) {
        String[] params = url.split("id=");
        String oo = params[1];
        String[] params1 = oo.split("&");
        String goodsId = params1[0];
        url = "https://item.taobao.com/item.htm?id=" + goodsId;
        BigDecimal goodsPrice = null;
        try {
            Element em;
            Elements ems;
            Element j_PromoHd;
            Document doc;
            if (!StringUtils.isEmpty((String)url) && (doc = Jsoup.connect((String)url).timeout(60).get()) != null && (j_PromoHd = doc.getElementById("J_StrPrice")) != null && (ems = j_PromoHd.getElementsByTag("em")) != null && (em = ems.get(1)) != null) {
                String price = em.text();
                goodsPrice = new BigDecimal(price);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return goodsPrice;
    }

    public Map<String, Object> getGoodsNameByTmall(String name) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsName", name);
        return map;
    }

    public static OutSeo getSeoByTaobao(String httpUrl) throws IOException {
        Document doc = null;
        Connection conn = Jsoup.connect((String)httpUrl).userAgent("Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/38.0.2125.122 Safari/537.36 SE 2.X MetaSr 1.0");
        doc = conn.get();
        OutSeo os = new OutSeo();
        Elements d = doc.getElementsByTag("title");
        LOGGER.info((Object)("title..." + d.eq(0).text()));
        os.setSeoTitle(d.eq(0).text());
        Elements contents = doc.getElementsByTag("meta");
        if (CollectionUtils.isNotEmpty((Collection)contents)) {
            for (Element content : contents) {
                String tagName = content.attr("name");
                if ("keywords".equals(tagName)) {
                    os.setSeoKeywords(content.attr("content"));
                    continue;
                }
                if (!"description".equals(tagName)) continue;
                os.setSeoDescription(content.attr("content"));
            }
        }
        return os;
    }
}

