/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.information.controller;

import com.qianjiang.information.bean.Information;
import com.qianjiang.information.service.ThirdInforService;
import com.qianjiang.information.service.ThirdInforTypeService;
import com.qianjiang.third.util.MenuOperationUtil;
import com.qianjiang.util.PageBean;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ThirdInforController {
    private static final String THIRDID = "thirdId";
    private static final String QUERYTHIRDINFOVOLIST_HTM = "queryThirdInfoVoList.htm";
    @Resource(name="ThirdInforTypeService")
    private ThirdInforTypeService thirdInforTypeService;
    @Resource(name="ThirdInforService")
    private ThirdInforService infoService;

    @ResponseBody
    @RequestMapping(value={"getThirdInfoTypeCount"}, produces={"application/json;charset=UTF-8"})
    public int getThirdInfoTypeCount(HttpServletRequest request) {
        String thirdId = ((Long)request.getSession().getAttribute(THIRDID)).toString();
        return this.thirdInforTypeService.selectInfoTypeByAttr(thirdId).size();
    }

    @RequestMapping(value={"/queryThirdInfoVoList"})
    public ModelAndView queryThirdInfoVoList(HttpServletRequest request, String n, String l, PageBean pb, Long typeId, String infoName) {
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        String thirdId = ((Long)request.getSession().getAttribute(THIRDID)).toString();
        if (null == thirdId || "".equals(thirdId)) {
            thirdId = "1";
        }
        List infoTypes = this.thirdInforTypeService.selectInfoTypeByAttr(thirdId);
        return new ModelAndView("information/third_info_list", "pb", (Object)this.infoService.queryByPageBean(pb, infoName, typeId, thirdId)).addObject("infoTypes", (Object)infoTypes).addObject("typeId", (Object)typeId).addObject("infoName", (Object)infoName);
    }

    @RequestMapping(value={"/showThirdInformation"})
    public ModelAndView showThirdInfo(HttpServletRequest request, Long infoId) {
        String thirdId;
        ModelAndView mav = new ModelAndView();
        if (infoId != null) {
            Information info = this.infoService.selectByPrimaryKey(infoId);
            mav.addObject("info", (Object)info);
        }
        if (null == (thirdId = ((Long)request.getSession().getAttribute(THIRDID)).toString()) || "".equals(thirdId)) {
            thirdId = "1";
        }
        List infoTypes = this.thirdInforTypeService.selectInfoTypeByAttr(thirdId);
        mav.addObject("infoTypes", (Object)infoTypes);
        mav.setViewName("information/show_third_info");
        return mav;
    }

    @RequestMapping(value={"/addThirdInformation"})
    public ModelAndView addThirdInfo(HttpServletRequest request, HttpServletResponse response, Information information) {
        information.setCreateUserId(Long.valueOf(1L));
        String thirdId = ((Long)request.getSession().getAttribute(THIRDID)).toString();
        if (null == thirdId || "".equals(thirdId)) {
            thirdId = "1";
        }
        information.setTemp2(thirdId);
        this.infoService.saveInfo(information);
        return new ModelAndView((View)new RedirectView(QUERYTHIRDINFOVOLIST_HTM));
    }

    @RequestMapping(value={"/updateThirdInformation"})
    public ModelAndView updateThirdInfo(HttpServletRequest request, HttpServletResponse response, Information information) {
        information.setUpdateUserId(Long.valueOf(1L));
        this.infoService.updateInfo(information);
        return new ModelAndView((View)new RedirectView(QUERYTHIRDINFOVOLIST_HTM));
    }

    @RequestMapping(value={"/delThirdInformation"})
    public ModelAndView delThirdInfo(HttpServletRequest request, Long[] infoIds) {
        for (int i = 0; i < infoIds.length; ++i) {
            this.infoService.delInfo(infoIds[i]);
        }
        return new ModelAndView((View)new RedirectView(QUERYTHIRDINFOVOLIST_HTM));
    }

    @RequestMapping(value={"/checkThirdInformationByTitle"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean checkThirdInfoByTitle(HttpServletRequest request, String title, Long infoId) {
        String thirdId = ((Long)request.getSession().getAttribute(THIRDID)).toString();
        if (null == thirdId || "".equals(thirdId)) {
            thirdId = "1";
        }
        if (null != infoId) {
            return this.infoService.checkAddInfoByTitle(title, thirdId, infoId);
        }
        return this.infoService.checkAddInfoByTitle(title, thirdId);
    }
}

