/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.information.controller;

import com.qianjiang.information.bean.InformationType;
import com.qianjiang.information.service.ThirdInforService;
import com.qianjiang.information.service.ThirdInforTypeService;
import com.qianjiang.information.vo.InformationTypeVo;
import com.qianjiang.third.util.MenuOperationUtil;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ThirdInforTypeController {
    @Resource(name="ThirdInforTypeService")
    private ThirdInforTypeService thirdInforTypeService;
    @Resource(name="ThirdInforService")
    private ThirdInforService infoService;
    private static final String JUMPURL = "jumpForThirdInfoTypeView.htm";
    private static final String LOGINUSERID = "loginUserId";
    private static final String THIRDID = "thirdId";

    @RequestMapping(value={"/delThirdInfoType"})
    public ModelAndView delThirdInfoType(HttpServletRequest request, Long infoTypeId) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        this.thirdInforTypeService.delInformation(infoTypeId, loginUserId);
        return new ModelAndView((View)new RedirectView(JUMPURL));
    }

    @RequestMapping(value={"/batchDelThirdInfoType"})
    public ModelAndView batchDelThirdInfoType(HttpServletRequest request, Long[] infoTypeIds) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        this.thirdInforTypeService.batchDelInformation(infoTypeIds, loginUserId);
        return new ModelAndView((View)new RedirectView(JUMPURL));
    }

    @RequestMapping(value={"/showThirdInfoType"})
    public ModelAndView showThirdInfo(HttpServletRequest request, HttpServletResponse response, Long infoTypeId) {
        ModelAndView mav = new ModelAndView();
        InformationType infoType = new InformationType();
        if (null != infoTypeId) {
            infoType = this.thirdInforTypeService.selectByPrimaryKey(infoTypeId);
        }
        mav.addObject("infoType", (Object)infoType);
        String thirdId = ((Long)request.getSession().getAttribute(THIRDID)).toString();
        if (null == thirdId || "".equals(thirdId)) {
            thirdId = "1";
        }
        List infoTypes = this.thirdInforTypeService.selectAllByThirdId(thirdId);
        mav.addObject("infoTypes", (Object)infoTypes);
        mav.setViewName("information/show_third_infotype");
        return mav;
    }

    @RequestMapping(value={"/selectInfoTypeByPrimaryKey"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public InformationType selectInfoTypeByPrimaryKey(Long infoTypeId) {
        return this.thirdInforTypeService.selectByPrimaryKey(infoTypeId);
    }

    @RequestMapping(value={"/saveThirdInfoType"})
    public ModelAndView saveThirdInfoType(HttpServletRequest request, InformationType infotype) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        infotype.setCreateUserId(loginUserId);
        infotype.setUpdateUserId(loginUserId);
        String thirdId = ((Long)request.getSession().getAttribute(THIRDID)).toString();
        if (null == thirdId || "".equals(thirdId)) {
            thirdId = "1";
        }
        this.thirdInforTypeService.saveInformation(infotype, thirdId);
        return new ModelAndView((View)new RedirectView(JUMPURL));
    }

    @RequestMapping(value={"/updateThirdInfoType"})
    public ModelAndView updateThirdInfoType(HttpServletRequest request, InformationType infotype) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        infotype.setUpdateUserId(loginUserId);
        this.thirdInforTypeService.updateInformation(infotype);
        return new ModelAndView((View)new RedirectView(JUMPURL));
    }

    @RequestMapping(value={"/checkDelThirdInfoType"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> checkDelThirdInfoType(Long infoTypeId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean flag = false;
        flag = this.thirdInforTypeService.checkDelWithInfoTypeId(infoTypeId);
        if (flag) {
            flag = this.infoService.checkDelInfoTypeByInfoCount(infoTypeId);
            if (flag) {
                map.put("flag", flag);
            } else {
                map.put("flag", flag);
                map.put("msg", "\u8be5\u680f\u76ee\u4e0b\u6709\u6587\u7ae0\uff0c\u4e0d\u80fd\u5220\u9664");
            }
        } else {
            map.put("flag", flag);
            map.put("msg", "\u8be5\u680f\u76ee\u4e0b\u6709\u5b50\u680f\u76ee\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        return map;
    }

    @RequestMapping(value={"/selectAllThirdInfoType"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<InformationTypeVo> selectAllThirdInfoType(HttpServletRequest request) {
        String thirdId = ((Long)request.getSession().getAttribute(THIRDID)).toString();
        if (null == thirdId || "".equals(thirdId)) {
            thirdId = "1";
        }
        return this.thirdInforTypeService.selectAllByThirdId(thirdId);
    }

    @RequestMapping(value={"/queryThirdInfoTypeVoList"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public PageBean queryThirdInfoTypeVoList(HttpServletRequest request, PageBean pb, String searchText) {
        String thirdId = ((Long)request.getSession().getAttribute(THIRDID)).toString();
        if (null == thirdId || "".equals(thirdId)) {
            thirdId = "1";
        }
        return this.thirdInforTypeService.queryByPageBean(pb, searchText, thirdId);
    }

    @RequestMapping(value={"/jumpForThirdInfoTypeView"})
    public ModelAndView jumpForThirdInfoTypeView(HttpServletRequest request, String n, String l) {
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        return new ModelAndView("information/third_infotype_list");
    }

    @RequestMapping(value={"/checkThirdInfoTypeName"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean checkThirdInfoTypeName(HttpServletRequest request, String name, Long infoTypeId) {
        String thirdId = ((Long)request.getSession().getAttribute(THIRDID)).toString();
        if (null == thirdId || "".equals(thirdId)) {
            thirdId = "1";
        }
        if (null != infoTypeId) {
            return this.thirdInforTypeService.checkAddInfoTypeByName(name, thirdId, infoTypeId);
        }
        return this.thirdInforTypeService.checkAddInfoTypeByName(name, thirdId);
    }

    @RequestMapping(value={"/getThirdInfoTypeWhenHaveInfo"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<InformationType> getThirdInfoTypeWhenHaveInfo(HttpServletRequest request) {
        String thirdId = ((Long)request.getSession().getAttribute(THIRDID)).toString();
        if (null == thirdId || "".equals(thirdId)) {
            thirdId = "1";
        }
        return this.thirdInforTypeService.selectInfoTypeByAttr(thirdId);
    }
}

