/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.storestreet.controller;

import com.qianjiang.third.storestreet.bean.StoreStreetThirdImage;
import com.qianjiang.third.storestreet.service.StoreStreetService;
import com.qianjiang.third.util.MenuOperationUtil;
import com.qianjiang.util.UploadUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class StoreStreetController {
    private static final String THIRDID = "thirdId";
    private static final String STORESTREET_HTML = "/storeStreet.html";
    @Resource(name="storeStreetService")
    private StoreStreetService storeStreetService;

    @RequestMapping(value={"/storeStreetthird"})
    public ModelAndView selectExpress(HttpServletRequest request, String n, String l) {
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        HashMap<String, List> resultMap = new HashMap<String, List>();
        List storeInfoImageList = this.storeStreetService.selectStoreStreetListImage((Long)request.getSession().getAttribute(THIRDID));
        resultMap.put("storestreetimage", storeInfoImageList);
        return new ModelAndView("storestreet/storestreetimage").addObject("storeInfoImageList", (Object)storeInfoImageList);
    }

    @RequestMapping(value={"saveStoreStreetImage"})
    public ModelAndView saveStoreStreetImage(MultipartHttpServletRequest request, StoreStreetThirdImage storeStreetThirdImage) {
        MultipartFile muFile = request.getFile("imgSrc");
        if (muFile.getSize() > 0L) {
            storeStreetThirdImage.setStoreId((Long)request.getSession().getAttribute(THIRDID));
            storeStreetThirdImage.setImageAddress(UploadUtil.uploadFileOne((MultipartFile)muFile));
            storeStreetThirdImage.setCreatetime(new Date());
            this.storeStreetService.saveStoreStreetImage(storeStreetThirdImage);
        }
        return new ModelAndView((View)new RedirectView(request.getContextPath() + STORESTREET_HTML));
    }

    @RequestMapping(value={"updateStoreStreetImage"})
    public ModelAndView updateStoreStreetImage(HttpServletRequest request, StoreStreetThirdImage storeStreetThirdImage) {
        this.storeStreetService.updateStoreStreetImage(storeStreetThirdImage);
        return new ModelAndView((View)new RedirectView(request.getContextPath() + STORESTREET_HTML));
    }

    @RequestMapping(value={"updateStoremage"})
    public ModelAndView updateStoremage(MultipartHttpServletRequest request, StoreStreetThirdImage storeStreetThirdImage) {
        MultipartFile muFile = request.getFile("imgSrc");
        storeStreetThirdImage.setImageAddress(UploadUtil.uploadFileOne((MultipartFile)muFile, (HttpServletRequest)request));
        this.storeStreetService.updateStoreStreetImage(storeStreetThirdImage);
        return new ModelAndView((View)new RedirectView(request.getContextPath() + STORESTREET_HTML));
    }

    @RequestMapping(value={"selectStoreStreetImageById"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public StoreStreetThirdImage selectStoreStreetImageById(Long imageId) {
        return this.storeStreetService.selectStoreStreetImageById(imageId);
    }

    @RequestMapping(value={"delAllImage"})
    public ModelAndView delAllImage(HttpServletRequest request, Long[] imageId) {
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        this.storeStreetService.updateImages(imageId, thirdId);
        return new ModelAndView((View)new RedirectView(request.getContextPath() + STORESTREET_HTML));
    }
}

