/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.goods.controller;

import com.qianjiang.goods.service.GoodsCateService;
import com.qianjiang.third.goods.bean.GoodsBrand;
import com.qianjiang.third.goods.bean.GoodsCate;
import com.qianjiang.third.goods.bean.GoodsTag;
import com.qianjiang.third.goods.service.ThirdOtherService;
import com.qianjiang.third.util.PageBean;
import com.qianjiang.util.MyLogger;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ThirdOtherController {
    private static final MyLogger LOGGER = new MyLogger(ThirdOtherController.class);
    @Resource(name="ThirdOtherService")
    private ThirdOtherService thirdOtherService;
    @Resource(name="GoodsCateService")
    private GoodsCateService goodsCateService;

    @RequestMapping(value={"/queryGrandBrandByThirdId"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<GoodsBrand> queryGrandBrandByThirdId(HttpServletRequest request) {
        ArrayList<GoodsBrand> list = new ArrayList();
        Long thirdId = (Long)request.getSession().getAttribute("thirdId");
        try {
            list = this.thirdOtherService.queryGrandBrandByThirdId(thirdId);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u67e5\u8be2\u6240\u6709\u6388\u6743\u7684\u5546\u54c1\u54c1\u724c\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return list;
    }

    @RequestMapping(value={"/queryAllTagForThird"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<GoodsTag> queryAllTagForThird() {
        ArrayList<GoodsTag> list = new ArrayList();
        try {
            list = this.thirdOtherService.queryAllGoodsTagForThird();
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u67e5\u8be2\u6240\u6709\u7684\u5546\u54c1\u6807\u7b7e\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return list;
    }

    @RequestMapping(value={"/queryAllGrandCateForThird"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<GoodsCate> queryAllGrandCateForThird(HttpServletRequest request) {
        ArrayList<GoodsCate> list = new ArrayList();
        Long thirdId = (Long)request.getSession().getAttribute("thirdId");
        try {
            list = this.thirdOtherService.queryGrandCateForThird(thirdId);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error(" \u67e5\u8be2\u6240\u6709\u7684\u7b2c\u4e09\u65b9\u7b7e\u7ea6\u7684\u5206\u7c7b\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return list;
    }

    @RequestMapping(value={"/queryAllGrandCateForThirdtwo"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<GoodsCate> queryAllGrandCateForThirdtwo(Long cateId, HttpServletRequest request) {
        ArrayList<GoodsCate> list = new ArrayList();
        Long thirdId = (Long)request.getSession().getAttribute("thirdId");
        try {
            list = this.thirdOtherService.queryGrandCateForThirdnew(thirdId, cateId);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u67e5\u8be2\u5546\u5bb6\u7684\u5546\u54c1\u7c7b\u76ee\u7684\u4e00\u7ea7\u5206\u7c7b\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return list;
    }

    @RequestMapping(value={"/queryAllGrandCateForThirdThree"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<com.qianjiang.goods.bean.GoodsCate> queryAllGrandCateForThirdThree(Long cateId, HttpServletRequest request) {
        ArrayList<com.qianjiang.goods.bean.GoodsCate> list = new ArrayList();
        try {
            list = this.goodsCateService.querySonCateByParentId(cateId);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u7236\u5206\u7c7bID \u67e5\u8be2\u5b50\u5206\u7c7b\u5217\u8868\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return list;
    }

    @RequestMapping(value={"/queryAboutGoodsByThirdInfo"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public PageBean queryAboutGoodsByThirdInfo(Long goodsCatId, PageBean pb, HttpServletRequest request) {
        Long thirdId = (Long)request.getSession().getAttribute("thirdId");
        try {
            this.thirdOtherService.queryAboutGoodsForThirdByThirdInfo(pb, thirdId, goodsCatId);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u7b2c\u4e09\u65b9\u76f8\u5173\u53c2\u6570\u67e5\u8be2\u76f8\u5173\u5546\u54c1\u7684\u96c6\u5408\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return pb;
    }
}

