/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.order.controller;

import com.qianjiang.coupon.bean.Coupon;
import com.qianjiang.coupon.service.CouponService;
import com.qianjiang.customer.bean.Customer;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogBean;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.order.bean.Order;
import com.qianjiang.order.bean.OrderContainer;
import com.qianjiang.order.bean.OrderExpress;
import com.qianjiang.order.service.OrderCouponService;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.system.bean.LogisticsSingle;
import com.qianjiang.system.service.LogisticsSingleService;
import com.qianjiang.system.util.BasicSetUtil;
import com.qianjiang.third.auth.bean.ThirdPage;
import com.qianjiang.third.auth.service.ThirdAuthorityPageService;
import com.qianjiang.third.goods.service.ThirdGoodsService;
import com.qianjiang.third.logger.util.OperateLogUtil;
import com.qianjiang.third.order.service.ThirdOrderService;
import com.qianjiang.third.seller.bean.Express;
import com.qianjiang.third.seller.service.ExpressInfoService;
import com.qianjiang.third.seller.service.SellerService;
import com.qianjiang.third.util.DateUtils;
import com.qianjiang.third.util.MenuOperationUtil;
import com.qianjiang.third.util.OrderGoods;
import com.qianjiang.third.util.PageBean;
import com.qianjiang.util.MyLogger;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ThirdOrderController {
    private static final MyLogger LOGGER = new MyLogger(ThirdOrderController.class);
    private static final String THIRDID = "thirdId";
    private static final String ORDER = "order";
    private static final String THIRDORDERDELIVERYS_HTML = "thirdorderdeliverys.html";
    private static final String STATUS = "status";
    private static final String CUSTOMERID = "customerId";
    private ThirdOrderService orderService;
    private OrderService bossOrderService;
    @Resource
    private ThirdGoodsService thirdGoodsService;
    private ExpressInfoService expressInfoService;
    @Resource(name="LogisticsSingleService")
    private LogisticsSingleService logisticsSingleService;
    @Resource(name="sellerService")
    private SellerService sellerService;
    @Resource(name="OrderCouponService")
    private OrderCouponService orderCouponService;
    @Resource(name="CouponService")
    private CouponService couponService;
    @Resource(name="thirdAuthorityPageService")
    private ThirdAuthorityPageService thirdManagerService;

    @RequestMapping(value={"/queryThirdOrderList"})
    public ModelAndView queryThirdOrderList(PageBean pb, String n, String l, HttpServletRequest request, Order order) throws UnsupportedEncodingException {
        String date;
        String urlType = request.getParameter("urlType");
        if (!StringUtils.isEmpty((String)urlType) && "toDay".equals(urlType)) {
            LOGGER.info((Object)"\u67e5\u8be2\u4eca\u65e5\u8ba2\u5355");
            date = DateUtils.getTodayDate(null);
            order.setStartTime(date);
            order.setEndTime(date);
        } else if (!StringUtils.isEmpty((String)urlType) && "yesterday".equals(urlType)) {
            LOGGER.info((Object)"\u67e5\u8be2\u6628\u65e5\u8ba2\u5355");
            date = DateUtils.getBeforeTodayAfter(null, -1);
            order.setStartTime(date);
            order.setEndTime(date);
        }
        if (null != order.getShippingPerson()) {
            String str = new String(order.getShippingPerson().getBytes("ISO8859-1"), "utf-8");
            order.setShippingPerson(str);
        }
        pb.setUrl("queryThirdOrderList");
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        order.setBusinessId((Long)request.getSession().getAttribute(THIRDID));
        order.setDelFlag("0");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(ORDER, order);
        map.put("bset", BasicSetUtil.getAddress((String)this.thirdGoodsService.bsetUrl()));
        map.put("pb", this.orderService.searchOrderList(pb, order));
        pb.setUrl("queryThirdOrderList.htm?n=" + n + "&l=" + l);
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        List thirdPages = this.thirdManagerService.queryMenuByManager(customerId);
        String isPage = "";
        if (thirdPages != null && !thirdPages.isEmpty()) {
            block0: for (int j = 0; j < thirdPages.size(); ++j) {
                if (((ThirdPage)thirdPages.get(j)).getMenuVos() == null || ((ThirdPage)thirdPages.get(j)).getMenuVos().isEmpty()) continue;
                for (int i = 0; i < ((ThirdPage)thirdPages.get(j)).getMenuVos().size(); ++i) {
                    if (!"querythirdoutstock.html".equals(((ThirdPage)thirdPages.get(j)).getMenuVos().get(i).getUrl())) continue;
                    isPage = "0";
                    continue block0;
                }
            }
        }
        map.put("isPage", isPage);
        return new ModelAndView("order/thirdorderlist", "map", map);
    }

    @RequestMapping(value={"/searcharOrderByParam"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Order searcharOrderByParam(Long orderId) {
        return this.orderService.searcharOrderByParam(orderId);
    }

    @RequestMapping(value={"/updateThirdOrder"})
    public ModelAndView updateThirdOrder(HttpServletRequest request, Order order) {
        Customer cust;
        order.setBusinessId((Long)request.getSession().getAttribute(THIRDID));
        Order orderPre = this.orderService.searcharOrderByParam(order.getOrderId());
        order.setModifyPrice(orderPre.getOrderPrice().subtract(order.getOrderPrice()));
        this.orderService.updateThirdOrder(order);
        List orderGoodses = this.orderService.queryOrderGoods(order.getOrderId());
        BigDecimal all = BigDecimal.ZERO;
        for (OrderGoods og : orderGoodses) {
            all = all.add(og.getGoodsBackPrice());
        }
        for (OrderGoods orderGoods : orderGoodses) {
            this.orderService.modifyGoodsBackPrice(orderGoods.getGoodsBackPrice().subtract(orderGoods.getGoodsBackPrice().multiply(order.getModifyPrice()).divide(all, 2)), order.getOrderId(), orderGoods.getGoodsInfoId());
        }
        if (request.getSession().getAttribute("cust") != null && (cust = (Customer)request.getSession().getAttribute("cust")).getCustomerUsername() != null) {
            OperateLogUtil.addOperaLog(request, cust.getCustomerUsername(), "\u4fee\u6539\u8ba2\u5355\u4ef7\u683c", "\u8ba2\u5355\u7f16\u53f7\u4e3a\u3010" + orderPre.getOrderCode() + "\u3011\u7684\u8ba2\u5355\u4ef7\u683c\u7531\u3010" + orderPre.getOrderPrice() + "\u3011\u6539\u4e3a\u3010" + order.getOrderPrice() + "\u3011-->\u7528\u6237\u540d\uff1a" + cust.getCustomerUsername());
            LOGGER.info((Object)"\u4fee\u6539\u8ba2\u5355\u4ef7\u683c");
        }
        return new ModelAndView((View)new RedirectView("queryThirdOrderList.htm"));
    }

    @RequestMapping(value={"/delThirdOrderByparam"})
    public ModelAndView delThirdOrderByparam(HttpServletRequest request, Long orderId) {
        Customer cust;
        Order order = new Order();
        order.setBusinessId((Long)request.getSession().getAttribute(THIRDID));
        order.setOrderId(orderId);
        order.setOrderStatus("4");
        this.orderService.updateThirdOrder(order);
        this.orderCouponService.modifyCouponStatusNew(orderId);
        Order preorder = this.orderService.searcharOrderByParam(orderId);
        if (request.getSession().getAttribute("cust") != null && (cust = (Customer)request.getSession().getAttribute("cust")).getCustomerUsername() != null) {
            OperateLogUtil.addOperaLog(request, cust.getCustomerUsername(), "\u53d6\u6d88\u8ba2\u5355", "\u53d6\u6d88\u8ba2\u5355\uff0c\u8ba2\u5355\u53f7\u3010" + preorder.getOrderCode() + "\u3011-->\u7528\u6237\u540d\uff1a" + cust.getCustomerUsername());
            LOGGER.info((Object)"\u53d6\u6d88\u8ba2\u5355");
        }
        return new ModelAndView((View)new RedirectView("queryThirdOrderList.htm"));
    }

    @RequestMapping(value={"/delThirdOrderByparams"})
    public ModelAndView delThirdOrderByparams(Long[] thirdOrderId) {
        this.orderService.updateThirdOrderByParams(thirdOrderId);
        return new ModelAndView((View)new RedirectView("queryThirdOrderList.htm"));
    }

    @RequestMapping(value={"/updateThirdOrderSta"})
    public ModelAndView updateThirdOrderSta(HttpServletRequest request, Long orderId, String orderStatus) {
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        if (null != orderId && null != orderStatus) {
            Customer cust;
            if (this.bossOrderService.modifyOrderByKey(orderId, thirdId, orderStatus) == 1) {
                // empty if block
            }
            Order order = this.bossOrderService.getPayOrder(orderId);
            if (request.getSession().getAttribute("cust") != null && (cust = (Customer)request.getSession().getAttribute("cust")).getCustomerUsername() != null) {
                OperateLogUtil.addOperaLog(request, cust.getCustomerUsername(), "\u4fee\u6539\u8ba2\u5355\u72b6\u6001", "\u4fee\u6539\u8ba2\u5355\u7f16\u53f7\u4e3a\u3010" + order.getOrderCode() + "\u3011\u7684\u8ba2\u5355\u72b6\u6001\u4e3a\uff1a\u5df2\u4ed8\u6b3e\u5f85\u53d1\u8d27-->\u7528\u6237\u540d\uff1a" + cust.getCustomerUsername());
                LOGGER.info((Object)"\u4fee\u6539\u8ba2\u5355\u72b6\u6001");
            }
        }
        return new ModelAndView((View)new RedirectView("queryThirdOrderList.htm"));
    }

    @RequestMapping(value={"/thirdorderdeliverys"})
    public ModelAndView thirdOrderDeliverys(Long orderId, HttpServletRequest request) {
        this.bossOrderService.initContainerRelation(orderId);
        List relations = this.bossOrderService.queryContainerRalation(orderId);
        Order order = this.bossOrderService.getPayOrder(orderId);
        return new ModelAndView("order/printoutstock", ORDER, (Object)order).addObject("relations", (Object)relations);
    }

    @RequestMapping(value={"/thirdaddcontainer"})
    public ModelAndView thirdAddContainer(Long orderId) {
        this.bossOrderService.addContainerRalation(orderId);
        return new ModelAndView((View)new RedirectView(THIRDORDERDELIVERYS_HTML)).addObject("orderId", (Object)orderId);
    }

    @RequestMapping(value={"/thirdupdatecontainer"})
    public ModelAndView thirdUpdateContainer(OrderContainer container, Long orderId) {
        OrderContainer orderContainer = this.bossOrderService.queryOrderContainerById(container.getContainerId());
        OrderContainer newCon = this.bossOrderService.queryOrderContainerByGoodInfoId(container.getRelationId(), orderContainer.getGoodsInfoId());
        if (orderContainer.getGoodsNum() > container.getGoodsNum()) {
            orderContainer.setGoodsNum(Long.valueOf(orderContainer.getGoodsNum() - container.getGoodsNum()));
            this.bossOrderService.updateRelation(orderContainer);
            if (newCon != null) {
                newCon.setGoodsNum(Long.valueOf(newCon.getGoodsNum() + container.getGoodsNum()));
                this.bossOrderService.updateRelation(newCon);
            } else {
                newCon = container;
                newCon.setContainerId(null);
                newCon.setGoodsInfoId(orderContainer.getGoodsInfoId());
                newCon.setContainerStatus("0");
                if (StringUtils.isNotEmpty((String)orderContainer.getContainerStatus()) && orderContainer.getContainerStatus().equals("1")) {
                    newCon.setContainerStatus("1");
                }
                this.bossOrderService.addRelation(newCon);
            }
        } else if (orderContainer.getGoodsNum().equals(container.getGoodsNum())) {
            if (newCon != null) {
                newCon.setGoodsNum(Long.valueOf(newCon.getGoodsNum() + container.getGoodsNum()));
                this.bossOrderService.updateRelation(newCon);
                this.bossOrderService.delContainerByCId(container.getContainerId());
            } else {
                this.bossOrderService.updateRelation(container);
            }
        }
        return new ModelAndView((View)new RedirectView(THIRDORDERDELIVERYS_HTML)).addObject("orderId", (Object)orderId);
    }

    @RequestMapping(value={"goUpdateOrderPage"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Order goUpdateOrderPage(Long orderId) {
        return this.bossOrderService.getPayOrder(orderId);
    }

    @RequestMapping(value={"/thirddelrelationbyid"})
    public ModelAndView thirdDelRelationById(Long relationId, Long orderId) {
        this.bossOrderService.delRelationById(relationId);
        return new ModelAndView((View)new RedirectView(THIRDORDERDELIVERYS_HTML)).addObject("orderId", (Object)orderId);
    }

    @RequestMapping(value={"/tothirdordersendgoods"})
    public ModelAndView toThirdOrderSendGoods(HttpServletRequest request, Long orderId, String status) {
        return new ModelAndView("order/ordersendgoods").addObject("orderId", (Object)orderId).addObject(STATUS, (Object)status);
    }

    @RequestMapping(value={"/thirdordersendgoods"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> thirdOrderSendGoods(HttpServletRequest request, Long orderId, String status) {
        Express expressList = new Express();
        List relations = this.bossOrderService.queryContainerRalation(orderId);
        Order order = this.bossOrderService.getPayOrder(orderId);
        OrderExpress express = this.bossOrderService.expressDetail(orderId);
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        LogisticsSingle logisticsSingle = this.logisticsSingleService.selectLogisticsSingle(thirdId, express.getExpressId());
        order.setOrderExpress(express);
        expressList.setIsDefault("1");
        expressList.setStoreId(thirdId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("store", this.sellerService.selectByStoreId(thirdId));
        map.put("logisticsSingle", logisticsSingle);
        map.put(ORDER, order);
        map.put("relations", relations);
        map.put(STATUS, status);
        map.put("express", express);
        return map;
    }

    @RequestMapping(value={"/thirdsendorder"})
    public ModelAndView thirdSendOrder(Long orderId, Long[] relationIds, String[] expressNo, HttpServletRequest request) {
        Customer cust;
        this.bossOrderService.updateSendOrderGoods(relationIds, expressNo, null);
        this.bossOrderService.modifyOrderByKey(orderId, "2");
        Order order = this.orderService.searcharOrderByParam(orderId);
        if (request.getSession().getAttribute("cust") != null && (cust = (Customer)request.getSession().getAttribute("cust")).getCustomerUsername() != null) {
            OperateLogUtil.addOperaLog(request, cust.getCustomerUsername(), "\u8ba2\u5355\u53d1\u8d27\u64cd\u4f5c", "\u8ba2\u5355\u53d1\u8d27\u64cd\u4f5c\uff0c\u8ba2\u5355\u7f16\u53f7\u3010" + order.getOrderCode() + "\u3011-->\u7528\u6237\u540d\uff1a" + cust.getCustomerUsername());
            LOGGER.info((Object)"\u8ba2\u5355\u53d1\u8d27\u64cd\u4f5c");
        }
        return new ModelAndView((View)new RedirectView("thirdordersendgoods.html")).addObject("orderId", (Object)orderId).addObject(STATUS, (Object)"0");
    }

    @RequestMapping(value={"/toThirdOrderDetail"})
    public ModelAndView toThirdOrderDetail(HttpServletRequest request, HttpServletResponse response, Long orderId) {
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        Order order = this.bossOrderService.orderDetail(orderId);
        if (thirdId != null && order.getBusinessId() != null && !thirdId.equals(order.getBusinessId())) {
            return new ModelAndView((View)new RedirectView(request.getContextPath() + "/sellerinfo.html"));
        }
        String couponName = "";
        if (null != order && order.getCouponNo() != null && !order.getCouponNo().isEmpty()) {
            Coupon coupon = this.couponService.selectCouponByCodeNo(order.getCouponNo());
            couponName = coupon.getCouponName();
        }
        return new ModelAndView("order/thirdorderdetail", ORDER, (Object)order).addObject("couponName", (Object)couponName);
    }

    @RequestMapping(value={"/thirdsubsendgoodsorder"})
    public void thirdSubSendGoodsorder(HttpServletResponse response, String token, Long orderId, Long[] relationIds, String[] expressNo, HttpServletRequest request, int[] expressId) {
        try {
            PrintWriter pw = response.getWriter();
            if (token == null || !"L".equals(token)) {
                pw.print("0");
            } else if (this.bossOrderService.judgeStatus("2", orderId) == 0) {
                pw.print("0");
            }
            this.bossOrderService.updateThirdSendOrderGoods(relationIds, expressNo, expressId);
            Long thirdId = (long)((Long)request.getSession().getAttribute(THIRDID));
            this.bossOrderService.sendOrderByP(orderId, "2", null, "2", thirdId);
            this.bossOrderService.updateSetCargoStatusByOrderId(orderId, "3");
        }
        catch (IOException e) {
            Customer cust = (Customer)request.getSession().getAttribute("cust");
            OperaLogBean operaLogBean = new OperaLogBean((Exception)e, cust.getCustomerUsername());
            operaLogBean.setIp(IPAddress.getIpAddr((HttpServletRequest)request));
            operaLogBean.setLoginUserId((Long)request.getSession().getAttribute("loginUserId"));
            operaLogBean.setName((String)request.getSession().getAttribute("name"));
            OperaLogUtil.addOperaException((OperaLogBean)operaLogBean);
        }
    }

    @RequestMapping(value={"/buyThirdOrderList"})
    public ModelAndView buyThirdOrderList(PageBean pb, String n, String l, HttpServletRequest request, Order order) throws UnsupportedEncodingException {
        if (null != order.getShippingPerson()) {
            String str = new String(order.getShippingPerson().getBytes("ISO8859-1"), "utf-8");
            order.setShippingPerson(str);
        }
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        order.setBusinessId((Long)request.getSession().getAttribute(THIRDID));
        order.setDelFlag("0");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(ORDER, order);
        map.put("pb", this.orderService.searchBuyOrderList(pb, order));
        return new ModelAndView("order/puythirdorderlist", "map", map);
    }

    public ThirdOrderService getOrderService() {
        return this.orderService;
    }

    @Resource(name="ThirdOrderService")
    public void setOrderService(ThirdOrderService orderService) {
        this.orderService = orderService;
    }

    public OrderService getBossOrderService() {
        return this.bossOrderService;
    }

    @Resource(name="OrderService")
    public void setBossOrderService(OrderService bossOrderService) {
        this.bossOrderService = bossOrderService;
    }

    public ExpressInfoService getExpressInfoService() {
        return this.expressInfoService;
    }

    @Resource(name="expressInfoService")
    public void setExpressInfoService(ExpressInfoService expressInfoService) {
        this.expressInfoService = expressInfoService;
    }
}

