/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.feedback.controller;

import com.qianjiang.feedback.bean.Feedback;
import com.qianjiang.feedback.service.FeedBackService;
import com.qianjiang.third.util.MenuOperationUtil;
import com.qianjiang.third.util.ResultData;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.utils.DateUtils;
import java.text.SimpleDateFormat;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@RequestMapping(value={"/feedbackController"})
@Controller
public class FeedbackController {
    private static final MyLogger logger = new MyLogger(FeedbackController.class);
    @Autowired
    private FeedBackService feedBackService;

    @RequestMapping(value={"/toFeedbackPages"})
    public ModelAndView toFeedbackPages(HttpServletRequest request, ModelMap modelMap, PageBean page, String n, String l) {
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        ModelAndView view = new ModelAndView("feedback/feedbackList");
        long thirdId = (Long)request.getSession().getAttribute("thirdId");
        Feedback feedback = new Feedback();
        feedback.setThirdId(Long.valueOf(thirdId));
        PageBean pageBean = this.feedBackService.queryFeedBackByPage(page, feedback);
        modelMap.put((Object)"page", (Object)pageBean);
        return view;
    }

    @RequestMapping(value={"/addFeedback"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String addFeedback(HttpServletRequest request, ModelMap modelMap, Feedback feedback) {
        ResultData result = new ResultData();
        result.setStatus(ResultData.getError());
        try {
            if (null != feedback) {
                long thirdId = (Long)request.getSession().getAttribute("thirdId");
                feedback.setThirdId(Long.valueOf(thirdId));
                feedback.setStatus(Integer.valueOf(0));
                feedback.setDelFlag("0");
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String nowDate = DateUtils.getTodayDate((SimpleDateFormat)format);
                feedback.setCreateTime(format.parse(nowDate));
                if (this.feedBackService.addFeedBack(feedback)) {
                    result.setStatus(ResultData.getSuccess());
                }
            }
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u53cd\u9988\u5efa\u8bae\u5f02\u5e38", (Throwable)e);
        }
        return JSONObject.fromObject(result).toString();
    }
}

