/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.order.controller;

import com.qianjiang.customer.bean.Customer;
import com.qianjiang.order.bean.Order;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.system.util.BasicSetUtil;
import com.qianjiang.third.goods.service.ThirdGoodsService;
import com.qianjiang.third.logger.util.OperateLogUtil;
import com.qianjiang.third.order.service.ThirdOrderService;
import com.qianjiang.third.util.MenuOperationUtil;
import com.qianjiang.third.util.PageBean;
import com.qianjiang.util.MyLogger;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ThirdOutStockController {
    private static final MyLogger LOGGER = new MyLogger(ThirdOutStockController.class);
    @Resource(name="ThirdOrderService")
    private ThirdOrderService orderService;
    @Resource
    private ThirdGoodsService thirdGoodsService;
    @Resource(name="OrderService")
    private OrderService bossOrderService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/querythirdoutstock"})
    public ModelAndView queryThirdOutStock(Order order, HttpServletRequest request, String n, String l, PageBean pb) throws UnsupportedEncodingException {
        HashMap<String, Object> map;
        Order orderNew = order;
        PageBean pbNew = pb;
        if (null != orderNew.getShippingPerson()) {
            String str = new String(orderNew.getShippingPerson().getBytes("ISO8859-1"), "utf-8");
            orderNew.setShippingPerson(str);
        }
        try {
            orderNew.setBusinessId((Long)request.getSession().getAttribute("thirdId"));
            pbNew.setUrl("querythirdoutstock.html");
            MenuOperationUtil.fillSessionMenuIndex(request, n, l);
            map = new HashMap<String, Object>();
            map.put("order", orderNew);
            map.put("bset", BasicSetUtil.getAddress((String)this.thirdGoodsService.bsetUrl()));
            map.put("pb", this.orderService.searchOrderListByOrderCargo(pbNew, orderNew));
            ModelAndView modelAndView = new ModelAndView("order/thirdoutstock").addObject("map", map);
            return modelAndView;
        }
        finally {
            map = null;
            orderNew = null;
            pbNew = null;
        }
    }

    @RequestMapping(value={"/thirdorderpicking"})
    public ModelAndView thirdOrderPicking(Long[] orderId, HttpServletRequest request) {
        Map map = this.orderService.orderPicking(orderId, request);
        return new ModelAndView("order/printtakepro", "map", (Object)map);
    }

    @RequestMapping(value={"/thirdchangeorderpicking"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int thirdChangeOrderPicking(Long[] orderId, HttpServletRequest request) {
        Customer cust;
        String codes = "";
        for (int i = 0; i < orderId.length; ++i) {
            Order order = this.orderService.searcharOrderByParam(orderId[i]);
            codes = codes.concat("\u3010" + order.getOrderCode() + "\u3011");
        }
        if (request.getSession().getAttribute("cust") != null && (cust = (Customer)request.getSession().getAttribute("cust")).getCustomerUsername() != null) {
            OperateLogUtil.addOperaLog(request, cust.getCustomerUsername(), "\u62e3\u8d27\u64cd\u4f5c", "\u62e3\u8d27\u64cd\u4f5c\uff0c\u8ba2\u5355\u7f16\u53f7" + codes + "-->\u7528\u6237\u540d\uff1a" + cust.getCustomerUsername());
            LOGGER.info((Object)"\u62e3\u8d27\u64cd\u4f5c");
        }
        return this.orderService.goOrderPicking(orderId, request);
    }

    @RequestMapping(value={"thirdmodifyorderbyparam"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int thirdModifyOrderByParam(Long orderId, String orderStatus, HttpServletRequest request, String token) {
        Customer cust;
        if (token == null || !"L".equals(token)) {
            return 0;
        }
        if (this.bossOrderService.judgeStatus("1", orderId) == 0) {
            return 0;
        }
        Order order = this.orderService.searcharOrderByParam(orderId);
        if (request.getSession().getAttribute("cust") != null && (cust = (Customer)request.getSession().getAttribute("cust")).getCustomerUsername() != null) {
            OperateLogUtil.addOperaLog(request, cust.getCustomerUsername(), "\u88c5\u7bb1\u64cd\u4f5c", "\u88c5\u7bb1\u64cd\u4f5c\uff0c\u8ba2\u5355\u7f16\u53f7\u3010" + order.getOrderCode() + "\u3011-->\u7528\u6237\u540d\uff1a" + cust.getCustomerUsername());
            LOGGER.info((Object)"\u88c5\u7bb1\u64cd\u4f5c");
        }
        return this.bossOrderService.updateSetCargoStatusByThirdOrderId(orderId, orderStatus, (Long)request.getSession().getAttribute("thirdId"));
    }
}

