/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.goods.controller;

import com.qianjiang.customer.bean.PunishRecord;
import com.qianjiang.customer.service.PunishRecordService;
import com.qianjiang.freight.bean.FreightExpress;
import com.qianjiang.freight.service.FreightTemplateService;
import com.qianjiang.goods.bean.Goods;
import com.qianjiang.goods.service.GetOnOffService;
import com.qianjiang.goods.service.GoodsBrandService;
import com.qianjiang.goods.service.GoodsCateService;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.goods.service.GoodsService;
import com.qianjiang.goods.service.GoodsTagService;
import com.qianjiang.goods.service.ProductWareService;
import com.qianjiang.goods.service.SearchAsyncService;
import com.qianjiang.goods.service.WareHouseService;
import com.qianjiang.goods.vo.GoodsMoifiedVo;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.system.service.ServiceSupportMapperService;
import com.qianjiang.system.util.BasicSetUtil;
import com.qianjiang.third.auth.bean.Customer;
import com.qianjiang.third.goods.service.ThirdCateService;
import com.qianjiang.third.goods.service.ThirdGoodsService;
import com.qianjiang.third.goods.service.ThirdOtherService;
import com.qianjiang.third.goods.util.CookieUtil;
import com.qianjiang.third.goods.util.ThirdGoodsSearchBean;
import com.qianjiang.third.goods.vo.ThirdCateVo;
import com.qianjiang.third.seller.service.SellerService;
import com.qianjiang.third.util.MenuOperationUtil;
import com.qianjiang.third.util.PageBean;
import com.qianjiang.util.MyLogger;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ThirdGoodsController {
    private static final MyLogger LOGGER = new MyLogger(ThirdGoodsController.class);
    private static final String THIRDID = "thirdId";
    private static final String ISTHIRDAUDITUSED = "isThirdAuditUsed";
    private static final String PARAMID = "paramId";
    private static final String EXPANDPARAMID = "expandParamId";
    private static final String SEARCHBEAN = "searchBean";
    private static final String GOODSADDEDSTA = "goodsAddedSta";
    private static final String GOODS_THIRDGOODSLIST = "goods/thirdgoodslist";
    private GoodsService goodsService;
    private ThirdGoodsService thirdGoodsService;
    private ThirdCateService cateService;
    private ThirdOtherService thirdOtherService;
    private ThirdCateService thirdCateService;
    private GoodsTagService goodsTagService;
    private GoodsBrandService goodsBrandService;
    private WareHouseService wareHouseService;
    private GoodsCateService goodsCateService;
    private ProductWareService productWareService;
    private ServiceSupportMapperService serviceSupportMapperService;
    @Resource(name="GetOnOffService")
    private GetOnOffService getOnOffMapper;
    @Resource(name="FreightTemplateService")
    private FreightTemplateService freightTemplateService;
    @Autowired
    private SearchAsyncService searchAsyncService;
    @Resource(name="GoodsProductService")
    private GoodsProductService goodsProductService;
    @Resource(name="sellerService")
    private SellerService sellerService;
    @Resource(name="PunishRecordService")
    private PunishRecordService punishRecordService;

    @RequestMapping(value={"/upthirdgoods"})
    public ModelAndView upThirdGoods(HttpServletRequest request, HttpServletResponse response, String n, String l) {
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        String s = "0";
        ModelAndView mav = new ModelAndView();
        try {
            FreightExpress fe = this.freightTemplateService.selectFreightExpressByDistriThirdId(thirdId);
            List punishRecordList = this.punishRecordService.queryInfoByTidandDate(thirdId);
            if (punishRecordList != null && !punishRecordList.isEmpty()) {
                for (int i = 0; i < punishRecordList.size(); ++i) {
                    PunishRecord punishRecord = (PunishRecord)punishRecordList.get(i);
                    if (punishRecord == null || punishRecord.getPunishId() != 7L) continue;
                    response.setContentType("text/html;charset=utf-8");
                    PrintWriter out = response.getWriter();
                    out.write("<script>window.location.href='" + request.getContextPath() + "/thirdgoodsmanager.html';</script>");
                    return null;
                }
            }
            if (fe != null) {
                s = "1";
            }
            List queryGrandCateForThird = this.thirdOtherService.queryGrandCateForThird(thirdId);
            mav.addObject("queryGrandCateForThird", (Object)queryGrandCateForThird);
            List queryAllTag = this.goodsTagService.queryAllTag();
            mav.addObject("tagList", (Object)queryAllTag);
            List queryGrandBrandByThirdId = this.thirdOtherService.queryGrandBrandByThirdId((Long)request.getSession().getAttribute(THIRDID));
            mav.addObject("brandList", (Object)queryGrandBrandByThirdId);
            List selectAll = this.serviceSupportMapperService.selectAll();
            mav.addObject("support", (Object)selectAll);
            List queryAllWareHouse = this.wareHouseService.queryAllWareHouse();
            mav.addObject("wareHouse", (Object)queryAllWareHouse);
            mav.addObject("haveFreight", (Object)s);
            String onOffFlag = this.getOnOffMapper.getOnOffFlag();
            mav.addObject("onOffFlag", (Object)onOffFlag);
            mav.setViewName("goods/upthirdgoods");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u53d1\u5e03\u5546\u54c1\u521d\u59cb\u5316\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/sathirdgoods"})
    public ModelAndView saveThirdGoods(Goods goods, HttpServletRequest request, HttpServletResponse resp) throws IOException {
        PrintWriter out = resp.getWriter();
        String[] tags = request.getParameterValues("tags");
        String[] paramId = request.getParameterValues(PARAMID);
        String[] paramValue = request.getParameterValues("paramValue");
        String[] expandParamId = request.getParameterValues(EXPANDPARAMID);
        String[] expandParamValue = request.getParameterValues("expandParamValue");
        String[] specs = request.getParameterValues("specs");
        String[] specsValue = request.getParameterValues("specsValue");
        String[] specsValueImg = request.getParameterValues("specsValueImg");
        String[] specsValueRemark = request.getParameterValues("specsValueRemark");
        String[] about = request.getParameterValues("about");
        String goodsThirdCateId = request.getParameter("goodsThirdCateId");
        if (null != goodsThirdCateId) {
            goods.setThirdCateId(Long.valueOf(Long.parseLong(goodsThirdCateId)));
        }
        String isThirdAuditUsed = this.getOnOffMapper.getOnOffFlag();
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Long newId = null;
        try {
            map.put("tags", tags);
            map.put("expandParamIds", expandParamId);
            map.put("expandParamValues", expandParamValue);
            map.put("paramIds", paramId);
            map.put("paramValue", paramValue);
            map.put("aboutGoodsId", about);
            map.put("specId", specs);
            map.put("specValues", specsValue);
            map.put("openSpecValueImg", specsValueImg);
            map.put("openSpecValueRemark", specsValueRemark);
            goods.setIsThird("1");
            goods.setGoodsBelo((Long)request.getSession().getAttribute(THIRDID));
            goods.setGoodsBeloName((String)request.getSession().getAttribute("storeName"));
            if (Integer.parseInt(goods.getGoodsAdded()) == 0) {
                goods.setAuditStatus("0");
                goods.setGoodsAdded("0");
            } else if (Integer.parseInt(goods.getGoodsAdded()) == 1 && Integer.parseInt(isThirdAuditUsed) == 1) {
                goods.setAuditStatus("1");
                goods.setGoodsAdded("0");
            } else {
                goods.setAuditStatus("3");
                goods.setGoodsAdded("1");
            }
            newId = this.goodsService.saveGoods(goods, (String)request.getSession().getAttribute("name"), map);
            out.append("<script>parent.call_save_goods('" + newId + "');</script>");
            ModelAndView modelAndView = new ModelAndView((View)new RedirectView("auditgoodslist.html"));
            return modelAndView;
        }
        finally {
            ThirdCateVo tcv = this.cateService.queryThirdCateById(goods.getCatId());
            if (tcv != null) {
                CookieUtil.saveToCookie(tcv, request, resp);
            }
            out.flush();
            tags = null;
            paramId = null;
            paramValue = null;
            expandParamId = null;
            expandParamValue = null;
            specs = null;
            specsValue = null;
            specsValueImg = null;
            about = null;
            map = null;
            newId = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/thirdcopylist"})
    public ModelAndView thirdCopyList(PageBean pb, ThirdGoodsSearchBean searchBean, HttpServletRequest request, String n, String l, Long thirdId) {
        if (null != n && null != l) {
            MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        }
        pb.setUrl("thirdcopylist.html");
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("pb", this.thirdGoodsService.queryThirdGoodsCopyList(pb, thirdId, searchBean, null));
            map.put(SEARCHBEAN, searchBean);
            map.put(GOODSADDEDSTA, 0);
            map.put(THIRDID, thirdId);
            map.put("storeList", this.sellerService.selectAll());
            ModelAndView modelAndView = new ModelAndView("goods/thirdgoodscopylist", "map", map);
            return modelAndView;
        }
        finally {
            map = null;
        }
    }

    @RequestMapping(value={"copygoodsbygoodsids"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ModelAndView copyGoodsByGoodsIds(Long[] thirdGoodsId, HttpServletRequest request) {
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        Customer cust = (Customer)request.getSession().getAttribute("cust");
        String ip = IPAddress.getIpAddr((HttpServletRequest)request);
        Long loginUserId = (Long)request.getSession().getAttribute("loginUserId");
        String name = (String)request.getSession().getAttribute("name");
        this.thirdGoodsService.copyByGoodsIds(thirdId, thirdGoodsId, cust, ip, name, loginUserId);
        return new ModelAndView("redirect:/thirdcopylist.html");
    }

    @RequestMapping(value={"/tNewUploadSaveGoodsDesc"})
    public void newUploadSaveGoodsDesc(Long goodsId, String goodsDetailDesc, String goodsMobileDesc, HttpServletResponse resp, HttpServletRequest request) throws IOException {
        PrintWriter out = resp.getWriter();
        Goods goods = new Goods();
        goods.setGoodsId(goodsId);
        if (null != goodsDetailDesc && goodsDetailDesc.length() > 0 && !"".equals(goodsDetailDesc)) {
            goods.setGoodsDetailDesc(goodsDetailDesc);
        } else {
            goods.setGoodsDetailDesc("");
        }
        if (null != goodsMobileDesc && goodsMobileDesc.length() > 0 && !"".equals(goodsMobileDesc)) {
            goods.setMobileDesc(goodsMobileDesc);
        } else {
            goods.setMobileDesc("");
        }
        this.goodsService.updateGoodsDesc(goods);
        request.getSession().setAttribute(ISTHIRDAUDITUSED, (Object)ISTHIRDAUDITUSED);
        out.append("<script>parent.call_save_desc('" + goodsId + "');</script>");
    }

    @RequestMapping(value={"/toModifiedThirdGoods"})
    public ModelAndView toModifiedThirdGoods(Long goodsId, Long goodsAddedSta, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        HashMap<String, Object> map = new HashMap<String, Object>();
        long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        try {
            GoodsMoifiedVo goods = this.goodsService.queryModeifiedVoByGoodsId(goodsId);
            ThirdCateVo thirdCate = this.thirdCateService.queryThirdCateById(goods.getThirdCateId());
            List queryGrandCateForThird = this.thirdOtherService.queryGrandCateForThird(Long.valueOf(thirdId));
            List queryAllTag = this.goodsTagService.queryAllTag();
            List selectAll = this.serviceSupportMapperService.selectAll();
            List queryAllWareHouse = this.wareHouseService.queryAllWareHouse();
            List queryGrandBrandByThirdId = this.thirdOtherService.queryGrandBrandByThirdId((Long)request.getSession().getAttribute(THIRDID));
            String isThirdAuditUsed = this.getOnOffMapper.getOnOffFlag();
            map.put("goodsModifiedVo", goods);
            map.put("thirdCate", thirdCate);
            map.put("queryGrandCateForThird", queryGrandCateForThird);
            mav.addObject("tagList", (Object)queryAllTag);
            mav.addObject("support", (Object)selectAll);
            mav.addObject("wareHouse", (Object)queryAllWareHouse);
            map.put("brandList", queryGrandBrandByThirdId);
            map.put(GOODSADDEDSTA, goodsAddedSta);
            map.put(ISTHIRDAUDITUSED, isThirdAuditUsed);
            mav.addObject("map", map);
            mav.setViewName("goods/modifiedThirdgoods");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u521d\u59cb\u5316\u4fee\u6539\u5546\u54c1\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/modithirdgoods"})
    public ModelAndView modiThirdGoods(Goods goods, HttpServletRequest request, MultipartHttpServletRequest request2, Long goodsAddedSta, HttpServletResponse response) throws UnsupportedEncodingException {
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        Goods goodthird = this.goodsService.queryGoodsByGoodsId(goods.getGoodsId());
        Long goodsBelo = null;
        if (goodthird != null) {
            goodsBelo = goodthird.getGoodsBelo();
        }
        if (thirdId.equals(goodsBelo)) {
            String[] tags = request.getParameterValues("goods_tag");
            String[] expandParamId = request.getParameterValues(EXPANDPARAMID);
            String[] expandparamValue = request.getParameterValues("expandparamValue");
            String[] paramId = request.getParameterValues(PARAMID);
            String[] paramValue = request.getParameterValues("paramValue");
            String[] aboutGoodsId = request.getParameterValues("aboutGoodsId");
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            map.put("tags", tags);
            map.put(EXPANDPARAMID, expandParamId);
            map.put("expandparamValue", expandparamValue);
            map.put(PARAMID, paramId);
            map.put("paramValue", paramValue);
            map.put("aboutGoodsId", aboutGoodsId);
            String goodsAddFlag = goods.getGoodsAdded();
            String isThirdAuditUsed = this.getOnOffMapper.getOnOffFlag();
            if (Integer.parseInt(goods.getGoodsAdded()) == 0) {
                goods.setAuditStatus("0");
                goods.setGoodsAdded("0");
            } else if (Integer.parseInt(goods.getGoodsAdded()) == 1 && Integer.parseInt(isThirdAuditUsed) == 1) {
                goods.setAuditStatus("1");
                goods.setGoodsAdded("0");
            } else {
                goods.setAuditStatus("3");
                goods.setGoodsAdded("1");
            }
            this.goodsService.updateGoods(goods, map, isThirdAuditUsed, ((Customer)request.getSession().getAttribute("cust")).getCustomerUsername(), goodsAddFlag);
            ThirdCateVo tcv = this.cateService.queryThirdCateById(goods.getCatId());
            if (tcv != null) {
                CookieUtil.saveToCookie(tcv, (HttpServletRequest)request2, response);
            }
            this.searchAsyncService.updateThirdOneGoodsIndexToEs(goods.getGoodsId());
            if (goodsAddedSta == 1L) {
                return new ModelAndView((View)new RedirectView("auditgoodslist.html"));
            }
            return new ModelAndView((View)new RedirectView("waitSaleThirdGoods.html"));
        }
        return null;
    }

    @RequestMapping(value={"/getGoodNumber"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String getGoodNumber(String catId, HttpServletRequest request) {
        StringBuilder goodsNumber = new StringBuilder();
        goodsNumber.append(catId);
        String mands = catId.length() <= 3 ? String.valueOf(Math.round(Math.random() * 1.0E13)) : (catId.length() <= 6 ? String.valueOf(Math.round(Math.random() * 1.0E9)) : (catId.length() <= 9 ? String.valueOf(Math.round(Math.random() * 1.0E7)) : String.valueOf(Math.round(Math.random() * 100000.0))));
        goodsNumber.append(mands);
        return goodsNumber.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/thirdgoodsmanager"})
    public ModelAndView goodsManger(PageBean pb, ThirdGoodsSearchBean searchBean, HttpServletRequest request, String n, String l) {
        if (null != n && null != l) {
            MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        }
        String isThirdAuditUsed = this.getOnOffMapper.getOnOffFlag();
        pb.setUrl("thirdgoodsmanager.html");
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            if (Integer.parseInt(isThirdAuditUsed) == 1) {
                map.put("pb", this.thirdGoodsService.queryThirdGoodsListByFlag(pb, (Long)request.getSession().getAttribute(THIRDID), searchBean, Long.valueOf(1L), Long.valueOf(1L)));
            } else {
                map.put("pb", this.thirdGoodsService.queryThirdGoodsList(pb, (Long)request.getSession().getAttribute(THIRDID), searchBean, Long.valueOf(1L)));
            }
            map.put(SEARCHBEAN, searchBean);
            map.put(ISTHIRDAUDITUSED, isThirdAuditUsed);
            map.put(GOODSADDEDSTA, 1);
            map.put("bset", BasicSetUtil.getAddress((String)this.thirdGoodsService.bsetUrl()));
            map.put("flag", 0);
            ModelAndView modelAndView = new ModelAndView(GOODS_THIRDGOODSLIST, "map", map);
            return modelAndView;
        }
        finally {
            map = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/waitSaleThirdGoods"})
    public ModelAndView waitSaleThirdGoods(PageBean pb, ThirdGoodsSearchBean searchBean, HttpServletRequest request, String n, String l) {
        if (null != n && null != l) {
            MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        }
        String isThirdAuditUsed = this.getOnOffMapper.getOnOffFlag();
        pb.setUrl("waitSaleThirdGoods.html");
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            if (Integer.parseInt(isThirdAuditUsed) == 1) {
                map.put("pb", this.thirdGoodsService.queryThirdGoodsListByFlag(pb, (Long)request.getSession().getAttribute(THIRDID), searchBean, Long.valueOf(0L), Long.valueOf(2L)));
            } else {
                map.put("pb", this.thirdGoodsService.queryThirdGoodsList(pb, (Long)request.getSession().getAttribute(THIRDID), searchBean, Long.valueOf(0L)));
            }
            map.put(SEARCHBEAN, searchBean);
            map.put(ISTHIRDAUDITUSED, isThirdAuditUsed);
            map.put(GOODSADDEDSTA, 0);
            map.put("bset", BasicSetUtil.getAddress((String)this.thirdGoodsService.bsetUrl()));
            map.put("flag", 1);
            ModelAndView modelAndView = new ModelAndView(GOODS_THIRDGOODSLIST, "map", map);
            return modelAndView;
        }
        finally {
            map = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/auditgoodslist"})
    public ModelAndView auditGoodsList(PageBean pb, ThirdGoodsSearchBean searchBean, HttpServletRequest request, String n, String l) {
        if (null != n && null != l) {
            MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        }
        String isThirdAuditUsed = this.getOnOffMapper.getOnOffFlag();
        pb.setUrl("auditgoodslist.html");
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            if (Integer.parseInt(isThirdAuditUsed) == 1) {
                map.put("pb", this.thirdGoodsService.queryThirdGoodsListByFlag(pb, (Long)request.getSession().getAttribute(THIRDID), searchBean, Long.valueOf(0L), Long.valueOf(3L)));
            }
            map.put(SEARCHBEAN, searchBean);
            map.put(ISTHIRDAUDITUSED, isThirdAuditUsed);
            map.put(GOODSADDEDSTA, 2);
            map.put("bset", BasicSetUtil.getAddress((String)this.thirdGoodsService.bsetUrl()));
            map.put("flag", 2);
            ModelAndView modelAndView = new ModelAndView(GOODS_THIRDGOODSLIST, "map", map);
            return modelAndView;
        }
        finally {
            map = null;
        }
    }

    @RequestMapping(value={"/delThirdGoods"})
    public ModelAndView delThirdGoods(Long thirdGoodsId, Long goodsAddedSta, HttpServletRequest request) {
        this.goodsService.delThirdGoods(thirdGoodsId, (Long)request.getSession().getAttribute(THIRDID), ((Customer)request.getSession().getAttribute("cust")).getCustomerUsername());
        Long[] ls = new Long[]{thirdGoodsId};
        List sList = this.goodsProductService.selectInfoIdList(ls);
        this.searchAsyncService.batchDeleteGoodsIndexToEs(sList);
        if (null == goodsAddedSta || goodsAddedSta == 1L) {
            return new ModelAndView((View)new RedirectView("thirdgoodsmanager.html"));
        }
        return new ModelAndView((View)new RedirectView("waitSaleThirdGoods.html"));
    }

    @RequestMapping(value={"/delThirdGoodsByChangeCate"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String delThirdGoodsByChangeCate(HttpServletRequest req, HttpServletResponse resp, Long thirdGoodsId, Long goodsAddedSta) {
        String result = "0";
        try {
            this.goodsService.delThirdGoods(thirdGoodsId, (Long)req.getSession().getAttribute(THIRDID), ((Customer)req.getSession().getAttribute("cust")).getCustomerUsername());
            Long[] ls = new Long[]{thirdGoodsId};
            List sList = this.goodsProductService.selectInfoIdList(ls);
            this.searchAsyncService.batchDeleteGoodsIndexToEs(sList);
            result = "1";
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5546\u5bb6\u7aef\u5207\u6362\u7c7b\u76ee\u5220\u9664\u5546\u54c1\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/batchDownThirdGoods"})
    public ModelAndView batchDownThirdGoods(Long[] thirdGoodsId, HttpServletRequest request) {
        this.goodsService.batchUploadOrDownGoods(thirdGoodsId, "0", ((Customer)request.getSession().getAttribute("cust")).getCustomerUsername(), "0", (Long)request.getSession().getAttribute(THIRDID));
        for (Long goodsId : thirdGoodsId) {
            this.searchAsyncService.deleteGoodsIndexToEs(goodsId);
        }
        return new ModelAndView((View)new RedirectView("thirdgoodsmanager.html"));
    }

    @RequestMapping(value={"/batchUploadThirdGoods"})
    public ModelAndView batchUploadThirdGoods(Long[] thirdGoodsId, HttpServletRequest request, String auditStatus) {
        String auditStatusNew = auditStatus;
        String isThirdAuditUsed = this.getOnOffMapper.getOnOffFlag();
        if (Integer.parseInt(isThirdAuditUsed) == 1) {
            auditStatusNew = "1";
            this.goodsService.batchAuditUploadOrDownGoods(thirdGoodsId, "0", auditStatusNew, ((Customer)request.getSession().getAttribute("cust")).getCustomerUsername(), (Long)request.getSession().getAttribute(THIRDID));
        } else {
            this.goodsService.batchUploadOrDownGoods(thirdGoodsId, "1", ((Customer)request.getSession().getAttribute("cust")).getCustomerUsername(), "3", (Long)request.getSession().getAttribute(THIRDID));
        }
        for (Long goodsId : thirdGoodsId) {
            this.searchAsyncService.updateOneGoodsIndexToEs(goodsId);
        }
        return new ModelAndView((View)new RedirectView("waitSaleThirdGoods.html"));
    }

    public GoodsService getGoodsService() {
        return this.goodsService;
    }

    @Resource(name="GoodsService")
    public void setGoodsService(GoodsService goodsService) {
        this.goodsService = goodsService;
    }

    public ThirdGoodsService getThirdGoodsService() {
        return this.thirdGoodsService;
    }

    @Resource(name="ThirdGoodsService")
    public void setThirdGoodsService(ThirdGoodsService thirdGoodsService) {
        this.thirdGoodsService = thirdGoodsService;
    }

    public ThirdCateService getCateService() {
        return this.cateService;
    }

    @Resource(name="ThirdCateService1")
    public void setCateService(ThirdCateService cateService) {
        this.cateService = cateService;
    }

    public ThirdOtherService getThirdOtherService() {
        return this.thirdOtherService;
    }

    @Resource(name="ThirdOtherService")
    public void setThirdOtherService(ThirdOtherService thirdOtherService) {
        this.thirdOtherService = thirdOtherService;
    }

    public ThirdCateService getThirdCateService() {
        return this.thirdCateService;
    }

    @Resource(name="ThirdCateService1")
    public void setThirdCateService(ThirdCateService thirdCateService) {
        this.thirdCateService = thirdCateService;
    }

    public GoodsTagService getGoodsTagService() {
        return this.goodsTagService;
    }

    @Resource(name="GoodsTagServiceImpl")
    public void setGoodsTagService(GoodsTagService goodsTagService) {
        this.goodsTagService = goodsTagService;
    }

    public GoodsBrandService getGoodsBrandService() {
        return this.goodsBrandService;
    }

    @Resource(name="GoodsBrandService")
    public void setGoodsBrandService(GoodsBrandService goodsBrandService) {
        this.goodsBrandService = goodsBrandService;
    }

    public WareHouseService getWareHouseService() {
        return this.wareHouseService;
    }

    @Resource(name="WareHouseService")
    public void setWareHouseService(WareHouseService wareHouseService) {
        this.wareHouseService = wareHouseService;
    }

    public ServiceSupportMapperService getServiceSupportMapperService() {
        return this.serviceSupportMapperService;
    }

    @Resource(name="serviceSupportMapperService")
    public void setServiceSupportMapperService(ServiceSupportMapperService serviceSupportMapperService) {
        this.serviceSupportMapperService = serviceSupportMapperService;
    }

    public GoodsCateService getGoodsCateService() {
        return this.goodsCateService;
    }

    @Resource(name="GoodsCateService")
    public void setGoodsCateService(GoodsCateService goodsCateService) {
        this.goodsCateService = goodsCateService;
    }

    public ProductWareService getProductWareService() {
        return this.productWareService;
    }

    @Resource(name="ProductWareService")
    public void setProductWareService(ProductWareService productWareService) {
        this.productWareService = productWareService;
    }
}

