/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.register.controller;

import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.other.bean.CityBean;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.other.bean.DistrictBean;
import com.qianjiang.other.bean.ProvinceBean;
import com.qianjiang.other.bean.StreetBean;
import com.qianjiang.other.util.IPAddress;
import com.qianjiang.system.bean.BasicSet;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.third.audit.service.StoreInfoService;
import com.qianjiang.third.login.service.LoginService;
import com.qianjiang.third.register.service.RegisterService;
import com.qianjiang.third.seller.bean.StoreInfo;
import com.qianjiang.util.MyLogger;
import com.qianjiang.utils.UUIDUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class RegisterController {
    private static final MyLogger LOGGER = new MyLogger(RegisterController.class);
    @Resource(name="registerService")
    private RegisterService registerService;
    @Resource(name="loginServiceThird")
    private LoginService loginService;
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;
    @Resource(name="StoreInfoService")
    private StoreInfoService storeInfoService;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceMapper;
    @Autowired
    private StringRedisTemplate redisTemplate;

    @RequestMapping(value={"/customer/register"})
    public ModelAndView jumpRegister() {
        ModelAndView mav = new ModelAndView();
        try {
            BasicSet findBasicSet = this.basicSetService.findBasicSet();
            mav.addObject("basicSet", (Object)findBasicSet);
            mav.setViewName("/register/newregisterone");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5546\u5bb6\u6ce8\u518c\u7b2c\u4e00\u6b65\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/newregistertwo"})
    public ModelAndView toRegisterTwoPage(HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        String token = request.getParameter("token");
        try {
            BasicSet findBasicSet = this.basicSetService.findBasicSet();
            mav.addObject("basicSet", (Object)findBasicSet);
            mav.addObject("token", (Object)token);
            mav.setViewName("/register/newregistertwo");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5546\u5bb6\u6ce8\u518c\u7b2c\u4e8c\u6b65\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/businessenter"})
    public ModelAndView jumpBusinessEnter() {
        return new ModelAndView("/register/businessenter");
    }

    @RequestMapping(value={"/progress"})
    public ModelAndView jumpProgress() {
        return new ModelAndView("/register/progress").addObject("basicSet", (Object)this.basicSetService.findBasicSet());
    }

    @RequestMapping(value={"/queryProgress"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int queryProgress(String username) {
        Customer customer = this.customerServiceMapper.getCustomerByInput(username);
        if (customer != null && customer.getCustomerId() != null) {
            StoreInfo storeInfo = this.storeInfoService.selectByCustomerId(customer.getCustomerId());
            if (storeInfo != null) {
                if ("0".equals(storeInfo.getCheckStatus())) {
                    return 1;
                }
                if ("1".equals(storeInfo.getCheckStatus())) {
                    return 2;
                }
                return 3;
            }
            return 4;
        }
        return 0;
    }

    @RequestMapping(value={"/thirdsendcode"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int sendcode(HttpServletRequest request, String moblie) throws IOException {
        return this.registerService.sendPost(request, moblie);
    }

    @RequestMapping(value={"/sendcodetovalidate"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int sendcodeToValidate(HttpServletRequest request, String mobile, String code) throws IOException {
        if (StringUtils.isEmpty((String)((String)request.getSession().getAttribute("MPATCHCA")))) {
            return 2;
        }
        if (!request.getSession().getAttribute("MPATCHCA").equals(code)) {
            return 2;
        }
        request.getSession().removeAttribute("MPATCHCA");
        return this.registerService.newsendPost(request, mobile);
    }

    @RequestMapping(value={"/checkthirdmobileexist"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Long checkmobileexist(HttpServletRequest request, String mobile) {
        return this.customerServiceMapper.checkMobileExist(mobile);
    }

    @RequestMapping(value={"/checkmobilecode"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int checkmobilecode(HttpServletRequest request, String mobile, String codetext) throws IOException {
        String userMobile;
        String string = userMobile = request.getSession().getAttribute("userMobile") != null ? request.getSession().getAttribute("userMobile").toString() : "";
        if (userMobile.equals(mobile)) {
            String mcCode;
            String string2 = mcCode = request.getSession().getAttribute("mcCode") != null ? request.getSession().getAttribute("mcCode").toString() : "";
            if (mcCode.equals(codetext)) {
                return 1;
            }
        }
        return 0;
    }

    @RequestMapping(value={"/checkUserNameExist"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Long checkUserNameExist(HttpServletRequest request, String customerUsername) throws IOException {
        return this.customerServiceMapper.selectCustomerByName(customerUsername);
    }

    @RequestMapping(value={"/checkUserNameExistForforgeting"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Long checkUserNameExistForforgeting(String customerUsername) throws IOException {
        return this.customerServiceMapper.selectCustomerByNameForThird(customerUsername);
    }

    @RequestMapping(value={"/thirdRegisterCustomer"})
    public ModelAndView thirdRegisterCustomer(@Valid CustomerAllInfo allInfo, String varification, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        String token = request.getParameter("token");
        try {
            BasicSet findBasicSet = this.basicSetService.findBasicSet();
            mav.addObject("basicSet", (Object)findBasicSet);
            if (!this.registerCustomerValidate(allInfo, (String)request.getSession().getAttribute("PATCHCA"), varification) && !StringUtils.isEmpty((String)token)) {
                mav.setView((View)new RedirectView("jumplogin.htm"));
                return mav;
            }
            allInfo.setLoginIp(IPAddress.getIpAddr((HttpServletRequest)request));
            allInfo.setIsSeller("3");
            allInfo.setIsMobile("1");
            String mobile = (String)this.redisTemplate.opsForValue().get((Object)token);
            if (StringUtils.isEmpty((String)mobile)) {
                mav.setView((View)new RedirectView("jumplogin.htm"));
                return mav;
            }
            allInfo.setInfoMobile(mobile);
            if (this.isAddCustomerSuccess(allInfo)) {
                this.redisTemplate.delete((Object)token);
                if (this.isloginSystemSuccess(request, allInfo)) {
                    mav.setViewName("/register/new_register_succeed");
                    return mav;
                }
                mav.setView((View)new RedirectView("jumplogin.htm"));
            } else {
                mav.setView((View)new RedirectView("jumplogin.htm"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5546\u5bb6\u6ce8\u518c\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    private boolean isAddCustomerSuccess(CustomerAllInfo allInfo) {
        return this.customerServiceMapper.addThirdCustomer(allInfo) == 1;
    }

    private boolean isloginSystemSuccess(HttpServletRequest request, CustomerAllInfo allInfo) {
        return 1 == this.loginService.checkCustomerExists(request, allInfo.getCustomerUsername(), allInfo.getCustomerPassword());
    }

    private boolean registerCustomerValidate(CustomerAllInfo allInfo, String sessionPatchca, String userPatchca) {
        if (null == allInfo) {
            return false;
        }
        if (allInfo.isNameAndPasswordEmpty()) {
            return false;
        }
        return this.validateUserNameAndPatchcaCode(sessionPatchca, allInfo.getCustomerUsername(), userPatchca);
    }

    private boolean validateUserNameAndPatchcaCode(String sessionPatchca, String userName, String userPatchca) {
        if (StringUtils.isEmpty((String)sessionPatchca) || StringUtils.isEmpty((String)userPatchca)) {
            return false;
        }
        return 0L == this.customerServiceMapper.selectCustomerByName(userName) && sessionPatchca.equals(userPatchca);
    }

    @RequestMapping(value={"/registerController/registerSendCodeToValidate"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    private String registerSendCodeToValidate(HttpServletRequest request, String mobile, String code) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)mobile)) {
            result.put("status", "0");
        } else {
            String uuid = UUIDUtil.getUUID();
            result.put("status", this.registerService.sendMobileCode(request, mobile, uuid) + "");
            result.put("token", uuid);
        }
        return JSONObject.fromObject((Object)((Object)result).toString()).toString();
    }

    @RequestMapping(value={"/registerController/checkMobileCode"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String checkMobileCode(HttpServletRequest request, String mobile, String code, String token) throws IOException {
        com.alibaba.fastjson.JSONObject redisMobileCode;
        String redisMobile;
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("status", "0");
        if (!(StringUtils.isEmpty((String)mobile) || StringUtils.isEmpty((String)code) || StringUtils.isEmpty((String)token) || StringUtils.isEmpty((String)(redisMobile = (String)this.redisTemplate.opsForValue().get((Object)token))) || null == (redisMobileCode = com.alibaba.fastjson.JSONObject.parseObject((String)redisMobile)) || redisMobileCode.isEmpty())) {
            String mcCode = redisMobileCode.get("mcCode").toString();
            String userMobile = redisMobileCode.get("userMobile").toString();
            if (!StringUtils.isEmpty((String)mcCode) && !StringUtils.isEmpty((String)userMobile) && mobile.equals(userMobile) && code.equals(mcCode)) {
                result.put("status", "1");
                String uuid = UUIDUtil.getUUID();
                this.redisTemplate.opsForValue().set((Object)uuid, (Object)mobile);
                result.put("token", uuid);
                this.redisTemplate.delete((Object)token);
            }
        }
        return JSONObject.fromObject(result).toString();
    }

    @RequestMapping(value={"/getAllProvince"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<ProvinceBean> getAllProvince() {
        return this.customerServiceMapper.selectAllProvince();
    }

    @RequestMapping(value={"/getAllCityByPid"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<CityBean> getAllCityByPid(Long provinceId) {
        return this.customerServiceMapper.selectAllCityByPid(provinceId);
    }

    @RequestMapping(value={"/getAllCity"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<CityBean> getAllCity() {
        return this.customerServiceMapper.selectAllCity();
    }

    @RequestMapping(value={"/getAllDistrictByCid"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<DistrictBean> getAllDistrictByCid(Long cityId) {
        return this.customerServiceMapper.selectAllDistrictByCid(cityId);
    }

    @RequestMapping(value={"/getAllDistrict"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<DistrictBean> getAllDistrict() {
        return this.customerServiceMapper.selectAllDistrict();
    }

    @RequestMapping(value={"/getAllStreetByDid"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<StreetBean> getAllStreetByDid(Long dId) {
        return this.customerServiceMapper.getAllStreetByDid(dId);
    }
}

