/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.meneManager.controller;

import com.qianjiang.customer.bean.Customer;
import com.qianjiang.third.auth.bean.ThirdPage;
import com.qianjiang.third.auth.service.ThirdAuthorityPageService;
import com.qianjiang.third.auth.service.ThirdAuthorityService;
import com.qianjiang.third.util.MenuOperationUtil;
import com.qianjiang.third.util.ResultData;
import com.qianjiang.util.MyLogger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class MenuController {
    private static final MyLogger LOGGER = new MyLogger(MenuController.class);
    @Resource(name="thirdAuthorityPageService")
    private ThirdAuthorityPageService thirdManagerService;
    @Resource(name="thirdAuthorityService")
    private ThirdAuthorityService thirdAuthorityService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/querryMenuList"})
    public ModelAndView querryMenuList(HttpServletRequest request, String n, String l) {
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        try {
            ModelAndView modelAndView = new ModelAndView("goods/menulist");
            return modelAndView;
        }
        finally {
            LOGGER.info((Object)">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\u524d\u5f80\u83dc\u5355\u7ba1\u7406\u5217\u8868");
        }
    }

    @RequestMapping(value={"/queryAllMenu"}, produces={"application/json;charset=utf-8"})
    @ResponseBody
    public String queryAllMenu(HttpServletRequest request, ModelMap modelMap) {
        LOGGER.info((Object)"\u5f00\u59cb\u67e5\u8be2\u5546\u5bb6\u4e0b\u6240\u6709\u83dc\u5355");
        ResultData result = new ResultData();
        result.setStatus(ResultData.getError());
        try {
            ArrayList cates = new ArrayList();
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            List menus = this.thirdManagerService.queryMenuByManager(customerId);
            if (null != menus && menus.size() > 0) {
                for (ThirdPage cate : menus) {
                    HashMap<String, Object> cateMap = new HashMap<String, Object>();
                    cateMap.put("catId", cate.getId());
                    cateMap.put("catName", cate.getDesignation());
                    cateMap.put("catSort", cate.getSort());
                    cateMap.put("iconCls", "icon-tree");
                    cateMap.put("endNode", cate.getGrade());
                    cateMap.put("pageId", cate.getPageId());
                    cateMap.put("url", cate.getUrl());
                    cateMap.put("_parentId", cate.getParentId());
                    cates.add(cateMap);
                    for (int i = 0; i < cate.getMenuVos().size(); ++i) {
                        HashMap<String, Object> cateMap1 = new HashMap<String, Object>();
                        cateMap1.put("catId", cate.getMenuVos().get(i).getId());
                        cateMap1.put("catName", cate.getMenuVos().get(i).getDesignation());
                        cateMap1.put("catSort", cate.getMenuVos().get(i).getSort());
                        cateMap1.put("iconCls", "icon-tree");
                        cateMap1.put("pageId", cate.getMenuVos().get(i).getPageId());
                        cateMap1.put("endNode", cate.getMenuVos().get(i).getGrade());
                        cateMap1.put("url", cate.getMenuVos().get(i).getUrl());
                        cateMap1.put("_parentId", cate.getMenuVos().get(i).getParentId());
                        cates.add(cateMap1);
                    }
                }
            }
            result.setRows(cates);
            result.setStatus(ResultData.getSuccess());
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u83dc\u5355\u5217\u8868", (Throwable)e);
        }
        return JSONObject.fromObject(result).toString();
    }

    @RequestMapping(value={"/saveMenu"})
    public ModelAndView saveThirdCate(ThirdPage page, HttpServletRequest request, MultipartHttpServletRequest request2) {
        LOGGER.info((Object)"\u6dfb\u52a0\u83dc\u5355");
        long thirdId = (Long)request.getSession().getAttribute("thirdId");
        if (page.getParentId() == 0L) {
            page.setType("0");
        } else {
            page.setType("1");
        }
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        Long authId = this.thirdManagerService.selectAuthIdByCustId(customerId);
        page.setCreateTime(new Date());
        page.setModTime(new Date());
        page.setFlag("0");
        int add = this.thirdManagerService.insertSupplierPage(page, authId);
        return new ModelAndView("goods/menulist");
    }

    @RequestMapping(value={"/updateMenuInfo"})
    public ModelAndView updateMenuInfo(ThirdPage page, HttpServletRequest request, MultipartHttpServletRequest request2) {
        LOGGER.info((Object)"\u7f16\u8f91\u83dc\u5355");
        if (page.getParentId() == 0L) {
            page.setType("0");
        } else {
            page.setType("1");
        }
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        Long authId = this.thirdManagerService.selectAuthIdByCustId(customerId);
        page.setCreateTime(new Date());
        page.setModTime(new Date());
        Long autherPageId = page.getPageId();
        page.setFlag("0");
        this.thirdManagerService.updateSupplierPage(page, autherPageId, authId);
        return new ModelAndView("goods/menulist");
    }

    @RequestMapping(value={"/queryMenuName"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String queryMenuName(HttpServletRequest request) {
        ResultData result = new ResultData();
        result.setStatus(ResultData.getError());
        String catName = request.getParameter("catName");
        Customer customer = MenuController.findCustomer(request);
        if (null != customer && customer.getThirdId() != null && !StringUtils.isEmpty((CharSequence)catName)) {
            List menus = (List)request.getSession().getAttribute("menuPages");
            if (menus.size() > 0) {
                for (int i = 0; i < menus.size(); ++i) {
                    if (!((ThirdPage)menus.get(i)).getDesignation().equals(catName)) continue;
                    result.setStatus(ResultData.getError());
                }
            } else {
                result.setStatus(ResultData.getSuccess());
            }
        }
        return JSONObject.fromObject(result).toString();
    }

    private static final Customer findCustomer(HttpServletRequest request) {
        Customer customer = new Customer();
        long thirdId = (Long)request.getSession().getAttribute("thirdId");
        customer.setThirdId(Long.valueOf(thirdId));
        return customer;
    }
}

