/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.goods.controller;

import com.qianjiang.excel.FileBean;
import com.qianjiang.excel.ImportGoods;
import com.qianjiang.goods.bean.PageBean;
import com.qianjiang.goods.service.GoodsBrandService;
import com.qianjiang.goods.service.GoodsImportService;
import com.qianjiang.goods.service.GoodsTagService;
import com.qianjiang.goods.util.SelectBean;
import com.qianjiang.system.service.ServiceSupportMapperService;
import com.qianjiang.third.util.MenuOperationUtil;
import com.qianjiang.util.MyLogger;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ThirdGoodsImportController {
    private static final String REDIRECT = "thirdImport.html";
    public static final MyLogger LOGGER = new MyLogger(ThirdGoodsImportController.class);
    private GoodsImportService goodsImportService;
    private ImportGoods importGoods;
    private GoodsBrandService goodsBrandService;
    private GoodsTagService goodsTagService;
    @Resource(name="serviceSupportMapperService")
    private ServiceSupportMapperService serviceSupportMapperService;

    @RequestMapping(value={"/thirdDownImportExcel"})
    public void downImportExcel(HttpServletResponse response) {
        this.importGoods.exportProductList(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/thirdImport"})
    public ModelAndView queryAllImport(PageBean pageBean, SelectBean selectBean, HttpServletRequest request, String n, String l) {
        if (null != n && null != l) {
            MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        }
        pageBean.setUrl("thirdImport.htm");
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("pageBean", this.goodsImportService.selectAllGoodsImport(pageBean, selectBean, (Long)request.getSession().getAttribute("thirdId")));
            map.put("selectBean", selectBean);
            ModelAndView modelAndView = new ModelAndView("goods/thirdgoodsimport", "map", map);
            return modelAndView;
        }
        finally {
            map = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/thirdToPubImportGoods"})
    public ModelAndView toPubGoods(Long id) {
        ModelAndView mav = new ModelAndView("goods/pubimportgoods");
        try {
            mav.addObject("brandList", (Object)this.goodsBrandService.queryAllBrand());
            mav.addObject("tagList", (Object)this.goodsTagService.queryAllTag());
            mav.addObject("support", (Object)this.serviceSupportMapperService.selectAll());
            mav.addObject("importGoods", (Object)this.goodsImportService.selectByPrimaryKey(id));
            ModelAndView modelAndView = mav;
            return modelAndView;
        }
        finally {
            mav = null;
        }
    }

    @RequestMapping(value={"/thirdBatchDelImport"})
    public ModelAndView batchDelImport(Long[] importCheck, HttpServletRequest request) {
        this.goodsImportService.batchDelGoodsImport(importCheck);
        return new ModelAndView((View)new RedirectView(REDIRECT));
    }

    @RequestMapping(value={"/thirdUpdateImportAdded"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean updateImportAdded(Long id) {
        return this.goodsImportService.updateGoodsImportAdded(id) > 0;
    }

    @RequestMapping(value={"/thirdImportGoods"})
    public ModelAndView importGoods(HttpServletRequest request, HttpServletResponse response, Long goodsCateId, MultipartHttpServletRequest request2) {
        try {
            request.setAttribute("imThirdId", (Object)((Long)request.getSession().getAttribute("thirdId")));
            request.setAttribute("imThirdName", (Object)((String)request.getSession().getAttribute("storeName")));
            Long imThirdId = (Long)request.getSession().getAttribute("thirdId");
            String imThirdName = (String)request.getSession().getAttribute("storeName");
            MultipartFile file = request2.getFile("importExcel");
            FileBean fileBean = new FileBean();
            fileBean.setOriginalFilename(file.getOriginalFilename());
            fileBean.setFileb(file.getBytes());
            this.goodsImportService.importGoodsByExcel(imThirdId, imThirdName, fileBean);
        }
        catch (Exception e) {
            LOGGER.error("" + e);
            return new ModelAndView((View)new RedirectView(REDIRECT));
        }
        return new ModelAndView((View)new RedirectView(REDIRECT));
    }

    public GoodsImportService getGoodsImportService() {
        return this.goodsImportService;
    }

    @Resource(name="GoodsImportService")
    public void setGoodsImportService(GoodsImportService goodsImportService) {
        this.goodsImportService = goodsImportService;
    }

    @Resource(name="ImportGoods")
    public void setImportGoods(ImportGoods importGoods) {
        this.importGoods = importGoods;
    }

    public GoodsBrandService getGoodsBrandService() {
        return this.goodsBrandService;
    }

    @Resource(name="GoodsBrandService")
    public void setGoodsBrandService(GoodsBrandService goodsBrandService) {
        this.goodsBrandService = goodsBrandService;
    }

    public GoodsTagService getGoodsTagService() {
        return this.goodsTagService;
    }

    @Resource(name="GoodsTagServiceImpl")
    public void setGoodsTagService(GoodsTagService goodsTagService) {
        this.goodsTagService = goodsTagService;
    }
}

