/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.market.controller;

import com.qianjiang.common.util.DateUtil;
import com.qianjiang.coupon.service.CouponService;
import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.service.PointLevelServiceMapper;
import com.qianjiang.goods.service.GoodsBrandService;
import com.qianjiang.goods.service.GoodsCateService;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.promotion.bean.PreDiscountMarketing;
import com.qianjiang.promotion.bean.Promotion;
import com.qianjiang.promotion.service.CodexService;
import com.qianjiang.promotion.service.PromotionLogoService;
import com.qianjiang.promotion.service.PromotionService;
import com.qianjiang.third.goods.bean.SelectBean;
import com.qianjiang.third.goods.service.ThirdCateService;
import com.qianjiang.third.grandbrand.service.GrandBrandService;
import com.qianjiang.third.logger.util.OperateLogUtil;
import com.qianjiang.third.market.service.ThirdMarketingService;
import com.qianjiang.third.util.MenuOperationUtil;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class MarketingThirdController {
    private static final MyLogger LOGGER = new MyLogger(MarketingThirdController.class);
    private static final String THIRDID = "thirdId";
    private static final String NOWDATE = "nowdate";
    private static final String CODEXLIST = "codexList";
    private static final String BRANDLIST = "brandlist";
    private static final String CUSTOMERLEVEL = "customerLevel";
    private static final String COUPONLIST = "couponlist";
    private static final String LOGOLIST = "logolist";
    private static final String THIRDCATELIST = "thirdCateList";
    private static final String PROLIST = "prolist";
    private static final String CODEXLISTX = "codexlist";
    private static final String CODEXTYPE = "codexType";
    private static final String MARKETING = "marketing";
    @Resource(name="CodexService")
    private CodexService codexService;
    @Resource(name="GoodsBrandService")
    private GoodsBrandService goodsBrandService;
    @Resource(name="MarketingService")
    private PromotionService marketingService;
    @Resource(name="GrandBrandService")
    private GrandBrandService brandService;
    @Resource(name="ThirdCateService1")
    private ThirdCateService cateService;
    @Resource(name="ThirdMarketingService")
    private ThirdMarketingService thirdMarketingService;
    @Resource(name="pointLevelServiceMapper")
    private PointLevelServiceMapper pointLevelServiceMapper;
    @Resource(name="CouponService")
    private CouponService couponService;
    @Resource(name="PromotionLogoService")
    private PromotionLogoService logoService;
    @Resource(name="GoodsCateService")
    private GoodsCateService goodsCateService;
    @Resource(name="GoodsProductService")
    private GoodsProductService goodsProductService;

    @RequestMapping(value={"/thirdproductmarketing"})
    public ModelAndView thirdProductMarketing(PageBean pageBean, HttpServletRequest request, Promotion marketing, String n, String l) {
        ModelAndView mav = new ModelAndView();
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        pageBean.setUrl("thirdproductmarketing.htm");
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        Date date = new Date();
        try {
            marketing.setMarketingType("0");
            marketing.setBusinessId(thirdId);
            PageBean marketList = this.marketingService.marketList(pageBean, marketing, "DP");
            String nowdate = DateUtil.dateToString((Date)date, (String)DateUtil.DEFAULT_TIME_PATTERN);
            mav.addObject("pb", (Object)marketList);
            mav.addObject(NOWDATE, (Object)nowdate);
            mav.setViewName("/marketing/thirdproductmarket");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5546\u5bb6\u7aef\u521d\u59cb\u5316\u4fc3\u9500\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/createzkmarketing"})
    public ModelAndView thirdZKProductMarketing(PageBean pageBean, HttpServletRequest request, Promotion marketing, String n, String l) {
        ModelAndView mav = new ModelAndView();
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        pageBean.setUrl("createzkmarketing.htm");
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        Date date = new Date();
        try {
            marketing.setMarketingType("0");
            marketing.setBusinessId(thirdId);
            PageBean marketList = this.marketingService.marketList(pageBean, marketing, "ZK");
            String nowdate = DateUtil.dateToString((Date)date, (String)DateUtil.DEFAULT_TIME_PATTERN);
            mav.addObject("pb", (Object)marketList);
            mav.addObject(NOWDATE, (Object)nowdate);
            mav.setViewName("/marketing/thirdzkproductmarket");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u521d\u59cb\u5316\u6298\u6263\u4fc3\u9500\u5217\u8868\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/createbymarketing"})
    public ModelAndView thirdBYProductMarketing(HttpServletRequest request, PageBean pageBean, Promotion marketing, String n, String l) {
        ModelAndView mav = new ModelAndView();
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        pageBean.setUrl("createbymarketing.htm");
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        Date date = new Date();
        try {
            marketing.setMarketingType("0");
            marketing.setBusinessId(thirdId);
            PageBean marketList = this.marketingService.marketList(pageBean, marketing, "BY");
            String nowdate = DateUtil.dateToString((Date)date, (String)DateUtil.DEFAULT_TIME_PATTERN);
            mav.addObject("pb", (Object)marketList);
            mav.addObject(NOWDATE, (Object)nowdate);
            mav.setViewName("/marketing/thirdbyproductmarket");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u521d\u59cb\u5316\u5305\u90ae\u4fc3\u9500\u5217\u8868\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/createmjomarketing"})
    public ModelAndView thirdMJOProductMarketing(PageBean pageBean, HttpServletRequest request, Promotion marketing, String n, String l) {
        ModelAndView mav = new ModelAndView();
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        pageBean.setUrl("createmjomarketing.htm");
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        Date date = new Date();
        try {
            marketing.setMarketingType("0");
            marketing.setBusinessId(thirdId);
            PageBean marketList = this.marketingService.marketList(pageBean, marketing, "MJO");
            String nowdate = DateUtil.dateToString((Date)date, (String)DateUtil.DEFAULT_TIME_PATTERN);
            mav.addObject("pb", (Object)marketList);
            mav.addObject(NOWDATE, (Object)nowdate);
            mav.setViewName("/marketing/thirdmjoproductmarket");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u521d\u59cb\u5316\u6ee1\u51cf\u4fc3\u9500\u5217\u8868\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/createmjpmarketing"})
    public ModelAndView thirdMJpProductMarketing(PageBean pageBean, HttpServletRequest request, Promotion marketing, String n, String l) {
        ModelAndView mav = new ModelAndView();
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        pageBean.setUrl("createmjpmarketing.htm");
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        Date date = new Date();
        try {
            marketing.setMarketingType("0");
            marketing.setBusinessId(thirdId);
            PageBean marketList = this.marketingService.marketList(pageBean, marketing, "MJP");
            String nowdate = DateUtil.dateToString((Date)date, (String)DateUtil.DEFAULT_TIME_PATTERN);
            mav.addObject("pb", (Object)marketList);
            mav.addObject(NOWDATE, (Object)nowdate);
            mav.setViewName("/marketing/thirdmjpproductmarket");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u521d\u59cb\u5316\u6ee1\u51cf\u5217\u8868\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/adddpmarketing"})
    public ModelAndView addDpMarketing(HttpServletRequest request, String n, String l) {
        ModelAndView mav = new ModelAndView();
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        try {
            List codexList = this.codexService.selectCodexListUseBox();
            List queryAllGoodsGrandBrand = this.brandService.queryAllGoodsGrandBrand(thirdId);
            List selectAllPointLevel = this.pointLevelServiceMapper.selectAllPointLevel();
            List selectCouponListByStoreId = this.couponService.selectCouponListByStoreId(thirdId);
            List queryAllLogoList = this.logoService.queryAllLogoList();
            List queryAllGoodThirdCate = this.goodsCateService.queryAllGoodThirdCate();
            List queryProductForMarketing = this.goodsProductService.queryProductForMarketing(thirdId);
            mav.addObject(CODEXLIST, (Object)codexList);
            mav.addObject(BRANDLIST, (Object)queryAllGoodsGrandBrand);
            mav.addObject(CUSTOMERLEVEL, (Object)selectAllPointLevel);
            mav.addObject(COUPONLIST, (Object)selectCouponListByStoreId);
            mav.addObject(LOGOLIST, (Object)queryAllLogoList);
            mav.addObject(THIRDCATELIST, (Object)queryAllGoodThirdCate);
            mav.addObject(PROLIST, (Object)queryProductForMarketing);
            mav.setViewName("/marketing/createmarketing-dp");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5546\u5bb6\u7aef\u8df3\u8f6c\u6dfb\u52a0\u76f4\u964d\u4fc3\u9500\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/addzkmarketing"})
    public ModelAndView addZkMarketing(HttpServletRequest request, String n, String l) {
        ModelAndView mav = new ModelAndView();
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        try {
            List codexList = this.codexService.selectCodexListUseBox();
            List queryAllGoodsGrandBrand = this.brandService.queryAllGoodsGrandBrand(thirdId);
            List selectAllPointLevel = this.pointLevelServiceMapper.selectAllPointLevel();
            List selectCouponListByStoreId = this.couponService.selectCouponListByStoreId(thirdId);
            List queryAllLogoList = this.logoService.queryAllLogoList();
            List queryAllGoodThirdCate = this.goodsCateService.queryAllGoodThirdCate();
            List queryProductForMarketing = this.goodsProductService.queryProductForMarketing(thirdId);
            mav.addObject(CODEXLIST, (Object)codexList);
            mav.addObject(BRANDLIST, (Object)queryAllGoodsGrandBrand);
            mav.addObject(CUSTOMERLEVEL, (Object)selectAllPointLevel);
            mav.addObject(COUPONLIST, (Object)selectCouponListByStoreId);
            mav.addObject(LOGOLIST, (Object)queryAllLogoList);
            mav.addObject(THIRDCATELIST, (Object)queryAllGoodThirdCate);
            mav.addObject(PROLIST, (Object)queryProductForMarketing);
            mav.setViewName("/marketing/createmarketing-zk");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5546\u5bb6\u7aef\u8df3\u8f6c\u6dfb\u52a0\u6298\u6263\u4fc3\u9500\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/addbymarketing"})
    public ModelAndView addByMarketing(HttpServletRequest request, String n, String l) {
        ModelAndView mav = new ModelAndView();
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        try {
            List codexList = this.codexService.selectCodexListUseBox();
            List queryAllGoodsGrandBrand = this.brandService.queryAllGoodsGrandBrand(thirdId);
            List selectAllPointLevel = this.pointLevelServiceMapper.selectAllPointLevel();
            List selectCouponListByStoreId = this.couponService.selectCouponListByStoreId(thirdId);
            List queryAllLogoList = this.logoService.queryAllLogoList();
            List queryAllGoodThirdCate = this.goodsCateService.queryAllGoodThirdCate();
            List queryProductForMarketing = this.goodsProductService.queryProductForMarketing(thirdId);
            mav.addObject(CODEXLIST, (Object)codexList);
            mav.addObject(BRANDLIST, (Object)queryAllGoodsGrandBrand);
            mav.addObject(CUSTOMERLEVEL, (Object)selectAllPointLevel);
            mav.addObject(COUPONLIST, (Object)selectCouponListByStoreId);
            mav.addObject(LOGOLIST, (Object)queryAllLogoList);
            mav.addObject(THIRDCATELIST, (Object)queryAllGoodThirdCate);
            mav.addObject(PROLIST, (Object)queryProductForMarketing);
            mav.setViewName("/marketing/createmarketing-by");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5546\u5bb6\u7aef\u8df3\u8f6c\u5305\u90ae\u4fc3\u9500\u9875\u9762\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/addmjomarketing"})
    public ModelAndView addMjoMarketing(HttpServletRequest request, String n, String l) {
        ModelAndView mav = new ModelAndView();
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        try {
            List codexList = this.codexService.selectCodexListUseBox();
            List queryAllGoodsGrandBrand = this.brandService.queryAllGoodsGrandBrand(thirdId);
            List selectAllPointLevel = this.pointLevelServiceMapper.selectAllPointLevel();
            List selectCouponListByStoreId = this.couponService.selectCouponListByStoreId(thirdId);
            List queryAllLogoList = this.logoService.queryAllLogoList();
            List queryAllGoodThirdCate = this.goodsCateService.queryAllGoodThirdCate();
            List queryProductForMarketing = this.goodsProductService.queryProductForMarketing(thirdId);
            mav.addObject(CODEXLIST, (Object)codexList);
            mav.addObject(BRANDLIST, (Object)queryAllGoodsGrandBrand);
            mav.addObject(CUSTOMERLEVEL, (Object)selectAllPointLevel);
            mav.addObject(COUPONLIST, (Object)selectCouponListByStoreId);
            mav.addObject(LOGOLIST, (Object)queryAllLogoList);
            mav.addObject(THIRDCATELIST, (Object)queryAllGoodThirdCate);
            mav.addObject(PROLIST, (Object)queryProductForMarketing);
            mav.setViewName("/marketing/createmarketing-mjo");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5546\u5bb6\u7aef\u8df3\u8f6c\u6dfb\u52a0\u6ee1\u51cf\u4fc3\u9500\u9875\u9762\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/addmjpmarketing"})
    public ModelAndView addMjpMarketing(HttpServletRequest request, String n, String l) {
        ModelAndView mav = new ModelAndView();
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        try {
            List codexList = this.codexService.selectCodexListUseBox();
            List queryAllGoodsGrandBrand = this.brandService.queryAllGoodsGrandBrand(thirdId);
            List selectAllPointLevel = this.pointLevelServiceMapper.selectAllPointLevel();
            List selectCouponListByStoreId = this.couponService.selectCouponListByStoreId(thirdId);
            List queryAllLogoList = this.logoService.queryAllLogoList();
            List queryAllGoodThirdCate = this.goodsCateService.queryAllGoodThirdCate();
            List queryProductForMarketing = this.goodsProductService.queryProductForMarketing(thirdId);
            mav.addObject(CODEXLIST, (Object)codexList);
            mav.addObject(BRANDLIST, (Object)queryAllGoodsGrandBrand);
            mav.addObject(CUSTOMERLEVEL, (Object)selectAllPointLevel);
            mav.addObject(COUPONLIST, (Object)selectCouponListByStoreId);
            mav.addObject(LOGOLIST, (Object)queryAllLogoList);
            mav.addObject(THIRDCATELIST, (Object)queryAllGoodThirdCate);
            mav.addObject(PROLIST, (Object)queryProductForMarketing);
            mav.setViewName("/marketing/createmarketing-mjp");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5546\u5bb6\u7aef\u8df3\u8f6c\u6dfb\u52a0\u6ee1\u4ef6\u4fc3\u9500\u9875\u9762\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/thirdordermarketing"})
    public ModelAndView thirdOrderMarketing(PageBean pageBean, HttpServletRequest request, Promotion marketing, String marketingBeginTime, String marketingEndTime, String n, String l) {
        ModelAndView mav = new ModelAndView();
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        pageBean.setUrl("thirdordermarketing.htm");
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        try {
            marketing.setMarketingType("1");
            marketing.setBusinessId(thirdId);
            PageBean marketOrderList = this.marketingService.marketOrderList(pageBean, marketing, marketingBeginTime, marketingEndTime);
            mav.addObject("pageBean", (Object)marketOrderList);
            mav.setViewName("/marketing/thirdordermarket");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mav;
    }

    @RequestMapping(value={"/toaddgoodsmarketingthird"})
    public ModelAndView toAddGoodsMarketing(HttpServletRequest request, SelectBean selectBean) {
        ModelAndView mav = new ModelAndView();
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        try {
            Promotion mk = new Promotion();
            mk.setMarketingType("0");
            mav.addObject("mk", (Object)mk);
            mav.addObject(CODEXLISTX, (Object)this.codexService.selectCodexListUseBox());
            mav.addObject(BRANDLIST, (Object)this.brandService.queryAllGoodsGrandBrand(thirdId));
            mav.addObject("pre", (Object)this.marketingService.selectAll());
            mav.setViewName("/marketing/thirdcreatemarket");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mav;
    }

    @RequestMapping(value={"/toaddordersmarketingthird"})
    public ModelAndView toAddOrdersMarketing(HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        try {
            Promotion mk = new Promotion();
            mk.setMarketingType("1");
            mav.addObject("mk", (Object)mk);
            mav.addObject(CODEXLISTX, (Object)this.codexService.selectCodexListUseBox());
            mav.addObject(BRANDLIST, (Object)this.brandService.queryAllGoodsGrandBrand(thirdId));
            mav.addObject(CODEXLISTX, (Object)this.codexService.selectCodexListUseBox());
            mav.addObject(BRANDLIST, (Object)this.goodsBrandService.queryAllBrandList());
            mav.addObject("pre", (Object)this.marketingService.selectAll());
            mav.setViewName("/marketing/thirdcreatemarket");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mav;
    }

    @RequestMapping(value={"/addmarketing"})
    public ModelAndView doAddMarketing(HttpServletRequest request, Promotion marketing, String sTime, String eTime) {
        ModelAndView mav = new ModelAndView();
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        try {
            marketing.setBusinessId(thirdId);
            marketing.setMarketingBegin(DateUtil.stringToDate((String)sTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
            marketing.setMarketingEnd(DateUtil.stringToDate((String)eTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
            String codexType = request.getParameter(CODEXTYPE);
            this.marketingService.doAddMarketing(marketing, codexType, request);
            if ("1".equals(marketing.getMarketingType())) {
                mav.setView((View)new RedirectView("thirdordermarketing.htm"));
            } else {
                mav.setView((View)new RedirectView("thirdproductmarketing.htm"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mav;
    }

    @RequestMapping(value={"/newaddmarketing"})
    public ModelAndView newDoAddMarketing(HttpServletRequest request, Promotion marketing, String sTime, String eTime, String status, Long[] lelvelId, Long[] promotionLogoId, String marketingFlag) {
        ModelAndView mav = new ModelAndView();
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        try {
            marketing.setBusinessId(thirdId);
            marketing.setMarketingBegin(DateUtil.stringToDate((String)sTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
            marketing.setMarketingEnd(DateUtil.stringToDate((String)eTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
            String giveIntegral = request.getParameter("giveIntegral");
            if (giveIntegral == null || "".equals(giveIntegral)) {
                marketing.setGiveIntegral(Integer.valueOf(0));
            }
            String codexType = request.getParameter(CODEXTYPE);
            this.marketingService.newDoAddMarketing(marketing, codexType, request, status, lelvelId, promotionLogoId);
            if ("DP".equals(marketingFlag)) {
                Customer cust;
                if (request.getSession().getAttribute("cust") != null && (cust = (Customer)request.getSession().getAttribute("cust")).getCustomerUsername() != null) {
                    OperateLogUtil.addOperaLog(request, cust.getCustomerUsername(), "\u6dfb\u52a0\u5355\u54c1\u4fc3\u9500", "\u6dfb\u52a0\u5355\u54c1\u4fc3\u9500\uff0c\u4fc3\u9500\u540d\u79f0\u3010" + marketing.getMarketingName() + "\u3011-->\u7528\u6237\u540d\uff1a" + cust.getCustomerUsername());
                    LOGGER.info((Object)"\u6dfb\u52a0\u5355\u54c1\u4fc3\u9500");
                }
                mav.setView((View)new RedirectView("thirdproductmarketing.htm"));
            } else if ("ZK".equals(marketingFlag)) {
                Customer cust;
                if (request.getSession().getAttribute("cust") != null && (cust = (Customer)request.getSession().getAttribute("cust")).getCustomerUsername() != null) {
                    OperateLogUtil.addOperaLog(request, cust.getCustomerUsername(), "\u6dfb\u52a0\u6298\u6263\u4fc3\u9500", "\u6dfb\u52a0\u6298\u6263\u4fc3\u9500\uff0c\u4fc3\u9500\u540d\u79f0\u3010" + marketing.getMarketingName() + "\u3011-->\u7528\u6237\u540d\uff1a" + cust.getCustomerUsername());
                    LOGGER.info((Object)"\u6dfb\u52a0\u6298\u6263\u4fc3\u9500");
                }
                mav.setView((View)new RedirectView("createzkmarketing.htm"));
            } else if ("BY".equals(marketingFlag)) {
                Customer cust;
                if (request.getSession().getAttribute("cust") != null && (cust = (Customer)request.getSession().getAttribute("cust")).getCustomerUsername() != null) {
                    OperateLogUtil.addOperaLog(request, cust.getCustomerUsername(), "\u6dfb\u52a0\u5305\u90ae\u4fc3\u9500", "\u6dfb\u52a0\u5305\u90ae\u4fc3\u9500\uff0c\u4fc3\u9500\u540d\u79f0\u3010" + marketing.getMarketingName() + "\u3011-->\u7528\u6237\u540d\uff1a" + cust.getCustomerUsername());
                    LOGGER.info((Object)"\u6dfb\u52a0\u5305\u90ae\u4fc3\u9500");
                }
                mav.setView((View)new RedirectView("createbymarketing.htm"));
            } else if ("MJO".equals(marketingFlag)) {
                Customer cust;
                if (request.getSession().getAttribute("cust") != null && (cust = (Customer)request.getSession().getAttribute("cust")).getCustomerUsername() != null) {
                    OperateLogUtil.addOperaLog(request, cust.getCustomerUsername(), "\u6dfb\u52a0\u6ee1\u51cf\u4fc3\u9500", "\u6dfb\u52a0\u6ee1\u51cf\u4fc3\u9500\uff0c\u4fc3\u9500\u540d\u79f0\u3010" + marketing.getMarketingName() + "\u3011-->\u7528\u6237\u540d\uff1a" + cust.getCustomerUsername());
                    LOGGER.info((Object)"\u6dfb\u52a0\u6ee1\u51cf\u4fc3\u9500");
                }
                mav.setView((View)new RedirectView("createmjomarketing.htm"));
            } else if ("MJP".equals(marketingFlag)) {
                Customer cust;
                if (request.getSession().getAttribute("cust") != null && (cust = (Customer)request.getSession().getAttribute("cust")).getCustomerUsername() != null) {
                    OperateLogUtil.addOperaLog(request, cust.getCustomerUsername(), "\u6dfb\u52a0\u6ee1\u4ef6\u4fc3\u9500", "\u6dfb\u52a0\u6ee1\u4ef6\u4fc3\u9500\uff0c\u4fc3\u9500\u540d\u79f0\u3010" + marketing.getMarketingName() + "\u3011-->\u7528\u6237\u540d\uff1a" + cust.getCustomerUsername());
                    LOGGER.info((Object)"\u6dfb\u52a0\u6ee1\u4ef6\u4fc3\u9500");
                }
                mav.setView((View)new RedirectView("createmjpmarketing.htm"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5546\u5bb6\u7aef\u6dfb\u52a0\u4fc3\u9500\u4fe1\u606f\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/editmarket"})
    public ModelAndView editMarket(Long marketingId) {
        ModelAndView mav = new ModelAndView();
        try {
            mav.addObject(MARKETING, (Object)this.marketingService.marketingDetail(marketingId));
            mav.addObject("skulist", this.marketingService.selectMarketingScope(marketingId, "2"));
            mav.addObject(CODEXLISTX, (Object)this.codexService.selectCodexListUseBox());
            mav.addObject(BRANDLIST, (Object)this.goodsBrandService.queryAllBrandList());
            mav.setViewName("/marketing/thirdupdatemarket");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mav;
    }

    @RequestMapping(value={"/marketdetails"})
    public ModelAndView marketDetails(Long marketingId) {
        ModelAndView mav = new ModelAndView();
        try {
            mav.addObject(MARKETING, (Object)this.marketingService.marketingDetail(marketingId));
            mav.addObject("skulist", this.marketingService.selectMarketingScope(marketingId, "2"));
            mav.addObject(CODEXLISTX, (Object)this.codexService.selectCodexListUseBox());
            mav.addObject(BRANDLIST, (Object)this.goodsBrandService.queryAllBrandList());
            mav.setViewName("/marketing/marketdetails");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mav;
    }

    @RequestMapping(value={"/doeditmarket"})
    public ModelAndView doUpdateMarketing(HttpServletRequest request, Promotion marketing, String sTime, String eTime) {
        ModelAndView mav = new ModelAndView();
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        try {
            marketing.setBusinessId(thirdId);
            marketing.setMarketingBegin(DateUtil.stringToDate((String)sTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
            marketing.setMarketingEnd(DateUtil.stringToDate((String)eTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
            String codexType = request.getParameter(CODEXTYPE);
            this.marketingService.doUpdateMarketing(marketing, codexType, request);
            if ("1".equals(marketing.getMarketingType())) {
                mav.setView((View)new RedirectView("thirdordermarketing.htm"));
            } else {
                mav.setView((View)new RedirectView("thirdproductmarketing.htm"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mav;
    }

    @RequestMapping(value={"/delmarketing"})
    public ModelAndView delMarketingById(Long marketingId) {
        ModelAndView mav = new ModelAndView();
        try {
            Promotion marketing = this.marketingService.marketingDetail(marketingId);
            this.marketingService.deleteMarketingById(marketing);
            if ("1".equals(marketing.getMarketingType())) {
                mav.setView((View)new RedirectView("thirdordermarketing.htm"));
            } else {
                mav.setView((View)new RedirectView("thirdproductmarketing.htm"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mav;
    }

    @RequestMapping(value={"/delnewmarketing"})
    public ModelAndView newDelMarketingById(HttpServletRequest request, Long marketingId, String codexType) {
        ModelAndView mav = new ModelAndView();
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        try {
            this.marketingService.deleteMarkting(marketingId, thirdId);
            if ("1".equals(codexType)) {
                mav.setView((View)new RedirectView("thirdproductmarketing.htm"));
            } else if ("15".equals(codexType)) {
                mav.setView((View)new RedirectView("createzkmarketing.htm"));
            } else if ("12".equals(codexType)) {
                mav.setView((View)new RedirectView("createbymarketing.htm"));
            } else if ("5".equals(codexType) || "8".equals(codexType)) {
                mav.setView((View)new RedirectView("createmjomarketing.htm"));
            } else if ("13".equals(codexType) || "14".equals(codexType)) {
                mav.setView((View)new RedirectView("createmjpmarketing.htm"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5546\u5bb6\u7aef\uff1a\u5355\u4e2a\u5220\u9664\u8425\u9500\u4fe1\u606f\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/delmarketings"})
    public ModelAndView delAllMarketingByIds(Long[] marketingId, String marketingType, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        try {
            this.marketingService.delAllMarketingByIds(marketingId, thirdId);
            if ("1".equals(marketingType)) {
                mav.setView((View)new RedirectView("thirdordermarketing.htm"));
            } else {
                mav.setView((View)new RedirectView("thirdproductmarketing.htm"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mav;
    }

    @RequestMapping(value={"/newdelmarketings"})
    public ModelAndView newdelAllMarketingByIds(HttpServletRequest request, Long[] marketingId, String codexType) {
        ModelAndView mav = new ModelAndView();
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        try {
            this.marketingService.delAllMarketingByIds(marketingId, thirdId);
            String[] arr = codexType.split(",");
            String type = arr[0];
            LOGGER.info((Object)("\u9700\u8981\u5220\u9664\u7684codexType\uff1a" + type));
            if ("1".equals(type)) {
                mav.setView((View)new RedirectView("thirdproductmarketing.htm"));
            } else if ("15".equals(type)) {
                mav.setView((View)new RedirectView("createzkmarketing.htm"));
            } else if ("12".equals(type)) {
                mav.setView((View)new RedirectView("createbymarketing.htm"));
            } else if ("5".equals(type) || "8".equals(type)) {
                mav.setView((View)new RedirectView("createmjomarketing.htm"));
            } else if ("13".equals(type) || "14".equals(type)) {
                mav.setView((View)new RedirectView("createmjpmarketing.htm"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5546\u5bb6\u7aef\u6279\u91cf\u5220\u9664\u4fc3\u9500\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/queryAllThirdGoodsCate"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<Object> queryAllThirdGoodsCate(SelectBean selectBean, HttpServletRequest request) {
        ArrayList<Object> list = new ArrayList();
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        try {
            list = this.cateService.getAllCalcThirdCate(selectBean, thirdId);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u67e5\u8be2\u5e97\u94fa\u6240\u6709\u5206\u7c7b\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return list;
    }

    @RequestMapping(value={"/neweditmarketing"})
    public ModelAndView newEditMarketing(HttpServletRequest request, Long marketingId, String marketingFlag) {
        ModelAndView mav = new ModelAndView();
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        try {
            Promotion mark = this.marketingService.marketingDetailNotTime(marketingId);
            if (thirdId != null && mark.getBusinessId() != null && !thirdId.equals(mark.getBusinessId())) {
                mav.setView((View)new RedirectView(request.getContextPath() + "/sellerinfo.html"));
                return mav;
            }
            BigDecimal dis = BigDecimal.ZERO;
            if (mark != null && "1".equals(mark.getIsAll()) && "15".equals(mark.getCodexType()) && !CollectionUtils.isEmpty((Collection)mark.getPreDiscountMarketings())) {
                dis = ((PreDiscountMarketing)mark.getPreDiscountMarketings().get(0)).getDiscountInfo();
            }
            Promotion marketing = this.marketingService.marketingDetailNotTime(marketingId);
            Object catelistMarketingScope = this.thirdMarketingService.selectThirdMarketingScope(marketingId, "0", thirdId);
            Object brandtMarketingScope = this.thirdMarketingService.selectThirdMarketingScope(marketingId, "1", thirdId);
            Object productMarketingScope = this.thirdMarketingService.selectThirdMarketingScope(marketingId, "2", thirdId);
            List selectAllPointLevel = this.pointLevelServiceMapper.selectAllPointLevel();
            List selectCouponListByAble = this.couponService.selectCouponListByAble();
            List queryAllLogoList = this.logoService.queryAllLogoList();
            List queryAllGoodThirdCate = this.goodsCateService.queryAllGoodThirdCate();
            List codexList = this.codexService.selectCodexListUseBox();
            List queryAllProduct = this.goodsProductService.queryProductForMarketing(thirdId);
            mav.addObject(MARKETING, (Object)marketing);
            mav.addObject("catelist", catelistMarketingScope);
            mav.addObject(BRANDLIST, brandtMarketingScope);
            mav.addObject("kulist", productMarketingScope);
            mav.addObject(CUSTOMERLEVEL, (Object)selectAllPointLevel);
            mav.addObject(COUPONLIST, (Object)selectCouponListByAble);
            mav.addObject(LOGOLIST, (Object)queryAllLogoList);
            mav.addObject(THIRDCATELIST, (Object)queryAllGoodThirdCate);
            mav.addObject(CODEXLIST, (Object)codexList);
            mav.addObject(PROLIST, (Object)queryAllProduct);
            mav.addObject("discount", (Object)dis);
            mav.addObject("marketingFlag", (Object)marketingFlag);
            mav.setViewName("/marketing/modifymarketing");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u8df3\u8f6c\u4fee\u6539\u4fc3\u9500\u4fe1\u606f\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/newsavemarketing"})
    public ModelAndView newDoSaveMarketing(HttpServletRequest request, Promotion marketing, String sTime, String eTime, String status, Long[] lelvelId, Long[] promotionLogoId, String marketingFlag) {
        ModelAndView mav = new ModelAndView();
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        try {
            marketing.setBusinessId(thirdId);
            marketing.setMarketingBegin(DateUtil.stringToDate((String)sTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
            marketing.setMarketingEnd(DateUtil.stringToDate((String)eTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
            String giveIntegral = request.getParameter("giveIntegral");
            if (giveIntegral == null || "".equals(giveIntegral)) {
                marketing.setGiveIntegral(Integer.valueOf(0));
            }
            String codexType = request.getParameter(CODEXTYPE);
            this.marketingService.newDoUpdateMarketing(marketing, codexType, status, request, lelvelId, promotionLogoId);
            if ("DP".equals(marketingFlag)) {
                Customer cust;
                if (request.getSession().getAttribute("cust") != null && (cust = (Customer)request.getSession().getAttribute("cust")).getCustomerUsername() != null) {
                    OperateLogUtil.addOperaLog(request, cust.getCustomerUsername(), "\u4fee\u6539\u5355\u54c1\u4fc3\u9500", "\u4fee\u6539\u5355\u54c1\u4fc3\u9500\uff0c\u73b0\u4fc3\u9500\u540d\u79f0\u3010" + marketing.getMarketingName() + "\u3011-->\u7528\u6237\u540d\uff1a" + cust.getCustomerUsername());
                    LOGGER.info((Object)"\u4fee\u6539\u5355\u54c1\u4fc3\u9500");
                }
                mav.setView((View)new RedirectView("thirdproductmarketing.htm"));
            } else if ("ZK".equals(marketingFlag)) {
                Customer cust;
                if (request.getSession().getAttribute("cust") != null && (cust = (Customer)request.getSession().getAttribute("cust")).getCustomerUsername() != null) {
                    OperateLogUtil.addOperaLog(request, cust.getCustomerUsername(), "\u4fee\u6539\u6298\u6263\u4fc3\u9500", "\u4fee\u6539\u6298\u6263\u4fc3\u9500\uff0c\u73b0\u4fc3\u9500\u540d\u79f0\u3010" + marketing.getMarketingName() + "\u3011-->\u7528\u6237\u540d\uff1a" + cust.getCustomerUsername());
                    LOGGER.info((Object)"\u4fee\u6539\u6298\u6263\u4fc3\u9500");
                }
                mav.setView((View)new RedirectView("createzkmarketing.htm"));
            } else if ("BY".equals(marketingFlag)) {
                Customer cust;
                if (request.getSession().getAttribute("cust") != null && (cust = (Customer)request.getSession().getAttribute("cust")).getCustomerUsername() != null) {
                    OperateLogUtil.addOperaLog(request, cust.getCustomerUsername(), "\u4fee\u6539\u5305\u90ae\u4fc3\u9500", "\u4fee\u6539\u5305\u90ae\u4fc3\u9500\uff0c\u73b0\u4fc3\u9500\u540d\u79f0\u3010" + marketing.getMarketingName() + "\u3011-->\u7528\u6237\u540d\uff1a" + cust.getCustomerUsername());
                    LOGGER.info((Object)"\u4fee\u6539\u5305\u90ae\u4fc3\u9500");
                }
                mav.setView((View)new RedirectView("createbymarketing.htm"));
            } else if ("MJO".equals(marketingFlag)) {
                Customer cust;
                if (request.getSession().getAttribute("cust") != null && (cust = (Customer)request.getSession().getAttribute("cust")).getCustomerUsername() != null) {
                    OperateLogUtil.addOperaLog(request, cust.getCustomerUsername(), "\u4fee\u6539\u6ee1\u51cf\u4fc3\u9500", "\u4fee\u6539\u6ee1\u51cf\u4fc3\u9500\uff0c\u73b0\u4fc3\u9500\u540d\u79f0\u3010" + marketing.getMarketingName() + "\u3011-->\u7528\u6237\u540d\uff1a" + cust.getCustomerUsername());
                    LOGGER.info((Object)"\u4fee\u6539\u6ee1\u51cf\u4fc3\u9500");
                }
                mav.setView((View)new RedirectView("createmjomarketing.htm"));
            } else if ("MJP".equals(marketingFlag)) {
                Customer cust;
                if (request.getSession().getAttribute("cust") != null && (cust = (Customer)request.getSession().getAttribute("cust")).getCustomerUsername() != null) {
                    OperateLogUtil.addOperaLog(request, cust.getCustomerUsername(), "\u4fee\u6539\u6ee1\u4ef6\u4fc3\u9500", "\u4fee\u6539\u6ee1\u4ef6\u4fc3\u9500\uff0c\u73b0\u4fc3\u9500\u540d\u79f0\u3010" + marketing.getMarketingName() + "\u3011-->\u7528\u6237\u540d\uff1a" + cust.getCustomerUsername());
                    LOGGER.info((Object)"\u4fee\u6539\u6ee1\u4ef6\u4fc3\u9500");
                }
                mav.setView((View)new RedirectView("createmjpmarketing.htm"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4fee\u6539\u4fc3\u9500\u4fe1\u606f\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }
}

