/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.image.controller;

import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.image.bean.InfoImageManage;
import com.qianjiang.image.service.InfoImageClassifyService;
import com.qianjiang.image.service.InfoImageManageService;
import com.qianjiang.third.logger.util.OperateLogUtil;
import com.qianjiang.third.util.MenuOperationUtil;
import com.qianjiang.uploadfileset.bean.UploadFileSet;
import com.qianjiang.uploadfileset.service.UploadFileSetService;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.UploadUtil;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ImageManagerThirdController {
    private static final Logger LOGGER = Logger.getLogger(ImageManagerThirdController.class);
    private static final String THIRDID = "thirdId";
    @Resource(name="UploadFileSetService")
    private UploadFileSetService uploadFileSetService;
    @Resource(name="InfoImageClassifyService")
    public InfoImageClassifyService infoImageClassifyService;
    @Resource(name="InfoImageManageService")
    private InfoImageManageService infoImageManageService;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceMapper;
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";

    @RequestMapping(value={"/queryImageManageByChoose"})
    public ModelAndView queryImageByPbAndCidForChoose(HttpServletRequest request, PageBean pb, Long classifyId, Integer size) {
        Integer sizeNew = size;
        LOGGER.debug((Object)"======\u6839\u636e\u5206\u7c7b\uff0c\u5206\u9875\u67e5\u8be2\u56fe\u7247\u4fe1\u606f======");
        ModelAndView mav = new ModelAndView();
        if (null == sizeNew) {
            sizeNew = 1;
        }
        mav.addObject("size", (Object)sizeNew);
        UploadFileSet ufs = this.uploadFileSetService.getCurrUploadFileSet();
        mav.addObject("ufs", (Object)ufs);
        mav.setViewName("image/chooseImage");
        return mav;
    }

    @RequestMapping(value={"third/imageListManager"})
    public ModelAndView imageListManager(PageBean pb, HttpServletRequest request, String n, String l) {
        String nNew = n;
        String lNew = l;
        if (nNew == null || lNew == null) {
            nNew = "2";
            lNew = "95";
        }
        HashMap<String, PageBean> map = new HashMap<String, PageBean>();
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        map.put("pb", this.infoImageManageService.selectImageByThirdId(pb, thirdId));
        MenuOperationUtil.fillSessionMenuIndex(request, nNew, lNew);
        pb.setUrl("imageListManager.html?n=" + nNew + "&l=" + lNew);
        return new ModelAndView("image/imagelist").addObject("map", map);
    }

    @RequestMapping(value={"saveImageAction"})
    public ModelAndView saveImageAction(MultipartHttpServletRequest request, InfoImageManage infoImageManage) {
        MultipartFile muFile = request.getFile("imgSrc");
        if (muFile.getSize() > 0L) {
            Customer cust;
            infoImageManage.setThirdId((Long)request.getSession().getAttribute(THIRDID));
            infoImageManage.setImageManageUrl(UploadUtil.uploadFileOne((MultipartFile)muFile, (HttpServletRequest)request));
            infoImageManage.setImageOnlineDate(new Date());
            if (this.infoImageManageService.saveInfoImageManage(infoImageManage) > 0 && request.getSession().getAttribute("cust") != null && (cust = (Customer)request.getSession().getAttribute("cust")).getCustomerUsername() != null) {
                OperateLogUtil.addOperaLog((HttpServletRequest)request, cust.getCustomerUsername(), "\u6dfb\u52a0\u56fe\u7247", "\u6dfb\u52a0\u56fe\u7247-->\u7528\u6237\u540d\uff1a" + cust.getCustomerUsername());
                LOGGER.info((Object)"\u6dfb\u52a0\u56fe\u7247");
            }
        }
        return new ModelAndView((View)new RedirectView(request.getContextPath() + "/imageListManager.html"));
    }

    @RequestMapping(value={"updateImage"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int updateImage(Long imageManageId, HttpServletRequest request) {
        Customer cust;
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        if (request.getSession().getAttribute("cust") != null && (cust = (Customer)request.getSession().getAttribute("cust")).getCustomerUsername() != null) {
            OperateLogUtil.addOperaLog(request, cust.getCustomerUsername(), "\u5220\u9664\u56fe\u7247", "\u5220\u9664\u56fe\u7247-->\u7528\u6237\u540d\uff1a" + cust.getCustomerUsername());
            LOGGER.info((Object)"\u5220\u9664\u56fe\u7247");
        }
        return this.infoImageManageService.updateImage(imageManageId, thirdId);
    }

    @RequestMapping(value={"updateImages"})
    public ModelAndView updateImages(HttpServletRequest request, Long[] imageManageIds) {
        Customer cust;
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        this.infoImageManageService.updateImages(imageManageIds, thirdId);
        if (request.getSession().getAttribute("cust") != null && (cust = (Customer)request.getSession().getAttribute("cust")).getCustomerUsername() != null) {
            OperateLogUtil.addOperaLog(request, cust.getCustomerUsername(), "\u6279\u91cf\u5220\u9664\u56fe\u7247", "\u6279\u91cf\u5220\u9664\u56fe\u7247-->\u7528\u6237\u540d\uff1a" + cust.getCustomerUsername());
            LOGGER.info((Object)"\u6279\u91cf\u5220\u9664\u56fe\u7247");
        }
        return new ModelAndView((View)new RedirectView(request.getContextPath() + "/imageListManager.html"));
    }

    @ResponseBody
    @RequestMapping(value={"/ajaxQueryImageForChooseAndThirdId"}, produces={"application/json;charset=UTF-8"})
    public PageBean ajaxQueryImageForChoose(HttpServletRequest request, PageBean pb, Long classifyId) {
        LOGGER.debug((Object)"======\u6839\u636e\u5206\u7c7b\uff0c\u5206\u9875\u67e5\u8be2\u56fe\u7247\u4fe1\u606f======");
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        if (null != classifyId && classifyId >= 0L) {
            return this.infoImageManageService.selectImageManageByParam(pb, classifyId, thirdId);
        }
        return this.infoImageManageService.selectImageManageByParam(pb, null, thirdId);
    }
}

