/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.seller.controller;

import com.qianjiang.comment.bean.Comment;
import com.qianjiang.comment.service.CommentServiceMapper;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.goods.bean.GoodsCate;
import com.qianjiang.goods.service.GoodsBrandService;
import com.qianjiang.goods.service.GoodsCateService;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.system.service.DistrictService;
import com.qianjiang.system.util.AddressUtil;
import com.qianjiang.third.audit.service.StoreInfoService;
import com.qianjiang.third.goods.bean.GoodsBrand;
import com.qianjiang.third.goods.service.ThirdOtherService;
import com.qianjiang.third.goods.service.ThirdWarnGoodService;
import com.qianjiang.third.logger.util.OperateLogUtil;
import com.qianjiang.third.seller.bean.ApplyBrand;
import com.qianjiang.third.seller.bean.OrderCount;
import com.qianjiang.third.seller.bean.StoreInfo;
import com.qianjiang.third.seller.bean.ThirdStoreMess;
import com.qianjiang.third.seller.service.ApplyBrandService;
import com.qianjiang.third.seller.service.SellerService;
import com.qianjiang.third.seller.service.StroreContactService;
import com.qianjiang.third.seller.util.FileUploadUtil;
import com.qianjiang.third.sld.service.DomainCustomService;
import com.qianjiang.third.util.DateUtils;
import com.qianjiang.third.util.MenuOperationUtil;
import com.qianjiang.third.util.ResultData;
import com.qianjiang.third.util.ThirdStoreURLUtil;
import com.qianjiang.util.MyLogger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class SellerController {
    private static final MyLogger LOGGER = new MyLogger(SellerController.class);
    private static final String THIRDID = "thirdId";
    private static final String CUSTOMERID = "customerId";
    public static final String NAME = "name";
    private SellerService sellerService;
    private StroreContactService stroreContactService;
    private GoodsBrandService goodsBrandService;
    @Resource(name="ApplyBrandService")
    private ApplyBrandService applyBrandService;
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceMapper;
    @Autowired
    private GoodsCateService goodsCateService;
    @Resource(name="StoreInfoService")
    public StoreInfoService sotreInfoMapper;
    @Resource(name="domainCustomService")
    private DomainCustomService domainCustomService;
    @Resource(name="DistrictService")
    private DistrictService districtService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private ThirdWarnGoodService thirdWarnGoodService;
    @Autowired
    private ThirdOtherService thirdOtherService;
    @Autowired
    private CommentServiceMapper commentServiceMapper;

    @RequestMapping(value={"third/sellerinfos"})
    public ModelAndView sellerinfos(HttpServletRequest request, String n, String l) {
        StoreInfo storeInfo = null;
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        CustomerAllInfo customer = this.customerServiceMapper.selectByPrimaryKey(customerId);
        storeInfo = this.sotreInfoMapper.selectByCustomerId(customer.getCustomerId());
        resultMap.put("info", this.sellerService.selectByStoreId((Long)request.getSession().getAttribute(THIRDID)));
        resultMap.put("seller", this.stroreContactService.selectByStoreId((Long)request.getSession().getAttribute(THIRDID)));
        request.getSession().setAttribute("siteUrl", (Object)this.basicSetService.findBasicSet());
        request.getSession().setAttribute("customer", (Object)customer);
        if ("1".equals(storeInfo.getCheckStatus()) && "1".equals(storeInfo.getIsSubmit())) {
            return new ModelAndView("seller/sellerinfo").addAllObjects(resultMap);
        }
        return new ModelAndView((View)new RedirectView("login.html"));
    }

    @RequestMapping(value={"third/sellerinfo"})
    public ModelAndView sellerinfo(HttpServletRequest request, String n, String l, String urlType) {
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        CustomerAllInfo customer = this.customerServiceMapper.selectByPrimaryKey(customerId);
        long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        String address = "";
        StoreInfo storeInfo = this.sellerService.selectByStoreId(Long.valueOf(thirdId));
        if (storeInfo != null && storeInfo.getBussAddrId() != null && storeInfo.getBussAddrId().split(",").length == 3) {
            AddressUtil addressUtil = this.districtService.queryAddressNameByDistrictId(Long.valueOf(storeInfo.getBussAddrId().split(",")[2]));
            address = addressUtil.getProvinceName() + "-" + addressUtil.getCityName() + "-" + addressUtil.getDistrictName();
        }
        resultMap.put("info", storeInfo);
        request.getSession().setAttribute("siteUrl", (Object)this.basicSetService.findBasicSet());
        request.getSession().setAttribute("customer", (Object)customer);
        request.getSession().setAttribute("infostore", (Object)storeInfo);
        if (!StringUtils.isEmpty((String)urlType) && "new".equals(urlType)) {
            return new ModelAndView("seller/newsellerinfo").addAllObjects(resultMap).addObject("isSell", (Object)customer.getIsSeller());
        }
        resultMap.put("address", address);
        resultMap.put("seller", this.stroreContactService.selectByStoreId(Long.valueOf(thirdId)));
        return new ModelAndView("seller/sellerinfo").addAllObjects(resultMap).addObject("isSell", (Object)customer.getIsSeller());
    }

    @RequestMapping(value={"third/updateseller"})
    public ModelAndView updateSeller(HttpServletRequest request, StoreInfo storeInfo, MultipartHttpServletRequest multipartRequest) {
        CustomerAllInfo customerAllInfo;
        Pattern pattern;
        Matcher matcher;
        if (storeInfo != null && null != storeInfo.getServiceQq() && !"".equals(storeInfo.getServiceQq()) && !(matcher = (pattern = Pattern.compile("[0-9]*")).matcher(storeInfo.getServiceQq())).matches()) {
            storeInfo.setServiceQq("");
        }
        Long storeId = (Long)request.getSession().getAttribute(THIRDID);
        storeInfo.setStoreId(storeId);
        FileUploadUtil.fillFileURL(storeInfo, multipartRequest);
        this.sellerService.updateByStoreInfo(storeInfo);
        if (request.getSession().getAttribute(CUSTOMERID) != null && (customerAllInfo = this.customerServiceMapper.selectByPrimaryKey((Long)request.getSession().getAttribute(CUSTOMERID))) != null && customerAllInfo.getCustomerUsername() != null) {
            OperateLogUtil.addOperaLog(request, customerAllInfo.getCustomerUsername(), "\u4fee\u6539\u5546\u5bb6\u4fe1\u606f", "\u4fee\u6539\u5546\u5bb6\u4fe1\u606f-->\u7528\u6237\u540d\uff1a" + customerAllInfo.getCustomerUsername());
            LOGGER.info((Object)"\u4fee\u6539\u5546\u5bb6\u4fe1\u606f");
        }
        return new ModelAndView((View)new RedirectView(request.getContextPath() + "/sellerinfo.html"));
    }

    @RequestMapping(value={"third/bankcheck"})
    public ModelAndView bankCheck(HttpServletRequest request, String n, String l) {
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        return new ModelAndView("/seller/checkbank").addObject("info", (Object)this.sellerService.selectByStoreId((Long)request.getSession().getAttribute(THIRDID)));
    }

    @RequestMapping(value={"third/tobankcheck"})
    public ModelAndView toBankCheck(HttpServletRequest request) {
        return new ModelAndView("/seller/paytoboss");
    }

    @RequestMapping(value={"third/paytoboss"})
    public ModelAndView payToBoss(HttpServletRequest request) {
        return new ModelAndView("/seller/paied");
    }

    @RequestMapping(value={"third/massreceive"})
    public ModelAndView massreceive(HttpServletRequest request, String n, String l) {
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        return new ModelAndView("seller/inforeceive").addObject("messes", (Object)this.sellerService.selectMessByStoreId((Long)request.getSession().getAttribute(THIRDID)));
    }

    @RequestMapping(value={"third/storetip"})
    public ModelAndView storeTip() {
        return new ModelAndView("/seller/storetip");
    }

    @RequestMapping(value={"/querystoremess"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ThirdStoreMess queryStoreMessBySidAndMid(HttpServletRequest request, Long mid) {
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        return this.sellerService.queryStoreMessBySidAndMid(thirdId, mid);
    }

    @RequestMapping(value={"/updatestoremess"})
    public ModelAndView updateStoreMess(HttpServletRequest request, ThirdStoreMess mess) {
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        this.sellerService.updateStoreMess(thirdId, mess);
        return new ModelAndView((View)new RedirectView(request.getContextPath() + "/massreceive.html"));
    }

    @RequestMapping(value={"/addstoremess"})
    public ModelAndView addStoreMess(HttpServletRequest request, ThirdStoreMess mess) {
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        this.sellerService.addStoreMess(thirdId, mess);
        return new ModelAndView((View)new RedirectView(request.getContextPath() + "/massreceive.html"));
    }

    @RequestMapping(value={"third/showprotocol"})
    public ModelAndView showProtocol(HttpServletRequest request) {
        String show = request.getParameter("show");
        if (StringUtils.isEmpty((String)show)) {
            show = "yes";
        }
        return new ModelAndView("/openstore/protocol").addObject("basicest", (Object)this.basicSetService.findBasicSet()).addObject("show", (Object)show);
    }

    @RequestMapping(value={"third/engageinfo"})
    public ModelAndView engageInfo(HttpServletRequest request, StoreInfo storeInfo) {
        this.sellerService.updateByStoreInfo(storeInfo, (Long)request.getSession().getAttribute(CUSTOMERID));
        return new ModelAndView("/openstore/engageinfoNew").addObject("info", (Object)this.sellerService.selectByCustomerId((Long)request.getSession().getAttribute(CUSTOMERID)));
    }

    @RequestMapping(value={"/saveengageinfo"})
    public ModelAndView saveEngageinfo(HttpServletRequest request, StoreInfo storeInfo, MultipartHttpServletRequest multipartRequest) {
        FileUploadUtil.fillFileURL(storeInfo, multipartRequest);
        String[] appId = request.getParameterValues("appId");
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        this.sellerService.saveStoreInfo(customerId, appId, storeInfo);
        return new ModelAndView((View)new RedirectView(request.getContextPath() + "/aptitude.html"));
    }

    @RequestMapping(value={"third/aptitude"})
    public ModelAndView aptitude(HttpServletRequest request) {
        return new ModelAndView("/openstore/aptitude").addObject("info", (Object)this.sellerService.selectByCustomerId((Long)request.getSession().getAttribute(CUSTOMERID)));
    }

    @RequestMapping(value={"saveStoreInfo"})
    public ModelAndView saveStoreInfo(HttpServletRequest request, StoreInfo storeInfo, MultipartHttpServletRequest multipartRequest, String cids, String bids) {
        FileUploadUtil.fillFileURL(storeInfo, multipartRequest);
        String[] appId = request.getParameterValues("appId");
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        this.sellerService.saveStoreCateAndBrand(customerId, storeInfo.getStoreId(), cids, bids);
        return new ModelAndView((View)new RedirectView(request.getContextPath() + "/auditsubmit.html"));
    }

    @RequestMapping(value={"third/filltax"})
    public ModelAndView fillTax(HttpServletRequest request) {
        return new ModelAndView("/openstore/tax").addObject("info", (Object)this.sellerService.selectByCustomerId((Long)request.getSession().getAttribute(CUSTOMERID)));
    }

    @RequestMapping(value={"third/wantengageinfo"})
    public ModelAndView wantEngageInfo(HttpServletRequest request) {
        return new ModelAndView("/openstore/wantengageinfo").addObject("info", (Object)this.sellerService.selectByCustomerId((Long)request.getSession().getAttribute(CUSTOMERID))).addObject("brandlist", (Object)this.goodsBrandService.queryAllBrand()).addObject("apbrand", (Object)this.applyBrandService.selectApplyBrand((Long)request.getSession().getAttribute(CUSTOMERID)));
    }

    @RequestMapping(value={"third/auditsubmit"})
    public ModelAndView auditSubmit(HttpServletRequest request) {
        return new ModelAndView("/openstore/auditsubmit").addObject("info", (Object)this.sellerService.selectByCustomerId((Long)request.getSession().getAttribute(CUSTOMERID)));
    }

    @RequestMapping(value={"/gofuncsetview"})
    public String goFuncSetView(Model data, HttpServletRequest request, String n, String l) {
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        StoreInfo info = this.sellerService.selectByStoreId(thirdId);
        data.addAttribute("info", (Object)info);
        data.addAttribute("storeUrl", (Object)ThirdStoreURLUtil.getThirdStoreURL());
        data.addAttribute("domainCustom", (Object)this.domainCustomService.findDomainCustom(thirdId));
        return "/seller/storeBasicSet";
    }

    @RequestMapping(value={"/updateStoreIndexState"})
    public String updateStoreIndexState(StoreInfo storeInfo, HttpServletRequest request) {
        storeInfo.setStoreId((Long)request.getSession().getAttribute(THIRDID));
        this.sellerService.updateStoreIndexState(storeInfo);
        return "redirect:/gofuncsetview.htm";
    }

    @RequestMapping(value={"/updateStoreIndexStateAlax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int updateStoreIndexStateAjax(StoreInfo storeInfo, HttpServletRequest request, String logourl) {
        storeInfo.setStoreId((Long)request.getSession().getAttribute(THIRDID));
        if (StringUtils.isEmpty((String)logourl)) {
            logourl = null;
        }
        storeInfo.setLogoUrl(logourl);
        return this.sellerService.updateStoreIndexState(storeInfo);
    }

    @RequestMapping(value={"/queryStoreNameCount"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int queryStoreNameCount(String storeName) {
        return this.sellerService.queryCountByStoreName(storeName);
    }

    @RequestMapping(value={"/checkStoreNameIsUsing"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int checkStoreNameIsUsing(String storeName, HttpServletRequest request) {
        StoreInfo storeInfo = this.sellerService.selectByStoreName(storeName);
        if (storeInfo == null) {
            return 0;
        }
        if (storeInfo.getCustomerid().equals(request.getSession().getAttribute(CUSTOMERID))) {
            return 0;
        }
        return 1;
    }

    @RequestMapping(value={"/queryOrderSalesList"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String queryOrderSalesList(HttpServletRequest request) {
        ArrayList<String> priceList = new ArrayList<String>();
        String[] dates = DateUtils.getToDayWeek(null, -7);
        String businessId = String.valueOf(request.getSession().getAttribute(CUSTOMERID));
        if (!StringUtils.isEmpty((String)businessId)) {
            String payTimeStart = DateUtils.getBeforeTodayAfter(null, -7);
            String payTimeEnd = DateUtils.getTodayDate(null);
            List orderSalesList = this.orderService.queryOrderSales(Long.valueOf(businessId), payTimeStart + " 00:00:00", payTimeEnd + " 23:59:59");
            for (int i = 0; i < dates.length; ++i) {
                String date = dates[i];
                String price = "0";
                for (Map dateMap : orderSalesList) {
                    String mapDate = String.valueOf(dateMap.get("paytime"));
                    if (!date.equals(mapDate)) continue;
                    price = dateMap.get("totalPrice").toString();
                }
                priceList.add(price);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("prices", priceList);
        result.put("dates", dates);
        return JSONObject.fromObject(result).toString();
    }

    @RequestMapping(value={"/queryOrderTotal"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String queryOrderTotal(HttpServletRequest request) {
        ArrayList<String> orderList = new ArrayList<String>();
        ArrayList<String> sendList = new ArrayList<String>();
        ArrayList<String> payList = new ArrayList<String>();
        String[] dates = DateUtils.getToDayWeek(null, -7);
        String thirdId = String.valueOf(request.getSession().getAttribute(THIRDID));
        if (!StringUtils.isEmpty((String)thirdId)) {
            String beginTime = DateUtils.getBeforeTodayAfter(null, -7) + " 00:00:00" + " 00:00:00";
            String endTime = DateUtils.getTodayDate(null) + " 23:59:59";
            List allOrderList = this.orderService.queryOrderTotal(Long.valueOf(thirdId), beginTime, endTime);
            List sendOrderList = this.orderService.queryOrderSendTotal(Long.valueOf(thirdId), beginTime, endTime);
            List payOrderList = this.orderService.queryOrderPayTotal(Long.valueOf(thirdId), beginTime, endTime);
            for (int i = 0; i < dates.length; ++i) {
                String order = "0";
                String send = "0";
                String pay = "0";
                String date = dates[i];
                for (Map dateMap : allOrderList) {
                    String createTime = String.valueOf(dateMap.get("createTime"));
                    if (!date.equals(createTime)) continue;
                    order = dateMap.get("orderTotal").toString();
                }
                for (Map dateMap : sendOrderList) {
                    String sendTime = String.valueOf(dateMap.get("sendTime"));
                    if (!date.equals(sendTime)) continue;
                    send = dateMap.get("orderTotal").toString();
                }
                for (Map dateMap : payOrderList) {
                    String payTime = String.valueOf(dateMap.get("payTime"));
                    if (!date.equals(payTime)) continue;
                    pay = dateMap.get("orderTotal").toString();
                }
                orderList.add(order);
                sendList.add(send);
                payList.add(pay);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("all", orderList);
        result.put("send", sendList);
        result.put("pay", payList);
        result.put("week", dates);
        return JSONObject.fromObject(result).toString();
    }

    @ResponseBody
    @RequestMapping(value={"/queryOrderStatistical"}, produces={"application/json;charset=UTF-8"})
    public String queryOrderStatistical(HttpServletRequest request) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", "0");
        try {
            LOGGER.info((Object)"\u5f00\u59cb\u67e5\u8be2\u5546\u5bb6\u8ba2\u5355\u4e1a\u52a1\u6982\u89c8\u548c\u5f85\u5904\u7406\u4e8b\u9879\u7edf\u8ba1");
            long thirdId = (Long)request.getSession().getAttribute(THIRDID);
            String toDay = DateUtils.getTodayDate(null);
            String yesterday = DateUtils.getBeforeTodayAfter(null, -1);
            List toDayOrderTotal = this.orderService.queryOrderTotal(Long.valueOf(thirdId), toDay + " 00:00:00", toDay + " 23:59:59");
            List yesterdayOrderTotal = this.orderService.queryOrderTotal(Long.valueOf(thirdId), yesterday + " 00:00:00", yesterday + " 23:59:59");
            List noPayList = this.orderService.querySupplierOrder(thirdId, "", "", "0");
            List noSendList = this.orderService.querySupplierOrder(thirdId, "", "", "1");
            List returnGoods = this.orderService.querySupplierOrder(thirdId, "", "", "14");
            List returnPrice = this.orderService.querySupplierOrder(thirdId, "", "", "15");
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String beginCreateTime = DateUtils.getBeforeTodayAfter(format, -1);
            String endCreateTime = DateUtils.getTodayDate(format);
            int shareTotal = this.commentServiceMapper.queryShareTotal(String.valueOf(thirdId), beginCreateTime, endCreateTime);
            Comment comment = new Comment();
            comment.setThirdId(Long.valueOf(thirdId));
            comment.setPublishTime(format.parse(beginCreateTime));
            comment.setPublishTimeTo(format.parse(endCreateTime));
            int commentTotal = this.commentServiceMapper.queryConsultCount(comment).intValue();
            int commentCount = this.commentServiceMapper.queryCommentCount(comment).intValue();
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("goodsAdded", "1");
            paramMap.put(THIRDID, thirdId);
            paramMap.put("flag", 1);
            int goods = this.sellerService.queryThirdGoodsCount(paramMap);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("goodsAdded", "0");
            param.put(THIRDID, thirdId);
            param.put("flag", 2);
            int shelvesGoods = this.sellerService.queryThirdGoodsCount(param);
            HashMap<String, Long> queryWarnGoods = new HashMap<String, Long>();
            queryWarnGoods.put("thirdid", thirdId);
            int inventoryWarning = this.thirdWarnGoodService.queryWarnGoodsCount(queryWarnGoods);
            int noGoods = this.thirdWarnGoodService.queryNoGodsCount(thirdId);
            OrderCount total = new OrderCount();
            total.setInventoryWarning(inventoryWarning);
            total.setShelvesGoods(shelvesGoods);
            total.setGoodsTotal(goods);
            total.setNewComments(commentCount);
            total.setNewSunSingle(shareTotal);
            total.setNewConsulting(commentTotal);
            total.setNoGoods(noGoods);
            if (null != toDayOrderTotal && toDayOrderTotal.size() > 0) {
                total.setTodayOrder(Integer.valueOf(((Map)toDayOrderTotal.get(0)).get("orderTotal").toString()));
            }
            if (null != yesterdayOrderTotal && yesterdayOrderTotal.size() > 0) {
                total.setYesterdayOrder(Integer.valueOf(((Map)yesterdayOrderTotal.get(0)).get("orderTotal").toString()));
            }
            if (null != noPayList && noPayList.size() > 0) {
                total.setNoPay(noPayList.size());
            }
            if (null != noSendList && noSendList.size() > 0) {
                total.setNoSend(noSendList.size());
            }
            if (null != returnGoods && returnGoods.size() > 0) {
                total.setAuditReturns(returnGoods.size());
            }
            if (null != returnPrice && returnPrice.size() > 0) {
                total.setAuditRefund(returnPrice.size());
            }
            result.put("status", "1");
            result.put("datas", total);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u5546\u5bb6\u8ba2\u5355\u4e1a\u52a1\u6982\u89c8\u548c\u5f85\u5904\u7406\u4e8b\u9879\u7edf\u8ba1\u5f02\u5e38", (Throwable)e);
        }
        LOGGER.info((Object)"\u7ed3\u675f\u67e5\u8be2\u5546\u5bb6\u8ba2\u5355\u4e1a\u52a1\u6982\u89c8\u548c\u5f85\u5904\u7406\u4e8b\u9879\u7edf\u8ba1");
        return JSONObject.fromObject(result).toString();
    }

    @RequestMapping(value={"/queryApplyBrand"}, method={RequestMethod.POST}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String queryApplyBrand(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", "0");
        try {
            HashMap<String, String> brand;
            long thirdId = (Long)request.getSession().getAttribute(THIRDID);
            List allBrandList = this.thirdOtherService.queryGrandBrandByThirdId(Long.valueOf(thirdId));
            List brandList = this.applyBrandService.selectApplyBrand(Long.valueOf(thirdId));
            ArrayList allBrand = new ArrayList();
            if (null != allBrandList && allBrandList.size() > 0) {
                brand = null;
                for (GoodsBrand goods : allBrandList) {
                    brand = new HashMap<String, String>();
                    brand.put("brandName", goods.getBrandName());
                    allBrand.add(brand);
                }
            }
            if (null != brandList && brandList.size() > 0) {
                brand = null;
                for (ApplyBrand applyBrand : brandList) {
                    brand = new HashMap();
                    brand.put("brandName", applyBrand.getApplyBrandName());
                    allBrand.add(brand);
                }
            }
            result.put("status", "1");
            result.put("datas", allBrand);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u5546\u5bb6\u4e3b\u8425\u54c1\u724c\u5f02\u5e38", (Throwable)e);
        }
        return JSONObject.fromObject(result).toString();
    }

    @RequestMapping(value={"/queryGoodsCate"}, produces={"application/json;charset=utf-8"})
    @ResponseBody
    public String queryGoodsCate(HttpServletRequest request) {
        LOGGER.info((Object)"\u5f00\u59cb\u67e5\u8be2\u5e73\u53f0\u7c7b\u76ee");
        List cateList = this.goodsCateService.queryGoodsCates();
        if (null != cateList && cateList.size() > 0) {
            for (int i = 0; i < cateList.size(); ++i) {
                GoodsCate cate = (GoodsCate)cateList.get(i);
                if (cate.getCatId() != 0L) continue;
                cateList.remove(i);
                break;
            }
        }
        HashMap<String, List> result = new HashMap<String, List>();
        result.put("rows", cateList);
        LOGGER.info((Object)"\u7ed3\u675f\u67e5\u8be2\u5e73\u53f0\u7c7b\u76ee");
        return JSONObject.fromObject(result).toString();
    }

    @RequestMapping(value={"/queryCoodsCate"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String queryCoodsCate(HttpServletRequest request) {
        ResultData result = new ResultData();
        result.setStatus(ResultData.getError());
        try {
            LOGGER.info((Object)"\u5f00\u59cb\u67e5\u8be2\u5546\u5bb6\u5df2\u7b7e\u7ea6\u7684\u7c7b\u76ee");
            long thirdId = (Long)request.getSession().getAttribute(THIRDID);
            List goodsCate = this.thirdOtherService.queryGrandCateForThird(Long.valueOf(thirdId));
            result.setRows(goodsCate);
            result.setStatus(ResultData.getSuccess());
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u5546\u5bb6\u5df2\u7b7e\u7ea6\u7684\u7c7b\u76ee\u5f02\u5e38", (Throwable)e);
        }
        LOGGER.info((Object)"\u7ed3\u675f\u67e5\u8be2\u5546\u5bb6\u5df2\u7b7e\u7ea6\u7684\u7c7b\u76ee");
        return JSONObject.fromObject(result).toString();
    }

    public SellerService getSellerService() {
        return this.sellerService;
    }

    @Resource(name="sellerService")
    public void setSellerService(SellerService sellerService) {
        this.sellerService = sellerService;
    }

    public StroreContactService getStroreContactService() {
        return this.stroreContactService;
    }

    @Resource(name="StroreContactService")
    public void setStroreContactService(StroreContactService stroreContactService) {
        this.stroreContactService = stroreContactService;
    }

    public GoodsBrandService getGoodsBrandService() {
        return this.goodsBrandService;
    }

    @Resource(name="GoodsBrandService")
    public void setGoodsBrandService(GoodsBrandService goodsBrandService) {
        this.goodsBrandService = goodsBrandService;
    }
}

