/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.seller.controller;

import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.order.bean.OrderExpress;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.third.logger.util.OperateLogUtil;
import com.qianjiang.third.seller.bean.Express;
import com.qianjiang.third.seller.service.ExpressInfoService;
import com.qianjiang.third.util.MenuOperationUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ExpressInfoController {
    private static final Logger LOGGER = Logger.getLogger(ExpressInfoController.class);
    private static final String THIRDID = "thirdId";
    private ExpressInfoService expressInfoService;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceMapper;
    @Resource(name="OrderService")
    private OrderService orderService;

    @RequestMapping(value={"third/selectexpress"})
    public ModelAndView selectExpress(HttpServletRequest request, String n, String l) {
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Express express = new Express();
        express.setStoreId((Long)request.getSession().getAttribute(THIRDID));
        resultMap.put("express", this.expressInfoService.selectByStoreIds(express));
        resultMap.put("boolcot", this.expressInfoService.selectDefaultRows((Long)request.getSession().getAttribute(THIRDID)));
        return new ModelAndView("seller/expressinfo").addAllObjects(resultMap);
    }

    @RequestMapping(value={"/expressdetailsupplier"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> expressDetail(Long orderId, Map<String, Object> map, HttpServletRequest request) {
        try {
            Express express = new Express();
            express.setStoreId((Long)request.getSession().getAttribute(THIRDID));
            List list = this.expressInfoService.selectByStoreIds(express);
            OrderExpress orderExpress = this.orderService.expressDetail(orderId);
            map.put("orderExpress", orderExpress);
            map.put("list", list);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error((Object)("\u67e5\u8be2\u5feb\u9012\u516c\u53f8\u5931\u8d25" + e.getMessage()), (Throwable)e);
        }
        return map;
    }

    @RequestMapping(value={"onekeydeliverysupplier"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean isOneKeyDeliveryFinished(HttpServletRequest request, Long orderId, String expressNo, Long thirdId, Long shoerExpId) {
        try {
            Express express = new Express();
            express.setStoreId((Long)request.getSession().getAttribute(THIRDID));
            List list = this.expressInfoService.selectByStoreIds(express);
            for (int i = 0; i < list.size(); ++i) {
                if (((Express)list.get(i)).getShoreExpId() != shoerExpId) continue;
                OrderExpress orderExpress = new OrderExpress();
                orderExpress.setOrderId(orderId);
                orderExpress.setExpressName(((Express)list.get(i)).getExpName());
                orderExpress.setExpressId(shoerExpId);
                this.orderService.updateExpress(orderExpress);
            }
            if (orderId == null || StringUtils.isEmpty((String)expressNo) || thirdId == null) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error((Object)("\u4fdd\u5b58\u7269\u6d41\u4fe1\u606f\u5931\u8d25" + e.getMessage()), (Throwable)e);
        }
        Customer cust = (Customer)request.getSession().getAttribute("cust");
        long loginUserId = 0L;
        String name = "";
        if (null != cust) {
            loginUserId = cust.getCustomerId();
            name = cust.getCustomerUsername();
        }
        return this.orderService.isOneKeyDeliveryFinished(orderId, expressNo, name, loginUserId, IPAddress.getIpAddr((HttpServletRequest)request), thirdId, null);
    }

    @RequestMapping(value={"third/checkExpressNo"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int checkExpressNo(HttpServletRequest request, String expCompany, Long shoreExpId) {
        int result = 0;
        if (null != expCompany) {
            Express ex = this.expressInfoService.selectByshoreExpId(shoreExpId);
            if (null != ex && expCompany.equals(ex.getExpCompany())) {
                return result;
            }
            Express exs = new Express();
            exs.setStoreId((Long)request.getSession().getAttribute(THIRDID));
            List expres = this.expressInfoService.selectByStoreIds(exs);
            if (!expres.isEmpty() && expres.size() > 0) {
                for (int i = 0; i < expres.size(); ++i) {
                    Express exp = (Express)expres.get(i);
                    if (!expCompany.equals(exp.getExpCompany())) continue;
                    ++result;
                }
            }
        }
        return result;
    }

    @RequestMapping(value={"third/checkExpressName"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int checkExpressName(HttpServletRequest request, String expressName) {
        int result = 0;
        if (null != expressName) {
            Express exs = new Express();
            exs.setStoreId((Long)request.getSession().getAttribute(THIRDID));
            List expres = this.expressInfoService.selectByStoreIds(exs);
            if (!expres.isEmpty() && expres.size() > 0) {
                for (int i = 0; i < expres.size(); ++i) {
                    Express exp = (Express)expres.get(i);
                    if (!expressName.equals(exp.getExpName())) continue;
                    ++result;
                }
            }
        }
        return result;
    }

    @RequestMapping(value={"third/addexpressinfo"})
    public ModelAndView toAddEmp() {
        return new ModelAndView("seller/addexpress");
    }

    @RequestMapping(value={"third/insertexpress"})
    public ModelAndView addExpress(HttpServletRequest request, Express express) {
        CustomerAllInfo customerAllInfo;
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        this.expressInfoService.insertExpress(thirdId, express);
        if (request.getSession().getAttribute("customerId") != null && (customerAllInfo = this.customerServiceMapper.selectByPrimaryKey((Long)request.getSession().getAttribute("customerId"))) != null && customerAllInfo.getCustomerUsername() != null) {
            OperateLogUtil.addOperaLog(request, customerAllInfo.getCustomerUsername(), "\u5546\u5bb6\u65b0\u589e\u7269\u6d41", "\u5546\u5bb6\u65b0\u589e\u7269\u6d41\uff0c\u7269\u6d41\u540d\u79f0\uff1a" + express.getExpName() + "-->\u7528\u6237\u540d\uff1a" + customerAllInfo.getCustomerUsername());
            LOGGER.info((Object)"\u5546\u5bb6\u65b0\u589e\u7269\u6d41");
        }
        return new ModelAndView((View)new RedirectView(request.getContextPath() + "/expresslist.html"));
    }

    @RequestMapping(value={"third/deleteexpress"})
    public ModelAndView deleteExpress(HttpServletRequest request, Express delflag) {
        CustomerAllInfo customerAllInfo;
        Express before = this.expressInfoService.selectByshoreExpId(delflag.getShoreExpId());
        delflag.setStoreId((Long)request.getSession().getAttribute(THIRDID));
        this.expressInfoService.deleteByShoreExpIdUpdate(delflag);
        if (request.getSession().getAttribute("customerId") != null && (customerAllInfo = this.customerServiceMapper.selectByPrimaryKey((Long)request.getSession().getAttribute("customerId"))) != null && customerAllInfo.getCustomerUsername() != null) {
            OperateLogUtil.addOperaLog(request, customerAllInfo.getCustomerUsername(), "\u5220\u9664\u5546\u5bb6\u7269\u6d41", "\u5220\u9664\u5546\u5bb6\u7269\u6d41\uff0c\u7269\u6d41\u540d\u79f0\uff1a" + before.getExpName() + "-->\u7528\u6237\u540d\uff1a" + customerAllInfo.getCustomerUsername());
            LOGGER.info((Object)"\u5220\u9664\u5546\u5bb6\u7269\u6d41");
        }
        return new ModelAndView((View)new RedirectView(request.getContextPath() + "/expresslist.html"));
    }

    @RequestMapping(value={"third/updatedefaultstate"})
    public ModelAndView updateExpressToState(HttpServletRequest request, Express express) {
        CustomerAllInfo customerAllInfo;
        Express before = this.expressInfoService.selectByshoreExpId(express.getShoreExpId());
        express.setStoreId((Long)request.getSession().getAttribute(THIRDID));
        this.expressInfoService.updateStateByShoreExpId(express);
        if (request.getSession().getAttribute("customerId") != null && (customerAllInfo = this.customerServiceMapper.selectByPrimaryKey((Long)request.getSession().getAttribute("customerId"))) != null && customerAllInfo.getCustomerUsername() != null) {
            OperateLogUtil.addOperaLog(request, customerAllInfo.getCustomerUsername(), "\u5f00\u542f\u5546\u5bb6\u7269\u6d41", "\u5f00\u542f\u5546\u5bb6\u7269\u6d41\uff0c\u7269\u6d41\u540d\u79f0\uff1a" + before.getExpName() + "-->\u7528\u6237\u540d\uff1a" + customerAllInfo.getCustomerUsername());
            LOGGER.info((Object)"\u5f00\u542f\u5546\u5bb6\u7269\u6d41");
        }
        return new ModelAndView((View)new RedirectView(request.getContextPath() + "/expresslist.html"));
    }

    @RequestMapping(value={"third/updatebackstate"})
    public ModelAndView updateExpressToStateBack(HttpServletRequest request, Express express) {
        CustomerAllInfo customerAllInfo;
        Express before = this.expressInfoService.selectByshoreExpId(express.getShoreExpId());
        express.setStoreId((Long)request.getSession().getAttribute(THIRDID));
        this.expressInfoService.updateStateBackByShoreExpId(express);
        if (request.getSession().getAttribute("customerId") != null && (customerAllInfo = this.customerServiceMapper.selectByPrimaryKey((Long)request.getSession().getAttribute("customerId"))) != null && customerAllInfo.getCustomerUsername() != null) {
            OperateLogUtil.addOperaLog(request, customerAllInfo.getCustomerUsername(), "\u5173\u95ed\u5546\u5bb6\u7269\u6d41", "\u5173\u95ed\u5546\u5bb6\u7269\u6d41\uff0c\u7269\u6d41\u540d\u79f0\uff1a" + before.getExpName() + "-->\u7528\u6237\u540d\uff1a" + customerAllInfo.getCustomerUsername());
            LOGGER.info((Object)"\u5173\u95ed\u5546\u5bb6\u7269\u6d41");
        }
        return new ModelAndView((View)new RedirectView(request.getContextPath() + "/expresslist.html"));
    }

    @RequestMapping(value={"third/updateexpress"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Express toUpdateEmp(Long shoreExpId) {
        return this.expressInfoService.selectByshoreExpId(shoreExpId);
    }

    @RequestMapping(value={"third/updatedoneexpress"})
    public ModelAndView updateExpress(HttpServletRequest request, Express express) {
        CustomerAllInfo customerAllInfo;
        Express before = this.expressInfoService.selectByshoreExpId(express.getShoreExpId());
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        this.expressInfoService.updateExpress(thirdId, express);
        if (request.getSession().getAttribute("customerId") != null && (customerAllInfo = this.customerServiceMapper.selectByPrimaryKey((Long)request.getSession().getAttribute("customerId"))) != null && customerAllInfo.getCustomerUsername() != null) {
            OperateLogUtil.addOperaLog(request, customerAllInfo.getCustomerUsername(), "\u4fee\u6539\u5546\u5bb6\u7269\u6d41\u4fe1\u606f", "\u4fee\u6539\u5546\u5bb6\u7269\u6d41\u4fe1\u606f\uff0c\u7269\u6d41\u540d\u79f0\uff1a" + before.getExpName() + "-->\u7528\u6237\u540d\uff1a" + customerAllInfo.getCustomerUsername());
            LOGGER.info((Object)"\u4fee\u6539\u5546\u5bb6\u7269\u6d41\u4fe1\u606f");
        }
        return new ModelAndView((View)new RedirectView(request.getContextPath() + "/expresslist.html"));
    }

    public ExpressInfoService getExpressInfoService() {
        return this.expressInfoService;
    }

    @Resource(name="expressInfoService")
    public void setExpressInfoService(ExpressInfoService expressInfoService) {
        this.expressInfoService = expressInfoService;
    }
}

